/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.logmon.clientapi.udp;

import java.io.IOException;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import net.za.pwnconsulting.javaconfig.utils.StringUtils;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import net.za.pwnconsulting.logmon.clientapi.LogMonClientAPI;
import net.za.pwnconsulting.logmon.clientapi.LogMonClientAPIException;
import net.za.pwnconsulting.logmon.clientapi.LogMonOwner;
import net.za.pwnconsulting.logmon.clientapi.LogMonPerfCounter;
import net.za.pwnconsulting.logmon.clientapi.cci.CCILogMonClientAPI;

public class UDPLogMonClientAPI
implements LogMonClientAPI {
    private List mCanLogList = new ArrayList();
    private static DatagramSocket mSocket = null;
    private static final String SEPARATOR = ",";
    private static final SimpleDateFormat mSDF = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final long INTERVAL_TIME = 5000L;
    private static final Random RANDOM = new Random();
    private static final String LOGMON_COMMAND_CHECK_LOGGABILITY = "CHECK LOGGABILITY";
    private static final String LOGMON_RESPONSE_CHECK_LOGGABILITY = "TRUE";
    private static final int WAIT_TIME = 3000;
    private static final int MAX_RECEIVE_BUFFER_LEN = 2048;
    private String mServerIP;
    private int mPort;
    private InetAddress mServer;

    public UDPLogMonClientAPI(String pServerIP, int pPort) {
        this.mServerIP = pServerIP;
        this.mPort = pPort;
        try {
            this.mServer = InetAddress.getByName(this.mServerIP);
        }
        catch (UnknownHostException e) {
            throw new LogMonClientAPIException("Could not lookup server: " + e.getMessage(), e);
        }
    }

    public void logInfo(LogMonOwner pLogMonOwner, String pMessage, String pDetails) {
        if (this.canLog(pLogMonOwner, 'I')) {
            this.sendPacket(this.encodeMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), 'I', pMessage, pDetails));
        }
    }

    public void logWarning(LogMonOwner pLogMonOwner, String pMessage, String pDetails) {
        if (this.canLog(pLogMonOwner, 'W')) {
            this.sendPacket(this.encodeMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), 'W', pMessage, pDetails));
        }
    }

    public void logError(LogMonOwner pLogMonOwner, String pMessage, String pDetails) {
        if (this.canLog(pLogMonOwner, 'E')) {
            this.sendPacket(this.encodeMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), 'E', pMessage, pDetails));
        }
    }

    public void logDebug(LogMonOwner pLogMonOwner, String pMessage, String pDetails) {
        if (this.canLog(pLogMonOwner, 'D')) {
            this.sendPacket(this.encodeMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), 'D', pMessage, pDetails));
        }
    }

    public void logPerformance(LogMonOwner pLogMonOwner, LogMonPerfCounter[] pCounters) {
        if (this.canLog(pLogMonOwner, 'P')) {
            this.sendPacket(this.encodeMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), 'P', pCounters));
        }
    }

    public void logAlert(LogMonOwner pLogMonOwner, String pMessage, String pDetails, int pAlertKind) {
        if (this.canLog(pLogMonOwner, 'A')) {
            this.sendPacket(this.encodeMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), 'A', pMessage, pDetails, pAlertKind));
        }
    }

    public void logAudit(LogMonOwner pLogMonOwner, String pMessage, String pDetails, String pUser) {
        if (this.canLog(pLogMonOwner, 'U')) {
            this.sendPacket(this.encodeMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), 'A', pMessage, pDetails, pUser));
        }
    }

    private void sendPacket(String pMessage) throws LogMonClientAPIException {
        try {
            byte[] vBuffer = pMessage.getBytes();
            DatagramPacket vPacket = new DatagramPacket(vBuffer, vBuffer.length, this.mServer, this.mPort);
            mSocket.send(vPacket);
        }
        catch (IOException e) {
            throw new LogMonClientAPIException("Could not lookup server: " + e.getMessage(), e);
        }
    }

    private String encodeMessage(String pSystemID, String pNodeID, String pClientID, char pKind, String pMessage, String pDetails) {
        String vTimestamp = mSDF.format(new Timestamp(new Date().getTime()));
        return StringUtils.hexEncodeAsString((Object)Utils.makeProperString((String)pSystemID)) + SEPARATOR + StringUtils.hexEncodeAsString((Object)Utils.makeProperString((String)pNodeID)) + SEPARATOR + StringUtils.hexEncodeAsString((Object)Utils.makeProperString((String)pClientID)) + SEPARATOR + StringUtils.hexEncodeAsString((Object)Utils.makeProperString((String)new Character(pKind).toString())) + SEPARATOR + StringUtils.hexEncodeAsString((Object)Utils.makeProperString((String)pMessage)) + SEPARATOR + StringUtils.hexEncodeAsString((Object)Utils.makeProperString((String)pDetails)) + SEPARATOR + StringUtils.hexEncodeAsString((Object)Utils.makeProperString((String)vTimestamp));
    }

    private String encodeMessage(String pSystemID, String pNodeID, String pClientID, char pKind, LogMonPerfCounter[] pCounters) {
        if (pCounters == null || pCounters.length <= 0) {
            throw new LogMonClientAPIException("pCounters was not specified");
        }
        StringBuffer vMessage = new StringBuffer();
        for (int i = 0; i < pCounters.length; ++i) {
            LogMonPerfCounter vCounter = pCounters[i];
            if (i > 0) {
                vMessage.append(',');
            }
            vMessage.append(vCounter.getCounterName()).append("=").append("\"").append(vCounter.getCounterValue()).append("{").append(vCounter.getCounterUnit()).append("}").append("{").append(vCounter.getCounterDetails()).append("}").append("\"");
        }
        return this.encodeMessage(pSystemID, pNodeID, pClientID, pKind, vMessage.toString(), "");
    }

    private String encodeMessage(String pSystemID, String pNodeID, String pClientID, char pKind, String pMessage, String pDetails, int pAlertKind) {
        String vEncodedString = this.encodeMessage(pSystemID, pNodeID, pClientID, pKind, pMessage, pDetails);
        return vEncodedString + SEPARATOR + StringUtils.hexEncodeAsString((Object)Utils.makeProperString((String)Integer.toString(pAlertKind)));
    }

    private String encodeMessage(String pSystemID, String pNodeID, String pClientID, char pKind, String pMessage, String pDetails, String pUser) {
        String vEncodedString = this.encodeMessage(pSystemID, pNodeID, pClientID, pKind, pMessage, pDetails);
        return vEncodedString + SEPARATOR + StringUtils.hexEncodeAsString((Object)Utils.makeProperString((String)pUser));
    }

    private boolean canLog(LogMonOwner pLogMonOwner, char pLogKind) {
        CCILogMonClientAPI.LogMonCheck vLMC = new CCILogMonClientAPI.LogMonCheck(pLogMonOwner, pLogKind);
        int vStoredLMCIndex = this.mCanLogList.indexOf(vLMC);
        CCILogMonClientAPI.LogMonCheck vStoredLMC = vLMC;
        if (vStoredLMCIndex == -1) {
            this.mCanLogList.add(vLMC);
        } else {
            vStoredLMC = (CCILogMonClientAPI.LogMonCheck)this.mCanLogList.get(vStoredLMCIndex);
        }
        boolean vCanLog = vStoredLMC.isCanLog();
        long vNow = System.currentTimeMillis();
        if (vNow - vStoredLMC.getCounter() > 5000L) {
            vCanLog = this.checkLogMon(pLogMonOwner, new Character(pLogKind).toString());
            vStoredLMC.setCanLog(vCanLog);
            vStoredLMC.setCounter(vNow);
        }
        return vCanLog;
    }

    private boolean checkLogMon(LogMonOwner pLogMonOwner, String pLogKind) {
        try {
            String vCookie = this.generateToken();
            StringBuffer vLogCriteria = new StringBuffer(pLogMonOwner.getSystemID()).append(SEPARATOR).append(pLogMonOwner.getNodeID()).append(SEPARATOR).append(pLogMonOwner.getClientID()).append(SEPARATOR).append(pLogKind);
            StringBuffer vCommandString = new StringBuffer(LOGMON_COMMAND_CHECK_LOGGABILITY).append("=").append(vLogCriteria).append("{").append(vCookie).append("}");
            this.sendPacket(StringUtils.hexEncodeAsString((Object)vCommandString));
            byte[] vBuffer = new byte[2048];
            DatagramPacket vPacket = new DatagramPacket(vBuffer, vBuffer.length);
            mSocket.setSoTimeout(3000);
            mSocket.receive(vPacket);
            String vDecodedResponse = Utils.makeProperString((String)new String(StringUtils.hexDecodeAsBytes((String)Utils.makeProperString((String)new String(vBuffer)))));
            StringTokenizer vST = new StringTokenizer(vDecodedResponse, "{");
            if (!vST.hasMoreTokens()) {
                throw new LogMonClientAPIException("Invalid response received from UDP check for loggability {err1}: [" + vDecodedResponse + "]");
            }
            String vResult = Utils.makeProperString((String)vST.nextToken());
            if (!vST.hasMoreTokens()) {
                throw new LogMonClientAPIException("Invalid response received from UDP check for loggability {err2}: [" + vDecodedResponse + "]");
            }
            String vCookieResponse = Utils.makeProperString((String)vST.nextToken());
            if (vCookieResponse.length() > 0) {
                vCookieResponse = vCookieResponse.substring(0, vCookieResponse.length() - 1);
            }
            if (!vCookieResponse.equals(vCookie)) {
                throw new LogMonClientAPIException("Invalid response received from UDP check for loggability {err3}: [" + vDecodedResponse + "]");
            }
            return vResult.equals(LOGMON_RESPONSE_CHECK_LOGGABILITY);
        }
        catch (IOException e) {
            throw new LogMonClientAPIException("Could not receive data from server: " + e.getMessage(), e);
        }
    }

    private String generateToken() {
        return new BigInteger(128, RANDOM).toString(32).toUpperCase();
    }

    static {
        try {
            mSocket = new DatagramSocket();
        }
        catch (SocketException e) {
            throw new LogMonClientAPIException("Failed creating a UDP datagram socket: " + e.getMessage(), e);
        }
    }
}

