/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.logmon.clientapi.cci;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import net.za.pwnconsulting.logmon.clientapi.LogMonClientAPI;
import net.za.pwnconsulting.logmon.clientapi.LogMonClientAPIException;
import net.za.pwnconsulting.logmon.clientapi.LogMonOwner;
import net.za.pwnconsulting.logmon.clientapi.LogMonPerfCounter;
import net.za.pwnconsulting.logmon.rar.cci.LogMonInteractionSpec;
import net.za.pwnconsulting.logmon.rar.cci.data.client.AlertLogMessage;
import net.za.pwnconsulting.logmon.rar.cci.data.client.AuditLogMessage;
import net.za.pwnconsulting.logmon.rar.cci.data.client.DebugLogMessage;
import net.za.pwnconsulting.logmon.rar.cci.data.client.ErrorLogMessage;
import net.za.pwnconsulting.logmon.rar.cci.data.client.InfoLogMessage;
import net.za.pwnconsulting.logmon.rar.cci.data.client.LogMessage;
import net.za.pwnconsulting.logmon.rar.cci.data.client.PerformanceLogMessage;
import net.za.pwnconsulting.logmon.rar.cci.data.client.QueryServerLogMessage;
import net.za.pwnconsulting.logmon.rar.cci.data.client.WarningLogMessage;

public class CCILogMonClientAPI
implements LogMonClientAPI {
    private List mCanLogList;
    private boolean mAlertOnFail;
    private ConnectionFactory mConnectionFactory;
    private static final LogMonInteractionSpec vLogMonInteractionSpec = new LogMonInteractionSpec("Data", 0L, 0);
    private static final long INTERVAL_TIME = 5000L;

    public CCILogMonClientAPI(String pLogMonDataSource, boolean pAlertOnFail) {
        this.mAlertOnFail = pAlertOnFail;
        this.mConnectionFactory = this.init(pLogMonDataSource);
        this.mCanLogList = new ArrayList();
    }

    public void logInfo(LogMonOwner pLogMonOwner, String pMessage, String pDetails) {
        if (this.canLog(pLogMonOwner, 'I')) {
            this.sendMessage((LogMessage)new InfoLogMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), pMessage, pDetails, (Date)new Timestamp(new Date().getTime())));
        }
    }

    public void logWarning(LogMonOwner pLogMonOwner, String pMessage, String pDetails) {
        if (this.canLog(pLogMonOwner, 'W')) {
            this.sendMessage((LogMessage)new WarningLogMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), pMessage, pDetails, (Date)new Timestamp(new Date().getTime())));
        }
    }

    public void logError(LogMonOwner pLogMonOwner, String pMessage, String pDetails) {
        if (this.canLog(pLogMonOwner, 'E')) {
            this.sendMessage((LogMessage)new ErrorLogMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), pMessage, pDetails, (Date)new Timestamp(new Date().getTime())));
        }
    }

    public void logDebug(LogMonOwner pLogMonOwner, String pMessage, String pDetails) {
        if (this.canLog(pLogMonOwner, 'D')) {
            this.sendMessage((LogMessage)new DebugLogMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), pMessage, pDetails, (Date)new Timestamp(new Date().getTime())));
        }
    }

    public void logPerformance(LogMonOwner pLogMonOwner, LogMonPerfCounter[] pCounters) {
        if (this.canLog(pLogMonOwner, 'P')) {
            this.sendMessage((LogMessage)new PerformanceLogMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), this.encodePerformanceCounters(pCounters), "", (Date)new Timestamp(new Date().getTime())));
        }
    }

    public void logAlert(LogMonOwner pLogMonOwner, String pMessage, String pDetails, int pAlertKind) {
        if (this.canLog(pLogMonOwner, 'A')) {
            this.sendMessage((LogMessage)new AlertLogMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), pMessage, pDetails, (Date)new Timestamp(new Date().getTime()), pAlertKind));
        }
    }

    public void logAudit(LogMonOwner pLogMonOwner, String pMessage, String pDetails, String pUser) {
        if (this.canLog(pLogMonOwner, 'U')) {
            this.sendMessage((LogMessage)new AuditLogMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), pMessage, pDetails, (Date)new Timestamp(new Date().getTime()), pUser));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMessage(LogMessage pLogMessage) throws LogMonClientAPIException {
        boolean vRes = false;
        try {
            Connection vConnection = this.mConnectionFactory.getConnection();
            try {
                Interaction vInteraction = vConnection.createInteraction();
                try {
                    vRes = vInteraction.execute((InteractionSpec)vLogMonInteractionSpec, (Record)pLogMessage, null);
                }
                finally {
                    vInteraction.close();
                }
            }
            finally {
                vConnection.close();
            }
            return vRes;
        }
        catch (ResourceException e) {
            if (this.mAlertOnFail) {
                String vMessage = "Error communicating with LogMon: " + e.getMessage() + ", Linked Exception: " + (e.getLinkedException() == null ? "unspecified" : e.getLinkedException().getMessage()) + ", Error Code: " + (e.getErrorCode() == null ? "unspecified" : e.getErrorCode());
                throw new LogMonClientAPIException(vMessage, e);
            }
            return false;
        }
    }

    private String encodePerformanceCounters(LogMonPerfCounter[] pCounters) {
        int vLength;
        int n = vLength = pCounters == null ? 0 : pCounters.length;
        if (pCounters == null || vLength <= 0) {
            throw new LogMonClientAPIException("pCounters was not specified");
        }
        StringBuffer vMessage = new StringBuffer();
        for (int i = 0; i < vLength; ++i) {
            LogMonPerfCounter vCounter = pCounters[i];
            if (i > 0) {
                vMessage.append(',');
            }
            vMessage.append(vCounter.getCounterName()).append("=").append("\"").append(vCounter.getCounterValue()).append("{").append(vCounter.getCounterUnit()).append("}").append("{").append(vCounter.getCounterDetails()).append("}").append("\"");
        }
        return vMessage.toString();
    }

    private ConnectionFactory init(String pLogMonDatasource) throws LogMonClientAPIException {
        try {
            InitialContext mInitialContext = new InitialContext(this.getInitialContextEnvironment());
            ConnectionFactory vConnectionFactory = (ConnectionFactory)mInitialContext.lookup(pLogMonDatasource);
            if (vConnectionFactory == null) {
                throw new LogMonClientAPIException("Retrieved a null value for the datasource [" + pLogMonDatasource + "]");
            }
            return vConnectionFactory;
        }
        catch (NamingException e) {
            throw new LogMonClientAPIException(e.getMessage(), e);
        }
    }

    protected Hashtable getInitialContextEnvironment() {
        return new Hashtable();
    }

    private boolean canLog(LogMonOwner pLogMonOwner, char pLogKind) {
        LogMonCheck vLMC = new LogMonCheck(pLogMonOwner, pLogKind);
        int vStoredLMCIndex = this.mCanLogList.indexOf(vLMC);
        LogMonCheck vStoredLMC = vLMC;
        if (vStoredLMCIndex == -1) {
            this.mCanLogList.add(vLMC);
        } else {
            vStoredLMC = (LogMonCheck)this.mCanLogList.get(vStoredLMCIndex);
        }
        boolean vCanLog = vStoredLMC.isCanLog();
        long vNow = System.currentTimeMillis();
        if (vNow - vStoredLMC.getCounter() > 5000L) {
            vCanLog = this.checkLogMon(pLogMonOwner, new Character(pLogKind).toString());
            vStoredLMC.setCanLog(vCanLog);
            vStoredLMC.setCounter(vNow);
        }
        return vCanLog;
    }

    private boolean checkLogMon(LogMonOwner pLogMonOwner, String pLogKind) {
        return this.sendMessage((LogMessage)new QueryServerLogMessage(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), pLogKind));
    }

    public static class LogMonCheck
    extends LogMonOwner {
        private char mLogKind;
        private boolean mCanLog;
        private long mCounter;

        public LogMonCheck(String pSystemID, String pNodeID, String pClientID, char pLogKind) {
            super(pSystemID, pNodeID, pClientID);
            this.mLogKind = pLogKind;
            this.mCounter = 0L;
            this.mCanLog = true;
        }

        public LogMonCheck(LogMonOwner pLogMonOwner, char pLogKind) {
            this(pLogMonOwner.getSystemID(), pLogMonOwner.getNodeID(), pLogMonOwner.getClientID(), pLogKind);
        }

        public char getLogKind() {
            return this.mLogKind;
        }

        public boolean isCanLog() {
            return this.mCanLog;
        }

        public long getCounter() {
            return this.mCounter;
        }

        public void setCounter(long pCounter) {
            this.mCounter = pCounter;
        }

        public void setCanLog(boolean pCanLog) {
            this.mCanLog = pCanLog;
        }

        public int hashCode() {
            return super.hashCode() ^ this.mLogKind;
        }

        public boolean equals(Object pObject) {
            return super.equals(pObject) && pObject instanceof LogMonCheck && ((LogMonCheck)pObject).getLogKind() == this.getLogKind();
        }
    }
}

