/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.trans.support;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import net.za.pwnconsulting.dblayer.query.BrokenConnectionException;
import net.za.pwnconsulting.dblayer.query.LockedRowException;
import net.za.pwnconsulting.dblayer.support.AbstractBaseDBLayerConfiguration;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.dblayer.trans.support.DBMSIndependentVendor;
import net.za.pwnconsulting.dblayer.trans.support.DBMSVendorException;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.exceptions.ProgrammerMistakeException;
import org.dom4j.Node;
import org.postgresql.util.PSQLException;

public class PostgreSQLRDBMSVendor
extends AbstractBaseDBLayerConfiguration
implements DBMSIndependentVendor {
    public int getSerial(Statement pStatement, SQLStatement pSQLStatement, String pPoolName) throws SQLException, DBMSVendorException {
        if (pSQLStatement.getSequenceName() == null || pSQLStatement.getSequenceName().equals("")) {
            throw new ProgrammerMistakeException("Programmer Error: The sequence value in SQLStatement is mandatory for PostgreSQL databases");
        }
        ResultSet vRS = null;
        String vSQL = "select currval('" + pSQLStatement.getSequenceName() + "')";
        if (!pSQLStatement.isUsePreparedStatements()) {
            vRS = pStatement.executeQuery(vSQL);
            if (vRS.next()) {
                return vRS.getInt(1);
            }
            throw new DBMSVendorException("Could not retrieve the sequence value");
        }
        PreparedStatement vStatement = pStatement.getConnection().prepareStatement(vSQL);
        try {
            vRS = vStatement.executeQuery();
            if (vRS.next()) {
                int n = vRS.getInt(1);
                return n;
            }
            throw new DBMSVendorException("Could not retrieve the sequence value");
        }
        finally {
            vStatement.close();
        }
    }

    public void checkExceptionForBrokenConnection(Exception pException, Connection pConnection, String pPoolName) throws BrokenConnectionException {
        boolean vBrokenConnection = false;
        ArrayList<String> vErrorCodes = new ArrayList<String>();
        vErrorCodes.add("57P01");
        vErrorCodes.add("57P02");
        vErrorCodes.add("57P03");
        vErrorCodes.add("58030");
        vErrorCodes.add("53300");
        if (pException instanceof PSQLException && ((PSQLException)pException).getSQLState() != null) {
            String vSQLState = ((PSQLException)pException).getSQLState();
            boolean bl = vBrokenConnection = vSQLState.startsWith("08") || vErrorCodes.contains(vSQLState);
        }
        if (pException instanceof PSQLException) {
            // empty if block
        }
        if (!vBrokenConnection && !(pException instanceof SQLException)) {
            return;
        }
        if (vBrokenConnection) {
            BrokenConnectionException vBC = new BrokenConnectionException("Connection is broken: " + pException.getMessage(), pException);
            vBC.setConnection(pConnection);
            vBC.setPoolName(pPoolName);
            throw vBC;
        }
    }

    public void checkExceptionForLockedRow(Exception pException, Connection pConnection, String pPoolName) throws LockedRowException {
    }

    public void initIV(Node pConfig) throws ConfigurationException {
        this.init(pConfig);
    }
}

