/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.trans.support;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.za.pwnconsulting.dblayer.query.BrokenConnectionException;
import net.za.pwnconsulting.dblayer.query.LockedRowException;
import net.za.pwnconsulting.dblayer.support.AbstractBaseDBLayerConfiguration;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.dblayer.trans.support.DBMSIndependentVendor;
import net.za.pwnconsulting.dblayer.trans.support.DBMSIndependentVendorFactory;
import net.za.pwnconsulting.dblayer.trans.support.DBMSVendorException;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import org.dom4j.Node;

public class IBMWebSphereJDBC2DSRDBMSVendor
extends AbstractBaseDBLayerConfiguration
implements DBMSIndependentVendor {
    public static final String REAL_DBMS_NAME = "RealDBMSName";

    public int getSerial(Statement pStatement, SQLStatement pSQLStatement, String pPoolName) throws SQLException, DBMSVendorException {
        DBMSIndependentVendorFactory vRDBMS = new DBMSIndependentVendorFactory(this.getSettings().getParameterByNameSilent(REAL_DBMS_NAME));
        return vRDBMS.getCurrentRDBMSVendor().getSerial(pStatement, pSQLStatement, pPoolName);
    }

    public void checkExceptionForBrokenConnection(Exception pException, Connection pConnection, String pPoolName) throws BrokenConnectionException, DBMSVendorException {
        if (pException != null && pException.getClass().getName().equals("com.ibm.websphere.ce.cm.StaleConnectionException")) {
            BrokenConnectionException vBC = new BrokenConnectionException("Connection is broken: " + pException.getMessage(), pException);
            vBC.setConnection(pConnection);
            vBC.setPoolName(pPoolName);
            throw vBC;
        }
    }

    public void checkExceptionForLockedRow(Exception pException, Connection pConnection, String pPoolName) throws LockedRowException, DBMSVendorException {
        DBMSIndependentVendorFactory vRDBMS = new DBMSIndependentVendorFactory(this.getSettings().getParameterByNameSilent(REAL_DBMS_NAME));
        vRDBMS.getCurrentRDBMSVendor().checkExceptionForLockedRow(pException, pConnection, pPoolName);
    }

    public void initIV(Node pConfig) throws ConfigurationException {
        this.init(pConfig);
    }
}

