/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.trans.support;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.za.pwnconsulting.dblayer.query.BrokenConnectionException;
import net.za.pwnconsulting.dblayer.query.LockedRowException;
import net.za.pwnconsulting.dblayer.support.AbstractBaseDBLayerConfiguration;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.dblayer.trans.support.DBMSIndependentVendor;
import net.za.pwnconsulting.dblayer.trans.support.DBMSVendorException;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.exceptions.RuntimeNestedException;
import org.dom4j.Node;

public class DerbyRDBMSVendor
extends AbstractBaseDBLayerConfiguration
implements DBMSIndependentVendor {
    public int getSerial(Statement pStatement, SQLStatement pSQLStatement, String pPoolName) throws SQLException, DBMSVendorException {
        ResultSet vR = pStatement.getGeneratedKeys();
        if (vR == null) {
            throw new RuntimeNestedException("Could not retrieve the auto generated key from the DB");
        }
        if (vR.next()) {
            return new Long(vR.getInt(1)).intValue();
        }
        throw new RuntimeNestedException("Could not retrieve the auto generated key from the DB");
    }

    public void checkExceptionForBrokenConnection(Exception pException, Connection pConnection, String pPoolName) throws BrokenConnectionException {
        boolean vBrokenConnection;
        BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, pException.getMessage(), (Throwable)pException);
        boolean bl = vBrokenConnection = pException.getMessage() != null && pException instanceof SQLException && ((SQLException)pException).getSQLState().indexOf("XSDA4") != -1;
        if (vBrokenConnection) {
            BrokenConnectionException vBC = new BrokenConnectionException("Connection is broken: " + pException.getMessage(), pException);
            vBC.setConnection(pConnection);
            vBC.setPoolName(pPoolName);
            throw vBC;
        }
    }

    public void checkExceptionForLockedRow(Exception pException, Connection pConnection, String pPoolName) throws LockedRowException {
        BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, pException.getMessage(), (Throwable)pException);
    }

    public void initIV(Node pConfig) throws ConfigurationException {
        this.init(pConfig);
    }
}

