/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.trans;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import net.za.pwnconsulting.dblayer.conn.DBConnectionLayer;
import net.za.pwnconsulting.dblayer.conn.DBConnectionLayerException;
import net.za.pwnconsulting.dblayer.conn.pool.Retries;
import net.za.pwnconsulting.dblayer.locking.XLayerProperties;
import net.za.pwnconsulting.dblayer.parser.SQLParser;
import net.za.pwnconsulting.dblayer.parser.SQLParserParams;
import net.za.pwnconsulting.dblayer.query.BrokenConnectionException;
import net.za.pwnconsulting.dblayer.query.LockedRowException;
import net.za.pwnconsulting.dblayer.trans.AbstractTransactionLayer;
import net.za.pwnconsulting.dblayer.trans.DBTransactionLayerException;
import net.za.pwnconsulting.dblayer.trans.SQLBatch;
import net.za.pwnconsulting.dblayer.trans.SQLBatchException;
import net.za.pwnconsulting.dblayer.trans.SQLFailureEntry;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.dblayer.trans.TransactionResult;
import net.za.pwnconsulting.dblayer.trans.support.AbstractStreamField;
import net.za.pwnconsulting.dblayer.trans.support.AsciiStreamField;
import net.za.pwnconsulting.dblayer.trans.support.BinaryStreamField;
import net.za.pwnconsulting.dblayer.trans.support.DBMSIndependentVendor;
import net.za.pwnconsulting.dblayer.trans.support.DBMSIndependentVendorFactory;
import net.za.pwnconsulting.dblayer.trans.support.DBMSVendorException;
import net.za.pwnconsulting.dblayer.trans.support.SerialField;
import net.za.pwnconsulting.dblayer.trans.support.SerialFieldException;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.exceptions.NestedException;
import net.za.pwnconsulting.javaconfig.exceptions.ProgrammerMistakeException;
import net.za.pwnconsulting.javaconfig.exceptions.RuntimeFailureException;
import net.za.pwnconsulting.javaconfig.utils.MutableInteger;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import net.za.pwnconsulting.logmon.clientapi.LogMonPerfCounter;

public class StandardTransactionLayer
extends AbstractTransactionLayer {
    public TransactionResult submitTransaction(SQLStatement pSQLStatement, String pPoolName) throws DBTransactionLayerException {
        return this.submitTransaction(pSQLStatement, pPoolName, new XLayerProperties());
    }

    public TransactionResult submitTransaction(SQLStatement pSQLStatement, String pPoolName, XLayerProperties pXLayerProperties) throws DBTransactionLayerException {
        return this.submitTransaction(pSQLStatement, pPoolName, pXLayerProperties, false);
    }

    private TransactionResult submitTransaction(SQLStatement pSQLStatement, String pPoolName, XLayerProperties pXLayerProperties, boolean pNonCommitting) throws DBTransactionLayerException {
        try {
            ArrayList<SQLBatch> vSQLBatches = new ArrayList<SQLBatch>();
            SQLBatch vSQLBatch = new SQLBatch(true, pPoolName, pXLayerProperties);
            vSQLBatch.addSQLStatement(pSQLStatement);
            vSQLBatches.add(vSQLBatch);
            return this.submitTransactionInternalExceptionWrapper(vSQLBatches, null, pNonCommitting)[0];
        }
        catch (SQLBatchException e) {
            String vMessage = "Could not add SQL Batch: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBTransactionLayerException(vMessage, (Throwable)((Object)e));
        }
    }

    public TransactionResult submitTransaction(SQLBatch pSQLBatch) throws DBTransactionLayerException {
        return this.submitTransaction(pSQLBatch, null);
    }

    public TransactionResult submitTransaction(SQLBatch pSQLBatch, boolean pNonCommitting) throws DBTransactionLayerException {
        ArrayList<SQLBatch> vSQLBatches = new ArrayList<SQLBatch>();
        vSQLBatches.add(pSQLBatch);
        return this.submitTransactionInternalExceptionWrapper(vSQLBatches, null, pNonCommitting)[0];
    }

    public TransactionResult[] submitTransaction(List pSQLBatches) throws DBTransactionLayerException {
        return this.submitTransaction(pSQLBatches, null);
    }

    public TransactionResult submitTransaction(SQLBatch pSQLBatch, SQLFailureEntry pFailureEntry) throws DBTransactionLayerException {
        ArrayList<SQLBatch> vSQLBatches = new ArrayList<SQLBatch>();
        vSQLBatches.add(pSQLBatch);
        return this.submitTransactionInternalExceptionWrapper(vSQLBatches, pFailureEntry, false)[0];
    }

    public TransactionResult[] submitTransaction(List pSQLBatches, SQLFailureEntry pFailureEntry) throws DBTransactionLayerException {
        return this.submitTransactionInternalExceptionWrapper(pSQLBatches, pFailureEntry, false);
    }

    private TransactionResult[] submitTransactionInternalExceptionWrapper(List pSQLBatches, SQLFailureEntry pSQLFailureEntry, boolean pNonCommitting) throws DBTransactionLayerException {
        try {
            int vBrokenConnectionRetryCount = 0;
            int vLockedRowRetryCount = 0;
            boolean vBrokenConnectionRetryCountExceeded = false;
            boolean vLockedRowRetryCountExceeded = false;
            String vPoolName = "Undefined";
            MutableInteger vLastSuccessfulBatch = new MutableInteger(0);
            ArrayList vTransactionResults = new ArrayList();
            List vGroupedSQLBatches = this.groupSQLBatches(pSQLBatches);
            NestedException vReason = null;
            while (true) {
                Retries vRetries;
                try {
                    if (vLastSuccessfulBatch.getInteger() <= 0) {
                        vTransactionResults.clear();
                    }
                    long vStart = System.currentTimeMillis();
                    TransactionResult[] vTR = this.submitTransactionInternal(pSQLBatches, vLastSuccessfulBatch, vTransactionResults, vGroupedSQLBatches, vBrokenConnectionRetryCount > 0, pSQLFailureEntry, pNonCommitting);
                    BasicLogger.getBasicLogger().performance(this.mLogger, LMS.OWNER_DBLAYER, new LogMonPerfCounter[]{new LogMonPerfCounter("JDBCTransactionExecutionTime", (Object)new Long(System.currentTimeMillis() - vStart), "milliseconds", pSQLBatches.toString())});
                    return vTR;
                }
                catch (BrokenConnectionException e) {
                    vReason = e;
                    this.getConfiguration().getDBConnectionLayer().removeConnection(e.getConnection(), e.getPoolName());
                    vRetries = this.getConfiguration().getDBConnectionLayer().getPoolRetries(e.getPoolName());
                    if (++vBrokenConnectionRetryCount > vRetries.getBrokenConnectionRetryCount()) {
                        vBrokenConnectionRetryCountExceeded = true;
                        vPoolName = e.getPoolName();
                        break;
                    }
                    if (vLockedRowRetryCount > vRetries.getLockedRowRetryCount()) {
                        vLockedRowRetryCountExceeded = true;
                        vPoolName = e.getPoolName();
                        break;
                    }
                    BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Broken connection while executing submitTransaction in pool [" + e.getPoolName() + "], retry [" + vBrokenConnectionRetryCount + "/" + vRetries.getBrokenConnectionRetryCount() + "] ");
                    try {
                        Thread.sleep(vRetries.getBrokenConnectionRetryWait() * 1000);
                    }
                    catch (InterruptedException e1) {}
                    continue;
                }
                catch (LockedRowException e) {
                    vReason = e;
                    ++vLockedRowRetryCount;
                    vRetries = this.getConfiguration().getDBConnectionLayer().getPoolRetries(e.getPoolName());
                    if (vBrokenConnectionRetryCount > vRetries.getBrokenConnectionRetryCount()) {
                        vBrokenConnectionRetryCountExceeded = true;
                        vPoolName = e.getPoolName();
                        break;
                    }
                    if (vLockedRowRetryCount > vRetries.getLockedRowRetryCount()) {
                        vLockedRowRetryCountExceeded = true;
                        vPoolName = e.getPoolName();
                        break;
                    }
                    BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Locked row while executing submitTransaction in pool [" + e.getPoolName() + "], retry [" + vLockedRowRetryCount + "/" + vRetries.getLockedRowRetryCount() + "] ");
                    try {
                        Thread.sleep(vRetries.getLockedRowRetryWait() * 1000);
                    }
                    catch (InterruptedException e1) {}
                    continue;
                }
                break;
            }
            if (vBrokenConnectionRetryCountExceeded) {
                throw new DBConnectionLayerException("Broken connection retry count exceeded in submitTransaction in pool [" + vPoolName + "] - failing because of [" + vReason.getMessage() + "]", (Throwable)vReason);
            }
            if (vLockedRowRetryCountExceeded) {
                throw new DBConnectionLayerException("Locked row retry count exceeded in submitTransaction in pool [" + vPoolName + "] - failing because of [" + vReason.getMessage() + "]", (Throwable)vReason);
            }
            throw new DBConnectionLayerException("Internal Exception: Assert failed in submitTransactionInternalExceptionWrapper()");
        }
        catch (DBConnectionLayerException e) {
            String vMessage = "Could not execute transaction: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBTransactionLayerException(vMessage, (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionResult[] submitTransactionInternal(List pSQLBatches, MutableInteger pLastSuccessfulBatch, List pTransactionResults, List pGroupedSQLBatches, boolean pHasFailedConnection, SQLFailureEntry pSQLFailureEntry, boolean pNonCommitting) throws DBTransactionLayerException, BrokenConnectionException, LockedRowException {
        if (pSQLBatches == null || pSQLBatches.size() <= 0) {
            throw new DBTransactionLayerException("No SQL Batches were specified to be executed");
        }
        try {
            DBConnectionLayer vDBConLayer = this.getConfiguration().getDBConnectionLayer();
            ArrayList vPersistentFailedSQLStatements = new ArrayList();
            ArrayList<WrappedActiveBatch> vPendingConnections = new ArrayList<WrappedActiveBatch>();
            for (int i = pLastSuccessfulBatch.getInteger().intValue(); i < pGroupedSQLBatches.size(); ++i) {
                ArrayList<Integer> vSerials = new ArrayList<Integer>();
                ArrayList<Integer> vNumRowsAffected = new ArrayList<Integer>();
                SQLBatch vBatch = (SQLBatch)pGroupedSQLBatches.get(i);
                vBatch.rewindSQLStatement();
                ArrayList<Object> vFailedSQLStatements = new ArrayList<Object>();
                try {
                    Connection vCon;
                    String vSQLQueryDetails = "<<Unavailable>>";
                    try {
                        vCon = pHasFailedConnection ? vDBConLayer.getConnection(vBatch.getPoolName(), true) : vDBConLayer.getConnection(vBatch.getPoolName());
                    }
                    catch (DBConnectionLayerException e) {
                        BrokenConnectionException vBCE = new BrokenConnectionException("Connection could not be made: " + e.getMessage(), (Throwable)((Object)e));
                        vBCE.setConnection(null);
                        vBCE.setPoolName(vBatch.getPoolName());
                        throw vBCE;
                    }
                    vPendingConnections.add(new WrappedActiveBatch(vBatch, vCon));
                    if (vDBConLayer.supportsTransactions(vBatch.getPoolName())) {
                        vCon.setTransactionIsolation(vBatch.getXLayerProperties().getTransactionIsolationLevel());
                    }
                    String vDateFormat = vDBConLayer.getDateFormat(vBatch.getPoolName());
                    String vTimeFormat = vDBConLayer.getTimeFormat(vBatch.getPoolName());
                    while (vBatch.hasNextSQLStatement()) {
                        SQLStatement vSQLStatement = vBatch.nextSQLStatement();
                        vSQLQueryDetails = vSQLStatement.getSQL();
                        if (vPersistentFailedSQLStatements.contains(vSQLStatement)) {
                            if (vSQLStatement.isCritical()) {
                                throw new ProgrammerMistakeException("Only non-critical SQL Statements may be skipped in a retry.  There is a bug in the code.");
                            }
                            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Skipping SQL statement [" + vSQLQueryDetails + "] since it is non-critical and failed on the previous attempt...");
                            continue;
                        }
                        try {
                            Statement vStatement = vSQLStatement.isUsePreparedStatements() ? (vBatch.getXLayerProperties().isGeneratedKeys() && vSQLStatement.isReturningSerial() ? vCon.prepareStatement(vSQLStatement.getSQL(), 1) : vCon.prepareStatement(vSQLStatement.getSQL(), vBatch.getXLayerProperties().getResultSetType(), vBatch.getXLayerProperties().getResultSetConcurrency())) : vCon.createStatement(vBatch.getXLayerProperties().getResultSetType(), vBatch.getXLayerProperties().getResultSetConcurrency());
                            try {
                                Object var27_39;
                                if (!vBatch.getXLayerProperties().isUseTransactions()) {
                                    vCon.setAutoCommit(true);
                                }
                                try {
                                    int vRowCount = 0;
                                    if (vSQLStatement.isUsePreparedStatements()) {
                                        PreparedStatement vPreparedStatement = (PreparedStatement)vStatement;
                                        if (vSQLStatement.getParameters() != null) {
                                            for (int p = 1; p <= vSQLStatement.getParameters().length; ++p) {
                                                Object vParam = this.getRealParameter(vSQLStatement.getParameters()[p - 1], pTransactionResults, vSerials, pGroupedSQLBatches, vBatch);
                                                if (vParam instanceof AsciiStreamField) {
                                                    vPreparedStatement.setAsciiStream(p, ((AbstractStreamField)vParam).getInputStream(), ((AbstractStreamField)vParam).getLength());
                                                    continue;
                                                }
                                                if (vParam instanceof BinaryStreamField) {
                                                    vPreparedStatement.setBinaryStream(p, ((AbstractStreamField)vParam).getInputStream(), ((AbstractStreamField)vParam).getLength());
                                                    continue;
                                                }
                                                if (vParam instanceof java.util.Date) {
                                                    vPreparedStatement.setObject(p, vParam, 93);
                                                    continue;
                                                }
                                                if (vParam instanceof Date) {
                                                    vPreparedStatement.setObject(p, vParam, 93);
                                                    continue;
                                                }
                                                if (vParam instanceof Timestamp) {
                                                    vPreparedStatement.setObject(p, vParam, 93);
                                                    continue;
                                                }
                                                vPreparedStatement.setObject(p, vParam);
                                            }
                                        }
                                        vSQLQueryDetails = vSQLStatement.getSQL();
                                        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYERSQL, "Received [PreparedStatement] SQL Command: [" + vSQLStatement.getSQL() + "]");
                                        vRowCount = vPreparedStatement.executeUpdate();
                                    } else {
                                        String vSQLQuery;
                                        ArrayList<Object> vRealParameters = new ArrayList<Object>();
                                        if (vSQLStatement.getParameters() != null) {
                                            for (int z = 0; z < vSQLStatement.getParameters().length; ++z) {
                                                vRealParameters.add(this.getRealParameter(vSQLStatement.getParameters()[z], pTransactionResults, vSerials, pGroupedSQLBatches, vBatch));
                                            }
                                        }
                                        vSQLQueryDetails = vSQLStatement.getSQL();
                                        vSQLQueryDetails = vSQLQuery = SQLParser.parseSQL(new SQLParserParams(vSQLStatement.getSQL(), vRealParameters.toArray(), vBatch.getXLayerProperties().getParanoiaLevel(), vDateFormat, vTimeFormat));
                                        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYERSQL, "Received [Normal] SQL Command [" + vSQLQuery + "]");
                                        vRowCount = vBatch.getXLayerProperties().isGeneratedKeys() && vSQLStatement.isReturningSerial() ? vStatement.executeUpdate(vSQLQuery, 1) : vStatement.executeUpdate(vSQLQuery);
                                    }
                                    vFailedSQLStatements.add(null);
                                    vNumRowsAffected.add(new Integer(vRowCount));
                                    if (vSQLStatement.isReturningSerial()) {
                                        String vDBProductName = vDBConLayer.getDatabaseProductName(vBatch.getPoolName());
                                        DBMSIndependentVendor vRDBMS = new DBMSIndependentVendorFactory(vDBProductName).getCurrentRDBMSVendor();
                                        vSerials.add(new Integer(vRDBMS.getSerial(vStatement, vSQLStatement, vBatch.getPoolName())));
                                    } else {
                                        vSerials.add(null);
                                    }
                                    var27_39 = null;
                                    if (vBatch.getXLayerProperties().isUseTransactions()) continue;
                                }
                                catch (Throwable throwable) {
                                    var27_39 = null;
                                    if (!vBatch.getXLayerProperties().isUseTransactions()) {
                                        vCon.setAutoCommit(false);
                                    }
                                    throw throwable;
                                }
                                vCon.setAutoCommit(false);
                                {
                                }
                            }
                            finally {
                                vStatement.close();
                            }
                        }
                        catch (Exception e) {
                            this.handleFailedSQLStatement(vSQLStatement, vBatch, vPendingConnections, vDBConLayer, e, vFailedSQLStatements, pSQLFailureEntry, i, vBatch.getCurrentSQLStatementIndex(), vSQLQueryDetails);
                        }
                    }
                }
                catch (NonCriticalSQLStatementFailedException e) {
                    --i;
                    vPersistentFailedSQLStatements.addAll(vFailedSQLStatements);
                    continue;
                }
                catch (Exception e) {
                    this.handleFailedBatch(vBatch, vPendingConnections, vDBConLayer, e);
                }
                vPersistentFailedSQLStatements.clear();
                pTransactionResults.add(new TransactionResult(Utils.toIntegerArray((Object[])vSerials.toArray()), Utils.toIntegerArray((Object[])vNumRowsAffected.toArray()), vFailedSQLStatements));
            }
            ArrayList vBackupPendingConnections = new ArrayList(vPendingConnections);
            while (vPendingConnections.size() > 0) {
                WrappedActiveBatch vWAB = (WrappedActiveBatch)vPendingConnections.get(0);
                try {
                    if (pNonCommitting) {
                        vWAB.getConnection().rollback();
                    } else {
                        vWAB.getConnection().commit();
                    }
                    pLastSuccessfulBatch.setInteger(pLastSuccessfulBatch.getInteger() + 1);
                    try {
                        vDBConLayer.releaseConnection(vWAB.getConnection(), vWAB.getSQLBatch().getPoolName());
                    }
                    catch (DBConnectionLayerException e1) {
                        BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Could not release connection back to pool [" + vWAB.getSQLBatch().getPoolName() + "]: " + e1.getMessage());
                    }
                    vPendingConnections.remove(0);
                }
                catch (SQLException e) {
                    try {
                        this.handleFailedBatch(vWAB.getSQLBatch(), vPendingConnections, vDBConLayer, e);
                    }
                    catch (SQLBatchException e1) {
                        this.dumpAllBatchSQL(vBackupPendingConnections, vWAB);
                        throw e1;
                    }
                }
            }
            List vTransactionResults = this.unGroupTransactionResults(pSQLBatches, pGroupedSQLBatches, pTransactionResults);
            return this.toTransactionResultArray(vTransactionResults.toArray());
        }
        catch (SQLBatchException e) {
            String vMessage = "Could not execute SQL Transaction because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBTransactionLayerException(vMessage, (Throwable)((Object)e));
        }
    }

    private TransactionResult[] toTransactionResultArray(Object[] pArray) {
        if (pArray == null) {
            return null;
        }
        TransactionResult[] vArray = new TransactionResult[pArray.length];
        for (int i = 0; i < pArray.length; ++i) {
            vArray[i] = (TransactionResult)pArray[i];
        }
        return vArray;
    }

    private Object getRealParameter(Object pParameter, List pTransactionResults, List pSerials, List pGroupedSQLBatches, SQLBatch pBatch) throws SerialFieldException {
        if (!(pParameter instanceof SerialField)) {
            return pParameter;
        }
        SerialField vSerialField = (SerialField)pParameter;
        for (int i = 0; i < pGroupedSQLBatches.size(); ++i) {
            int vSQLStatementIndex;
            SQLBatch vSQLBatch = (SQLBatch)pGroupedSQLBatches.get(i);
            if (!vSQLBatch.getName().equals(vSerialField.getBatchName()) || (vSQLStatementIndex = vSQLBatch.findSQLStatementIndexByName(vSerialField.getSQLCommandName())) == -1) continue;
            if (pGroupedSQLBatches.indexOf(pBatch) == i) {
                return pSerials.get(vSQLStatementIndex);
            }
            return ((TransactionResult)pTransactionResults.get(i)).getSerials()[vSQLStatementIndex];
        }
        throw new SerialFieldException("Could not locate the serial number for the SQL request [" + vSerialField.getSQLCommandName() + "] in batch [" + vSerialField.getBatchName() + "]");
    }

    private void dumpAllBatchSQL(List pBackupPendingConnections, WrappedActiveBatch pWAB) {
        int vIndexOfFirstCriticalFailure = pBackupPendingConnections.indexOf(pWAB);
        BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "========== START OF BATCH DUMP ==========");
        for (int i = 0; i < pBackupPendingConnections.size(); ++i) {
            if (i < vIndexOfFirstCriticalFailure && i == 0) {
                BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "========== DUMP OF PASSED BATCHES ==========");
            } else if (i == vIndexOfFirstCriticalFailure) {
                BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "========== DUMP OF FAILED BATCHES ==========");
            }
            WrappedActiveBatch vWAB = (WrappedActiveBatch)pBackupPendingConnections.get(i);
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "---------- BATCH START [" + vWAB.getSQLBatch().getName() + "] ----------");
            vWAB.getSQLBatch().rewindSQLStatement();
            while (vWAB.getSQLBatch().hasNextSQLStatement()) {
                SQLStatement vSQLStatement = vWAB.getSQLBatch().nextSQLStatement();
                try {
                    BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "SQL Statement [" + vSQLStatement.getName() + "]: [" + SQLParser.parseSQL(vSQLStatement.getSQL(), vSQLStatement.getParameters()) + "]");
                }
                catch (Exception e) {
                    BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "SQL Statement [" + vSQLStatement.getName() + "]: [Failed to parse SQL: " + e.getMessage() + "]");
                }
            }
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "---------- BATCH END [" + vWAB.getSQLBatch().getName() + "] ----------");
        }
        BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "========== END OF BATCH DUMP ==========");
    }

    private void handleFailedSQLStatement(SQLStatement pSQLStatement, SQLBatch pBatch, List pPendingConnections, DBConnectionLayer pDBConnectionLayer, Exception pException, List pFailedSQLStatements, SQLFailureEntry pSQLFailureEntry, int pBatchIndex, int pSQLStatementIndex, String pSQLQueryDetails) throws CriticalSQLStatementFailedException, NonCriticalSQLStatementFailedException, BrokenConnectionException, LockedRowException {
        try {
            Connection vCon = ((WrappedActiveBatch)pPendingConnections.get(pPendingConnections.size() - 1)).getConnection();
            DBMSIndependentVendorFactory vRDBMS = new DBMSIndependentVendorFactory(pDBConnectionLayer.getDatabaseProductName(pBatch.getPoolName()));
            vRDBMS.getCurrentRDBMSVendor().checkExceptionForBrokenConnection(pException, vCon, pBatch.getPoolName());
            vRDBMS.getCurrentRDBMSVendor().checkExceptionForLockedRow(pException, vCon, pBatch.getPoolName());
        }
        catch (DBMSVendorException e) {
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "Could not determine whether there is a locked row or broken connection in pool [" + pBatch.getPoolName() + "]: " + e.getMessage());
        }
        catch (DBConnectionLayerException e) {
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "Could not determine whether there is a locked row or broken connection in pool [" + pBatch.getPoolName() + "]: " + e.getMessage());
        }
        catch (Exception e) {
            if (e instanceof BrokenConnectionException || e instanceof LockedRowException) {
                int vIndex = pPendingConnections.size() - 1;
                this.rollbackBatch((WrappedActiveBatch)pPendingConnections.get(vIndex), pDBConnectionLayer);
                pPendingConnections.remove(vIndex);
                if (e instanceof BrokenConnectionException) {
                    throw (BrokenConnectionException)((Object)e);
                }
                if (e instanceof LockedRowException) {
                    throw (LockedRowException)((Object)e);
                }
            }
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "Internal Error: Should catch all non-retry exceptions and handle them before catching Exception in handleFailedSQLStatement() [" + e.getClass().getName() + "]: " + e.getMessage());
            ByteArrayOutputStream vBOS = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(vBOS));
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "Stack Trace: " + vBOS.toString());
        }
        String vErrorMessage = "";
        vErrorMessage = pSQLStatement.isCritical() ? "Error in executing critical SQL statement [" + pSQLQueryDetails + "] in pool [" + pBatch.getPoolName() + "]: " + pException.getMessage() + (pException instanceof SQLException ? "(Detail: " + (((SQLException)pException).getNextException() == null ? "<<Unavailable>>" : ((SQLException)pException).getNextException().getMessage()) + ")" : "") : "Error in executing non-critical SQL statement [" + pSQLStatement.getSQL() + "] in pool [" + pBatch.getPoolName() + "]: " + pException.getMessage() + ". Will roll back current batch and retry it without the problematic " + "SQL statement since it is non-critical";
        BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, vErrorMessage);
        int vIndex = pPendingConnections.size() - 1;
        this.rollbackBatch((WrappedActiveBatch)pPendingConnections.get(vIndex), pDBConnectionLayer);
        pPendingConnections.remove(vIndex);
        if (pSQLFailureEntry != null) {
            pSQLFailureEntry.setBatchID(pBatchIndex);
            pSQLFailureEntry.setSQLStatementID(pSQLStatementIndex);
            pSQLFailureEntry.setSQLStatement(pSQLStatement);
        }
        pFailedSQLStatements.add(pSQLStatement);
        if (pSQLStatement.isCritical()) {
            throw new CriticalSQLStatementFailedException(vErrorMessage, pException);
        }
        throw new NonCriticalSQLStatementFailedException(vErrorMessage, pException);
    }

    private void handleFailedBatch(SQLBatch pBatch, List pPendingConnections, DBConnectionLayer pDBConnectionLayer, Exception pException) throws SQLBatchException, BrokenConnectionException, LockedRowException {
        try {
            if (pException instanceof BrokenConnectionException) {
                throw (BrokenConnectionException)((Object)pException);
            }
            if (pException instanceof LockedRowException) {
                throw (LockedRowException)((Object)pException);
            }
            if (pPendingConnections.size() > 0) {
                Connection vCon = ((WrappedActiveBatch)pPendingConnections.get(pPendingConnections.size() - 1)).getConnection();
                DBMSIndependentVendorFactory vRDBMS = new DBMSIndependentVendorFactory(pDBConnectionLayer.getDatabaseProductName(pBatch.getPoolName()));
                vRDBMS.getCurrentRDBMSVendor().checkExceptionForBrokenConnection(pException, vCon, pBatch.getPoolName());
                vRDBMS.getCurrentRDBMSVendor().checkExceptionForLockedRow(pException, vCon, pBatch.getPoolName());
            }
        }
        catch (DBMSVendorException e) {
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "Could not determine whether there is a locked row or broken connection in pool [" + pBatch.getPoolName() + "]: " + e.getMessage());
        }
        catch (DBConnectionLayerException e) {
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "Could not determine whether there is a locked row or broken connection in pool [" + pBatch.getPoolName() + "]: " + e.getMessage());
        }
        catch (Exception e) {
            if (e instanceof BrokenConnectionException || e instanceof LockedRowException) {
                for (int p = 0; p < pPendingConnections.size(); ++p) {
                    this.rollbackBatch((WrappedActiveBatch)pPendingConnections.get(p), pDBConnectionLayer);
                }
                pPendingConnections.clear();
                if (e instanceof BrokenConnectionException) {
                    throw (BrokenConnectionException)((Object)e);
                }
                if (e instanceof LockedRowException) {
                    throw (LockedRowException)((Object)e);
                }
            }
            String vMessage = "Internal Error: Should catch all non-retry exceptions and handle them before catching Exception in handleFailedBatch() [" + e.getClass().getName() + "]: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            ByteArrayOutputStream vBOS = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(vBOS));
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, "Stack Trace: " + vBOS.toString());
            throw new RuntimeFailureException(vMessage, (Throwable)e);
        }
        if (pBatch.isCritical()) {
            String vErrorMessage = "Error in executing/committing critical Batch [" + pBatch.getName() + "] in pool [" + pBatch.getPoolName() + "]: " + pException.getMessage();
            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, vErrorMessage);
            for (int p = 0; p < pPendingConnections.size(); ++p) {
                this.rollbackBatch((WrappedActiveBatch)pPendingConnections.get(p), pDBConnectionLayer);
            }
            pPendingConnections.clear();
            throw new SQLBatchException(vErrorMessage, pException);
        }
        BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Error in executing/committing non-critical Batch [" + pBatch.getName() + "] in pool [" + pBatch.getPoolName() + "]: " + pException.getMessage());
        int vIndex = pPendingConnections.size() - 1;
        if (vIndex >= 0) {
            this.rollbackBatch((WrappedActiveBatch)pPendingConnections.get(vIndex), pDBConnectionLayer);
            pPendingConnections.remove(vIndex);
        }
    }

    private void rollbackBatch(WrappedActiveBatch pWrappedBatch, DBConnectionLayer pDBConnectionLayer) {
        try {
            pWrappedBatch.getConnection().rollback();
        }
        catch (SQLException e1) {
            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Could not roll back transaction in pool [" + pWrappedBatch.getSQLBatch().getPoolName() + "]: " + e1.getMessage());
        }
        try {
            pDBConnectionLayer.releaseConnection(pWrappedBatch.getConnection(), pWrappedBatch.getSQLBatch().getPoolName());
        }
        catch (DBConnectionLayerException e1) {
            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Could not release connection back to pool [" + pWrappedBatch.getSQLBatch().getPoolName() + "]: " + e1.getMessage());
        }
    }

    private List unGroupTransactionResults(List pSQLBatches, List pGroupedSQLBatches, List pTransactionResults) throws DBTransactionLayerException {
        ArrayList vUnGroupedTransactionResults = new ArrayList(pTransactionResults);
        if (pSQLBatches.size() != pGroupedSQLBatches.size() || pSQLBatches.size() != pTransactionResults.size()) {
            throw new DBTransactionLayerException("Internal Consistency Error: The dimensions of SQLBatches, GroupedSQLBatches and TransactionResults are different");
        }
        for (int i = 0; i < pTransactionResults.size(); ++i) {
            int vOriginalIndex = pSQLBatches.indexOf(pGroupedSQLBatches.get(i));
            vUnGroupedTransactionResults.set(vOriginalIndex, pTransactionResults.get(i));
        }
        return vUnGroupedTransactionResults;
    }

    private List groupSQLBatches(List pSQLBatches) {
        return pSQLBatches;
    }

    class NonCriticalSQLStatementFailedException
    extends NestedException {
        public NonCriticalSQLStatementFailedException(String pMessage) {
            super(pMessage);
        }

        public NonCriticalSQLStatementFailedException(String pMessage, Throwable pRootCause) {
            super(pMessage, pRootCause);
        }
    }

    class CriticalSQLStatementFailedException
    extends NestedException {
        public CriticalSQLStatementFailedException(String pMessage) {
            super(pMessage);
        }

        public CriticalSQLStatementFailedException(String pMessage, Throwable pRootCause) {
            super(pMessage, pRootCause);
        }
    }

    class WrappedActiveBatch {
        private SQLBatch mSQLBatch;
        private Connection mConnection;

        public WrappedActiveBatch(SQLBatch pSQLBatch, Connection pConnection) {
            this.mSQLBatch = pSQLBatch;
            this.mConnection = pConnection;
        }

        public SQLBatch getSQLBatch() {
            return this.mSQLBatch;
        }

        public Connection getConnection() {
            return this.mConnection;
        }
    }
}

