/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.trans;

import java.util.ArrayList;
import java.util.List;
import net.za.pwnconsulting.dblayer.locking.XLayerProperties;
import net.za.pwnconsulting.dblayer.trans.SQLBatchException;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;

public class SQLBatch {
    private String mName;
    private boolean mCritical;
    private String mPoolName;
    private List mSQLStatements;
    private int mCurrentSQLStatementIndex;
    private XLayerProperties mXLayerProperties;

    public SQLBatch(String pName, boolean pCritical, String pPoolName, XLayerProperties pXLayerProperties) {
        this.mName = pName;
        this.mCritical = pCritical;
        this.mPoolName = pPoolName;
        this.mSQLStatements = new ArrayList();
        this.mCurrentSQLStatementIndex = 0;
        this.mXLayerProperties = pXLayerProperties;
    }

    public SQLBatch(String pName, boolean pCritical, String pPoolName) {
        this(pName, pCritical, pPoolName, new XLayerProperties());
    }

    public SQLBatch(boolean pCritical, String pPoolName, XLayerProperties pXLayerProperties) {
        this("__UNKNOWN__", pCritical, pPoolName, pXLayerProperties);
    }

    public SQLBatch(boolean pCritical, String pPoolName) {
        this("__UNKNOWN__", pCritical, pPoolName);
    }

    public void setInitialCapacity(int pInitialCapacity) {
        this.mSQLStatements = new ArrayList(pInitialCapacity);
    }

    public void addSQLStatement(SQLStatement pSQLStatement) throws SQLBatchException {
        for (int i = 0; i < this.mSQLStatements.size(); ++i) {
            SQLStatement vSQL = (SQLStatement)this.mSQLStatements.get(i);
            if (vSQL.getName().equals("__UNKNOWN__") || !vSQL.getName().equals(pSQLStatement.getName())) continue;
            throw new SQLBatchException("Could not add SQL Command as a duplicate SQL Command [" + vSQL.getName() + "] was found");
        }
        this.mSQLStatements.add(pSQLStatement);
    }

    public void addSQLStatementQuicklyAndUnsafely(SQLStatement pSQLStatement) throws SQLBatchException {
        this.mSQLStatements.add(pSQLStatement);
    }

    public void addAllSQLStatementsQuicklyAndUnsafely(SQLBatch pSQLBatch) throws SQLBatchException {
        while (pSQLBatch.hasNextSQLStatement()) {
            this.addSQLStatementQuicklyAndUnsafely(pSQLBatch.nextSQLStatement());
        }
    }

    public void addAllSQLStatements(SQLBatch pSQLBatch) throws SQLBatchException {
        while (pSQLBatch.hasNextSQLStatement()) {
            this.addSQLStatement(pSQLBatch.nextSQLStatement());
        }
    }

    public boolean hasNextSQLStatement() {
        return this.mCurrentSQLStatementIndex < this.mSQLStatements.size();
    }

    public SQLStatement nextSQLStatement() {
        if (this.hasNextSQLStatement()) {
            return (SQLStatement)this.mSQLStatements.get(this.mCurrentSQLStatementIndex++);
        }
        return null;
    }

    public int getSQLStatementCount() {
        return this.mSQLStatements.size();
    }

    public int getCurrentSQLStatementIndex() {
        return this.mCurrentSQLStatementIndex - 1;
    }

    public SQLStatement findSQLStatementByName(String pSQLStatementName) {
        for (int i = 0; i < this.mSQLStatements.size(); ++i) {
            if (!((SQLStatement)this.mSQLStatements.get(i)).getName().equals(pSQLStatementName)) continue;
            return (SQLStatement)this.mSQLStatements.get(i);
        }
        return null;
    }

    public int findSQLStatementIndexByName(String pSQLStatementName) {
        for (int i = 0; i < this.mSQLStatements.size(); ++i) {
            if (!((SQLStatement)this.mSQLStatements.get(i)).getName().equals(pSQLStatementName)) continue;
            return i;
        }
        return -1;
    }

    public void rewindSQLStatement() {
        this.mCurrentSQLStatementIndex = 0;
    }

    public boolean isCritical() {
        return this.mCritical;
    }

    public String getName() {
        return this.mName;
    }

    public String getPoolName() {
        return this.mPoolName;
    }

    public XLayerProperties getXLayerProperties() {
        return this.mXLayerProperties;
    }

    public String toString() {
        return this.mSQLStatements.toString();
    }
}

