/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.sproc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import net.za.pwnconsulting.dblayer.conn.DBConnectionLayer;
import net.za.pwnconsulting.dblayer.conn.DBConnectionLayerException;
import net.za.pwnconsulting.dblayer.conn.pool.Retries;
import net.za.pwnconsulting.dblayer.locking.XLayerProperties;
import net.za.pwnconsulting.dblayer.query.BrokenConnectionException;
import net.za.pwnconsulting.dblayer.query.InternalSQLQueryCallback;
import net.za.pwnconsulting.dblayer.query.LockedRowException;
import net.za.pwnconsulting.dblayer.sproc.AbstractStoredProcLayer;
import net.za.pwnconsulting.dblayer.sproc.DBStoredProcLayerException;
import net.za.pwnconsulting.dblayer.sproc.MapJavaJDBCTypes;
import net.za.pwnconsulting.dblayer.sproc.StoredProcCall;
import net.za.pwnconsulting.dblayer.sproc.StoredProcParameter;
import net.za.pwnconsulting.dblayer.sproc.StoredProcResult;
import net.za.pwnconsulting.dblayer.trans.support.DBMSIndependentVendorFactory;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.exceptions.InternalConsistencyException;
import net.za.pwnconsulting.javaconfig.exceptions.NestedException;
import net.za.pwnconsulting.logmon.clientapi.LogMonPerfCounter;

public class StandardStoredProcLayer
extends AbstractStoredProcLayer {
    private static final int DEFAULT_ROW_FETCH_SIZE = 100;

    public void executeStoredProcedure(String pStoredProcCall, String pPoolName) throws DBStoredProcLayerException {
        this.executeStoredProcedure(pStoredProcCall, pPoolName, new XLayerProperties());
    }

    public void executeStoredProcedure(String pStoredProcCall, String pPoolName, XLayerProperties pXLayerProperties) throws DBStoredProcLayerException {
        this.executeStoredProcedureInternalExceptionWrapper(new StoredProcCall(pStoredProcCall, pPoolName, pXLayerProperties));
    }

    public StoredProcResult executeStoredProcedure(StoredProcCall pStoredProcCall) throws DBStoredProcLayerException {
        return this.executeStoredProcedureInternalExceptionWrapper(pStoredProcCall);
    }

    private StoredProcResult executeStoredProcedureInternalExceptionWrapper(StoredProcCall pStoredProcCall) throws DBStoredProcLayerException {
        try {
            int vBrokenConnectionRetryCount = 0;
            int vLockedRowRetryCount = 0;
            Retries vRetries = this.getConfiguration().getDBConnectionLayer().getPoolRetries(pStoredProcCall.getPoolName());
            NestedException vReason = null;
            while (vBrokenConnectionRetryCount <= vRetries.getBrokenConnectionRetryCount() && vLockedRowRetryCount <= vRetries.getLockedRowRetryCount()) {
                try {
                    return this.executeStoredProcedureInternal(pStoredProcCall, vBrokenConnectionRetryCount > 0);
                }
                catch (BrokenConnectionException e) {
                    vReason = e;
                    BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Broken connection while executing executeStoredProcedure in pool [" + pStoredProcCall.getPoolName() + "], retry [" + ++vBrokenConnectionRetryCount + "/" + vRetries.getBrokenConnectionRetryCount() + "] ");
                    this.getConfiguration().getDBConnectionLayer().removeConnection(e.getConnection(), e.getPoolName());
                    try {
                        Thread.sleep(vRetries.getBrokenConnectionRetryWait() * 1000);
                    }
                    catch (InterruptedException e1) {}
                }
                catch (LockedRowException e) {
                    vReason = e;
                    BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Locked row while executing executeStoredProcedure in pool [" + pStoredProcCall.getPoolName() + "], retry [" + ++vLockedRowRetryCount + "/" + vRetries.getLockedRowRetryCount() + "] ");
                    try {
                        Thread.sleep(vRetries.getLockedRowRetryWait() * 1000);
                    }
                    catch (InterruptedException e1) {}
                }
            }
            if (vBrokenConnectionRetryCount > vRetries.getBrokenConnectionRetryCount()) {
                throw new DBConnectionLayerException("Broken connection retry count exceeded in executeStoredProcedure in pool [" + pStoredProcCall.getPoolName() + "] - [" + vBrokenConnectionRetryCount + "/" + vRetries.getBrokenConnectionRetryCount() + "] - " + "failing because of [" + vReason.getMessage() + "]", (Throwable)vReason);
            }
            if (vLockedRowRetryCount > vRetries.getLockedRowRetryCount()) {
                throw new DBConnectionLayerException("Locked row retry count exceeded in executeStoredProcedure in pool [" + pStoredProcCall.getPoolName() + "] - [" + vLockedRowRetryCount + "/" + vRetries.getLockedRowRetryCount() + "] - " + "failing because of [" + vReason.getMessage() + "]", (Throwable)vReason);
            }
            throw new DBConnectionLayerException("Internal Exception: Assert failed in executeStoredProcedureInternalExceptionWrapper()");
        }
        catch (DBConnectionLayerException e) {
            String vMessage = "Could not execute stored procedure: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBStoredProcLayerException(vMessage, (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoredProcResult executeStoredProcedureInternal(StoredProcCall pStoredProcCall, boolean pHasFailedConnection) throws DBStoredProcLayerException, BrokenConnectionException, LockedRowException {
        StoredProcResult storedProcResult;
        Connection vCon;
        if (pStoredProcCall == null) {
            throw new DBStoredProcLayerException("No StoredProcCall was specified");
        }
        DBConnectionLayer vDBConLayer = this.getConfiguration().getDBConnectionLayer();
        try {
            vCon = pHasFailedConnection ? vDBConLayer.getConnection(pStoredProcCall.getPoolName(), true) : vDBConLayer.getConnection(pStoredProcCall.getPoolName());
        }
        catch (DBConnectionLayerException e) {
            BrokenConnectionException vBCE = new BrokenConnectionException("Connection could not be made: " + e.getMessage(), (Throwable)((Object)e));
            vBCE.setConnection(null);
            vBCE.setPoolName(pStoredProcCall.getPoolName());
            throw vBCE;
        }
        if (vDBConLayer.supportsTransactions(pStoredProcCall.getPoolName())) {
            vCon.setTransactionIsolation(pStoredProcCall.getXLayerProperties().getTransactionIsolationLevel());
        }
        try {
            CallableStatement vStatement = vCon.prepareCall("{" + pStoredProcCall.getStoredProcCall() + "}", pStoredProcCall.getXLayerProperties().getResultSetType(), pStoredProcCall.getXLayerProperties().getResultSetConcurrency());
            StoredProcResult vStoredProcResult = new StoredProcResult();
            try {
                vStatement.setFetchSize(100);
                block22: for (int i = 1; i <= pStoredProcCall.getParameters().size(); ++i) {
                    StoredProcParameter vSPP = (StoredProcParameter)pStoredProcCall.getParameters().get(i - 1);
                    Object vParam = vSPP.getParameterValue();
                    switch (vSPP.getType()) {
                        case 0: {
                            vStatement.setObject(i, vParam);
                            continue block22;
                        }
                        case 1: {
                            vStatement.registerOutParameter(i, MapJavaJDBCTypes.getJDBCTypeForJavaType(vSPP.getParameterValue()));
                            continue block22;
                        }
                        case 2: {
                            vStatement.setObject(i, vParam);
                            vStatement.registerOutParameter(i, MapJavaJDBCTypes.getJDBCTypeForJavaType(vSPP.getParameterValue()));
                            continue block22;
                        }
                        default: {
                            throw new InternalConsistencyException("An unknown parameter type was specified [" + vSPP.getType() + "]");
                        }
                    }
                }
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYERSQL, "Received Stored Procedure SQL: [" + pStoredProcCall.getStoredProcCall() + "]");
                long vStart = System.currentTimeMillis();
                boolean vResultSetAvailable = vStatement.execute();
                BasicLogger.getBasicLogger().performance(this.mLogger, LMS.OWNER_DBLAYER, new LogMonPerfCounter[]{new LogMonPerfCounter("JDBCStoredProcExecutionTime", (Object)new Long(System.currentTimeMillis() - vStart), "milliseconds", pStoredProcCall.getStoredProcCall())});
                while (true) {
                    if (!vResultSetAvailable) {
                        int vUpdateCount = vStatement.getUpdateCount();
                        if (vUpdateCount == -1) break;
                        vStoredProcResult.addUpdateCount(new Integer(vUpdateCount));
                    } else if (vResultSetAvailable) {
                        ResultSet vResultSet = vStatement.getResultSet();
                        ArrayList vResultSetList = new ArrayList();
                        InternalSQLQueryCallback vCallback = new InternalSQLQueryCallback(vResultSetList);
                        while (vResultSet.next()) {
                            vCallback.handleRow(vResultSet);
                        }
                        vStoredProcResult.addResultSet(vResultSetList);
                    }
                    vResultSetAvailable = vStatement.getMoreResults();
                }
                block25: for (int i = 1; i <= pStoredProcCall.getParameters().size(); ++i) {
                    StoredProcParameter vSPP = (StoredProcParameter)pStoredProcCall.getParameters().get(i - 1);
                    switch (vSPP.getType()) {
                        case 1: {
                            vStoredProcResult.addOutParameter(new StoredProcParameter(vStatement.getObject(i), vSPP.getType()));
                            continue block25;
                        }
                        case 2: {
                            vStoredProcResult.addOutParameter(new StoredProcParameter(vStatement.getObject(i), vSPP.getType()));
                            continue block25;
                        }
                        default: {
                            continue block25;
                        }
                    }
                }
            }
            finally {
                vStatement.close();
            }
            vDBConLayer.releaseConnection(vCon, pStoredProcCall.getPoolName());
            storedProcResult = vStoredProcResult;
        }
        catch (Throwable throwable) {
            try {
                try {
                    vCon.commit();
                    throw throwable;
                }
                catch (Exception e) {
                    DBMSIndependentVendorFactory vRDBMS = new DBMSIndependentVendorFactory(vDBConLayer.getDatabaseProductName(pStoredProcCall.getPoolName()));
                    vRDBMS.getCurrentRDBMSVendor().checkExceptionForBrokenConnection(e, vCon, pStoredProcCall.getPoolName());
                    vDBConLayer.releaseConnection(vCon, pStoredProcCall.getPoolName());
                    vRDBMS.getCurrentRDBMSVendor().checkExceptionForLockedRow(e, vCon, pStoredProcCall.getPoolName());
                    throw e;
                }
            }
            catch (Exception e) {
                if (e instanceof BrokenConnectionException) {
                    throw (BrokenConnectionException)((Object)e);
                }
                if (e instanceof LockedRowException) {
                    throw (LockedRowException)((Object)e);
                }
                String vMessage = "Could not execute stored procedure [" + pStoredProcCall.getStoredProcCall() + "] in pool [" + pStoredProcCall.getParameters() + "] because: " + e.getMessage();
                BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
                throw new DBStoredProcLayerException(vMessage, e);
            }
        }
        vCon.commit();
        return storedProcResult;
    }
}

