/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.za.pwnconsulting.dblayer.conn.DBConnectionLayer;
import net.za.pwnconsulting.dblayer.conn.DBConnectionLayerException;
import net.za.pwnconsulting.dblayer.conn.pool.Retries;
import net.za.pwnconsulting.dblayer.locking.XLayerProperties;
import net.za.pwnconsulting.dblayer.parser.SQLParser;
import net.za.pwnconsulting.dblayer.parser.SQLParserException;
import net.za.pwnconsulting.dblayer.parser.SQLParserParams;
import net.za.pwnconsulting.dblayer.query.AbstractQueryLayer;
import net.za.pwnconsulting.dblayer.query.BrokenConnectionException;
import net.za.pwnconsulting.dblayer.query.DBQueryLayerException;
import net.za.pwnconsulting.dblayer.query.InternalSQLQueryCallback;
import net.za.pwnconsulting.dblayer.query.LockedRowException;
import net.za.pwnconsulting.dblayer.query.SQLQueryCallback;
import net.za.pwnconsulting.dblayer.trans.support.DBMSIndependentVendorFactory;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.exceptions.NestedException;
import net.za.pwnconsulting.logmon.clientapi.LogMonPerfCounter;

public class StandardQueryLayer
extends AbstractQueryLayer {
    private static final int DEFAULT_ROW_FETCH_SIZE = 100;

    public Object queryDatabaseScalar(String pSQL, Object[] pParameters, String pPoolName) throws DBQueryLayerException {
        List vResult = this.queryDatabase(pSQL, pParameters, pPoolName, new XLayerProperties());
        if (vResult.size() <= 0) {
            return null;
        }
        if (vResult.size() > 1) {
            throw new DBQueryLayerException("This method cannot be used on SELECT queries that return vector data");
        }
        Iterator vIterator = ((Map)vResult.get(0)).values().iterator();
        if (!vIterator.hasNext()) {
            return null;
        }
        return vIterator.next();
    }

    public List queryDatabase(String pSQL, Object[] pParameters, String pPoolName) throws DBQueryLayerException {
        return this.queryDatabase(pSQL, pParameters, pPoolName, new XLayerProperties());
    }

    public List queryDatabase(String pSQL, Object[] pParameters, String pPoolName, XLayerProperties pXLayerProperties) throws DBQueryLayerException {
        ArrayList vResult = new ArrayList();
        InternalSQLQueryCallback vInternalSQLQueryCallback = new InternalSQLQueryCallback(vResult);
        this.queryDatabaseInternalExceptionWrapper(pSQL, pParameters, pPoolName, vInternalSQLQueryCallback, false, pXLayerProperties);
        return vResult;
    }

    public List queryDatabasePrepared(String pSQL, Object[] pParameters, String pPoolName) throws DBQueryLayerException {
        return this.queryDatabasePrepared(pSQL, pParameters, pPoolName, new XLayerProperties());
    }

    public List queryDatabasePrepared(String pSQL, Object[] pParameters, String pPoolName, XLayerProperties pXLayerProperties) throws DBQueryLayerException {
        ArrayList vResult = new ArrayList();
        InternalSQLQueryCallback vInternalSQLQueryCallback = new InternalSQLQueryCallback(vResult);
        this.queryDatabaseInternalExceptionWrapper(pSQL, pParameters, pPoolName, vInternalSQLQueryCallback, true, pXLayerProperties);
        return vResult;
    }

    public List queryDatabaseUsingIn(String pSQL, Object[] pParameters, Object[] pInParameters, String pPoolName) throws DBQueryLayerException {
        return this.queryDatabaseUsingIn(pSQL, pParameters, pInParameters, pPoolName, new XLayerProperties());
    }

    public Object queryDatabaseScalarUsingIn(String pSQL, Object[] pParameters, Object[] pInParameters, String pPoolName) throws DBQueryLayerException {
        List vResult = this.queryDatabaseUsingIn(pSQL, pParameters, pInParameters, pPoolName, new XLayerProperties());
        if (vResult.size() <= 0) {
            return null;
        }
        if (vResult.size() > 1) {
            throw new DBQueryLayerException("This method cannot be used on SELECT queries that return vector data");
        }
        Iterator vIterator = ((Map)vResult.get(0)).values().iterator();
        if (!vIterator.hasNext()) {
            return null;
        }
        return vIterator.next();
    }

    public List queryDatabaseUsingIn(String pSQL, Object[] pParameters, Object[] pInParameters, String pPoolName, XLayerProperties pXLayerProperties) throws DBQueryLayerException {
        try {
            ArrayList vResult = new ArrayList();
            String vDateFormat = this.getConfiguration().getDBConnectionLayer().getDateFormat(pPoolName);
            String vTimeFormat = this.getConfiguration().getDBConnectionLayer().getTimeFormat(pPoolName);
            InternalSQLQueryCallback vInternalSQLQueryCallback = new InternalSQLQueryCallback(vResult);
            this.queryDatabaseInternalExceptionWrapper(SQLParser.expandIn(pSQL, pInParameters, vDateFormat, vTimeFormat), pParameters, pPoolName, vInternalSQLQueryCallback, false, pXLayerProperties);
            return vResult;
        }
        catch (SQLParserException e) {
            throw new DBQueryLayerException("Could not parse SQL statement: " + e.getMessage(), (Throwable)((Object)e));
        }
        catch (DBConnectionLayerException e) {
            throw new DBQueryLayerException("Could not determine default date/time format: " + e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void queryDatabaseUsingCallback(String pSQL, Object[] pParameters, String pPoolName, SQLQueryCallback pCallback) throws DBQueryLayerException {
        this.queryDatabaseUsingCallback(pSQL, pParameters, pPoolName, pCallback, new XLayerProperties());
    }

    public void queryDatabaseUsingCallback(String pSQL, Object[] pParameters, String pPoolName, SQLQueryCallback pCallback, XLayerProperties pXLayerProperties) throws DBQueryLayerException {
        this.queryDatabaseInternalExceptionWrapper(pSQL, pParameters, pPoolName, pCallback, false, pXLayerProperties);
    }

    private void queryDatabaseInternalExceptionWrapper(String pSQL, Object[] pParameters, String pPoolName, SQLQueryCallback pCallback, boolean pUsePreparedStatement, XLayerProperties pXLayerProperties) throws DBQueryLayerException {
        try {
            int vBrokenConnectionRetryCount = 0;
            int vLockedRowRetryCount = 0;
            Retries vRetries = this.getConfiguration().getDBConnectionLayer().getPoolRetries(pPoolName);
            NestedException vReason = null;
            while (vBrokenConnectionRetryCount <= vRetries.getBrokenConnectionRetryCount() && vLockedRowRetryCount <= vRetries.getLockedRowRetryCount()) {
                try {
                    this.queryDatabaseInternal(pSQL, pParameters, pPoolName, pCallback, pUsePreparedStatement, vBrokenConnectionRetryCount > 0, pXLayerProperties);
                    return;
                }
                catch (BrokenConnectionException e) {
                    vReason = e;
                    BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Broken connection while executing queryDatabase in pool [" + pPoolName + "], retry [" + ++vBrokenConnectionRetryCount + "/" + vRetries.getBrokenConnectionRetryCount() + "] ");
                    this.getConfiguration().getDBConnectionLayer().removeConnection(e.getConnection(), e.getPoolName());
                    try {
                        Thread.sleep(vRetries.getBrokenConnectionRetryWait() * 1000);
                    }
                    catch (InterruptedException e1) {}
                }
                catch (LockedRowException e) {
                    vReason = e;
                    BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Locked row while executing queryDatabase in pool [" + pPoolName + "], retry [" + ++vLockedRowRetryCount + "/" + vRetries.getLockedRowRetryCount() + "] ");
                    try {
                        Thread.sleep(vRetries.getLockedRowRetryWait() * 1000);
                    }
                    catch (InterruptedException e1) {}
                }
            }
            if (vBrokenConnectionRetryCount > vRetries.getBrokenConnectionRetryCount()) {
                throw new DBConnectionLayerException("Broken connection retry count exceeded in queryDatabase in pool [" + pPoolName + "] - [" + vBrokenConnectionRetryCount + "/" + vRetries.getBrokenConnectionRetryCount() + "] - " + "failing because of [" + vReason.getMessage() + "]", (Throwable)vReason);
            }
            if (vLockedRowRetryCount > vRetries.getLockedRowRetryCount()) {
                throw new DBConnectionLayerException("Locked row retry count exceeded in queryDatabase in pool [" + pPoolName + "] - [" + vLockedRowRetryCount + "/" + vRetries.getLockedRowRetryCount() + "] - " + "failing because of [" + vReason.getMessage() + "]", (Throwable)vReason);
            }
            throw new DBConnectionLayerException("Internal Exception: Assert failed in queryDatabaseInternalExceptionWrapper()");
        }
        catch (DBConnectionLayerException e) {
            String vMessage = "Could not execute query: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBQueryLayerException(vMessage, (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryDatabaseInternal(String pSQL, Object[] pParameters, String pPoolName, SQLQueryCallback pCallback, boolean pUsePreparedStatement, boolean pHasFailedConnection, XLayerProperties pXLayerProperties) throws DBQueryLayerException, BrokenConnectionException, LockedRowException {
        if (pCallback == null) {
            throw new DBQueryLayerException("No Callback was specified to handle the result set rows");
        }
        try {
            Connection vCon;
            String vDateFormat = this.getConfiguration().getDBConnectionLayer().getDateFormat(pPoolName);
            String vTimeFormat = this.getConfiguration().getDBConnectionLayer().getTimeFormat(pPoolName);
            DBConnectionLayer vDBConLayer = this.getConfiguration().getDBConnectionLayer();
            try {
                vCon = pHasFailedConnection ? vDBConLayer.getConnection(pPoolName, true) : vDBConLayer.getConnection(pPoolName);
            }
            catch (DBConnectionLayerException e) {
                BrokenConnectionException vBCE = new BrokenConnectionException("Connection could not be made: " + e.getMessage(), (Throwable)((Object)e));
                vBCE.setConnection(null);
                vBCE.setPoolName(pPoolName);
                throw vBCE;
            }
            try {
                if (vDBConLayer.supportsTransactions(pPoolName)) {
                    vCon.setTransactionIsolation(pXLayerProperties.getTransactionIsolationLevel());
                }
                try {
                    Statement vStatement = pUsePreparedStatement ? vCon.prepareStatement(pSQL, pXLayerProperties.getResultSetType(), pXLayerProperties.getResultSetConcurrency()) : vCon.createStatement(pXLayerProperties.getResultSetType(), pXLayerProperties.getResultSetConcurrency());
                    String vSQLForLogging = pSQL;
                    try {
                        ResultSet vResultSet;
                        vStatement.setFetchSize(100);
                        if (pUsePreparedStatement) {
                            if (pParameters != null) {
                                for (int i = 1; i <= pParameters.length; ++i) {
                                    Object vParam = pParameters[i - 1];
                                    ((PreparedStatement)vStatement).setObject(i, vParam);
                                }
                            }
                            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYERSQL, "Received [PreparedStatement] SQL Query: [" + pSQL + "]");
                            long vStart = System.currentTimeMillis();
                            vResultSet = ((PreparedStatement)vStatement).executeQuery();
                            BasicLogger.getBasicLogger().performance(this.mLogger, LMS.OWNER_DBLAYER, new LogMonPerfCounter[]{new LogMonPerfCounter("JDBCQueryExecutionTimePStmt", (Object)new Long(System.currentTimeMillis() - vStart), "milliseconds", vSQLForLogging)});
                        } else {
                            String vParsedSQL;
                            vSQLForLogging = vParsedSQL = SQLParser.parseSQL(new SQLParserParams(pSQL, pParameters, pXLayerProperties.getParanoiaLevel(), vDateFormat, vTimeFormat));
                            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYERSQL, "Received [Normal] SQL Query: [" + vParsedSQL + "]");
                            long vStart = System.currentTimeMillis();
                            vResultSet = vStatement.executeQuery(vParsedSQL);
                            BasicLogger.getBasicLogger().performance(this.mLogger, LMS.OWNER_DBLAYER, new LogMonPerfCounter[]{new LogMonPerfCounter("JDBCQueryExecutionTime", (Object)new Long(System.currentTimeMillis() - vStart), "milliseconds", vSQLForLogging)});
                        }
                        try {
                            long vStart = System.currentTimeMillis();
                            long vIncTime = 0L;
                            long vPrev = vStart;
                            int vCounter = 0;
                            while (vResultSet.next()) {
                                vIncTime += System.currentTimeMillis() - vPrev;
                                pCallback.handleRow(vResultSet);
                                vPrev = System.currentTimeMillis();
                                ++vCounter;
                            }
                            pCallback.finalisation();
                            BasicLogger.getBasicLogger().performance(this.mLogger, LMS.OWNER_DBLAYER, new LogMonPerfCounter[]{new LogMonPerfCounter("QueryCallbackCumulativeTime", (Object)new Long(System.currentTimeMillis() - vStart), "milliseconds"), new LogMonPerfCounter("QueryCallbackCumulativeResultSet.next()", (Object)new Long(vIncTime), "milliseconds", "[" + vCounter + "] iterations for SQL [" + vSQLForLogging + "]")});
                        }
                        finally {
                            vResultSet.close();
                        }
                    }
                    finally {
                        vStatement.close();
                    }
                    Object var25_32 = null;
                }
                catch (Throwable throwable) {
                    Object var25_33 = null;
                    try {
                        vCon.commit();
                    }
                    catch (Exception e) {
                        try {
                            vCon.rollback();
                        }
                        catch (Exception e1) {
                            vDBConLayer.removeConnection(vCon, pPoolName);
                            vCon = null;
                            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Failed committing connection in QL - removing from pool...");
                        }
                    }
                    throw throwable;
                }
                try {
                    vCon.commit();
                }
                catch (Exception e) {
                    try {
                        vCon.rollback();
                    }
                    catch (Exception e1) {
                        vDBConLayer.removeConnection(vCon, pPoolName);
                        vCon = null;
                        BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Failed committing connection in QL - removing from pool...");
                    }
                }
                if (vCon != null) {
                    vDBConLayer.releaseConnection(vCon, pPoolName);
                }
            }
            catch (Exception e) {
                DBMSIndependentVendorFactory vRDBMS = new DBMSIndependentVendorFactory(vDBConLayer.getDatabaseProductName(pPoolName));
                vRDBMS.getCurrentRDBMSVendor().checkExceptionForBrokenConnection(e, vCon, pPoolName);
                vDBConLayer.releaseConnection(vCon, pPoolName);
                vRDBMS.getCurrentRDBMSVendor().checkExceptionForLockedRow(e, vCon, pPoolName);
                throw e;
            }
        }
        catch (Exception e) {
            if (e instanceof BrokenConnectionException) {
                throw (BrokenConnectionException)((Object)e);
            }
            if (e instanceof LockedRowException) {
                throw (LockedRowException)((Object)e);
            }
            String vMessage = "Could not execute SQL query [" + pSQL + "] in pool [" + pPoolName + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBQueryLayerException(vMessage, e);
        }
    }
}

