/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.parser;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.za.pwnconsulting.dblayer.parser.IntegrityViolationException;
import net.za.pwnconsulting.dblayer.parser.SQLParser;
import net.za.pwnconsulting.dblayer.parser.SQLParserException;

public class SQLParserTest
extends TestCase {
    static /* synthetic */ Class class$net$za$pwnconsulting$dblayer$parser$SQLParserTest;

    public SQLParserTest(String s) {
        super(s);
    }

    public void testValidNoParamsSQL() throws SQLParserException, IntegrityViolationException {
        String vTestSQL = "select * from table where name = 'Some Name' and surname = '?'";
        String vSQL = SQLParser.parseSQL(vTestSQL, null);
        SQLParserTest.assertTrue((String)"SQL Generated equals SQL Passed in", (boolean)vTestSQL.equals(vSQL));
    }

    public void testInExpansionNumericSQL() throws SQLParserException, IntegrityViolationException {
        String vTestSQL = "select * from something where name = ? and id in ()";
        Object[] vParams = new Object[]{new Integer(1), new Integer(6), new Integer(3)};
        String vExpectedSQL = "select * from something where name = ? and id in (1,6,3)";
        String vSQL = SQLParser.expandIn(vTestSQL, vParams);
        SQLParserTest.assertTrue((String)"SQL Generated equals SQL Passed in", (boolean)vExpectedSQL.equals(vSQL));
    }

    public void testInExpansionStringSQL() throws SQLParserException, IntegrityViolationException {
        String vTestSQL = "select * from something where name = ? and id in ()";
        Object[] vParams = new Object[]{"Something", "Anot'her(thing)", "Last thing"};
        String vExpectedSQL = "select * from something where name = ? and id in ('Something','Anot''her(thing)','Last thing')";
        String vSQL = SQLParser.expandIn(vTestSQL, vParams);
        SQLParserTest.assertTrue((String)"SQL Generated equals SQL Passed in", (boolean)vExpectedSQL.equals(vSQL));
    }

    public void testMaliciousSQL() throws SQLParserException, IntegrityViolationException {
        try {
            String vTestSQL = "select * from table where name = 'Some 'Name' and surname = '?'";
            String string = SQLParser.parseSQL(vTestSQL, null);
        }
        catch (IntegrityViolationException e) {
            SQLParserTest.assertTrue((String)"Malicious SQL causes IntegrityViolationException", (boolean)true);
        }
    }

    public void testInvalidNoParamsSQL() throws SQLParserException, IntegrityViolationException {
        try {
            String vTestSQL = "select * from table where name = 'Some Name' and surname = ? and other_var = '?'";
            Object[] vParams = new Object[]{"Some Name", "Dummy"};
            String string = SQLParser.parseSQL(vTestSQL, vParams);
        }
        catch (SQLParserException e) {
            SQLParserTest.assertTrue((String)"Placeholder mismatch", (boolean)true);
        }
    }

    public void testValid5ParamsSQL() throws SQLParserException, IntegrityViolationException {
        String vTestSQL = "select * from some_table where name = ? and surname = ? and id = ? and address = 'Some? ''address'  and date = ? and value = ?";
        long vTime = new Date().getTime();
        Object[] vParams = new Object[]{"Some Name", "Some ' Surname", new Integer(5), new Timestamp(vTime), new BigDecimal("100423842387")};
        SimpleDateFormat vSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String vExpectedTestSQL = "select * from some_table where name = 'Some Name' and surname = 'Some '' Surname' and id = 5 and address = 'Some? ''address'  and date = '" + vSDF.format(new Date(vTime)) + "' and value = 1.00423842387E11";
        String vSQL = SQLParser.parseSQL(vTestSQL, vParams);
        SQLParserTest.assertTrue((String)("SQL Generated equals SQL Passed in expanded [" + vSQL + "] <-> [" + vExpectedTestSQL + "]"), (boolean)vExpectedTestSQL.equals(vSQL));
    }

    public static Test suite() {
        return new TestSuite(class$net$za$pwnconsulting$dblayer$parser$SQLParserTest == null ? (class$net$za$pwnconsulting$dblayer$parser$SQLParserTest = SQLParserTest.class$("net.za.pwnconsulting.dblayer.parser.SQLParserTest")) : class$net$za$pwnconsulting$dblayer$parser$SQLParserTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

