/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Date;
import net.za.pwnconsulting.dblayer.parser.IntegrityViolationException;
import net.za.pwnconsulting.dblayer.parser.QLIntegrityCheck;
import net.za.pwnconsulting.dblayer.parser.SQLParserException;
import net.za.pwnconsulting.dblayer.parser.SQLParserParams;
import net.za.pwnconsulting.javaconfig.beans.BeanFactoryException;
import net.za.pwnconsulting.javaconfig.beans.CoercionException;
import net.za.pwnconsulting.javaconfig.beans.StringCoercions;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocator;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocatorException;
import net.za.pwnconsulting.javaconfig.utils.StringUtils;
import net.za.pwnconsulting.javaconfig.utils.Utils;

public class SQLParser {
    public static final char QUOTE_CHAR = '\'';
    public static final boolean DEFAULT_PLACEHOLDERS_IN_PARAM = false;
    public static final char DEFAULT_PLACEHOLDER_CHAR = '?';
    private static final QLIntegrityCheck mQLIntegrityCheck = (QLIntegrityCheck)new ApplicationContextLocator().getApplicationContext().getDBLayerBeanFactory(new ApplicationContextLocator().getApplicationName()).getBean(class$net$za$pwnconsulting$dblayer$parser$QLIntegrityCheck == null ? (class$net$za$pwnconsulting$dblayer$parser$QLIntegrityCheck = SQLParser.class$("net.za.pwnconsulting.dblayer.parser.QLIntegrityCheck")) : class$net$za$pwnconsulting$dblayer$parser$QLIntegrityCheck);
    static /* synthetic */ Class class$net$za$pwnconsulting$dblayer$parser$QLIntegrityCheck;

    private SQLParser() {
    }

    public static String parseSQL(SQLParserParams pSQLParserParams) throws IntegrityViolationException, SQLParserException {
        try {
            int vParamsToReplaceCount;
            if (pSQLParserParams == null) {
                throw new SQLParserException("No SQL Parameters object was passed");
            }
            StringBuffer vParsedSQL = new StringBuffer();
            if (Utils.isEmptyString((String)pSQLParserParams.getSQL())) {
                throw new SQLParserException("No SQL statement was specified to be parsed");
            }
            StringCoercions vSC = new StringCoercions(pSQLParserParams.getDateFormat(), pSQLParserParams.getTimeFormat());
            if ((pSQLParserParams.getParameters() == null || pSQLParserParams.getParameters().length <= 0) && pSQLParserParams.getParanoidSQLIntegrityLevel() != -1) {
                mQLIntegrityCheck.checkSQLIntegrity(pSQLParserParams.getSQL(), pSQLParserParams.getParanoidSQLIntegrityLevel());
            }
            if ((vParamsToReplaceCount = SQLParser.countParamPlaceholders(pSQLParserParams.getSQL(), pSQLParserParams.getPlaceholderCharacter(), pSQLParserParams.isPlaceholdersInParam())) > 0 && pSQLParserParams.getParameters() == null || vParamsToReplaceCount > 0 && vParamsToReplaceCount != pSQLParserParams.getParameters().length || vParamsToReplaceCount == 0 && pSQLParserParams.getParameters() != null && pSQLParserParams.getParameters().length > 0) {
                throw new SQLParserException("The amount of placeholders to replace [" + vParamsToReplaceCount + "] does not equal the amount of parameters in the list [" + (pSQLParserParams.getParameters() == null ? 0 : pSQLParserParams.getParameters().length) + "]");
            }
            int vParamIndex = 0;
            int vSQLParamsLength = pSQLParserParams.getSQL().length();
            boolean vInQuotes = false;
            for (int i = 0; i < vSQLParamsLength; ++i) {
                char vSQLChar = pSQLParserParams.getSQL().charAt(i);
                if (vSQLChar == '\'') {
                    boolean bl = vInQuotes = !vInQuotes;
                }
                if (vSQLChar == pSQLParserParams.getPlaceholderCharacter()) {
                    if (!pSQLParserParams.isPlaceholdersInParam() && vInQuotes) {
                        vParsedSQL.append(vSQLChar);
                        continue;
                    }
                    vParsedSQL.append(SQLParser.quoteIfNeeded(vSC.coerceValueToString(pSQLParserParams.getParameters()[vParamIndex]), pSQLParserParams.getParameters()[vParamIndex]));
                    ++vParamIndex;
                    continue;
                }
                vParsedSQL.append(vSQLChar);
            }
            String vParsedQuery = vParsedSQL.toString();
            if (pSQLParserParams.getParanoidSQLIntegrityLevel() != -1) {
                mQLIntegrityCheck.checkSQLIntegrity(vParsedQuery, pSQLParserParams.getParanoidSQLIntegrityLevel());
            }
            return vParsedQuery;
        }
        catch (CoercionException e) {
            throw new SQLParserException("Could not parse one of the parameters: " + e.getMessage(), e);
        }
        catch (ConfigurationException e) {
            throw new SQLParserException("Could not parse one of the parameters: " + e.getMessage(), e);
        }
        catch (BeanFactoryException e) {
            throw new SQLParserException("Could not parse one of the parameters: " + e.getMessage(), e);
        }
        catch (ApplicationContextLocatorException e) {
            throw new SQLParserException("Could not parse one of the parameters: " + e.getMessage(), e);
        }
    }

    public static String parseSQL(String pSQL, Object[] pParameters) throws IntegrityViolationException, SQLParserException {
        return SQLParser.parseSQL(new SQLParserParams(pSQL, pParameters));
    }

    public static String expandIn(String pSQL, Object[] pInParameters, String pDateFormat, String pTimeFormat) throws SQLParserException {
        try {
            if (Utils.isEmptyString((String)pSQL)) {
                throw new SQLParserException("No SQL statement was specified to be parsed");
            }
            if (pInParameters == null) {
                throw new SQLParserException("No valid In Parameters object was specified");
            }
            int vIndexInSQLofBraces = pSQL.indexOf("()");
            if (vIndexInSQLofBraces == -1) {
                throw new SQLParserException("No valid IN () token was specified to be replaced");
            }
            StringCoercions vSC = new StringCoercions(pDateFormat, pTimeFormat);
            StringBuffer vParsedSQL = new StringBuffer(pSQL);
            StringBuffer vExpandedInClause = new StringBuffer();
            int vLength = pInParameters.length;
            for (int i = 0; i < vLength; ++i) {
                if (i > 0) {
                    vExpandedInClause.append(",");
                }
                vExpandedInClause.append(SQLParser.quoteIfNeeded(vSC.coerceValueToString(pInParameters[i]), pInParameters[i]));
            }
            if (vLength <= 0) {
                vExpandedInClause = new StringBuffer("null");
            }
            vParsedSQL.replace(vIndexInSQLofBraces, vIndexInSQLofBraces + 2, "(" + vExpandedInClause + ")");
            return vParsedSQL.toString();
        }
        catch (CoercionException e) {
            throw new SQLParserException("Could not parse one of the parameters: " + e.getMessage(), e);
        }
    }

    public static String expandIn(String pSQL, Object[] pInParameters) throws SQLParserException {
        return SQLParser.expandIn(pSQL, pInParameters, null, null);
    }

    public static String readClob(Clob pClob) {
        try {
            String vLine;
            StringBuffer vBuffer = new StringBuffer();
            BufferedReader vReader = new BufferedReader(pClob.getCharacterStream());
            while ((vLine = vReader.readLine()) != null) {
                vBuffer.append(vLine);
            }
            return vBuffer.toString();
        }
        catch (SQLException e) {
            throw new SQLParserException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SQLParserException(e.getMessage(), e);
        }
    }

    public static byte[] readBlob(Blob pBlob) {
        try {
            BufferedInputStream vBIS = new BufferedInputStream(pBlob.getBinaryStream());
            ByteArrayOutputStream vBOS = new ByteArrayOutputStream();
            byte[] vBuf = new byte[4096];
            int vLen = 0;
            while ((vLen = vBIS.read(vBuf, 0, vBuf.length)) != -1) {
                vBOS.write(vBuf, 0, vLen);
            }
            return vBOS.toByteArray();
        }
        catch (SQLException e) {
            throw new SQLParserException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SQLParserException(e.getMessage(), e);
        }
    }

    private static String quoteIfNeeded(String pValue, Object pValueType) {
        if (pValueType instanceof String || pValueType instanceof StringBuffer || pValueType instanceof Date) {
            return '\'' + StringUtils.escapeQuotesInString((String)pValue, (char)'\'') + '\'';
        }
        return pValue;
    }

    static boolean isInQuotes(String pSQL, int pPlaceholderCharPos, char pQuoteChar) {
        boolean vInQuotes = false;
        int vLength = pSQL.length();
        for (int i = 0; i < vLength; ++i) {
            if (pSQL.charAt(i) == pQuoteChar) {
                boolean bl = vInQuotes = !vInQuotes;
            }
            if (i == pPlaceholderCharPos) break;
        }
        return vInQuotes;
    }

    private static int countParamPlaceholders(String pSQL, char pPlaceholder, boolean pPlaceholdersInParams) {
        boolean vInQuotes = false;
        int vPlaceholderCount = 0;
        int vLength = pSQL.length();
        for (int i = 0; i < vLength; ++i) {
            char vChar = pSQL.charAt(i);
            if (vChar == '\'') {
                vInQuotes = !vInQuotes;
                continue;
            }
            if (vChar != pPlaceholder || !pPlaceholdersInParams && vInQuotes) continue;
            ++vPlaceholderCount;
        }
        return vPlaceholderCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

