/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.parser;

import net.za.pwnconsulting.dblayer.parser.IntegrityViolationException;
import net.za.pwnconsulting.dblayer.parser.QLIntegrityCheck;
import net.za.pwnconsulting.dblayer.parser.SQLParser;
import net.za.pwnconsulting.dblayer.support.AbstractBaseDBLayerConfiguration;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.dom4j.Node;

public class SQLIntegrityCheck
extends AbstractBaseDBLayerConfiguration
implements QLIntegrityCheck {
    private static final char ESCAPE_CHAR = '\\';
    private static int PARANOIA_LEVEL = -100;

    protected void initFramework(Node pConfig) throws ConfigurationException {
        super.initFramework(pConfig);
        String vValue = this.getSettings().getParameterByNameSilent("ParanoiaLevel");
        if (!Utils.isEmptyString((String)vValue)) {
            if (vValue.equalsIgnoreCase("PARANOIA_DISABLED")) {
                PARANOIA_LEVEL = -1;
            } else if (vValue.equalsIgnoreCase("PARANOIA_HIGH")) {
                PARANOIA_LEVEL = 10;
            } else if (vValue.equalsIgnoreCase("PARANOIA_MEDIUM")) {
                PARANOIA_LEVEL = 5;
            } else if (vValue.equalsIgnoreCase("PARANOIA_LOW")) {
                PARANOIA_LEVEL = 0;
            } else {
                throw new ConfigurationException("ParanoiaLevel set to unknown value [" + vValue + "]");
            }
        }
    }

    public void checkSQLIntegrity(String pQuery, int pParanoiaLevel) throws IntegrityViolationException {
        int vParanoiaLevel = this.getParanoiaLevel(pParanoiaLevel);
        if (vParanoiaLevel > -1) {
            if (Utils.isEmptyString((String)pQuery)) {
                throw new IntegrityViolationException("The SQL statement is either null or empty");
            }
            int vQuoteCount = 0;
            int vQueryLength = pQuery.length();
            for (int i = 0; i < vQueryLength; ++i) {
                char vPreviousQueryChar;
                char vQueryChar = pQuery.charAt(i);
                char c = vPreviousQueryChar = i == 0 ? (char)'\u0000' : pQuery.charAt(i - 1);
                if (vQueryChar == '\'' && (i <= 0 || i > 0 && vPreviousQueryChar != '\\')) {
                    ++vQuoteCount;
                }
                if (vParanoiaLevel != 10 || vQueryChar != '\'' || vPreviousQueryChar != '\\') continue;
                throw new IntegrityViolationException("The SQL statement [" + pQuery + "] has manually escaped quote characters and " + "the paranoia level is PARANOIA_HIGH");
            }
            if (vQuoteCount % 2 != 0) {
                throw new IntegrityViolationException("The SQL statement [" + pQuery + "] has an uneven amount of quote characters");
            }
            if (vParanoiaLevel == 5) {
                int vPos = 0;
                String[] vCommentStrings = new String[]{"--", "#", "/*"};
                for (int i = 0; i < vCommentStrings.length; ++i) {
                    while ((vPos = pQuery.indexOf(vCommentStrings[i], vPos)) != -1) {
                        if (!SQLParser.isInQuotes(pQuery, vPos, '\'')) {
                            throw new IntegrityViolationException("Illegal comment character [" + vCommentStrings[i] + "] found in SQL statement [" + pQuery + "] and the paranoia level is PARANOIA_MEDIUM");
                        }
                        ++vPos;
                    }
                }
            }
        }
    }

    private int getParanoiaLevel(int pParanoiaLevel) {
        try {
            if (pParanoiaLevel != -100) {
                return pParanoiaLevel;
            }
            if (PARANOIA_LEVEL == -100) {
                throw new ConfigurationException("ParanoiaLevel never assigned");
            }
            return PARANOIA_LEVEL;
        }
        catch (ConfigurationException e) {
            return 10;
        }
    }
}

