/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.conn.pool.vendor_datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.sql.DataSource;
import net.za.pwnconsulting.dblayer.conn.pool.AbstractDBConnectionPool;
import net.za.pwnconsulting.dblayer.conn.pool.DBConnectionPoolException;
import net.za.pwnconsulting.dblayer.conn.pool.Retries;
import net.za.pwnconsulting.dblayer.conn.pool.vendor_datasource.JDBC2DSPoolParameters;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDIException;
import net.za.pwnconsulting.javaconfig.j2ee.jndi.JNDISupport;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.dom4j.Node;

public class JDBC2DSDBConnectionPool
extends AbstractDBConnectionPool {
    private JDBC2DSPoolParameters mPoolParameters;
    private DataSource mDataSource;

    public void initPool(Node pPool, Retries pRetries) throws ConfigurationException {
        Retries vRetries;
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Reading pool configuration...");
        String vPoolName = pPool.valueOf("./@name");
        String vDatasourceJNDIName = pPool.valueOf("./@datasource_jndi_name");
        String vInitialContextFactory = pPool.valueOf("./@initial_context_factory");
        if (Utils.isEmptyString((String)vPoolName) || Utils.isEmptyString((String)vDatasourceJNDIName) || Utils.isEmptyString((String)vInitialContextFactory)) {
            throw new ConfigurationException("The XML configuration document contains an invalid pool configuration");
        }
        try {
            vRetries = AbstractDBConnectionPool.loadRetries(pPool.selectSingleNode("./retries"));
        }
        catch (ConfigurationException e) {
            vRetries = pRetries;
        }
        boolean vSupportsTransactions = Utils.getBool((String)pPool.valueOf("./@supports_transactions"));
        String vDateFormat = pPool.valueOf("./@date_fmt");
        String vTimeFormat = pPool.valueOf("./@time_fmt");
        this.mPoolParameters = new JDBC2DSPoolParameters(vPoolName, vDatasourceJNDIName, vInitialContextFactory, vRetries, vSupportsTransactions, vDateFormat, vTimeFormat);
        this.mPoolName = this.mPoolParameters.getPoolName();
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Initialized pool [" + this.mPoolName + "]");
    }

    public void start() throws DBConnectionPoolException {
        if (this.isStarted()) {
            return;
        }
        try {
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Starting pool [" + this.mPoolName + "]...");
            Hashtable<String, String> vEnv = new Hashtable<String, String>();
            vEnv.put("java.naming.factory.initial", this.mPoolParameters.getInitialContextFactory());
            JNDISupport vJNDISupport = new JNDISupport(vEnv);
            Object vDatasource = vJNDISupport.lookup(this.mPoolParameters.getDatasourceJNDIName());
            if (!(vDatasource instanceof DataSource)) {
                throw new DBConnectionPoolException("Could not lookup DataSource in JNDI tree as it is not of type DataSource");
            }
            this.mDataSource = (DataSource)vDatasource;
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Started pool [" + this.mPoolName + "]...");
            this.mStarted = true;
        }
        catch (JNDIException e) {
            String vMessage = "Could not start pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionPoolException(vMessage, e);
        }
    }

    public void stop() throws DBConnectionPoolException {
        if (!this.isStarted()) {
            return;
        }
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Stopping pool [" + this.mPoolName + "]...");
        this.mDataSource = null;
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Stopped pool [" + this.mPoolName + "]...");
        this.mStarted = false;
    }

    public Connection getConnection(boolean pForceNew) throws DBConnectionPoolException {
        try {
            Connection vConnection = this.mDataSource.getConnection();
            vConnection.setAutoCommit(false);
            if (this.mDatabaseProductName.equals("Unknown")) {
                BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Detecting RDBMS type...");
                this.mDatabaseProductName = vConnection.getMetaData().getDatabaseProductName();
                BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Detected pool [" + this.mPoolName + "] as servicing an [" + this.mDatabaseProductName + "] RDBMS");
            }
            return vConnection;
        }
        catch (SQLException e) {
            String vMessage = "Could not retrieve a connection in pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionPoolException(vMessage, e);
        }
    }

    public void releaseConnection(Connection pConnection) throws DBConnectionPoolException {
        try {
            if (pConnection != null) {
                pConnection.close();
            }
        }
        catch (SQLException e) {
            String vMessage = "Could not release the connection back to the pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionPoolException(vMessage, e);
        }
    }

    public void removeConnection(Connection pConnection) throws DBConnectionPoolException {
        try {
            if (pConnection != null) {
                pConnection.close();
            }
        }
        catch (SQLException e) {
            String vMessage = "Could not remove the connection from the pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionPoolException(vMessage, e);
        }
    }

    public Retries getPoolRetries() {
        return this.mPoolParameters.getRetries();
    }

    public boolean supportsTransactions() {
        return this.mPoolParameters.isSupportsTransactions();
    }

    public String getDateFormat() {
        return this.mPoolParameters.getDateFormat();
    }

    public String getTimeFormat() {
        return this.mPoolParameters.getTimeFormat();
    }
}

