/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.conn.pool.standard;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Timer;
import java.util.TimerTask;
import net.za.pwnconsulting.dblayer.conn.ManagedConnection;
import net.za.pwnconsulting.dblayer.conn.ManagedConnectionException;
import net.za.pwnconsulting.dblayer.conn.ManagedConnectionList;
import net.za.pwnconsulting.dblayer.conn.pool.AbstractDBConnectionPool;
import net.za.pwnconsulting.dblayer.conn.pool.DBConnectionPoolException;
import net.za.pwnconsulting.dblayer.conn.pool.Retries;
import net.za.pwnconsulting.dblayer.conn.pool.standard.ConnectionCacheMonitor;
import net.za.pwnconsulting.dblayer.conn.pool.standard.PoolParameters;
import net.za.pwnconsulting.dblayer.conn.pool.standard.URLDecoder;
import net.za.pwnconsulting.javaconfig.beans.BeanFactoryException;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.exceptions.ExceptionHelper;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import net.za.pwnconsulting.javaconfig.utils.encryption.Encryption;
import net.za.pwnconsulting.javaconfig.utils.encryption.EncryptionException;
import org.dom4j.Node;

public class JDBCDBConnectionPool
extends AbstractDBConnectionPool {
    private PoolParameters mPoolParameters;
    private ManagedConnectionList mConnections = new ManagedConnectionList();
    private Timer mConnectionCacheMonitor = new Timer(true);
    private static final int WARN_MAX_CON = 100;
    private static final int WARN_MIN_CON = 50;
    private static final int WARN_MIN_CON_USAGE = 10;
    static /* synthetic */ Class class$net$za$pwnconsulting$javaconfig$utils$encryption$Encryption;
    static /* synthetic */ Class class$net$za$pwnconsulting$dblayer$conn$pool$standard$URLDecoder;

    public void initPool(Node pPool, Retries pRetries) throws ConfigurationException {
        Retries vRetries;
        int vMonitorInterval;
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Reading pool configuration...");
        String vPoolName = pPool.valueOf("./@name");
        String vUsername = pPool.valueOf("./@user");
        String vPassword = pPool.valueOf("./@password");
        String vURLDecoder = pPool.valueOf("./@url_decoder");
        if (vPoolName == null || vPoolName.equals("")) {
            throw new ConfigurationException("The XML configuration document contains an invalid pool configuration");
        }
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Detected pool [" + vPoolName + "], continuing initialization...");
        try {
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Decrypting password [***MASKED***]...");
            Encryption vEncryption = (Encryption)this.getConfiguration().getBeanFactory().getBean(class$net$za$pwnconsulting$javaconfig$utils$encryption$Encryption == null ? (class$net$za$pwnconsulting$javaconfig$utils$encryption$Encryption = JDBCDBConnectionPool.class$("net.za.pwnconsulting.javaconfig.utils.encryption.Encryption")) : class$net$za$pwnconsulting$javaconfig$utils$encryption$Encryption);
            vEncryption.init("dsfTYty%^&2 23;'\u00a8\u00a9\u0192\u0192\u2202\u00ae\u00ae\u00ae\u2020Q=");
            vPassword = vEncryption.decryptData(vPassword);
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Successfully decrypted password");
        }
        catch (EncryptionException e) {
            String vMessage = "Could not decrypt password: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new ConfigurationException(vMessage, (Throwable)e);
        }
        catch (BeanFactoryException e) {
            String vMessage = "Could not load the Encryption object to decrypt the password: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new ConfigurationException(vMessage, (Throwable)e);
        }
        String vURL = pPool.valueOf("./@url");
        if (vURL == null || vURL.equals("")) {
            throw new ConfigurationException("The XML configuration document contains an invalid pool configuration");
        }
        if (!Utils.isEmptyString((String)vURLDecoder)) {
            try {
                BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "-> Decoding URL [" + vURL.substring(0, vURL.length() > 10 ? 10 : vURL.length()) + "...**MASKED***] with [" + vURLDecoder + "]...");
                URLDecoder vDecoder = (URLDecoder)this.getConfiguration().getBeanFactory().createUncachedBean(vURLDecoder, vURLDecoder, class$net$za$pwnconsulting$dblayer$conn$pool$standard$URLDecoder == null ? (class$net$za$pwnconsulting$dblayer$conn$pool$standard$URLDecoder = JDBCDBConnectionPool.class$("net.za.pwnconsulting.dblayer.conn.pool.standard.URLDecoder")) : class$net$za$pwnconsulting$dblayer$conn$pool$standard$URLDecoder);
                vURL = vDecoder.decodeURL(this.getConfiguration(), vURL);
                BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "-> Successfully decoded URL");
            }
            catch (Exception e) {
                String vMessage = "Could not decode URL: " + e.getMessage();
                BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
                throw new ConfigurationException(vMessage, (Throwable)e);
            }
        }
        int vMaxCon = Utils.getInt((String)pPool.valueOf("./@max_connections"));
        int vMinCon = Utils.getInt((String)pPool.valueOf("./@min_connections"));
        int vFreeConThreshold = Utils.getInt((String)pPool.valueOf("./@free_con_threshold"));
        int vMaxConUsage = Utils.getInt((String)pPool.valueOf("./@max_con_usage"));
        if (vMaxCon < 0 || vMinCon < 0 || vFreeConThreshold < 0) {
            throw new ConfigurationException("The XML configuration document contains an invalid entry [some of max_connections,min_connections,free_con_threshold are < 0]");
        }
        if (vMaxCon < vMinCon) {
            throw new ConfigurationException("The XML configuration document contains an invalid entry [max_connections < min_connections]");
        }
        if (vMinCon < vFreeConThreshold) {
            throw new ConfigurationException("The XML configuration document contains an invalid entry [min_connections < free_con_threshold]");
        }
        if (vMaxCon - vMinCon < vFreeConThreshold) {
            throw new ConfigurationException("The XML configuration document contains an invalid entry [(max_connections-min_connections) < free_con_threshold]");
        }
        if (vMaxCon >= 100) {
            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "The pool [" + vPoolName + "] has max_connections >= " + 100 + ", which can result in a severe degradation in performance");
        }
        if (vMinCon >= 50) {
            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "The pool [" + vPoolName + "] has min_connections >= " + 50 + ", which can result in the exhaustion of database connections");
        }
        if (vMaxConUsage <= 10) {
            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "The pool [" + vPoolName + "] has max_con_usage <= " + 10 + ", which can result in a severe degradation in performance");
        }
        if ((vMonitorInterval = Utils.getInt((String)pPool.valueOf("./@monitor_interval"))) <= 0) {
            throw new ConfigurationException("The XML configuration document contains an invalid entry [monitor_interval <= 0]");
        }
        try {
            vRetries = AbstractDBConnectionPool.loadRetries(pPool.selectSingleNode("./retries"));
        }
        catch (ConfigurationException e) {
            vRetries = pRetries;
        }
        boolean vSupportsTransactions = Utils.getBool((String)pPool.valueOf("./@supports_transactions"));
        String vDateFormat = pPool.valueOf("./@date_fmt");
        String vTimeFormat = pPool.valueOf("./@time_fmt");
        this.mPoolParameters = new PoolParameters(vPoolName, vURL, vUsername, vPassword, vMaxCon, vMinCon, vFreeConThreshold, vMaxConUsage, vMonitorInterval, vRetries, vSupportsTransactions, vDateFormat, vTimeFormat);
        this.mPoolName = this.mPoolParameters.getPoolName();
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Initialized pool [" + this.mPoolName + "]");
    }

    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Starting pool [" + this.mPoolName + "]...");
        ConnectionCacheMonitor vCCM = new ConnectionCacheMonitor(this);
        this.mConnectionCacheMonitor.schedule((TimerTask)vCCM, 0L, (long)(this.mPoolParameters.getMonitorInterval() * 1000));
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Started pool [" + this.mPoolName + "]...");
        this.mStarted = true;
    }

    public synchronized void stop() throws DBConnectionPoolException {
        if (!this.isStarted()) {
            return;
        }
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Stopping pool [" + this.mPoolName + "]...");
        this.mConnectionCacheMonitor.cancel();
        this.mConnectionCacheMonitor = new Timer(true);
        try {
            for (int i = 0; i < this.mConnections.getTotalCachedCount(); ++i) {
                ManagedConnection vMC = (ManagedConnection)this.mConnections.getAllConnections().get(i);
                Connection vC = vMC.checkOutConnection();
                if (vC == null || vC.isClosed()) continue;
                try {
                    vC.commit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                vC.close();
            }
            this.mConnections.removeAllConnections();
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Stopped pool [" + this.mPoolName + "]...");
            this.mStarted = false;
        }
        catch (SQLException e) {
            String vMessage = "Could not stop pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionPoolException(vMessage, e);
        }
    }

    private Connection getNewConnection() throws SQLException {
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Creating new connection in pool [" + this.mPoolName + "] with params [" + this.mPoolParameters.getURL().substring(0, this.mPoolParameters.getURL().length() > 10 ? 10 : this.mPoolParameters.getURL().length()) + "...**MASKED***," + this.mPoolParameters.getUsername() + ",XXXXXX]");
        Connection vConnection = this.mPoolParameters.hasUsername() ? DriverManager.getConnection(this.mPoolParameters.getURL(), this.mPoolParameters.getUsername(), this.mPoolParameters.getPassword()) : DriverManager.getConnection(this.mPoolParameters.getURL());
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Created new connection in pool [" + this.mPoolName + "]");
        vConnection.setAutoCommit(false);
        if (this.mDatabaseProductName.equals("Unknown")) {
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Detecting RDBMS type...");
            this.mDatabaseProductName = vConnection.getMetaData().getDatabaseProductName();
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Detected pool [" + this.mPoolName + "] as servicing an [" + this.mDatabaseProductName + "] RDBMS");
        }
        return vConnection;
    }

    public void makeNewCachedConnection() throws DBConnectionPoolException {
        this.releaseConnection(this.getConnection(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(boolean pForceNew) throws DBConnectionPoolException {
        try {
            ManagedConnectionList managedConnectionList = this.mConnections;
            synchronized (managedConnectionList) {
                if (pForceNew) {
                    BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Forcibly creating new connection in pool [" + this.mPoolName + "]");
                    if (this.mConnections.getTotalCachedCount() >= this.mPoolParameters.getMaxCon()) {
                        throw new DBConnectionPoolException("Maximum amount of allowed connections [" + this.mPoolParameters.getMaxCon() + "] reached in pool [" + this.getPoolName() + "]");
                    }
                    ManagedConnection vMC = new ManagedConnection(this.getNewConnection());
                    this.mConnections.addConnection(vMC);
                    BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Forcibly created new connection in pool [" + this.mPoolName + "]");
                    return vMC.checkOutConnection();
                }
                try {
                    BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Retrieving connection from cache in pool [" + this.mPoolName + "]");
                    ManagedConnection vMC = this.mConnections.getAvailableConnection();
                    BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Retrieved connection from cache in pool [" + this.mPoolName + "]");
                    if (vMC.getCheckedOutCount() >= this.getPoolParameters().getMaxConUsage()) {
                        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Connection in pool [" + this.mPoolName + "] exceeded the maximum usage count of [" + this.getPoolParameters().getMaxConUsage() + "], removing from the cache and replacing with a " + "new connection...");
                        this.removeConnection(vMC.checkOutConnection());
                        return this.getConnection(true);
                    }
                    return vMC.checkOutConnection();
                }
                catch (ManagedConnectionException e) {
                    BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Failed retrieving connection from cache in pool [" + this.mPoolName + "]... Trying to make new connection");
                    return this.getConnection(true);
                }
            }
        }
        catch (SQLException e) {
            String vMessage = "Could not retrieve a connection in pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage, (Throwable)e);
            SQLException vE = e;
            while ((vE = vE.getNextException()) != null) {
                BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, ExceptionHelper.getFullStackTrace((Throwable)vE));
            }
            throw new DBConnectionPoolException(vMessage, e);
        }
    }

    public void releaseConnection(Connection pConnection) throws DBConnectionPoolException {
        try {
            this.mConnections.putBackConnection(pConnection);
        }
        catch (ManagedConnectionException e) {
            String vMessage = "Could not release the connection back to the pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionPoolException(vMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeConnection(Connection pConnection) throws DBConnectionPoolException {
        try {
            try {
                if (pConnection != null && !pConnection.isClosed()) {
                    pConnection.close();
                }
                Object var3_2 = null;
                if (pConnection == null) return;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (pConnection == null) throw throwable;
                this.mConnections.removeConnection(pConnection);
                throw throwable;
            }
            this.mConnections.removeConnection(pConnection);
            return;
        }
        catch (SQLException e) {
            String vMessage = "Non-critical exception encountered while removing the connection from the pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            return;
        }
        catch (ManagedConnectionException e) {
            String vMessage = "Non-critical exception encountered while removing the connection from the pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
        }
    }

    public void removeCachedConnection() throws DBConnectionPoolException {
        try {
            ManagedConnection vMC = this.mConnections.getAvailableConnection();
            Connection vC = vMC.checkOutConnection();
            if (vC != null && !vC.isClosed()) {
                vC.close();
            }
            this.mConnections.removeConnection(vC);
        }
        catch (SQLException e) {
            String vMessage = "Could not remove a connection from the pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionPoolException(vMessage, e);
        }
        catch (ManagedConnectionException e) {
            String vMessage = "Could not remove a connection from the pool [" + this.getPoolName() + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionPoolException(vMessage, e);
        }
    }

    public PoolParameters getPoolParameters() {
        return this.mPoolParameters;
    }

    ManagedConnectionList getConnectionList() {
        return this.mConnections;
    }

    public Retries getPoolRetries() {
        return this.mPoolParameters.getRetries();
    }

    public boolean supportsTransactions() {
        return this.mPoolParameters.isSupportsTransactions();
    }

    public String getDateFormat() {
        return this.mPoolParameters.getDateFormat();
    }

    public String getTimeFormat() {
        return this.mPoolParameters.getTimeFormat();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

