/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.conn.pool.standard;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import net.za.pwnconsulting.javaconfig.utils.encryption.Encryption;
import net.za.pwnconsulting.javaconfig.utils.encryption.RC4Encryption;

public class DBPasswordUtility {
    private DBPasswordUtility() {
    }

    public static void main(String[] args) {
        try {
            if (args.length >= 2) {
                System.out.println("Usage: ");
                System.out.println("java net.za.pwnconsulting.dblayer.conn.pool.standard.DBPasswordUtility [EncryptionClass]");
                System.out.println("EncryptionClass   The fully qualified name of a valid Encryption class.  Default is RC4Encryption");
                return;
            }
            RC4Encryption vEncryption = null;
            if (args.length == 1) {
                Class<?> vEnc = Class.forName(args[0]);
                Object vEncO = vEnc.newInstance();
                if (!(vEncO instanceof Encryption)) {
                    throw new IllegalArgumentException("EncryptionClass specified must be the fully qualified name of a valid Encryption class");
                }
                vEncryption = (Encryption)vEncO;
            } else {
                vEncryption = new RC4Encryption();
            }
            System.out.print("Specify the password: ");
            InputStreamReader vISR = new InputStreamReader(System.in);
            BufferedReader vInput = new BufferedReader(vISR);
            String vRawPwd = vInput.readLine();
            if (vRawPwd == null) {
                System.out.println("Password was not given!");
                System.exit(1);
            }
            System.out.println("");
            vEncryption.init("dsfTYty%^&2 23;'\u00a8\u00a9\u0192\u0192\u2202\u00ae\u00ae\u00ae\u2020Q=");
            String vPassword = vEncryption.encryptData(vRawPwd);
            System.out.println("Using [" + vEncryption.getClass().getName() + "] as encryption algorithm...");
            System.out.println("Encrypted password: [" + vPassword + "]");
            System.out.println("Save this password (without the braces) in dblayer.xml");
            System.out.println("Ensure the same encryption class is specified in your dblayer-framework.xml file");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

