/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.conn.pool.standard;

import java.util.TimerTask;
import net.za.pwnconsulting.dblayer.conn.pool.DBConnectionPoolException;
import net.za.pwnconsulting.dblayer.conn.pool.standard.JDBCDBConnectionPool;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.LMS;
import org.apache.log4j.Logger;

public class ConnectionCacheMonitor
extends TimerTask {
    private JDBCDBConnectionPool mJDBCDBConnectionPool;
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());

    public ConnectionCacheMonitor(JDBCDBConnectionPool pJDBCDBConnectionPool) {
        this.mJDBCDBConnectionPool = pJDBCDBConnectionPool;
        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Connection Cache Monitor started for pool [" + this.mJDBCDBConnectionPool.getPoolName() + "]");
    }

    public void run() {
        try {
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Connection Cache Monitor running in pool [" + this.mJDBCDBConnectionPool.getPoolName() + "]...");
            int vCachedConnections = this.mJDBCDBConnectionPool.getConnectionList().getTotalCachedCount();
            int vCheckedOutConnectionCount = this.mJDBCDBConnectionPool.getConnectionList().getCheckedOutConnectionCount();
            int vMinConnectionCount = this.mJDBCDBConnectionPool.getPoolParameters().getMinCon();
            int vMaxConnectionCount = this.mJDBCDBConnectionPool.getPoolParameters().getMaxCon();
            int vFreeConnectionThreshold = this.mJDBCDBConnectionPool.getPoolParameters().getFreeConThreshold();
            int vConnsToCreate = vFreeConnectionThreshold - (vCachedConnections - vCheckedOutConnectionCount);
            if (vCachedConnections + vConnsToCreate < vMinConnectionCount) {
                vConnsToCreate = vMinConnectionCount - vCachedConnections;
            } else if (vCachedConnections + vConnsToCreate > vMaxConnectionCount) {
                vConnsToCreate = vMaxConnectionCount - vCachedConnections;
            }
            if (vConnsToCreate > 0) {
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Creating [" + vConnsToCreate + "] new connections in pool [" + this.mJDBCDBConnectionPool.getPoolName() + "]");
                for (int i = 0; i < vConnsToCreate; ++i) {
                    this.mJDBCDBConnectionPool.makeNewCachedConnection();
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Unexpected InterruptedException encountered while starting pool [" + this.mJDBCDBConnectionPool.getPoolName() + "]");
                    }
                }
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Created [" + vConnsToCreate + "] new connections in pool [" + this.mJDBCDBConnectionPool.getPoolName() + "]");
            } else if (vConnsToCreate < 0) {
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Destroying [" + Math.abs(vConnsToCreate) + "] connections in pool [" + this.mJDBCDBConnectionPool.getPoolName() + "]");
                for (int i = 0; i < Math.abs(vConnsToCreate); ++i) {
                    this.mJDBCDBConnectionPool.removeCachedConnection();
                }
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Destroyed [" + Math.abs(vConnsToCreate) + "] connections in pool [" + this.mJDBCDBConnectionPool.getPoolName() + "]");
            }
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Stats in pool [" + this.mJDBCDBConnectionPool.getPoolName() + "]: " + "{TotCached=" + this.mJDBCDBConnectionPool.getConnectionList().getTotalCachedCount() + ",CheckedOut=" + this.mJDBCDBConnectionPool.getConnectionList().getCheckedOutConnectionCount() + ",Min=" + vMinConnectionCount + ",Max=" + vMaxConnectionCount + ",FreeThreshold=" + vFreeConnectionThreshold + "}");
        }
        catch (DBConnectionPoolException e) {
            BasicLogger.getBasicLogger().warn(this.mLogger, LMS.OWNER_DBLAYER, "Problem in maintaining connection cache in pool [" + this.mJDBCDBConnectionPool.getPoolName() + "]: " + e.getMessage());
        }
    }
}

