/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.conn.pool;

import net.za.pwnconsulting.dblayer.conn.pool.DBConnectionPool;
import net.za.pwnconsulting.dblayer.conn.pool.Retries;
import net.za.pwnconsulting.dblayer.support.AbstractBaseDBLayerConfiguration;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.apache.log4j.Logger;
import org.dom4j.Node;

public abstract class AbstractDBConnectionPool
extends AbstractBaseDBLayerConfiguration
implements DBConnectionPool {
    protected String mPoolName;
    protected boolean mStarted = false;
    protected String mDatabaseProductName = "Unknown";
    private static final int DEFAULT_BROKEN_CON_RETRY_COUNT = 0;
    private static final int DEFAULT_BROKEN_CON_RETRY_WAIT = 0;
    private static final int DEFAULT_LOCKED_ROW_RETRY_COUNT = 0;
    private static final int DEFAULT_LOCKED_ROW_RETRY_WAIT = 0;
    protected final Logger mLogger = Logger.getLogger((String)this.getClass().getName());

    protected AbstractDBConnectionPool() {
    }

    public static Retries loadRetries(Node pRetries) throws ConfigurationException {
        if (pRetries != null) {
            String vBrokenConRetryCount = pRetries.valueOf("./broken_conn/@retry_count");
            String vBrokenConRetryWait = pRetries.valueOf("./broken_conn/@retry_delay");
            String vLockedRowRetryCount = pRetries.valueOf("./locked_row/@retry_count");
            String vLockedRowRetryWait = pRetries.valueOf("./locked_row/@retry_delay");
            if (!Utils.isValidInteger((String)vBrokenConRetryCount)) {
                throw new ConfigurationException("The XML configuration document does not contain a valid broken_conn node");
            }
            if (!Utils.isValidInteger((String)vBrokenConRetryWait)) {
                throw new ConfigurationException("The XML configuration document does not contain a valid broken_conn node");
            }
            if (!Utils.isValidInteger((String)vLockedRowRetryCount)) {
                throw new ConfigurationException("The XML configuration document does not contain a valid locked_row node");
            }
            if (!Utils.isValidInteger((String)vLockedRowRetryWait)) {
                throw new ConfigurationException("The XML configuration document does not contain a valid locked_row node");
            }
            Retries vRetries = new Retries(Utils.getInt((String)vBrokenConRetryCount), Utils.getInt((String)vBrokenConRetryWait), Utils.getInt((String)vLockedRowRetryCount), Utils.getInt((String)vLockedRowRetryWait));
            return vRetries;
        }
        return new Retries(0, 0, 0, 0);
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    public String getPoolName() {
        return this.mPoolName;
    }

    public String getDatabaseProductName() {
        return this.mDatabaseProductName;
    }
}

