/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.conn;

import java.sql.Connection;
import java.util.Iterator;
import net.za.pwnconsulting.dblayer.conn.AbstractDBConnectionLayer;
import net.za.pwnconsulting.dblayer.conn.DBConnectionLayerException;
import net.za.pwnconsulting.dblayer.conn.pool.DBConnectionPool;
import net.za.pwnconsulting.dblayer.conn.pool.DBConnectionPoolException;
import net.za.pwnconsulting.dblayer.conn.pool.Retries;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.LMS;
import org.dom4j.Document;

public class StandardDBConnectionLayer
extends AbstractDBConnectionLayer {
    protected void initConfig(Document pDocument) throws ConfigurationException {
    }

    public void start() throws DBConnectionPoolException {
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Starting All Pools...");
        Iterator vI = this.mPools.keySet().iterator();
        while (vI.hasNext()) {
            ((DBConnectionPool)this.mPools.get(vI.next())).start();
        }
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "All Pools Started.");
    }

    public void stop() throws DBConnectionPoolException {
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Stopping All Pools...");
        Iterator vI = this.mPools.keySet().iterator();
        while (vI.hasNext()) {
            ((DBConnectionPool)this.mPools.get(vI.next())).stop();
        }
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "All Pools Stopped.");
    }

    public void start(String pPoolName) throws DBConnectionLayerException, DBConnectionPoolException {
        if (!this.mPools.containsKey(pPoolName)) {
            throw new DBConnectionLayerException("Could not start pool [" + pPoolName + "] because it was not found");
        }
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Starting Pool [" + pPoolName + "]...");
        ((DBConnectionPool)this.mPools.get(pPoolName)).start();
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Started Pool [" + pPoolName + "]...");
    }

    public void stop(String pPoolName) throws DBConnectionLayerException, DBConnectionPoolException {
        if (!this.mPools.containsKey(pPoolName)) {
            throw new DBConnectionLayerException("Could not stop pool [" + pPoolName + "] because it was not found");
        }
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Stopping Pool [" + pPoolName + "]...");
        ((DBConnectionPool)this.mPools.get(pPoolName)).stop();
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Stopped Pool [" + pPoolName + "]...");
    }

    public Connection getConnection(String pPoolName, boolean pForceNew) throws DBConnectionLayerException {
        String vPoolName = pPoolName;
        if (!this.mPools.containsKey(pPoolName)) {
            if (!this.mPoolAliases.containsKey(pPoolName)) {
                throw new DBConnectionLayerException("Could not locate pool [" + pPoolName + "]");
            }
            vPoolName = (String)this.mPoolAliases.get(pPoolName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Requested pool [" + pPoolName + "] is aliased to pool [" + vPoolName + "]");
        }
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Retrieving [" + (pForceNew ? "new" : "cached") + "] connection in pool [" + pPoolName + "]...");
        try {
            DBConnectionPool vPool = (DBConnectionPool)this.mPools.get(vPoolName);
            return vPool.getConnection(pForceNew);
        }
        catch (DBConnectionPoolException e) {
            String vMessage = "Problem in DBLayer: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionLayerException(vMessage, (Throwable)((Object)e));
        }
    }

    public Connection getConnection(String pPoolName) throws DBConnectionLayerException {
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Retrieving connection in pool [" + pPoolName + "]...");
        return this.getConnection(pPoolName, false);
    }

    public void releaseConnection(Connection pConnection, String pPoolName) throws DBConnectionLayerException {
        String vPoolName = pPoolName;
        if (!this.mPools.containsKey(pPoolName)) {
            if (!this.mPoolAliases.containsKey(pPoolName)) {
                throw new DBConnectionLayerException("Could not locate pool [" + pPoolName + "]");
            }
            vPoolName = (String)this.mPoolAliases.get(pPoolName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Requested pool [" + pPoolName + "] is aliased to pool [" + vPoolName + "]");
        }
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Releasing connection in pool [" + pPoolName + "]...");
        try {
            DBConnectionPool vPool = (DBConnectionPool)this.mPools.get(vPoolName);
            vPool.releaseConnection(pConnection);
        }
        catch (DBConnectionPoolException e) {
            String vMessage = "Problem in DBLayer: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionLayerException(vMessage, (Throwable)((Object)e));
        }
    }

    public void removeConnection(Connection pConnection, String pPoolName) throws DBConnectionLayerException {
        String vPoolName = pPoolName;
        if (!this.mPools.containsKey(pPoolName)) {
            if (!this.mPoolAliases.containsKey(pPoolName)) {
                throw new DBConnectionLayerException("Could not locate pool [" + pPoolName + "]");
            }
            vPoolName = (String)this.mPoolAliases.get(pPoolName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Requested pool [" + pPoolName + "] is aliased to pool [" + vPoolName + "]");
        }
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Removing connection from pool [" + pPoolName + "]...");
        try {
            DBConnectionPool vPool = (DBConnectionPool)this.mPools.get(vPoolName);
            vPool.removeConnection(pConnection);
        }
        catch (DBConnectionPoolException e) {
            String vMessage = "Problem in DBLayer: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new DBConnectionLayerException(vMessage, (Throwable)((Object)e));
        }
    }

    public Retries getPoolRetries(String pPoolName) throws DBConnectionLayerException {
        String vPoolName = pPoolName;
        if (!this.mPools.containsKey(pPoolName)) {
            if (!this.mPoolAliases.containsKey(pPoolName)) {
                throw new DBConnectionLayerException("Could not locate pool [" + pPoolName + "]");
            }
            vPoolName = (String)this.mPoolAliases.get(pPoolName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Requested pool [" + pPoolName + "] is aliased to pool [" + vPoolName + "]");
        }
        return ((DBConnectionPool)this.mPools.get(vPoolName)).getPoolRetries();
    }

    public boolean supportsTransactions(String pPoolName) throws DBConnectionLayerException {
        String vPoolName = pPoolName;
        if (!this.mPools.containsKey(pPoolName)) {
            if (!this.mPoolAliases.containsKey(pPoolName)) {
                throw new DBConnectionLayerException("Could not locate pool [" + pPoolName + "]");
            }
            vPoolName = (String)this.mPoolAliases.get(pPoolName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Requested pool [" + pPoolName + "] is aliased to pool [" + vPoolName + "]");
        }
        return ((DBConnectionPool)this.mPools.get(vPoolName)).supportsTransactions();
    }

    public String getDatabaseProductName(String pPoolName) throws DBConnectionLayerException {
        String vPoolName = pPoolName;
        if (!this.mPools.containsKey(pPoolName)) {
            if (!this.mPoolAliases.containsKey(pPoolName)) {
                throw new DBConnectionLayerException("Could not locate pool [" + pPoolName + "]");
            }
            vPoolName = (String)this.mPoolAliases.get(pPoolName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Requested pool [" + pPoolName + "] is aliased to pool [" + vPoolName + "]");
        }
        return ((DBConnectionPool)this.mPools.get(vPoolName)).getDatabaseProductName();
    }

    public String getDateFormat(String pPoolName) throws DBConnectionLayerException {
        String vPoolName = pPoolName;
        if (!this.mPools.containsKey(pPoolName)) {
            if (!this.mPoolAliases.containsKey(pPoolName)) {
                throw new DBConnectionLayerException("Could not locate pool [" + pPoolName + "]");
            }
            vPoolName = (String)this.mPoolAliases.get(pPoolName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Requested pool [" + pPoolName + "] is aliased to pool [" + vPoolName + "]");
        }
        return ((DBConnectionPool)this.mPools.get(vPoolName)).getDateFormat();
    }

    public String getTimeFormat(String pPoolName) throws DBConnectionLayerException {
        String vPoolName = pPoolName;
        if (!this.mPools.containsKey(pPoolName)) {
            if (!this.mPoolAliases.containsKey(pPoolName)) {
                throw new DBConnectionLayerException("Could not locate pool [" + pPoolName + "]");
            }
            vPoolName = (String)this.mPoolAliases.get(pPoolName);
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Requested pool [" + pPoolName + "] is aliased to pool [" + vPoolName + "]");
        }
        return ((DBConnectionPool)this.mPools.get(vPoolName)).getTimeFormat();
    }
}

