/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.conn;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import net.za.pwnconsulting.dblayer.conn.ManagedConnection;
import net.za.pwnconsulting.dblayer.conn.ManagedConnectionException;

public class ManagedConnectionList {
    private List mConnections = new ArrayList();
    private int mLastIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ManagedConnection pConnection) {
        List list = this.mConnections;
        synchronized (list) {
            this.mConnections.add(pConnection);
        }
    }

    public int getTotalCachedCount() {
        return this.mConnections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnection getAvailableConnection() throws ManagedConnectionException {
        List list = this.mConnections;
        synchronized (list) {
            for (int i = this.mLastIndex; i < this.mConnections.size() + this.mLastIndex; ++i) {
                ManagedConnection vMC = (ManagedConnection)this.mConnections.get(i % this.mConnections.size());
                if (vMC.isCheckedOut()) continue;
                vMC.checkOutConnection();
                this.mLastIndex = (this.mLastIndex + 1) % this.mConnections.size();
                return vMC;
            }
        }
        throw new ManagedConnectionException("Could not locate a free connection in the cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBackConnection(Connection pConnection) throws ManagedConnectionException {
        List list = this.mConnections;
        synchronized (list) {
            for (int i = 0; i < this.mConnections.size(); ++i) {
                ManagedConnection vMC = (ManagedConnection)this.mConnections.get(i);
                if (!vMC.getRawConnection().equals(pConnection)) continue;
                vMC.checkInConnection();
                return;
            }
        }
        throw new ManagedConnectionException("Could not locate the connection in the cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCheckedOutConnectionCount() {
        int vCheckedOutConnectionCount = 0;
        List list = this.mConnections;
        synchronized (list) {
            for (int i = 0; i < this.mConnections.size(); ++i) {
                ManagedConnection vMC = (ManagedConnection)this.mConnections.get(i);
                if (!vMC.isCheckedOut()) continue;
                ++vCheckedOutConnectionCount;
            }
        }
        return vCheckedOutConnectionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection pConnection) throws ManagedConnectionException {
        List list = this.mConnections;
        synchronized (list) {
            for (int i = 0; i < this.mConnections.size(); ++i) {
                ManagedConnection vMC = (ManagedConnection)this.mConnections.get(i);
                if (!vMC.getRawConnection().equals(pConnection)) continue;
                this.mConnections.remove(vMC);
                return;
            }
        }
        throw new ManagedConnectionException("Could not locate the connection in the cache");
    }

    public List getAllConnections() {
        return this.mConnections;
    }

    public void removeAllConnections() {
        this.mConnections.clear();
    }
}

