/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.conn;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.za.pwnconsulting.dblayer.conn.DBConnectionLayer;
import net.za.pwnconsulting.dblayer.conn.pool.AbstractDBConnectionPool;
import net.za.pwnconsulting.dblayer.conn.pool.DBConnectionPool;
import net.za.pwnconsulting.dblayer.conn.pool.Retries;
import net.za.pwnconsulting.dblayer.support.AbstractBaseDBLayerConfiguration;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.LMS;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import org.dom4j.Document;
import org.dom4j.Node;

public abstract class AbstractDBConnectionLayer
extends AbstractBaseDBLayerConfiguration
implements DBConnectionLayer {
    protected Map mPools = new HashMap();
    protected Map mPoolAliases = new HashMap();
    private Retries mRetries;
    private static final int DIAG_METHOD_SOCKET = 0;
    private static final int DIAG_METHOD_MBEAN = 1;
    private static final int DIAG_METHOD_UNDEFINED = 2;
    private boolean mDiagnosticsEnabled;
    private int mDiagnosticsMethod;
    private int mDiagnosticsPort;
    public static final String XML_DOCUMENT_NAME = "dblayer";
    static /* synthetic */ Class class$net$za$pwnconsulting$dblayer$conn$pool$DBConnectionPool;

    protected AbstractDBConnectionLayer() {
    }

    public final void init(Document pDocument) throws ConfigurationException {
        try {
            int vCnt;
            if (pDocument == null) {
                throw new ConfigurationException("Config document was not specified");
            }
            String vRootElement = pDocument.getRootElement().getName();
            if (!vRootElement.trim().equals(XML_DOCUMENT_NAME)) {
                throw new ConfigurationException("The XML configuration document is not a valid dblayer document");
            }
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Loading global retries configuration...");
            this.mRetries = AbstractDBConnectionPool.loadRetries(pDocument.selectSingleNode("/dblayer/global/retries"));
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Loading diagnostics configuration...");
            if (!Utils.isValidBoolean((String)pDocument.valueOf("/dblayer/global/diagnostics/@enabled"))) {
                throw new ConfigurationException("The XML configuration document does not contain a valid diagnostics configuration");
            }
            this.mDiagnosticsEnabled = Utils.getBool((String)pDocument.valueOf("/dblayer/global/diagnostics/@enabled"));
            if (this.mDiagnosticsEnabled) {
                String vMethod = pDocument.valueOf("/dblayer/global/diagnostics/@method");
                if (vMethod == null || vMethod.equals("")) {
                    throw new ConfigurationException("The XML configuration document does not contain a valid diagnostics configuration");
                }
                int n = vMethod.equals("socket") ? 0 : (this.mDiagnosticsMethod = vMethod.equals("mbean") ? 1 : 2);
                if (this.mDiagnosticsMethod == 2) {
                    this.mDiagnosticsEnabled = false;
                    throw new ConfigurationException("The XML configuration document does not contain a valid diagnostics configuration");
                }
                if (this.mDiagnosticsMethod == 0) {
                    if (!Utils.isValidInteger((String)pDocument.valueOf("/dblayer/global/diagnostics/@socket_port"))) {
                        throw new ConfigurationException("The XML configuration document does not contain a valid diagnostics configuration");
                    }
                    this.mDiagnosticsPort = Utils.getInt((String)pDocument.valueOf("/dblayer/global/diagnostics/@socket_port"));
                }
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Starting Diagnostics...");
                if (this.mDiagnosticsMethod == 0 || this.mDiagnosticsMethod == 1) {
                    // empty if block
                }
                BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Diagnostics started.");
            }
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Loading drivers...");
            if (pDocument.selectSingleNode("/dblayer/drivers") != null) {
                int vCnt2 = Utils.getInt((String)pDocument.valueOf("count(/dblayer/drivers/driver)"));
                for (int i = 1; i <= vCnt2; ++i) {
                    this.loadDriver(pDocument.selectSingleNode("/dblayer/drivers/driver[" + i + "]"));
                }
            }
            Node vPoolsNode = pDocument.selectSingleNode("/dblayer/pools");
            if (pDocument.selectSingleNode("/dblayer/host_specific_pools") != null) {
                int vHostCnt = Utils.getInt((String)pDocument.valueOf("count(/dblayer/host_specific_pools/host)"));
                String vCurrentHost = null;
                boolean vFound = false;
                if (vHostCnt > 0) {
                    try {
                        vCurrentHost = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        throw new ConfigurationException("Could not determine the current machine's host name: " + e.getMessage(), (Throwable)e);
                    }
                }
                Node vDefaultNode = null;
                for (int i = 1; i <= vHostCnt; ++i) {
                    String vHostName = pDocument.valueOf("/dblayer/host_specific_pools/host[" + i + "]/@name");
                    String vDescription = pDocument.valueOf("/dblayer/host_specific_pools/host[" + i + "]/@description");
                    if (Utils.isEmptyString((String)vHostName)) {
                        throw new ConfigurationException("Empty host name attribute found in the host_specific_pools section for XML configuration document");
                    }
                    if (Utils.makeProperString((String)vHostName).equals("*")) {
                        vDefaultNode = pDocument.selectSingleNode("/dblayer/host_specific_pools/host[" + i + "]");
                        continue;
                    }
                    String[] vHosts = vHostName.split(",");
                    for (int j = 0; j < vHosts.length; ++j) {
                        vHosts[j] = Utils.makeProperString((String)vHosts[j].toUpperCase());
                    }
                    if (!Arrays.asList(vHosts).contains(vCurrentHost.toUpperCase())) continue;
                    BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Found host specific pool for host [" + vHostName + "] - loading...");
                    vPoolsNode = pDocument.selectSingleNode("/dblayer/host_specific_pools/host[" + i + "]");
                    vFound = true;
                    break;
                }
                if (vHostCnt > 0 && !vFound) {
                    if (vDefaultNode != null) {
                        BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Found default pool for host [" + vCurrentHost + "] - loading...");
                        vPoolsNode = vDefaultNode;
                    } else {
                        throw new ConfigurationException("Could not locate the current host name [" + vCurrentHost + "] in the list of defined host_specific_pools hosts in XML configuration document");
                    }
                }
            }
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Loading [JDBC1] pools...");
            if (vPoolsNode != null) {
                vCnt = Utils.getInt((String)vPoolsNode.valueOf("count(./jdbc1_pool)"));
                for (int i = 1; i <= vCnt; ++i) {
                    this.loadPool(vPoolsNode.selectSingleNode("./jdbc1_pool[" + i + "]"));
                }
            }
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Loading [JDBC2] pools...");
            if (vPoolsNode != null) {
                vCnt = Utils.getInt((String)vPoolsNode.valueOf("count(./jdbc2ds_pool)"));
                for (int i = 1; i <= vCnt; ++i) {
                    this.loadPool(vPoolsNode.selectSingleNode("./jdbc2ds_pool[" + i + "]"));
                }
            }
            BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Loading pool aliasses...");
            this.loadPoolAliasses(vPoolsNode);
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Asking subclasses to continue parsing config file...");
            this.initConfig(pDocument);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            String vMessage = "Internal Error loading the configuration: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new ConfigurationException(vMessage, (Throwable)e);
        }
    }

    protected void loadDriver(Node pDriver) throws ConfigurationException {
        String vDriverClassName = pDriver.valueOf("./@class");
        try {
            Driver vDriver = (Driver)Class.forName(vDriverClassName).newInstance();
            DriverManager.registerDriver(vDriver);
        }
        catch (Exception e) {
            String vMessage = "Could not load the driver [" + vDriverClassName + "] because: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new ConfigurationException(vMessage, (Throwable)e);
        }
    }

    protected void loadPool(Node pPool) throws ConfigurationException {
        String vPoolName = pPool.valueOf("./@name");
        if (vPoolName == null || vPoolName.equals("")) {
            throw new ConfigurationException("The XML configuration document contains an invalid pool configuration [no pool name]");
        }
        if (this.mPools.containsKey(vPoolName) && ((DBConnectionPool)this.mPools.get(vPoolName)).isStarted()) {
            throw new ConfigurationException("The XML configuration document contains a pool that was already loaded");
        }
        String vPoolClass = pPool.valueOf("./@class");
        if (vPoolClass == null || vPoolClass.equals("")) {
            throw new ConfigurationException("The XML configuration document contains an invalid pool configuration [no pool class]");
        }
        try {
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Constructing pool [" + vPoolName + "] of type [" + vPoolClass + "]...");
            DBConnectionPool vDCP = (DBConnectionPool)this.getConfiguration().getBeanFactory().createBean(vPoolName, vPoolClass, class$net$za$pwnconsulting$dblayer$conn$pool$DBConnectionPool == null ? (class$net$za$pwnconsulting$dblayer$conn$pool$DBConnectionPool = AbstractDBConnectionLayer.class$("net.za.pwnconsulting.dblayer.conn.pool.DBConnectionPool")) : class$net$za$pwnconsulting$dblayer$conn$pool$DBConnectionPool, false);
            vDCP.initPool(pPool, this.mRetries);
            this.mPools.put(vPoolName, vDCP);
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Constructed pool [" + vPoolName + "]");
        }
        catch (Exception e) {
            String vMessage = "Internal Configuration Error: " + e.getMessage();
            BasicLogger.getBasicLogger().error(this.mLogger, LMS.OWNER_DBLAYER, vMessage);
            throw new ConfigurationException(vMessage, (Throwable)e);
        }
    }

    protected void loadPoolAliasses(Node pPools) throws ConfigurationException {
        if (pPools == null) {
            return;
        }
        int vCnt = Utils.getInt((String)pPools.valueOf("count(./pool_alias)"));
        for (int i = 1; i <= vCnt; ++i) {
            String vAliasName = pPools.valueOf("./pool_alias[" + i + "]/@name");
            String vTargetPoolName = pPools.valueOf("./pool_alias[" + i + "]/@target_pool_name");
            if (!this.mPools.containsKey(vTargetPoolName)) {
                throw new ConfigurationException("The XML configuration document contains a pool alias [" + vAliasName + "] pointing to a non-existent pool [" + vTargetPoolName + "]");
            }
            if (this.mPoolAliases.containsKey(vAliasName)) {
                throw new ConfigurationException("The XML configuration document already contains the pool alias [" + vAliasName + "]");
            }
            this.mPoolAliases.put(vAliasName, vTargetPoolName);
        }
    }

    protected abstract void initConfig(Document var1) throws ConfigurationException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

