/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.cache.parser;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.za.pwnconsulting.dblayer.cache.parser.InvalidOrUnsupportedSQLSyntaxException;
import net.za.pwnconsulting.dblayer.cache.parser.UncomparableObjectException;
import net.za.pwnconsulting.javaconfig.beans.CoercionException;
import net.za.pwnconsulting.javaconfig.beans.Coercions;
import net.za.pwnconsulting.javaconfig.utils.IntelligentStringTokenizer;
import net.za.pwnconsulting.javaconfig.utils.Pair;

public class WhereCommandOperation {
    private Pair mFieldName;
    private Pair mValue;
    private int mOperation;
    private boolean mNegatedLogic;
    private String mDateFormat;
    private String mTimeFormat;
    private int mDepth;
    public static final int OP_EQUALS = 0;
    public static final int OP_LESS = 1;
    public static final int OP_GREATER = 2;
    public static final int OP_LESSEQUALS = 3;
    public static final int OP_GREATEREQUALS = 4;
    public static final int OP_LIKE = 5;
    public static final int OP_IS = 6;
    public static final int OP_BETWEEN = 7;
    public static final int OP_IN = 8;
    static /* synthetic */ Class class$java$lang$Comparable;

    public WhereCommandOperation(String pFieldName, String pValue, int pOperation, boolean pNegatedLogic, String pDateFormat, String pTimeFormat) {
        IntelligentStringTokenizer vST = new IntelligentStringTokenizer(pFieldName, ".", "'\"", "'\"");
        String vToken1 = null;
        String vToken2 = null;
        if (vST.hasMoreTokens()) {
            vToken1 = vST.nextToken();
            if (vST.hasMoreTokens()) {
                vToken2 = vST.nextToken();
                this.mFieldName = new Pair((Object)vToken1, (Object)vToken2);
            } else {
                this.mFieldName = new Pair(null, (Object)vToken1);
            }
        } else {
            this.mFieldName = null;
        }
        this.mValue = new Pair(null, (Object)pValue);
        this.mOperation = pOperation;
        this.mNegatedLogic = pNegatedLogic;
        this.mDateFormat = pDateFormat;
        this.mTimeFormat = pTimeFormat;
    }

    public WhereCommandOperation(String pFieldName, String pValue, String pOperation, boolean pNegatedLogic, String pDateFormat, String pTimeFormat, int pDepth) {
        this(pFieldName, pValue, -1, pNegatedLogic, pDateFormat, pTimeFormat);
        if (pOperation.equalsIgnoreCase("=")) {
            this.mOperation = 0;
        } else if (pOperation.equalsIgnoreCase("<>") || pOperation.equalsIgnoreCase("!=")) {
            this.mOperation = 0;
            this.mNegatedLogic = true;
        } else if (pOperation.equalsIgnoreCase("<")) {
            this.mOperation = 1;
        } else if (pOperation.equalsIgnoreCase("<=")) {
            this.mOperation = 3;
        } else if (pOperation.equalsIgnoreCase(">")) {
            this.mOperation = 2;
        } else if (pOperation.equalsIgnoreCase(">=")) {
            this.mOperation = 4;
        } else if (pOperation.equalsIgnoreCase("LIKE")) {
            this.mOperation = 5;
        } else if (pOperation.equalsIgnoreCase("IS")) {
            this.mOperation = 6;
        } else if (pOperation.equalsIgnoreCase("BETWEEN")) {
            this.mOperation = 7;
        } else if (pOperation.equalsIgnoreCase("IN")) {
            this.mOperation = 8;
        }
        this.mDepth = pDepth;
    }

    public Pair getFieldName() {
        return this.mFieldName;
    }

    public Pair getValue() {
        return this.mValue;
    }

    public int getOperation() {
        return this.mOperation;
    }

    public boolean isNegatedLogic() {
        return this.mNegatedLogic;
    }

    public int getDepth() {
        return this.mDepth;
    }

    public Map applyCommandOperation(Map pData, List pFromTables, int pJoinType) throws InvalidOrUnsupportedSQLSyntaxException {
        if (this.isEmpty(pData)) {
            return new HashMap();
        }
        if (!this.isField((String)this.mFieldName.getValue2(), pData)) {
            throw new InvalidOrUnsupportedSQLSyntaxException("The field [" + this.mFieldName.getValue2() + "] does not exist in " + "the list of tables cached");
        }
        try {
            HashMap vFiltered = new HashMap();
            Iterator vI = pData.keySet().iterator();
            while (vI.hasNext()) {
                String vTableName = (String)vI.next();
                List vData = (List)pData.get(vTableName);
                ArrayList<Map> vFilteredData = new ArrayList<Map>();
                if (!this.hasField((String)this.mFieldName.getValue2(), vData) && pJoinType == 0) continue;
                if (pJoinType == 0) {
                    block8: for (int i = 0; i < vData.size(); ++i) {
                        Map vEntry = (Map)vData.get(i);
                        switch (this.mOperation) {
                            case 7: {
                                String vLowerBound = null;
                                String vUpperBound = null;
                                StringTokenizer vST = new StringTokenizer((String)this.mValue.getValue2());
                                if (vST.hasMoreTokens()) {
                                    vLowerBound = vST.nextToken();
                                }
                                if (vST.hasMoreTokens() && !vST.nextToken().toUpperCase().equals("AND")) {
                                    throw new InvalidOrUnsupportedSQLSyntaxException("Could not compare the field value to the BETWEEN clause as it contains invalid syntax [" + this.mValue.getValue2() + "]");
                                }
                                if (vST.hasMoreTokens()) {
                                    vUpperBound = vST.nextToken();
                                }
                                if (vLowerBound == null || vUpperBound == null) {
                                    throw new InvalidOrUnsupportedSQLSyntaxException("Could not compare the field value to the BETWEEN clause as it contains invalid syntax [" + this.mValue.getValue2() + "]");
                                }
                                if (this.isField(vLowerBound, pData) || this.isField(vUpperBound, pData)) {
                                    throw new InvalidOrUnsupportedSQLSyntaxException("Although the join syntax is correctly parsed in this version, it is not yet supported to perform operations on fields");
                                }
                                if (vEntry.get(this.mFieldName.getValue2()) instanceof String || vEntry.get(this.mFieldName.getValue2()) instanceof Date) {
                                    vLowerBound = this.unescapeString(vLowerBound);
                                    vUpperBound = this.unescapeString(vUpperBound);
                                }
                                boolean vRes1 = this.performOperation(vEntry.get(this.mFieldName.getValue2()), vLowerBound, 4, this.mNegatedLogic);
                                boolean vRes2 = this.performOperation(vEntry.get(this.mFieldName.getValue2()), vUpperBound, 3, this.mNegatedLogic);
                                if (this.mNegatedLogic) {
                                    if (!vRes1 && !vRes2) continue block8;
                                    vFilteredData.add(vEntry);
                                    continue block8;
                                }
                                if (!vRes1 || !vRes2) continue block8;
                                vFilteredData.add(vEntry);
                                continue block8;
                            }
                            case 8: {
                                ArrayList<String> vValues = new ArrayList<String>();
                                StringTokenizer vST = new StringTokenizer((String)this.mValue.getValue2(), ",");
                                while (vST.hasMoreTokens()) {
                                    String vNextToken = vST.nextToken().trim();
                                    if (vEntry.get(this.mFieldName.getValue2()) instanceof String || vEntry.get(this.mFieldName.getValue2()) instanceof Date) {
                                        vNextToken = this.unescapeString(vNextToken);
                                    }
                                    vValues.add(vNextToken);
                                }
                                boolean vFound = false;
                                for (int z = 0; z < vValues.size(); ++z) {
                                    if (this.isField((String)vValues.get(z), pData)) {
                                        throw new InvalidOrUnsupportedSQLSyntaxException("Although the join syntax is correctly parsed in this version, it is not yet supported to perform operations on fields");
                                    }
                                    if (this.performOperation(vEntry.get(this.mFieldName.getValue2()), (String)vValues.get(z), 0, this.mNegatedLogic)) {
                                        vFound = true;
                                        if (this.mNegatedLogic) continue;
                                        break;
                                    }
                                    if (!this.mNegatedLogic) continue;
                                    vFound = false;
                                    break;
                                }
                                if (!vFound) continue block8;
                                vFilteredData.add(vEntry);
                                continue block8;
                            }
                            default: {
                                if (this.isField((String)this.mValue.getValue2(), pData)) {
                                    throw new InvalidOrUnsupportedSQLSyntaxException("Although the join syntax is correctly parsed in this version, it is not yet supported to perform operations on fields");
                                }
                                if (!this.performOperation(vEntry.get(this.mFieldName.getValue2()), (String)this.mValue.getValue2(), this.mOperation, this.mNegatedLogic)) continue block8;
                                vFilteredData.add(vEntry);
                            }
                        }
                    }
                    vFiltered.put(vTableName, vFilteredData);
                    continue;
                }
                throw new InvalidOrUnsupportedSQLSyntaxException("Although the join syntax is correctly parsed in this version, it is not yet supported to perform operations on fields");
            }
            return vFiltered;
        }
        catch (CoercionException e) {
            throw new InvalidOrUnsupportedSQLSyntaxException("Could not convert value to the type of the specified field: " + e.getMessage(), e);
        }
        catch (UncomparableObjectException e) {
            throw new InvalidOrUnsupportedSQLSyntaxException("Could not compare the value to the value of the specified field: " + e.getMessage(), e);
        }
    }

    private boolean isEmpty(Map pData) {
        Iterator vI = pData.keySet().iterator();
        while (vI.hasNext()) {
            List vTableData = (List)pData.get(vI.next());
            if (vTableData.size() <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean isField(String pValue, Map pData) {
        Iterator vI = pData.keySet().iterator();
        while (vI.hasNext()) {
            List vData = (List)pData.get(vI.next());
            if (!this.hasField(pValue, vData)) continue;
            return true;
        }
        return false;
    }

    private boolean hasField(String pFieldName, List pData) {
        if (pData.size() <= 0) {
            return false;
        }
        Map vData = (Map)pData.get(0);
        Iterator vI = vData.keySet().iterator();
        while (vI.hasNext()) {
            String vColumnName = (String)vI.next();
            if (!vColumnName.equals(pFieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean performOperation(Object pValue1, String pValue2, int pOperation, boolean pNegatedLogic) throws CoercionException, UncomparableObjectException, InvalidOrUnsupportedSQLSyntaxException {
        if (pValue1 == null) {
            if (pOperation == 6 && pNegatedLogic) {
                return !pValue2.trim().equals("null");
            }
            if (pOperation == 6 && !pNegatedLogic) {
                return pValue2.trim().equals("null");
            }
            return false;
        }
        if (pValue2.trim().equals("null")) {
            return pNegatedLogic;
        }
        if (pValue1 instanceof Boolean && ((Boolean)pValue1).booleanValue() == Boolean.valueOf(pValue2).booleanValue()) {
            return !pNegatedLogic;
        }
        if (!(class$java$lang$Comparable == null ? (class$java$lang$Comparable = WhereCommandOperation.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(pValue1.getClass())) {
            throw new UncomparableObjectException("The object [" + pValue1.getClass().getName() + "] does not implement the Comparable interface");
        }
        Comparable vValue1 = (Comparable)pValue1;
        String vParsedValue2 = pValue2;
        if (pValue1 instanceof String || pValue1 instanceof Date) {
            vParsedValue2 = this.unescapeString(vParsedValue2);
        }
        Coercions vC = new Coercions(this.mDateFormat);
        Object vValue2 = vC.coerceString(vParsedValue2, pValue1.getClass());
        int vRes = vValue1.compareTo(vValue2);
        switch (pOperation) {
            case 0: {
                if (pNegatedLogic) {
                    return vRes != 0;
                }
                return vRes == 0;
            }
            case 1: {
                return vRes < 0;
            }
            case 3: {
                return vRes <= 0;
            }
            case 2: {
                return vRes > 0;
            }
            case 4: {
                return vRes >= 0;
            }
            case 5: {
                if (!(pValue1 instanceof String)) {
                    throw new UncomparableObjectException("Can not perform the LIKE operation on data of type [" + pValue1.getClass().getName() + "]");
                }
                String vValue = (String)pValue1;
                int vResult = -2;
                if (pValue2.startsWith("%") && pValue2.endsWith("%")) {
                    vResult = vValue.indexOf(pValue2.substring(1, pValue2.length() - 2));
                } else if (pValue2.startsWith("%")) {
                    vResult = vValue.endsWith(pValue2.substring(1, pValue2.length() - 1)) ? 0 : -1;
                } else if (pValue2.endsWith("%")) {
                    int n = vResult = vValue.startsWith(pValue2.substring(0, pValue2.length() - 2)) ? 0 : -1;
                }
                if (pNegatedLogic) {
                    return vResult == -1;
                }
                return vResult != -1;
            }
            case 6: {
                return pNegatedLogic;
            }
        }
        throw new InvalidOrUnsupportedSQLSyntaxException("Could not compare value of type [" + pValue1.getClass().getName() + "] " + "with value [" + pValue2 + "] using operation [" + pOperation + "] as " + "the operation [" + pOperation + "] is unknown");
    }

    private String unescapeString(String pString) {
        if (pString.startsWith("'") && pString.endsWith("'") || pString.startsWith("\"") && pString.endsWith("\"")) {
            return pString.substring(1, pString.length() - 2);
        }
        return pString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

