/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.cache.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.za.pwnconsulting.dblayer.cache.parser.InvalidOrUnsupportedSQLSyntaxException;
import net.za.pwnconsulting.dblayer.cache.parser.WhereCommandOperation;
import net.za.pwnconsulting.javaconfig.exceptions.InternalConsistencyException;
import net.za.pwnconsulting.javaconfig.exceptions.ProgrammerMistakeException;
import net.za.pwnconsulting.javaconfig.utils.ListUtils;

public class WhereCommand {
    public static final int COND_OP_AND = 0;
    public static final int COND_OP_OR = 1;
    private List mWhereCommandOperations = new ArrayList();

    public void addWhereCommandOperand(WhereCommandOperation pOperand) {
        this.mWhereCommandOperations.add(pOperand);
    }

    public void addWhereCommandOperation(int pOperation, int pDepth) throws InvalidOrUnsupportedSQLSyntaxException {
        if (pOperation != 0 && pOperation != 1) {
            throw new InvalidOrUnsupportedSQLSyntaxException("The conditional WHERE operator is unknown [" + pOperation + "]");
        }
        this.mWhereCommandOperations.add(new WhereCommandOper(pOperation, pDepth));
    }

    public void addWhereCommandOperation(String pOperation, int pDepth) throws InvalidOrUnsupportedSQLSyntaxException {
        if (pOperation.equalsIgnoreCase("OR")) {
            this.addWhereCommandOperation(1, pDepth);
        } else if (pOperation.equalsIgnoreCase("AND")) {
            this.addWhereCommandOperation(0, pDepth);
        } else {
            throw new InvalidOrUnsupportedSQLSyntaxException("The conditional WHERE operator is unknown [" + pOperation + "]");
        }
    }

    public Map applyWhereCommand(Map pData, List pFromTables, int pJoinType) throws InvalidOrUnsupportedSQLSyntaxException {
        if (this.mWhereCommandOperations.size() % 2 == 0) {
            throw new InvalidOrUnsupportedSQLSyntaxException("A Where clause cannot have an even number of operands [in this version of the parser]");
        }
        ArrayList<ProcessedWhereCommand> vProcessedWhereCommandOperations = new ArrayList<ProcessedWhereCommand>();
        for (int i = 0; i < this.mWhereCommandOperations.size(); i += 2) {
            WhereCommandOperation vWCO1 = (WhereCommandOperation)this.mWhereCommandOperations.get(i);
            Map vData = vWCO1.applyCommandOperation(pData, pFromTables, pJoinType);
            if (this.mWhereCommandOperations.size() == 1) {
                return vData;
            }
            vProcessedWhereCommandOperations.add(new ProcessedWhereCommand(vData, vWCO1.getDepth()));
            if (i + 1 >= this.mWhereCommandOperations.size()) continue;
            Object vOper = this.mWhereCommandOperations.get(i + 1);
            if (!(vOper instanceof WhereCommandOper)) {
                throw new ProgrammerMistakeException("Bug in algorithm");
            }
            vProcessedWhereCommandOperations.add((ProcessedWhereCommand)vOper);
        }
        if (this.mWhereCommandOperations.size() != vProcessedWhereCommandOperations.size()) {
            throw new ProgrammerMistakeException("Bug in algorithm");
        }
        int vSameSizeValue = vProcessedWhereCommandOperations.size();
        int vOffset = 0;
        while (vProcessedWhereCommandOperations.size() > 1) {
            ArrayList vNewProcessedWhereCommandOperations = new ArrayList();
            for (int i = vOffset; i < vProcessedWhereCommandOperations.size(); i += 4) {
                boolean vPredicate3;
                if (vOffset > 0) {
                    for (int z = 0; z < vOffset; ++z) {
                        vNewProcessedWhereCommandOperations.add(vProcessedWhereCommandOperations.get(z));
                    }
                }
                ProcessedWhereCommand O1 = (ProcessedWhereCommand)vProcessedWhereCommandOperations.get(i);
                WhereCommandOper c1 = (WhereCommandOper)vProcessedWhereCommandOperations.get(i + 1);
                WhereCommandOper c2 = null;
                if (i + 3 < vProcessedWhereCommandOperations.size()) {
                    c2 = (WhereCommandOper)vProcessedWhereCommandOperations.get(i + 3);
                }
                WhereCommandOper c0 = null;
                if (i > 0) {
                    c0 = (WhereCommandOper)vProcessedWhereCommandOperations.get(i - 1);
                }
                ProcessedWhereCommand O2 = (ProcessedWhereCommand)vProcessedWhereCommandOperations.get(i + 2);
                boolean vPredicate1 = O1.getDepth() == O2.getDepth();
                boolean vPredicate2 = i + 3 == vProcessedWhereCommandOperations.size() || c2.getDepth() < c1.getDepth() || c2.getDepth() == c1.getDepth() && (c2.isLowerPrecedenceThan(c1) || c2.isEqualPrecedenceThan(c1));
                boolean bl = vPredicate3 = i <= 1 || i > 1 && (c1.getOriginalDepth() > c0.getOriginalDepth() || c1.getOriginalDepth() == c0.getOriginalDepth() && (c0.isLowerPrecedenceThan(c1) || c0.isEqualPrecedenceThan(c1)));
                if (vPredicate1 && vPredicate2 && vPredicate3) {
                    HashMap vFilteredList = new HashMap();
                    switch (c1.getOperation()) {
                        case 0: {
                            vFilteredList.putAll(this.intersectionWrapper(O1.getData(), O2.getData()));
                            break;
                        }
                        case 1: {
                            vFilteredList.putAll(this.unionWrapper(O1.getData(), O2.getData()));
                            break;
                        }
                        default: {
                            throw new InternalConsistencyException("An unknown conditional operator was specified [" + c1.getOperation() + "]");
                        }
                    }
                    vNewProcessedWhereCommandOperations.add(new ProcessedWhereCommand(vFilteredList, O1.getDepth() - 1));
                } else {
                    O1.decDepth();
                    c1.decDepth();
                    O2.decDepth();
                    vNewProcessedWhereCommandOperations.add(O1);
                    vNewProcessedWhereCommandOperations.add(c1);
                    vNewProcessedWhereCommandOperations.add(O2);
                }
                if (i + 5 == vProcessedWhereCommandOperations.size()) {
                    WhereCommandOper Pc = (WhereCommandOper)vProcessedWhereCommandOperations.get(i + 3);
                    ProcessedWhereCommand PO = (ProcessedWhereCommand)vProcessedWhereCommandOperations.get(i + 4);
                    Pc.decDepth();
                    PO.decDepth();
                    vNewProcessedWhereCommandOperations.add(Pc);
                    vNewProcessedWhereCommandOperations.add(PO);
                    break;
                }
                if (i + 5 >= vProcessedWhereCommandOperations.size()) continue;
                c2.decDepth();
                vNewProcessedWhereCommandOperations.add(c2);
            }
            if (vSameSizeValue == vNewProcessedWhereCommandOperations.size() && (vSameSizeValue - 1) % 4 == 0) {
                boolean vNeedDifferentTechnique = true;
                for (int i = 0; i < vNewProcessedWhereCommandOperations.size(); i += 2) {
                    ProcessedWhereCommand vProcessedWhereCommand = (ProcessedWhereCommand)vNewProcessedWhereCommandOperations.get(i);
                    if (vProcessedWhereCommand.getDepth() == 0) continue;
                    vNeedDifferentTechnique = false;
                    break;
                }
                if (vNeedDifferentTechnique) {
                    vOffset = 2;
                }
            } else {
                vOffset = 0;
            }
            vSameSizeValue = vNewProcessedWhereCommandOperations.size();
            vProcessedWhereCommandOperations.clear();
            vProcessedWhereCommandOperations.addAll(vNewProcessedWhereCommandOperations);
        }
        return ((ProcessedWhereCommand)vProcessedWhereCommandOperations.get(0)).getData();
    }

    private Map intersectionWrapper(Map pList1, Map pList2) {
        HashMap<String, List> vRes = new HashMap<String, List>();
        Iterator vI = pList1.keySet().iterator();
        while (vI.hasNext()) {
            String vTableName = (String)vI.next();
            List vData1 = (List)pList1.get(vTableName);
            List vData2 = (List)pList2.get(vTableName);
            vRes.put(vTableName, ListUtils.intersection((List)vData1, (List)vData2));
        }
        return vRes;
    }

    private Map unionWrapper(Map pList1, Map pList2) {
        HashMap<String, List> vRes = new HashMap<String, List>();
        Iterator vI = pList1.keySet().iterator();
        while (vI.hasNext()) {
            String vTableName = (String)vI.next();
            List vData1 = (List)pList1.get(vTableName);
            List vData2 = (List)pList2.get(vTableName);
            vRes.put(vTableName, ListUtils.union((List)vData1, (List)vData2));
        }
        return vRes;
    }

    static class ProcessedWhereCommand {
        private Map mData;
        private int mDepth;

        public ProcessedWhereCommand(Map pData, int pDepth) {
            this.mDepth = pDepth >= 0 ? pDepth : 0;
            this.mData = pData;
        }

        public Map getData() {
            return this.mData;
        }

        public int getDepth() {
            return this.mDepth;
        }

        public void decDepth() {
            if (this.mDepth > 0) {
                --this.mDepth;
            }
        }
    }

    static class WhereCommandOper {
        private int mOperation;
        private int mDepth;
        private int mOriginalDepth;

        public WhereCommandOper(int pOperation, int pDepth) {
            this.mOperation = pOperation;
            this.mDepth = pDepth;
            this.mOriginalDepth = pDepth;
        }

        public int getDepth() {
            return this.mDepth;
        }

        public int getOriginalDepth() {
            return this.mOriginalDepth;
        }

        public int getOperation() {
            return this.mOperation;
        }

        public boolean isLowerPrecedenceThan(WhereCommandOper pOper) {
            switch (pOper.getOperation()) {
                case 0: {
                    return this.getOperation() == 1;
                }
                case 1: {
                    return false;
                }
            }
            throw new InvalidOrUnsupportedSQLSyntaxException("The conditional WHERE operator is unknown [" + pOper.getOperation() + "]");
        }

        public boolean isEqualPrecedenceThan(WhereCommandOper pOper) {
            switch (pOper.getOperation()) {
                case 0: {
                    return this.getOperation() == 0;
                }
                case 1: {
                    return this.getOperation() == 1;
                }
            }
            throw new InvalidOrUnsupportedSQLSyntaxException("The conditional WHERE operator is unknown [" + pOper.getOperation() + "]");
        }

        public boolean isHigherPrecedenceThan(WhereCommandOper pOper) {
            return !this.isLowerPrecedenceThan(pOper) && !this.isEqualPrecedenceThan(pOper);
        }

        public void decDepth() {
            --this.mDepth;
        }
    }
}

