/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.cache.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.za.pwnconsulting.dblayer.cache.CacheMissException;
import net.za.pwnconsulting.dblayer.cache.parser.CacheEntry;
import net.za.pwnconsulting.dblayer.cache.parser.ColumnCommandOperation;
import net.za.pwnconsulting.dblayer.cache.parser.FromTable;
import net.za.pwnconsulting.dblayer.cache.parser.InvalidOrUnsupportedSQLSyntaxException;
import net.za.pwnconsulting.dblayer.cache.parser.ParsedSQLSelect;
import net.za.pwnconsulting.javaconfig.utils.Pair;

public class PoolCache {
    private Map mCacheEntry = new HashMap();
    private String mPoolName;
    private int mCacheHits;
    private int mCacheMisses;

    public PoolCache(String pPoolName) {
        this.mPoolName = pPoolName;
        this.mCacheHits = 0;
        this.mCacheMisses = 0;
    }

    public int getCacheHits() {
        return this.mCacheHits;
    }

    public int getCacheMisses() {
        return this.mCacheMisses;
    }

    public String getPoolName() {
        return this.mPoolName;
    }

    public CacheEntry findCacheEntry(String pCacheEntryName) throws CacheMissException {
        if (!this.mCacheEntry.containsKey(pCacheEntryName)) {
            ++this.mCacheMisses;
            throw new CacheMissException("Could not find the cache entry [" + pCacheEntryName + "] in the cache for pool [" + this.mPoolName + "]");
        }
        ++this.mCacheHits;
        return (CacheEntry)this.mCacheEntry.get(pCacheEntryName);
    }

    public boolean existsCacheEntry(String pCacheEntryName) throws CacheMissException {
        return this.mCacheEntry.containsKey(pCacheEntryName);
    }

    public List findCacheEntryData(String pCacheEntryName) throws CacheMissException {
        return this.findCacheEntry(pCacheEntryName).getCacheEntryData();
    }

    public void addCacheEntry(String pCacheEntryName, List pCacheData) {
        ArrayList vFields = new ArrayList();
        if (pCacheData.size() > 0) {
            Iterator vI = ((Map)pCacheData.get(0)).keySet().iterator();
            while (vI.hasNext()) {
                vFields.add(vI.next());
            }
        }
        this.mCacheEntry.put(pCacheEntryName, new CacheEntry(pCacheEntryName, pCacheData, vFields));
    }

    public void removeCacheEntry(String pCacheEntryName) {
        this.mCacheEntry.remove(pCacheEntryName);
    }

    public List applySQLSelectToList(ParsedSQLSelect pParsedSQLSelect) throws InvalidOrUnsupportedSQLSyntaxException {
        Map vFilteredData = this.applyJoinsToList(pParsedSQLSelect);
        vFilteredData = this.applyWhereConditionToData(vFilteredData, pParsedSQLSelect);
        List vFilteredList = this.transformList(vFilteredData, pParsedSQLSelect);
        vFilteredList = this.applyColumnOperationsToList(vFilteredList, pParsedSQLSelect);
        return this.applyDistinctOperationToList(vFilteredList, pParsedSQLSelect);
    }

    private List transformList(Map pFilteredData, ParsedSQLSelect pParsedSQLSelect) {
        ArrayList vRes = new ArrayList();
        boolean vSize = false;
        Iterator vI = pFilteredData.keySet().iterator();
        if (vI.hasNext()) {
            String vKey = (String)vI.next();
            List vData = (List)pFilteredData.get(vKey);
            return vData;
        }
        return vRes;
    }

    private Map applyJoinsToList(ParsedSQLSelect pParsedSQLSelect) throws InvalidOrUnsupportedSQLSyntaxException {
        FromTable vFT;
        int i;
        HashMap<String, List> vData = new HashMap<String, List>();
        if (pParsedSQLSelect.getFromTables().size() > 1) {
            throw new InvalidOrUnsupportedSQLSyntaxException("Currently joins are not supported");
        }
        for (i = 0; i < pParsedSQLSelect.getFromTables().size(); ++i) {
            vFT = (FromTable)pParsedSQLSelect.getFromTables().get(i);
            vData.put(vFT.getTableReference().getTableAlias(), ((CacheEntry)this.mCacheEntry.get(vFT.getTableReference().getTableAlias())).getCacheEntryData());
            if (vFT.getJoinType() == 0) continue;
            throw new InvalidOrUnsupportedSQLSyntaxException("Currently joins are not supported");
        }
        for (i = 0; i < pParsedSQLSelect.getFromTables().size(); ++i) {
            vFT = (FromTable)pParsedSQLSelect.getFromTables().get(i);
            if (vFT.getJoinType() == 0) continue;
            vFT.applyJoin(vData, pParsedSQLSelect.getFromTables());
        }
        return vData;
    }

    private Map applyWhereConditionToData(Map pFilteredData, ParsedSQLSelect pParsedSQLSelect) throws InvalidOrUnsupportedSQLSyntaxException {
        if (pParsedSQLSelect.hasWhereClause()) {
            return pParsedSQLSelect.getWhereCommand().applyWhereCommand(pFilteredData, pParsedSQLSelect.getFromTables(), 0);
        }
        return pFilteredData;
    }

    private List applyColumnOperationsToList(List pFilteredData, ParsedSQLSelect pParsedSQLSelect) throws InvalidOrUnsupportedSQLSyntaxException {
        if (pParsedSQLSelect.hasColumnCommand()) {
            return pParsedSQLSelect.getColumnCommand().applyColumnCommand(pFilteredData);
        }
        return pFilteredData;
    }

    private List applyDistinctOperationToList(List pFilteredData, ParsedSQLSelect pParsedSQLSelect) throws InvalidOrUnsupportedSQLSyntaxException {
        if (pParsedSQLSelect.isDistinct()) {
            ArrayList<Map> vFilteredList = new ArrayList<Map>();
            for (int i = 0; i < pFilteredData.size(); ++i) {
                Map vEntryOriginal = (Map)pFilteredData.get(i);
                boolean vFound = false;
                for (int j = 0; j < vFilteredList.size(); ++j) {
                    Map vEntryNew = (Map)vFilteredList.get(j);
                    boolean vOneOrMoreFieldsDiffer = false;
                    for (int k = 0; k < (pParsedSQLSelect.hasColumnCommand() ? pParsedSQLSelect.getColumnCommand().getColumnCommandOperations().size() : pParsedSQLSelect.getFieldNames().size()); ++k) {
                        String vFieldName = "";
                        vFieldName = pParsedSQLSelect.hasColumnCommand() ? ((ColumnCommandOperation)pParsedSQLSelect.getColumnCommand().getColumnCommandOperations().get(k)).getOriginalColumnCommand() : (String)((Pair)pParsedSQLSelect.getFieldNames().get(k)).getValue1();
                        if (vEntryNew.get(vFieldName) == null && vEntryOriginal.get(vFieldName) != null) {
                            vOneOrMoreFieldsDiffer = true;
                            break;
                        }
                        if (vEntryNew.get(vFieldName).equals(vEntryOriginal.get(vFieldName))) continue;
                        vOneOrMoreFieldsDiffer = true;
                        break;
                    }
                    if (vOneOrMoreFieldsDiffer) continue;
                    vFound = true;
                    break;
                }
                if (vFound) continue;
                vFilteredList.add(vEntryOriginal);
            }
            return vFilteredList;
        }
        return pFilteredData;
    }
}

