/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.cache.parser;

import java.util.ArrayList;
import java.util.List;
import net.za.pwnconsulting.dblayer.cache.parser.ColumnCommand;
import net.za.pwnconsulting.dblayer.cache.parser.ColumnCommandOperation;
import net.za.pwnconsulting.dblayer.cache.parser.FromTable;
import net.za.pwnconsulting.dblayer.cache.parser.InvalidOrUnsupportedSQLSyntaxException;
import net.za.pwnconsulting.dblayer.cache.parser.WhereCommand;
import net.za.pwnconsulting.javaconfig.utils.Pair;

public class ParsedSQLSelect {
    private List mFieldNames = new ArrayList();
    private ColumnCommand mColumnCommand = null;
    private List mFromTables = new ArrayList();
    private WhereCommand mWhereCommand = null;
    private boolean mDistinct = false;

    public void addFieldName(String pFieldName) throws InvalidOrUnsupportedSQLSyntaxException {
        String vFieldName;
        String vField1 = vFieldName = pFieldName;
        String vAlias = "";
        int vAsIndex = pFieldName.toLowerCase().indexOf(" as ");
        if (vAsIndex != -1) {
            vField1 = pFieldName.substring(0, vAsIndex).trim();
            vAlias = pFieldName.substring(vAsIndex + 4).trim();
            throw new InvalidOrUnsupportedSQLSyntaxException("Sorry!  Aliasing is not yet supported.");
        }
        if (vField1.indexOf("(") != -1 && vField1.indexOf(")") != -1) {
            String vColumnOperation = vField1.substring(0, vField1.indexOf("(")).trim();
            vFieldName = vField1.substring(vField1.indexOf("(") + 1, vField1.length() - 1);
            if (this.mColumnCommand == null) {
                this.mColumnCommand = new ColumnCommand();
            }
            if (vAlias.equals("")) {
                vAlias = vField1;
            }
            this.mColumnCommand.addColumnCommandOperation(new ColumnCommandOperation(vColumnOperation, vFieldName, vAlias, pFieldName));
        }
        if (vAlias.equals("")) {
            vAlias = vField1;
        }
        this.mFieldNames.add(new Pair((Object)vAlias, (Object)vField1));
        if (this.mColumnCommand != null && this.mFieldNames.size() > this.mColumnCommand.count()) {
            throw new InvalidOrUnsupportedSQLSyntaxException("Mixing of GROUP columns (MIN(),MAX(),COUNT()...) with non GROUP columns is illegal if there is no GROUP BY clause.  Since GROUP BY is not currently supported, this is invalid syntax");
        }
    }

    public void addFromTable(FromTable pFromTable) throws InvalidOrUnsupportedSQLSyntaxException {
        this.mFromTables.add(pFromTable);
    }

    public void setWhereCommand(WhereCommand pWhereCommand) {
        this.mWhereCommand = pWhereCommand;
    }

    public void setDistinct(boolean pDistinct) {
        this.mDistinct = pDistinct;
    }

    public List getFieldNames() {
        return this.mFieldNames;
    }

    public List getFromTables() {
        return this.mFromTables;
    }

    public WhereCommand getWhereCommand() {
        return this.mWhereCommand;
    }

    public ColumnCommand getColumnCommand() {
        return this.mColumnCommand;
    }

    public boolean isDistinct() {
        return this.mDistinct;
    }

    public boolean hasWhereClause() {
        return this.mWhereCommand != null;
    }

    public boolean hasColumnCommand() {
        return this.mColumnCommand != null;
    }
}

