/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.cache.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.za.pwnconsulting.dblayer.cache.parser.InvalidOrUnsupportedSQLSyntaxException;

public class ColumnCommandOperation {
    public static final int COL_CMD_COUNT = 0;
    public static final int COL_CMD_SUM = 1;
    public static final int COL_CMD_AVG = 2;
    public static final int COL_CMD_MIN = 3;
    public static final int COL_CMD_MAX = 4;
    private int mColumnCommand;
    private String mField;
    private String mAlias;
    private String mOriginalColumnCommand;

    public ColumnCommandOperation(int pColumnCommand, String pField, String pAlias, String pOriginalColumnCommand) throws InvalidOrUnsupportedSQLSyntaxException {
        if (pColumnCommand != 0 && pColumnCommand != 2 && pColumnCommand != 1 && pColumnCommand != 3 && pColumnCommand != 4) {
            throw new InvalidOrUnsupportedSQLSyntaxException("The column command [" + pColumnCommand + "] is unknown");
        }
        if (pColumnCommand != 0 && pField != null && pField.equals("*")) {
            throw new InvalidOrUnsupportedSQLSyntaxException("Cannot specify * with column command [" + pColumnCommand + "]");
        }
        this.mColumnCommand = pColumnCommand;
        this.mField = pField;
        this.mAlias = pAlias;
        this.mOriginalColumnCommand = pOriginalColumnCommand;
    }

    public ColumnCommandOperation(String pColumnCommand, String pField, String pAlias, String pOriginalColumnCommand) throws InvalidOrUnsupportedSQLSyntaxException {
        this(0, pField, pAlias, pOriginalColumnCommand);
        if (pColumnCommand.equalsIgnoreCase("COUNT")) {
            this.mColumnCommand = 0;
        } else if (pColumnCommand.equalsIgnoreCase("SUM")) {
            this.mColumnCommand = 1;
        } else if (pColumnCommand.equalsIgnoreCase("AVG")) {
            this.mColumnCommand = 2;
        } else if (pColumnCommand.equalsIgnoreCase("MIN")) {
            this.mColumnCommand = 3;
        } else if (pColumnCommand.equalsIgnoreCase("MAX")) {
            this.mColumnCommand = 4;
        } else {
            throw new InvalidOrUnsupportedSQLSyntaxException("The column command [" + pColumnCommand + "] is unknown");
        }
    }

    public String getField() {
        return this.mField;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public int getColumnCommand() {
        return this.mColumnCommand;
    }

    public String getOriginalColumnCommand() {
        return this.mOriginalColumnCommand;
    }

    public List applyColumnCommand(List pData) throws InvalidOrUnsupportedSQLSyntaxException {
        ArrayList vRes = new ArrayList();
        HashMap<String, Object> vRow = new HashMap<String, Object>();
        switch (this.mColumnCommand) {
            case 0: {
                vRow.put(this.mOriginalColumnCommand, new Long(pData.size()));
                vRes.add(vRow);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Object vSum = this.performOperation(pData, this.mField, this.mColumnCommand);
                vRow.put(this.mOriginalColumnCommand, vSum);
                vRes.add(vRow);
                break;
            }
            default: {
                throw new InvalidOrUnsupportedSQLSyntaxException("Could not compute unknown function [" + this.mColumnCommand + "]");
            }
        }
        return vRes;
    }

    private Object performOperation(List pData, String pField, int pColumnCommand) throws InvalidOrUnsupportedSQLSyntaxException {
        if (pField.equals("*")) {
            throw new InvalidOrUnsupportedSQLSyntaxException("Cannot specify * with column command [" + pColumnCommand + "]");
        }
        if (pData.size() <= 0) {
            return null;
        }
        int vNullCount = 0;
        for (int i = 0; i < pData.size(); ++i) {
            Map vRow = (Map)pData.get(i);
            if (vRow.get(pField) == null) {
                ++vNullCount;
                continue;
            }
            if (!(pColumnCommand != 2 && pColumnCommand != 1 || vRow.get(pField) instanceof Number)) {
                throw new InvalidOrUnsupportedSQLSyntaxException("Cannot determine the average or sum of a non numeric value");
            }
            if (pColumnCommand != 3 && pColumnCommand != 4 || vRow.get(pField) instanceof Comparable) continue;
            throw new InvalidOrUnsupportedSQLSyntaxException("Cannot determine the minimum or maximum of a non comparable value");
        }
        if (vNullCount == pData.size()) {
            return null;
        }
        if (pColumnCommand == 3) {
            Comparable vMin = null;
            for (int i = 0; i < pData.size(); ++i) {
                Map vRow = (Map)pData.get(i);
                if (vRow.get(pField) == null) continue;
                Comparable vC = (Comparable)vRow.get(pField);
                if (vMin != null && vC.compareTo(vMin) >= 0) continue;
                vMin = vC;
            }
            return vMin;
        }
        if (pColumnCommand == 4) {
            Comparable vMax = null;
            for (int i = 0; i < pData.size(); ++i) {
                Map vRow = (Map)pData.get(i);
                if (vRow.get(pField) == null) continue;
                Comparable vC = (Comparable)vRow.get(pField);
                if (vMax != null && vC.compareTo(vMax) <= 0) continue;
                vMax = vC;
            }
            return vMax;
        }
        if (pColumnCommand == 1) {
            BigDecimal vSum = null;
            for (int i = 0; i < pData.size(); ++i) {
                Map vRow = (Map)pData.get(i);
                if (vRow.get(pField) == null) continue;
                if (vSum == null) {
                    vSum = new BigDecimal(BigInteger.ZERO);
                }
                vSum = vSum.add(new BigDecimal(vRow.get(pField).toString()));
            }
            return vSum;
        }
        if (pColumnCommand == 2) {
            BigDecimal vAvg = null;
            int vNotNullCount = 0;
            for (int i = 0; i < pData.size(); ++i) {
                Map vRow = (Map)pData.get(i);
                if (vRow.get(pField) == null) continue;
                ++vNotNullCount;
                vAvg = vAvg == null ? new BigDecimal(vRow.get(pField).toString()) : vAvg.add(new BigDecimal(vRow.get(pField).toString()));
            }
            if (vAvg != null) {
                return vAvg.divide(new BigDecimal((double)vNotNullCount), 17, 4);
            }
            return null;
        }
        throw new InvalidOrUnsupportedSQLSyntaxException("Could not compute unknown function [" + pColumnCommand + "]");
    }
}

