/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.cache.parser;

import java.util.List;
import java.util.NoSuchElementException;
import net.za.pwnconsulting.dblayer.cache.parser.FromTable;
import net.za.pwnconsulting.dblayer.cache.parser.InvalidOrUnsupportedSQLSyntaxException;
import net.za.pwnconsulting.dblayer.cache.parser.ParsedSQLSelect;
import net.za.pwnconsulting.dblayer.cache.parser.SQLCacheParser;
import net.za.pwnconsulting.dblayer.cache.parser.WhereCommand;
import net.za.pwnconsulting.dblayer.cache.parser.WhereCommandOperation;
import net.za.pwnconsulting.javaconfig.utils.IntelligentStringTokenizer;

public class BasicSQLCacheParser
implements SQLCacheParser {
    private String mDateFormat;
    private String mTimeFormat;

    public BasicSQLCacheParser(String pDateFormat, String pTimeFormat) {
        this.mDateFormat = pDateFormat;
        this.mTimeFormat = pTimeFormat;
    }

    public BasicSQLCacheParser() {
        this(null, null);
    }

    public ParsedSQLSelect parseSQLSelect(String pSQL) throws InvalidOrUnsupportedSQLSyntaxException {
        ParsedSQLSelect vParsedSQLSelect = new ParsedSQLSelect();
        try {
            IntelligentStringTokenizer vST = new IntelligentStringTokenizer(pSQL);
            if (!vST.hasMoreTokens()) {
                throw new InvalidOrUnsupportedSQLSyntaxException("Expected SELECT token, found none");
            }
            String vToken = vST.nextToken();
            if (!vToken.equalsIgnoreCase("SELECT")) {
                throw new InvalidOrUnsupportedSQLSyntaxException("SQL Statement does not start with SELECT [" + pSQL + "]");
            }
            if (!vST.hasMoreTokens()) {
                throw new InvalidOrUnsupportedSQLSyntaxException("Expected DISTINCT or field list, found none");
            }
            vToken = vST.nextToken();
            if (vToken.equalsIgnoreCase("DISTINCT")) {
                vParsedSQLSelect.setDistinct(true);
                if (!vST.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected field list after DISTINCT, found none");
                }
                vToken = vST.nextToken();
            }
            String vFieldClause = pSQL.substring(vParsedSQLSelect.isDistinct() ? pSQL.toUpperCase().indexOf(" DISTINCT ") + " DISTINCT ".length() : pSQL.toUpperCase().indexOf("SELECT ") + "SELECT ".length(), pSQL.toUpperCase().indexOf(" FROM "));
            IntelligentStringTokenizer vST2 = new IntelligentStringTokenizer(vFieldClause, ",", "'\"", "'\"");
            while (vST2.hasMoreTokens()) {
                vParsedSQLSelect.addFieldName(vST2.nextToken());
            }
            String vFromClause = pSQL.substring(pSQL.toUpperCase().indexOf(" FROM ") + " FROM ".length(), pSQL.toUpperCase().indexOf(" WHERE ") != -1 ? pSQL.toUpperCase().indexOf(" WHERE ") : pSQL.length()).trim();
            vST2 = new IntelligentStringTokenizer(vFromClause, ",", "'\"", "'\"");
            while (vST2.hasMoreTokens()) {
                vParsedSQLSelect.addFromTable(this.parseFromTable(vST2.nextToken()));
            }
            if (pSQL.toUpperCase().indexOf(" WHERE ") == -1) {
                return vParsedSQLSelect;
            }
            WhereCommand vWhereCommand = this.parseWhereClause(pSQL.substring(pSQL.toUpperCase().indexOf(" WHERE ") + " WHERE ".length()));
            vParsedSQLSelect.setWhereCommand(vWhereCommand);
            return vParsedSQLSelect;
        }
        catch (NoSuchElementException e) {
            throw new InvalidOrUnsupportedSQLSyntaxException("Invalid SQL SELECT Statement [" + pSQL + "]: " + e.getMessage(), e);
        }
    }

    private FromTable parseFromTable(String pTableDef) throws InvalidOrUnsupportedSQLSyntaxException {
        String vTableName;
        FromTable vFT = new FromTable();
        vFT.setJoinType(0);
        IntelligentStringTokenizer vST2 = new IntelligentStringTokenizer(pTableDef);
        if (!vST2.hasMoreTokens()) {
            throw new InvalidOrUnsupportedSQLSyntaxException("A SQL SELECT statement must have a FROM clause");
        }
        String vAliasName = vTableName = vST2.nextToken();
        if (vST2.hasMoreTokens()) {
            String vToken2 = vST2.nextToken();
            if (vToken2.toLowerCase().equals("as")) {
                if (!vST2.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected alias name for table [" + vTableName + "] with AS clause");
                }
                vAliasName = vST2.nextToken();
            } else if (!(vToken2.toLowerCase().equals("join") || vToken2.toLowerCase().equals("inner") || vToken2.toLowerCase().equals("outer") || vToken2.toLowerCase().equals("left") || vToken2.toLowerCase().equals("right") || vToken2.toLowerCase().equals("full"))) {
                vAliasName = vToken2;
            }
            if (vST2.hasMoreTokens()) {
                String vJoinTableName;
                String vToken4;
                String vToken3 = vST2.nextToken();
                if (vToken3.toLowerCase().equals("inner")) {
                    if (!vST2.hasMoreTokens()) {
                        throw new InvalidOrUnsupportedSQLSyntaxException("Expected JOIN, found none for table [" + vTableName + "]");
                    }
                    vToken4 = vST2.nextToken();
                    if (!vToken4.toLowerCase().equals("join")) {
                        throw new InvalidOrUnsupportedSQLSyntaxException("Expected JOIN, found [" + vToken4 + "] for table [" + vTableName + "]");
                    }
                    vFT.setJoinType(1);
                } else if (vToken3.toLowerCase().equals("join")) {
                    vFT.setJoinType(1);
                } else if (vToken3.toLowerCase().equals("left") || vToken3.toLowerCase().equals("right") || vToken3.toLowerCase().equals("full")) {
                    if (!vST2.hasMoreTokens()) {
                        throw new InvalidOrUnsupportedSQLSyntaxException("Expected OUTER, found none for table [" + vTableName + "]");
                    }
                    vToken4 = vST2.nextToken();
                    if (!vToken4.toLowerCase().equals("outer")) {
                        throw new InvalidOrUnsupportedSQLSyntaxException("Expected OUTER, found [" + vToken4 + "] for table [" + vTableName + "]");
                    }
                    if (!vST2.hasMoreTokens()) {
                        throw new InvalidOrUnsupportedSQLSyntaxException("Expected JOIN, found none for table [" + vTableName + "]");
                    }
                    String vToken5 = vST2.nextToken();
                    if (!vToken5.toLowerCase().equals("join")) {
                        throw new InvalidOrUnsupportedSQLSyntaxException("Expected JOIN, found [" + vToken5 + "] for table [" + vTableName + "]");
                    }
                    if (vToken3.toLowerCase().equals("left")) {
                        vFT.setJoinType(2);
                    } else if (vToken3.toLowerCase().equals("full")) {
                        vFT.setJoinType(4);
                    } else if (vToken3.toLowerCase().equals("right")) {
                        vFT.setJoinType(3);
                    }
                } else if (vToken3.toLowerCase().equals("outer")) {
                    if (!vST2.hasMoreTokens()) {
                        throw new InvalidOrUnsupportedSQLSyntaxException("Expected JOIN, found none for table [" + vTableName + "]");
                    }
                    String vToken5 = vST2.nextToken();
                    if (!vToken5.toLowerCase().equals("join")) {
                        throw new InvalidOrUnsupportedSQLSyntaxException("Expected JOIN, found [" + vToken5 + "] for table [" + vTableName + "]");
                    }
                    vFT.setJoinType(2);
                }
                if (!vST2.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected join table name, found none for table [" + vTableName + "]");
                }
                String vJoinTableAlias = vJoinTableName = vST2.nextToken();
                if (vST2.hasMoreTokens()) {
                    String vToken6 = vST2.nextToken();
                    if (vToken6.toLowerCase().equals("as")) {
                        if (!vST2.hasMoreTokens()) {
                            throw new InvalidOrUnsupportedSQLSyntaxException("Expected alias name for join table [" + vJoinTableName + "] with AS clause");
                        }
                        vJoinTableAlias = vST2.nextToken();
                    } else {
                        vJoinTableAlias = vToken6;
                    }
                }
                vFT.setJoinTableReference(new FromTable.TableReference(vJoinTableName, vJoinTableAlias));
                if (!vST2.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected join condition, found none for table [" + vTableName + "]");
                }
                String vToken8 = vST2.nextToken();
                if (!vToken8.toLowerCase().equals("on")) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected ON, found [" + vToken8 + "] for table [" + vTableName + "]");
                }
                String vPartialStringFromCurrentPosition = vST2.getPartialStringFromCurrentPosition();
                if (vPartialStringFromCurrentPosition == null) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected a join_condition, found none for table [" + vTableName + "]");
                }
                vFT.setJoinCondition(this.parseWhereClause(vPartialStringFromCurrentPosition));
            }
        }
        vFT.setTableReference(new FromTable.TableReference(vTableName, vAliasName));
        return vFT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WhereCommand parseWhereClause(String pWhereClause) throws InvalidOrUnsupportedSQLSyntaxException {
        IntelligentStringTokenizer vST = new IntelligentStringTokenizer(pWhereClause);
        String vFieldName = "";
        String vOperation = "";
        String vValue = "";
        boolean vNegatedLogic = false;
        WhereCommand vWhereCommand = new WhereCommand();
        int vBracesIndex = 0;
        String vToken = "";
        while (vST.hasMoreTokens()) {
            if (!vST.hasMoreTokens()) {
                throw new InvalidOrUnsupportedSQLSyntaxException("Expected field name for operation in where clause, found none");
            }
            vFieldName = vST.nextToken();
            if (vFieldName.startsWith("(")) {
                ++vBracesIndex;
                vFieldName = vFieldName.substring(1);
            }
            if (!vST.hasMoreTokens()) {
                throw new InvalidOrUnsupportedSQLSyntaxException("Expected operator for operation in where clause, found none");
            }
            vOperation = vST.nextToken();
            if (vOperation.equalsIgnoreCase("IS")) {
                if (!vST.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected NOT or value for IS operation in where clause, found none");
                }
                vToken = vST.nextToken();
                if (vToken.equalsIgnoreCase("NOT")) {
                    vNegatedLogic = true;
                    if (!vST.hasMoreTokens()) {
                        throw new InvalidOrUnsupportedSQLSyntaxException("Expected value for IS NOT operation in where clause, found none");
                    }
                    vToken = vST.nextToken();
                }
            } else if (vOperation.equalsIgnoreCase("NOT")) {
                vNegatedLogic = true;
                if (!vST.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Invalid SQL SELECT WHERE clause - NOT found without matching BETWEEN, LIKE or IN [" + pWhereClause + "]");
                }
                vToken = vST.nextToken();
                if (!vToken.equalsIgnoreCase("BETWEEN") && !vToken.equalsIgnoreCase("LIKE") && !vToken.equalsIgnoreCase("IN")) throw new InvalidOrUnsupportedSQLSyntaxException("Invalid SQL SELECT WHERE clause - NOT found without matching BETWEEN, LIKE or IN [" + pWhereClause + "]");
                vOperation = vToken;
                if (!vST.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected value for NOT operation in where clause, found none");
                }
                vToken = vST.nextToken();
            } else {
                if (!vST.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected value for operation in where clause, found none");
                }
                vToken = vST.nextToken();
            }
            if (vOperation.equalsIgnoreCase("BETWEEN")) {
                if (!vST.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected AND for BETWEEN operation in where clause, found none");
                }
                String vAnd = vST.nextToken();
                if (!vAnd.equalsIgnoreCase("and")) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected AND for BETWEEN operation in where clause, found none");
                }
                if (!vST.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected upper bound value for BETWEEN operation in where clause, found none");
                }
                String vUpperBoundValue = vST.nextToken();
                vValue = vToken + " " + vAnd + " " + vUpperBoundValue;
            } else if (vOperation.equalsIgnoreCase("LIKE")) {
                vValue = vToken;
            } else if (vOperation.equalsIgnoreCase("IN")) {
                String vFragment = vST.getPartialStringFromPreviousPosition().trim();
                IntelligentStringTokenizer vST5 = new IntelligentStringTokenizer(vFragment, " \r\n\f\t)", "(", ")");
                if (!vST5.hasMoreTokens()) {
                    throw new InvalidOrUnsupportedSQLSyntaxException("Expected list () for IN operation in where clause, found none");
                }
                vValue = vToken = vST5.nextToken();
                String vPartialStringFromCurrentPosition = vST5.getPartialStringFromCurrentPosition();
                if (vPartialStringFromCurrentPosition != null) {
                    vST = new IntelligentStringTokenizer(pWhereClause.substring(pWhereClause.indexOf(vPartialStringFromCurrentPosition)));
                }
            } else {
                vValue = vToken;
            }
            int vOldBracesIndex = vBracesIndex--;
            if (vValue.endsWith(")")) {
                vValue = vValue.substring(0, vValue.length() - 1);
            }
            vWhereCommand.addWhereCommandOperand(new WhereCommandOperation(vFieldName, vValue, vOperation, vNegatedLogic, this.mDateFormat, this.mTimeFormat, vOldBracesIndex));
            vNegatedLogic = false;
            if (!vST.hasMoreTokens()) continue;
            vWhereCommand.addWhereCommandOperation(vST.nextToken(), vBracesIndex);
        }
        return vWhereCommand;
    }

    public List parseSQLUpdate(String pSQL) throws InvalidOrUnsupportedSQLSyntaxException {
        throw new InvalidOrUnsupportedSQLSyntaxException("Not yet implemented");
    }

    public List parseSQLDelete(String pSQL) throws InvalidOrUnsupportedSQLSyntaxException {
        throw new InvalidOrUnsupportedSQLSyntaxException("Not yet implemented");
    }

    public List parseSQLInsert(String pSQL) throws InvalidOrUnsupportedSQLSyntaxException {
        throw new InvalidOrUnsupportedSQLSyntaxException("Not yet implemented");
    }
}

