/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.cache;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import net.za.pwnconsulting.dblayer.DBLayer;
import net.za.pwnconsulting.dblayer.DBLayerException;
import net.za.pwnconsulting.dblayer.cache.CacheMissException;
import net.za.pwnconsulting.dblayer.cache.DBDataCache;
import net.za.pwnconsulting.dblayer.cache.parser.InvalidOrUnsupportedSQLSyntaxException;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.javaconfig.beans.BeanFactoryException;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.exceptions.NoMatchFoundException;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocator;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocatorException;

public class BasicDBDataCacheTest
extends TestCase {
    private DBLayer mDBLayer;
    static /* synthetic */ Class class$net$za$pwnconsulting$dblayer$cache$DBDataCache;
    static /* synthetic */ Class class$net$za$pwnconsulting$dblayer$cache$BasicDBDataCacheTest;

    public BasicDBDataCacheTest(String s) throws ApplicationContextLocatorException, BeanFactoryException, ConfigurationException {
        super(s);
        this.getBasicDBDataCache();
    }

    private void addData() throws DBLayerException {
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(10), "Something", new Double(3453434.0)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(22), "Other", new Double(334.0)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{null, null, null}, false), "TestPool");
    }

    private void prepData() throws DBLayerException {
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(6), "Something", new Double(3453434.0)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(2), "Other", new Double(334.0)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{null, null, null}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(-34324), "Cat", new Double(3.54)}, false), "TestPool");
    }

    private void prepData3() throws DBLayerException {
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        for (int i = 0; i < 2005; ++i) {
            this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(i), "Something", new Double(3453434.0)}, false), "TestPool");
        }
    }

    private void prepData2() throws DBLayerException {
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(6), "Something", new Double(3453434.0)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(2), "Other", new Double(334.0)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{null, null, null}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(-34324), "Cat", new Double(3.54)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table2 values (?,?,?)", new Object[]{new Integer(6), "Something", new Double(3453434.0)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table2 values (?,?,?)", new Object[]{new Integer(6), "Something2", new Double(3453434.0)}, false), "TestPool");
    }

    private void prepDuplicateData() throws DBLayerException {
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(6), "Something", new Double(3453434.0)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(2), "Other", new Double(334.0)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{null, null, null}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(6), "Other", new Double(3.54)}, false), "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(6), "Something", new Double(3.54)}, false), "TestPool");
    }

    DBDataCache getBasicDBDataCache() throws ConfigurationException, BeanFactoryException, ApplicationContextLocatorException {
        new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
        this.mDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
        return (DBDataCache)new ApplicationContextLocator().getApplicationContext().getDBLayerBeanFactory("Test").getBean(class$net$za$pwnconsulting$dblayer$cache$DBDataCache == null ? (class$net$za$pwnconsulting$dblayer$cache$DBDataCache = BasicDBDataCacheTest.class$("net.za.pwnconsulting.dblayer.cache.DBDataCache")) : class$net$za$pwnconsulting$dblayer$cache$DBDataCache);
    }

    public void testBasicDBDataCacheInitialWhere() throws InvalidOrUnsupportedSQLSyntaxException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException, CacheMissException {
        this.prepData();
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        String vSQL = "select alpha,beta, gamma from test_table where alpha > ?";
        List vRes = vBD.queryDatabase(vSQL, new Object[]{new Integer(5)}, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)1, (int)vRes.size());
    }

    public void testBasicDBDataCacheComplex() throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException {
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData();
        String vSQL = "select alpha,gamma from test_table where alpha < ? and gamma between ? and ?";
        List vData = vBD.queryDatabase(vSQL, new Object[]{new Integer(5), new Double(300.0), new Double(400.0)}, "TestPool");
        System.out.println(">>>>>" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 1 entry", (vData.size() == 1 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"List entry has a beta field with name \"Other\"", (boolean)((Map)vData.get(0)).get("beta").equals("Other"));
    }

    public void testBasicDBDataCacheComplex2() throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException {
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData();
        String vSQL = "select alpha from test_table where alpha = ? and gamma  not in (4,5,8) and beta like ?";
        List vData = vBD.queryDatabase(vSQL, new Object[]{new Integer(-34324), "Ca%"}, "TestPool");
        System.out.println(">>>>>" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 1 entry", (vData.size() == 1 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"List entry has a beta field with name \"Cat\"", (boolean)((Map)vData.get(0)).get("beta").equals("Cat"));
    }

    public void testBasicDBDataCacheComplex3() throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException {
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData();
        String vSQL = "select alpha from test_table where alpha = ? and gamma  not in (4,5,8) and beta like ? or beta is not null";
        List vData = vBD.queryDatabase(vSQL, new Object[]{new Integer(-34324), "Ca%"}, "TestPool");
        System.out.println(">>>>>" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)("List contains 3 entries failed, it contains [" + vData.size() + "]"), (vData.size() == 3 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((boolean)((Map)vData.get(0)).get("alpha").equals(new Integer(-34324)));
        BasicDBDataCacheTest.assertTrue((boolean)((Map)vData.get(1)).get("alpha").equals(new Integer(6)));
        BasicDBDataCacheTest.assertTrue((boolean)((Map)vData.get(2)).get("alpha").equals(new Integer(2)));
    }

    public void testBasicDBDataCacheAverage() throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException {
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData();
        String vSQL = "select avg(alpha) from test_table";
        List vData = vBD.queryDatabase(vSQL, null, "TestPool");
        System.out.println(">>>>>Cac" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 1 entry", (vData.size() == 1 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"List average value of ", (new BigDecimal(-34316.0).divide(new BigDecimal(3.0), 17, 4).compareTo((BigDecimal)((Map)vData.get(0)).get("avg(alpha)")) == 0 ? 1 : 0) != 0);
    }

    public void testBasicDBDataCacheAverageAs() throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException {
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData();
        String vSQL = "select avg(alpha) as average from test_table";
        List vData = vBD.queryDatabase(vSQL, null, "TestPool");
        System.out.println(">>>>>Cac" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 1 entry", (vData.size() == 1 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"No such element ", (!((Map)vData.get(0)).containsKey("avg(alpha)") ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"Contains element ", (boolean)((Map)vData.get(0)).containsKey("average"));
        BasicDBDataCacheTest.assertTrue((String)"List average value of ", (new BigDecimal(-34316.0).divide(new BigDecimal(3.0), 17, 4).compareTo((BigDecimal)((Map)vData.get(0)).get("average")) == 0 ? 1 : 0) != 0);
    }

    public void testBasicDBDataCacheColOpAll() throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException {
        List vData;
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData();
        String vSQL = "select count(*),avg(alpha),sum(alpha),sum(beta),sum(gamma),count(beta),min(alpha),min(beta),max(alpha),max(beta) from test_table";
        try {
            vData = vBD.queryDatabase(vSQL, null, "TestPool");
            System.out.println(">>>>>Cac" + vData.toString() + "<<<<<<");
        }
        catch (InvalidOrUnsupportedSQLSyntaxException e) {
            BasicDBDataCacheTest.assertTrue((e.getMessage().indexOf("Cannot determine the average or sum of a non numeric value") != -1 ? 1 : 0) != 0);
        }
        vSQL = "select count(*),avg(alpha),sum(alpha),sum(gamma),count(beta),min(alpha),min(beta),max(alpha),max(beta) from test_table";
        vData = vBD.queryDatabase(vSQL, null, "TestPool");
        System.out.println(">>>>>Cac" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 1 entry", (vData.size() == 1 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"Map contains 9 entries", (((Map)vData.get(0)).size() == 9 ? 1 : 0) != 0);
        Map vMap = (Map)vData.get(0);
        BasicDBDataCacheTest.assertTrue((String)"count(*) = 4", (((Long)vMap.get("count(*)")).intValue() == 4 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)("avg(alpha) = " + new BigDecimal(-34316.0).divide(new BigDecimal(3.0), 17, 4)), (new BigDecimal(-34316.0).divide(new BigDecimal(3.0), 17, 4).compareTo((BigDecimal)vMap.get("avg(alpha)")) == 0 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"sum(alpha) = -34316", (((BigDecimal)vMap.get("sum(alpha)")).longValue() == -34316L ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"sum(gamma) = 3453771.54", (new BigDecimal(3453771.54).setScale(8, 4).compareTo(((BigDecimal)vMap.get("sum(gamma)")).setScale(8, 4)) == 0 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"count(beta) = 4", (((Long)vMap.get("count(beta)")).intValue() == 4 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"min(alpha) = -34324", ((Integer)vMap.get("min(alpha)") == -34324 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"min(beta) = Cat", (boolean)((String)vMap.get("min(beta)")).equals("Cat"));
        BasicDBDataCacheTest.assertTrue((String)"max(alpha) = 6", ((Integer)vMap.get("max(alpha)") == 6 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"max(beta) = Something", (boolean)((String)vMap.get("max(beta)")).equals("Something"));
    }

    public void testBasicDBDataCacheDistinct1() throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException {
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepDuplicateData();
        String vSQL = "select alpha from test_table";
        List vData = vBD.queryDatabase(vSQL, null, "TestPool");
        System.out.println(">>>>N>" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 5 entries", (vData.size() == 5 ? 1 : 0) != 0);
        vSQL = "select distinct alpha from test_table";
        vData = vBD.queryDatabase(vSQL, null, "TestPool");
        System.out.println(">>>>N>" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 3 entries", (vData.size() == 3 ? 1 : 0) != 0);
    }

    public void testBasicDBDataCacheDistinct2() throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException {
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepDuplicateData();
        String vSQL = "select alpha,beta from test_table";
        List vData = vBD.queryDatabase(vSQL, null, "TestPool");
        System.out.println(">>>>N>" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 5 entries", (vData.size() == 5 ? 1 : 0) != 0);
        vSQL = "select distinct alpha,beta from test_table";
        vData = vBD.queryDatabase(vSQL, null, "TestPool");
        System.out.println(">>>>N>" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 4 entries", (vData.size() == 4 ? 1 : 0) != 0);
    }

    public void testBasicDBDataCacheDistinct3() throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException {
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepDuplicateData();
        String vSQL = "select sum(alpha) from test_table";
        List vData = vBD.queryDatabase(vSQL, null, "TestPool");
        System.out.println(">>>>N>" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 1 entry", (vData.size() == 1 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"sum(alpha) = 20", (((BigDecimal)((Map)vData.get(0)).get("sum(alpha)")).compareTo(new BigDecimal(20.0)) == 0 ? 1 : 0) != 0);
        vSQL = "select distinct sum(alpha) from test_table";
        vData = vBD.queryDatabase(vSQL, null, "TestPool");
        System.out.println(">>>>N>" + vData.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertTrue((String)"List contains 1 entry", (vData.size() == 1 ? 1 : 0) != 0);
        BasicDBDataCacheTest.assertTrue((String)"sum(alpha) = 20", (((BigDecimal)((Map)vData.get(0)).get("sum(alpha)")).compareTo(new BigDecimal(20.0)) == 0 ? 1 : 0) != 0);
    }

    public void testBasicDBDataCacheWhereAndJoin() throws InvalidOrUnsupportedSQLSyntaxException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException, CacheMissException {
        this.prepData2();
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        String vSQL = "select * from test_table, test_table2 where alpha = alpha2 and alpha > ?";
        List vRes = vBD.queryDatabase(vSQL, new Object[]{new Integer(5)}, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)3, (int)vRes.size());
        vSQL = "select alpha, beta, gamma, alpha2, beta2, gamma2 from test_table2, test_table where alpha2 = alpha and alpha2 > ?";
        vRes = vBD.queryDatabase(vSQL, new Object[]{new Integer(5)}, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)3, (int)vRes.size());
    }

    public void testBasicDBDataCacheWhereAndEnsureCaching() throws InvalidOrUnsupportedSQLSyntaxException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException, CacheMissException {
        this.prepData();
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        String vSQL = "select * from test_table where alpha > ?";
        List vRes = vBD.queryDatabase(vSQL, new Object[]{new Integer(5)}, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)1, (int)vRes.size());
        this.addData();
        vSQL = "select alpha, beta, gamma from test_table where alpha > ?";
        vRes = vBD.queryDatabase(vSQL, new Object[]{new Integer(5)}, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)1, (int)vRes.size());
        vBD.invalidateAllCaches("TestPool");
        vSQL = "select * from test_table where alpha > ?";
        vRes = vBD.queryDatabase(vSQL, new Object[]{new Integer(5)}, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)3, (int)vRes.size());
    }

    public void testBasicDBDataTooManyEntries() throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException {
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData3();
        try {
            String vSQL = "select count(*) from test_table";
            List list = vBD.queryDatabase(vSQL, null, "TestPool");
        }
        catch (CacheMissException e) {
            BasicDBDataCacheTest.assertTrue((e.getMessage().indexOf("more than the maximum") != -1 ? 1 : 0) != 0);
        }
    }

    public void testBasicDBDataCacheWhereWithIn() throws InvalidOrUnsupportedSQLSyntaxException, NoMatchFoundException, ConfigurationException, BeanFactoryException, ApplicationContextLocatorException, DBLayerException, CacheMissException {
        this.prepData();
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        String vSQL = "select * from test_table where alpha in (?,?)";
        List vRes = vBD.queryDatabase(vSQL, new Object[]{new Integer(6), new Integer(2)}, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)2, (int)vRes.size());
        vSQL = "select * from test_table where alpha in (?,?)";
        vRes = vBD.queryDatabase(vSQL, new Object[]{new Integer(6), new Integer(2)}, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)2, (int)vRes.size());
    }

    private void prepData10() throws DBLayerException {
        new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
        DBLayer vDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
        vDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        for (int i = 0; i < 9; ++i) {
            vDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(i), "Something", new Double(3453434.0)}, false), "TestPool");
        }
        vDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{null, "Something", new Double(3.45333434E8)}, false), "TestPool");
        vDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{null, null, new Double(3453434.0)}, false), "TestPool");
        vDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{null, "AAA", new Double(3.45322434E8)}, false), "TestPool");
        vDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(1222), "BBB", new Double(3.4534434E7)}, false), "TestPool");
        vDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(11122), null, new Double(3.4513434E7)}, false), "TestPool");
        vDBLayer.submitTransaction(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(2), "AAA", new Double(4.0)}, false), "TestPool");
    }

    public void testDBLayerCachedQuery() throws ApplicationContextLocatorException, ConfigurationException, DBLayerException {
        new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
        DBLayer vDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData10();
        List vRes = vDBLayer.queryDatabaseCached("select * from test_table", null, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)15, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        vRes = vDBLayer.queryDatabaseCached("select *  from  test_table", null, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)15, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        vRes = vDBLayer.queryDatabaseCached("select *  from  test_table", null, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)15, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
    }

    public void testDBLayerCachedQueryOR() throws ApplicationContextLocatorException, ConfigurationException, DBLayerException {
        new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
        DBLayer vDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData10();
        List vRes = vDBLayer.queryDatabaseCached("select * from test_table where (alpha = 1 or alpha is null or alpha = 2) and (beta = 'AAA' or beta is null)", null, "TestPool");
        System.out.println(">>>>N>" + vRes.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertEquals((int)3, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        Map[] vRequiredRes = new HashMap[3];
        vRequiredRes[0] = new HashMap();
        vRequiredRes[0].put("alpha", null);
        vRequiredRes[0].put("beta", "AAA");
        vRequiredRes[0].put("gamma", new Double(3.45322434E8));
        vRequiredRes[1] = new HashMap();
        vRequiredRes[1].put("alpha", null);
        vRequiredRes[1].put("beta", null);
        vRequiredRes[1].put("gamma", new Double(3453434.0));
        vRequiredRes[2] = new HashMap();
        vRequiredRes[2].put("alpha", new Integer(2));
        vRequiredRes[2].put("beta", "AAA");
        vRequiredRes[2].put("gamma", new Double(4.0));
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
        vRes = vDBLayer.queryDatabaseCached("select * from test_table where (alpha = 1 or alpha is null or alpha = 2) and (beta = 'AAA' or beta is null)", null, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)3, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
        vRes = vDBLayer.queryDatabaseCached("select alpha,beta, gamma from test_table where (alpha = 1 or alpha is null or alpha = 2) and (beta = 'AAA' or beta is null)", null, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)3, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
    }

    private boolean isEquals(Object A, Object B) {
        if (A == null && B == null) {
            return true;
        }
        if (A == null && B != null) {
            return false;
        }
        if (A != null && B == null) {
            return false;
        }
        return A.equals(B);
    }

    private int checkIfEquals(Map[] pRequiredRes, List pActualRes) {
        int vEqCount = 0;
        for (int i = 0; i < pActualRes.size(); ++i) {
            Map vRow = (Map)pActualRes.get(i);
            for (int j = 0; j < pRequiredRes.length; ++j) {
                Map vRR = pRequiredRes[j];
                if (!this.isEquals(vRR.get("alpha"), vRow.get("alpha")) || !this.isEquals(vRR.get("beta"), vRow.get("beta")) || !this.isEquals(vRR.get("gamma"), vRow.get("gamma"))) continue;
                ++vEqCount;
            }
        }
        return vEqCount;
    }

    public void testDBLayerCachedQueryOperatorPrecedence1() throws ApplicationContextLocatorException, ConfigurationException, DBLayerException {
        new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
        DBLayer vDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData10();
        List vRes = vDBLayer.queryDatabaseCached("select * from test_table where alpha = 1 or alpha is null and beta = 'AAA'", null, "TestPool");
        System.out.println(">>>>N>" + vRes.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertEquals((int)2, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        Map[] vRequiredRes = new HashMap[2];
        vRequiredRes[0] = new HashMap();
        vRequiredRes[0].put("alpha", new Integer(1));
        vRequiredRes[0].put("beta", "Something");
        vRequiredRes[0].put("gamma", new Double(3453434.0));
        vRequiredRes[1] = new HashMap();
        vRequiredRes[1].put("alpha", null);
        vRequiredRes[1].put("beta", "AAA");
        vRequiredRes[1].put("gamma", new Double(3.45322434E8));
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
        vRes = vDBLayer.queryDatabaseCached("select * from test_table where alpha = 1 or alpha is null and beta = 'AAA'", null, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)2, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
    }

    public void testDBLayerCachedQueryOperatorPrecedence2() throws ApplicationContextLocatorException, ConfigurationException, DBLayerException {
        new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
        DBLayer vDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData10();
        List vRes = vDBLayer.queryDatabaseCached("select * from test_table where (alpha = 1 or alpha is null) and beta = 'AAA'", null, "TestPool");
        System.out.println(">>>>N>" + vRes.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertEquals((int)1, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        Map[] vRequiredRes = new HashMap[]{new HashMap()};
        vRequiredRes[0].put("alpha", null);
        vRequiredRes[0].put("beta", "AAA");
        vRequiredRes[0].put("gamma", new Double(3.45322434E8));
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
        vRes = vDBLayer.queryDatabaseCached("select * from test_table where (alpha = 1 or alpha is null) and beta = 'AAA'", null, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)1, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
    }

    public void testDBLayerCachedQueryComplexBraces1() throws ApplicationContextLocatorException, ConfigurationException, DBLayerException {
        new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
        DBLayer vDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData10();
        List vRes = vDBLayer.queryDatabaseCached("select * from test_table where (alpha = 1 or (alpha is null and beta is null) and ((alpha = 2 and gamma < 10000 or beta = 'AAA') or (alpha = 3 and gamma > 100000))) or ((((beta is null))))", null, "TestPool");
        System.out.println(">>>>N>" + vRes.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertEquals((int)3, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        Map[] vRequiredRes = new HashMap[3];
        vRequiredRes[0] = new HashMap();
        vRequiredRes[0].put("alpha", new Integer(11122));
        vRequiredRes[0].put("beta", null);
        vRequiredRes[0].put("gamma", new Double(3.4513434E7));
        vRequiredRes[1] = new HashMap();
        vRequiredRes[1].put("alpha", null);
        vRequiredRes[1].put("beta", null);
        vRequiredRes[1].put("gamma", new Double(3453434.0));
        vRequiredRes[2] = new HashMap();
        vRequiredRes[2].put("alpha", new Integer(1));
        vRequiredRes[2].put("beta", "Something");
        vRequiredRes[2].put("gamma", new Double(3453434.0));
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
        vRes = vDBLayer.queryDatabaseCached("select * from test_table where (alpha = 1 or (alpha is null and beta is null) and ((alpha = 2 and gamma < 10000 or beta = 'AAA') or (alpha = 3 and gamma > 100000))) or ((((beta is null))))", null, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)3, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
    }

    public void testDBLayerCachedQueryComplexBraces2() throws ApplicationContextLocatorException, ConfigurationException, DBLayerException {
        new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
        DBLayer vDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
        DBDataCache vBD = this.getBasicDBDataCache();
        vBD.invalidateAllCaches("TestPool");
        this.prepData10();
        List vRes = vDBLayer.queryDatabaseCached("select * from test_table where alpha = 1 or alpha is null and beta is null and alpha = 2 and gamma < 10000 or beta = 'AAA' or alpha = 3 and gamma > 100000 or beta is null", null, "TestPool");
        System.out.println(">>>>N>" + vRes.toString() + "<<<<<<");
        BasicDBDataCacheTest.assertEquals((int)6, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        Map[] vRequiredRes = new HashMap[6];
        vRequiredRes[0] = new HashMap();
        vRequiredRes[0].put("alpha", new Integer(11122));
        vRequiredRes[0].put("beta", null);
        vRequiredRes[0].put("gamma", new Double(3.4513434E7));
        vRequiredRes[1] = new HashMap();
        vRequiredRes[1].put("alpha", null);
        vRequiredRes[1].put("beta", null);
        vRequiredRes[1].put("gamma", new Double(3453434.0));
        vRequiredRes[2] = new HashMap();
        vRequiredRes[2].put("alpha", new Integer(1));
        vRequiredRes[2].put("beta", "Something");
        vRequiredRes[2].put("gamma", new Double(3453434.0));
        vRequiredRes[3] = new HashMap();
        vRequiredRes[3].put("alpha", null);
        vRequiredRes[3].put("beta", "AAA");
        vRequiredRes[3].put("gamma", new Double(3.45322434E8));
        vRequiredRes[4] = new HashMap();
        vRequiredRes[4].put("alpha", new Integer(2));
        vRequiredRes[4].put("beta", "AAA");
        vRequiredRes[4].put("gamma", new Double(4.0));
        vRequiredRes[5] = new HashMap();
        vRequiredRes[5].put("alpha", new Integer(3));
        vRequiredRes[5].put("beta", "Something");
        vRequiredRes[5].put("gamma", new Double(3453434.0));
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
        vRes = vDBLayer.queryDatabaseCached("select * from test_table where alpha = 1 or alpha is null and beta is null and alpha = 2 and gamma < 10000 or beta = 'AAA' or alpha = 3 and gamma > 100000 or beta is null", null, "TestPool");
        BasicDBDataCacheTest.assertEquals((int)6, (int)vRes.size());
        BasicDBDataCacheTest.assertEquals((int)3, (int)((HashMap)vRes.get(0)).keySet().size());
        BasicDBDataCacheTest.assertTrue((this.checkIfEquals(vRequiredRes, vRes) == vRequiredRes.length ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(class$net$za$pwnconsulting$dblayer$cache$BasicDBDataCacheTest == null ? (class$net$za$pwnconsulting$dblayer$cache$BasicDBDataCacheTest = BasicDBDataCacheTest.class$("net.za.pwnconsulting.dblayer.cache.BasicDBDataCacheTest")) : class$net$za$pwnconsulting$dblayer$cache$BasicDBDataCacheTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)BasicDBDataCacheTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

