/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.za.pwnconsulting.dblayer.DBLayer;
import net.za.pwnconsulting.dblayer.DBLayerException;
import net.za.pwnconsulting.dblayer.cache.AbstractDBDataCache;
import net.za.pwnconsulting.dblayer.cache.CacheInvalidatorMonitor;
import net.za.pwnconsulting.dblayer.cache.CacheMissException;
import net.za.pwnconsulting.dblayer.cache.parser.BasicSQLCacheParser;
import net.za.pwnconsulting.dblayer.cache.parser.FromTable;
import net.za.pwnconsulting.dblayer.cache.parser.InvalidOrUnsupportedSQLSyntaxException;
import net.za.pwnconsulting.dblayer.cache.parser.ParsedSQLSelect;
import net.za.pwnconsulting.dblayer.cache.parser.PoolCache;
import net.za.pwnconsulting.dblayer.conn.DBConnectionLayer;
import net.za.pwnconsulting.dblayer.conn.DBConnectionLayerException;
import net.za.pwnconsulting.dblayer.parser.IntegrityViolationException;
import net.za.pwnconsulting.dblayer.parser.SQLParser;
import net.za.pwnconsulting.dblayer.parser.SQLParserException;
import net.za.pwnconsulting.javaconfig.beans.BeanFactoryException;
import net.za.pwnconsulting.javaconfig.core.BasicLogger;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.core.LMS;
import org.dom4j.Node;

public class BasicDBDataCache
extends AbstractDBDataCache {
    private Map mPoolsCache = new HashMap();
    private Timer mCacheInvalidator = new Timer(true);
    private boolean mCacheData = true;
    private static final int DEFAULT_CACHED_TABLE_MAX_ROW_COUNT = 2000;
    private int mCachedTableMaxRowCount = 2000;
    static /* synthetic */ Class class$net$za$pwnconsulting$dblayer$DBLayer;

    public List queryDatabase(String pSQL, Object[] pParameters, String pPoolName) throws InvalidOrUnsupportedSQLSyntaxException, CacheMissException, ConfigurationException {
        if (!this.mCacheData) {
            throw new CacheMissException("Caching is disabled.");
        }
        try {
            PoolCache vPoolCache;
            DBLayer vDBLayer = (DBLayer)this.getConfiguration().getBeanFactory().getBean(class$net$za$pwnconsulting$dblayer$DBLayer == null ? (class$net$za$pwnconsulting$dblayer$DBLayer = BasicDBDataCache.class$("net.za.pwnconsulting.dblayer.DBLayer")) : class$net$za$pwnconsulting$dblayer$DBLayer);
            if (this.mPoolsCache.containsKey(pPoolName)) {
                vPoolCache = (PoolCache)this.mPoolsCache.get(pPoolName);
            } else {
                vPoolCache = new PoolCache(pPoolName);
                this.mPoolsCache.put(pPoolName, vPoolCache);
            }
            DBConnectionLayer vDBConnectionLayer = this.getConfiguration().getDBConnectionLayer();
            String vDateFormat = vDBConnectionLayer.getDateFormat(pPoolName);
            String vTimeFormat = vDBConnectionLayer.getTimeFormat(pPoolName);
            BasicSQLCacheParser vBSP = new BasicSQLCacheParser(vDateFormat, vTimeFormat);
            ParsedSQLSelect vPSS = vBSP.parseSQLSelect(SQLParser.parseSQL(pSQL, pParameters));
            List vFromTables = vPSS.getFromTables();
            for (int i = 0; i < vFromTables.size(); ++i) {
                List vData;
                String vSQL;
                FromTable vFT = (FromTable)vFromTables.get(i);
                if (!vPoolCache.existsCacheEntry(vFT.getTableReference().getTableAlias())) {
                    vSQL = "select * from " + vFT.getTableReference().getTableName();
                    vData = vDBLayer.queryDatabase(vSQL, null, pPoolName);
                    if (vData.size() > this.mCachedTableMaxRowCount) {
                        throw new CacheMissException("Could not cache the data for the reference table [" + vFT.getTableReference().getTableName() + "] as it contains [" + vData.size() + "] rows of data, which is more than the maximum allowed value of [" + this.mCachedTableMaxRowCount + "]");
                    }
                    vPoolCache.addCacheEntry(vFT.getTableReference().getTableAlias(), vData);
                }
                if (vFT.getJoinType() == 0 || vPoolCache.existsCacheEntry(vFT.getJoinTableReference().getTableAlias())) continue;
                vSQL = "select * from " + vFT.getJoinTableReference().getTableName();
                vData = vDBLayer.queryDatabase(vSQL, null, pPoolName);
                if (vData.size() > this.mCachedTableMaxRowCount) {
                    throw new CacheMissException("Could not cache the data for the reference table [" + vFT.getTableReference().getTableName() + "] as it contains [" + vData.size() + "] rows of data, which is more than the maximum allowed value of [" + this.mCachedTableMaxRowCount + "]");
                }
                vPoolCache.addCacheEntry(vFT.getJoinTableReference().getTableAlias(), vData);
            }
            List vRes = vPoolCache.applySQLSelectToList(vPSS);
            return vRes;
        }
        catch (DBConnectionLayerException e) {
            throw new ConfigurationException("Could not determine the default date format from the dblayer configuration file: " + e.getMessage(), (Throwable)((Object)e));
        }
        catch (BeanFactoryException e) {
            throw new ConfigurationException("Could not locate the DBLayer: " + e.getMessage(), (Throwable)e);
        }
        catch (DBLayerException e) {
            throw new ConfigurationException("Could not load the data into the cache: " + e.getMessage(), (Throwable)((Object)e));
        }
        catch (IntegrityViolationException e) {
            throw new InvalidOrUnsupportedSQLSyntaxException("Integrity violation in SQL: " + e.getMessage(), (Throwable)((Object)e));
        }
        catch (SQLParserException e) {
            throw new InvalidOrUnsupportedSQLSyntaxException("Could not parse SQL: " + e.getMessage(), (Throwable)((Object)e));
        }
    }

    public synchronized void invalidateAllCaches() {
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Invalidating all caches.....");
        this.mPoolsCache.clear();
    }

    public synchronized void invalidateAllCaches(String pPoolName) {
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Invalidating all caches in pool [" + pPoolName + "].....");
        this.mPoolsCache.remove(pPoolName);
    }

    public synchronized void invalidateSpecificCaches(String pTableName, String pPoolName) throws InvalidOrUnsupportedSQLSyntaxException {
        BasicLogger.getBasicLogger().debug(this.mLogger, LMS.OWNER_DBLAYER, "Invalidating cache in pool [" + pPoolName + "] for table [" + pTableName + "].....");
        if (!this.mPoolsCache.containsKey(pPoolName)) {
            return;
        }
        PoolCache vPoolCache = (PoolCache)this.mPoolsCache.get(pPoolName);
        vPoolCache.removeCacheEntry(pTableName);
    }

    protected void initFramework(Node pConfig) throws ConfigurationException {
        int vCacheInvalidationInterval;
        if (this.getSettings().existsParameterByName("CachedTableMaxRowCount")) {
            this.mCachedTableMaxRowCount = Integer.parseInt(this.getSettings().getParameterByName("CachedTableMaxRowCount"));
        }
        if ((vCacheInvalidationInterval = Integer.parseInt(this.getSettings().getParameterByName("CacheInvalidationInterval"))) > 0) {
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Starting cache invalidator timer with interval [" + vCacheInvalidationInterval + "] seconds...");
            CacheInvalidatorMonitor vCIM = new CacheInvalidatorMonitor(this);
            this.mCacheInvalidator.schedule((TimerTask)vCIM, vCacheInvalidationInterval * 1000, (long)(vCacheInvalidationInterval * 1000));
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Started cache invalidator timer...");
        } else if (vCacheInvalidationInterval == 0) {
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Not starting cache invalidator, and no data will be cached");
            this.mCacheData = false;
        } else if (vCacheInvalidationInterval < 0) {
            BasicLogger.getBasicLogger().info(this.mLogger, LMS.OWNER_DBLAYER, "Not starting cache invalidator - data will be cached indefinitly");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

