/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer;

import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import net.za.pwnconsulting.dblayer.DBLayer;
import net.za.pwnconsulting.dblayer.DBLayerException;
import net.za.pwnconsulting.dblayer.trans.DBTransactionLayerException;
import net.za.pwnconsulting.dblayer.trans.SQLBatch;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.javaconfig.beans.BeanFactoryException;
import net.za.pwnconsulting.javaconfig.core.ConfigurationException;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocator;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocatorException;

public class DBTransactionLayerTest
extends TestCase {
    private DBLayer mDBLayer;
    static /* synthetic */ Class class$net$za$pwnconsulting$dblayer$DBTransactionLayerTest;

    public DBTransactionLayerTest(String s) throws ApplicationContextLocatorException, BeanFactoryException, ConfigurationException {
        super(s);
        this.getDBLayer();
    }

    private void prepDataCritBatchCritSQLOK() throws DBLayerException {
        SQLBatch vBatch = new SQLBatch("Critical", true, "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(1), "A", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(2), "B", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(3), "C", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(4), "D", null}, false));
        this.mDBLayer.submitTransaction(vBatch);
    }

    private void prepDataCritBatchCritSQLOneBad() throws DBLayerException {
        SQLBatch vBatch = new SQLBatch("Critical", true, "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(1), "A", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table1 values (?,?,?)", new Object[]{new Integer(2), "B", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(3), "C", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(4), "D", null}, false));
        this.mDBLayer.submitTransaction(vBatch);
    }

    private void prepDataCritBatchNonCritSQLOneBad() throws DBLayerException {
        SQLBatch vBatch = new SQLBatch("Critical", true, "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(1), "A", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table1 values (?,?,?)", new Object[]{new Integer(2), "B", null}, false, "NonCrit", false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(3), "C", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(4), "D", null}, false));
        this.mDBLayer.submitTransaction(vBatch);
    }

    private void prepDataCritBatchNonCritSQLThreeBad() throws DBLayerException {
        SQLBatch vBatch = new SQLBatch("Critical", true, "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(1), "A", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table1 values (?,?,?)", new Object[]{new Integer(2), "B", null}, false, "NonCrit1", false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table2 values (?,?,?)", new Object[]{new Integer(2), "B", null}, false, "NonCrit2", false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(3), "C", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table3 values (?,?,?)", new Object[]{new Integer(2), "B", null}, false, "NonCrit3", false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(4), "D", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(4), "D", null}, false));
        this.mDBLayer.submitTransaction(vBatch);
    }

    private void prepDataNonCritBatchCritSQLOneBad() throws DBLayerException {
        SQLBatch vBatch = new SQLBatch("NonCritical", false, "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(1), "A", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table1 values (?,?,?)", new Object[]{new Integer(2), "B", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(3), "C", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(4), "D", null}, false));
        SQLBatch vBatch2 = new SQLBatch("Critical", true, "TestPool");
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(5), "E", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(6), "F", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(7), "G", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(8), "H", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(9), "I", null}, false));
        this.mDBLayer.submitTransaction(Arrays.asList(vBatch, vBatch2));
    }

    private void prepDataNonCritBatchNonCritSQLOneBad() throws DBLayerException {
        SQLBatch vBatch = new SQLBatch("NonCritical", false, "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(1), "A", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table1 values (?,?,?)", new Object[]{new Integer(2), "B", null}, false, "NonCritical", false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(3), "C", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(4), "D", null}, false));
        SQLBatch vBatch2 = new SQLBatch("Critical", true, "TestPool");
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(5), "E", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(6), "F", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(7), "G", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(8), "H", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(9), "I", null}, false));
        this.mDBLayer.submitTransaction(Arrays.asList(vBatch, vBatch2));
    }

    private void prepDataTwoCritBatchCritSQLOneBad() throws DBLayerException {
        SQLBatch vBatch = new SQLBatch("Critical", true, "TestPool");
        this.mDBLayer.submitTransaction(new SQLStatement("delete from test_table", null, false), "TestPool");
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(1), "A", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table1 values (?,?,?)", new Object[]{new Integer(2), "B", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(3), "C", null}, false));
        vBatch.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(4), "D", null}, false));
        SQLBatch vBatch2 = new SQLBatch("NonCritical", false, "TestPool");
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(5), "E", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(6), "F", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(7), "G", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(8), "H", null}, false));
        vBatch2.addSQLStatement(new SQLStatement("insert into test_table values (?,?,?)", new Object[]{new Integer(9), "I", null}, false));
        this.mDBLayer.submitTransaction(Arrays.asList(vBatch, vBatch2));
    }

    void getDBLayer() throws ConfigurationException, BeanFactoryException, ApplicationContextLocatorException {
        new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
        this.mDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
    }

    public void testAllOK() {
        this.prepDataCritBatchCritSQLOK();
        String vSQL = "select alpha,beta,gamma from test_table";
        List vRes = this.mDBLayer.queryDatabase(vSQL, null, "TestPool");
        DBTransactionLayerTest.assertEquals((int)4, (int)vRes.size());
    }

    public void testOneBad() {
        try {
            this.prepDataCritBatchCritSQLOneBad();
        }
        catch (DBTransactionLayerException e) {
            String vSQL = "select alpha,beta,gamma from test_table";
            List vRes = this.mDBLayer.queryDatabase(vSQL, null, "TestPool");
            DBTransactionLayerTest.assertEquals((int)0, (int)vRes.size());
            return;
        }
        DBTransactionLayerTest.assertTrue((boolean)false);
    }

    public void testOneBadNonCritSQL() {
        this.prepDataCritBatchNonCritSQLOneBad();
        String vSQL = "select alpha,beta,gamma from test_table";
        List vRes = this.mDBLayer.queryDatabase(vSQL, null, "TestPool");
        DBTransactionLayerTest.assertEquals((int)3, (int)vRes.size());
    }

    public void testThreeBadNonCritSQL() {
        this.prepDataCritBatchNonCritSQLThreeBad();
        String vSQL = "select alpha,beta,gamma from test_table";
        List vRes = this.mDBLayer.queryDatabase(vSQL, null, "TestPool");
        DBTransactionLayerTest.assertEquals((int)4, (int)vRes.size());
    }

    public void testOneBadNonCritBatchCritSQLOneBad() {
        this.prepDataNonCritBatchCritSQLOneBad();
        String vSQL = "select alpha,beta,gamma from test_table";
        List vRes = this.mDBLayer.queryDatabase(vSQL, null, "TestPool");
        DBTransactionLayerTest.assertEquals((int)5, (int)vRes.size());
    }

    public void testOneBadNonCritBatchNonCritSQLOneBad() {
        this.prepDataNonCritBatchNonCritSQLOneBad();
        String vSQL = "select alpha,beta,gamma from test_table";
        List vRes = this.mDBLayer.queryDatabase(vSQL, null, "TestPool");
        DBTransactionLayerTest.assertEquals((int)8, (int)vRes.size());
    }

    public void testTwoCritBatchCritSQLOneBad() {
        try {
            this.prepDataTwoCritBatchCritSQLOneBad();
        }
        catch (DBTransactionLayerException e) {
            String vSQL = "select alpha,beta,gamma from test_table";
            List vRes = this.mDBLayer.queryDatabase(vSQL, null, "TestPool");
            DBTransactionLayerTest.assertEquals((int)0, (int)vRes.size());
            return;
        }
        DBTransactionLayerTest.assertTrue((boolean)false);
    }

    public static Test suite() {
        return new TestSuite(class$net$za$pwnconsulting$dblayer$DBTransactionLayerTest == null ? (class$net$za$pwnconsulting$dblayer$DBTransactionLayerTest = DBTransactionLayerTest.class$("net.za.pwnconsulting.dblayer.DBTransactionLayerTest")) : class$net$za$pwnconsulting$dblayer$DBTransactionLayerTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DBTransactionLayerTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

