/*
 * Decompiled with CFR 0.152.
 */
package net.za.pwnconsulting.dblayer;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import net.za.pwnconsulting.dblayer.DBLayer;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocator;

public class DBLayerPerformanceTest {
    public void run() {
        Vector<SimulationThread> vThreads = new Vector<SimulationThread>();
        for (int i = 0; i < 100; ++i) {
            SimulationThread vThread = new SimulationThread(i);
            vThread.start();
            vThreads.add(vThread);
        }
    }

    public static void main(String[] args) {
        try {
            new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
            DBLayer vDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
            System.out.println("Sleeping 20 seconds....");
            Thread.sleep(20000L);
            System.out.println("Main thread awoke.  Starting 100 threads simulating 100 users");
            DBLayerPerformanceTest vDBLayerTest = new DBLayerPerformanceTest();
            vDBLayerTest.run();
            System.out.println("100 Threads started...");
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    class SimulationThread
    extends Thread {
        private int mIndex = 0;

        public SimulationThread(int pIndex) {
            System.out.println("Thread " + pIndex + " starting...");
            this.mIndex = pIndex;
        }

        public void run() {
            String[] vSQL = new String[]{"SELECT round(sum(charge),2) spend FROM bill_0120030301, sbd_sub_dets, crm_subs_extra WHERE subscriber_id = sbd_subscriber_id and sbd_bill_ac_no = eppix_msisdn and group_name = ? UNION SELECT round(sum(charge),2) spend FROM bill_0120030201, sbd_sub_dets, crm_subs_extra WHERE subscriber_id = sbd_subscriber_id and sbd_bill_ac_no = eppix_msisdn and group_name = ? UNION SELECT round(sum(charge),2) spend FROM bill_0120030101, sbd_sub_dets, crm_subs_extra WHERE subscriber_id = sbd_subscriber_id and sbd_bill_ac_no = eppix_msisdn and group_name = ?", "select count(*) AS num_lines from crm_corp_extra a, sbd_sub_dets b where a.eppix_acc_no = b.sbd_bill_ac_no and a.group_name = ?", "SELECT a.*,b.sbd_bill_ac_no as corp_acc_no,c.*,ls_description, lt_description, b.sbd_firstname as eppix_name, b.sbd_package_code as package,b.sbd_address1 as postadd_line1, b.sbd_address2 as postadd_line2, b.sbd_address3 as postadd_line3,b.sbd_address4 as postadd_city,b.sbd_postcode as postadd_code,sbd_sub_tel as telephone,sbd_fax as fax, sbd_dob as birthday,sbd_email as e_mail, sbd_dialling_no FROM outer(crm_subs_extra a), sbd_sub_dets b, outer(ls_loyalty_subs c, ls_loyalty_status d, lt_loyalty_type e) WHERE a.eppix_msisdn = b.sbd_dialling_no AND sbd_dialling_no = ?  AND c.ls_msisdn_no = b.sbd_dialling_no AND c.ls_status = d.ls_type AND c.ls_type = e.lt_type", "select first 500 customer,alpha,name,address1,address2,address3,date_last_issue, date_created, analysis_codes2, credit_limit, cumulative_sales, bank_account_no, bank_address1,analysis_code_6, delivery_method, bank_branch_code,cp_lower_value,address6,fax,paydays2 from slcustm"};
            Object[][] vParams = new Object[][]{{"CRM Test Group", "CRM Test Group", "CRM Test Group"}, {"Religous Group"}, {"8X4142321000"}, null};
            int i = 0;
            int min = 1000000;
            int max = 0;
            double ave = 0.0;
            int j = 0;
            try {
                new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/j2ee-app.xml", "Test");
                DBLayer vDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Test");
                while (true) {
                    try {
                        while (true) {
                            i = (int)Math.round(Math.random() * 3.0);
                            System.out.println("Running query " + i + " in thread " + this.mIndex + "....");
                            Date vStart = new Date();
                            List vRes = vDBLayer.queryDatabase(vSQL[i], vParams[i], "crm_eppix");
                            if (i == 3) {
                                System.out.println("======================================================================");
                            }
                            System.out.println("Vector result size: " + vRes.size());
                            double vDiff = (double)(new Date().getTime() - vStart.getTime()) / 1000.0;
                            ++j;
                            if (vDiff <= (double)min) {
                                min = (int)vDiff;
                            }
                            if (vDiff >= (double)max) {
                                max = (int)vDiff;
                            }
                            ave += vDiff;
                            System.out.println("Finished running query " + i + " in thread " + this.mIndex + " - time was " + (long)vDiff + " seconds." + " This is run [" + j + "]");
                            if (j % 50 == 0) {
                                System.out.println("The mean is: " + ave / (double)j + ", min is " + min + ", max is " + max);
                            }
                            SimulationThread.sleep(Math.round(Math.random() * 5.0));
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Exception in thread [" + this.mIndex + "]: " + e.getMessage());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("Exception in thread [" + this.mIndex + "]: " + e.getMessage());
                return;
            }
        }
    }
}

