/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica.helpers;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.za.pwnconsulting.javaconfig.exceptions.ProgrammerMistakeException;

public class GUIUtils {
    public static void showNormalCursor(Window pWindow) {
        pWindow.setCursor(Cursor.getDefaultCursor());
    }

    public static void showHandCursor(Window pWindow) {
        pWindow.setCursor(Cursor.getPredefinedCursor(12));
    }

    public static void showBusyCursor(Window pWindow) {
        pWindow.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setFrameDimensions(Window pWindow, int pWidth, int pHeight, boolean pResizable, boolean pCenterOnParent) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int appWidth = 0;
        int appHeight = 0;
        int locX = 0;
        int locY = 0;
        appWidth = Math.min(screenSize.width, pWidth);
        appHeight = Math.min(screenSize.height - 40, pHeight);
        pWindow.setSize(new Dimension(appWidth, appHeight));
        if (pWindow instanceof JFrame) {
            ((JFrame)pWindow).getContentPane().setSize(new Dimension(appWidth, appHeight));
            ((JFrame)pWindow).getContentPane().setPreferredSize(new Dimension(appWidth, appHeight));
            ((JFrame)pWindow).setResizable(pResizable);
        } else if (pWindow instanceof JDialog) {
            ((JDialog)pWindow).getContentPane().setSize(new Dimension(appWidth, appHeight));
            ((JDialog)pWindow).getContentPane().setPreferredSize(new Dimension(appWidth, appHeight));
            ((JDialog)pWindow).setResizable(pResizable);
        }
        if (pCenterOnParent) {
            if (pWindow.getParent() == null) {
                throw new ProgrammerMistakeException("Cannot center a form on a parent if the child is an orphan");
            }
            locX = (pWindow.getParent().getWidth() - appWidth) / 2 + pWindow.getParent().getX();
            locY = (pWindow.getParent().getHeight() - appHeight) / 2 + pWindow.getParent().getY();
            pWindow.setLocation(locX, locY);
        }
    }

    public static String buildCopyrightString() {
        return "<html><p style=\"text-align: center;" + GUIUtils.getFontSize() + "\">" + GUIUtils.getCopyrightText();
    }

    private static String getCopyrightText() {
        return "&copy; Copyright " + Calendar.getInstance().get(1) + " PWN Consulting";
    }

    public static String getFontSize() {
        return GUIUtils.isWindows() ? "" : "font-size: 0.95em";
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.US).indexOf("windows") != -1;
    }

    public static void setTableColumnToFit(JTable pTable, int pColumn) {
        TableColumn vColumn = pTable.getColumnModel().getColumn(pColumn);
        int w = 10;
        int n = pTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableCellRenderer r = pTable.getCellRenderer(i, pColumn);
            Component c = r.getTableCellRendererComponent(pTable, pTable.getValueAt(i, pColumn), false, false, i, pColumn);
            w = Math.max(w, c.getPreferredSize().width);
        }
        vColumn.setPreferredWidth(w + 20);
    }

    public static boolean isMacOSX() {
        String vOS = System.getProperty("os.name").toLowerCase(Locale.US);
        return vOS.startsWith("mac os") && vOS.endsWith("x");
    }

    public static void setBold(JLabel pLabel) {
        Font vF = pLabel.getFont();
        pLabel.setFont(vF.deriveFont(vF.getStyle() | 1));
    }

    public static void unsetBold(JLabel pLabel) {
        Font vF = pLabel.getFont();
        pLabel.setFont(vF.deriveFont(vF.getStyle() & 0xFFFFFFFE));
    }
}

