/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica.helpers;

import java.io.File;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import net.za.pwnconsulting.dblayer.DBLayer;
import net.za.pwnconsulting.dblayer.DBLayerException;
import net.za.pwnconsulting.dblayer.conn.pool.DBConnectionPool;
import net.za.pwnconsulting.dblayer.locking.XLayerProperties;
import net.za.pwnconsulting.dblayer.trans.SQLBatch;
import net.za.pwnconsulting.dblayer.trans.SQLStatement;
import net.za.pwnconsulting.javaconfig.exceptions.RuntimeFailureException;
import net.za.pwnconsulting.javaconfig.exceptions.RuntimeNestedException;
import net.za.pwnconsulting.javaconfig.support.ApplicationContextLocator;
import net.za.pwnconsulting.javaconfig.utils.MapUtils;
import org.dom4j.DocumentException;
import za.co.pwnconsulting.aquatronica.AquatronicaDevicesForm;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.config.MutableConfiguration;
import za.co.pwnconsulting.aquatronica.helpers.DBPatchingFailedException;
import za.co.pwnconsulting.aquatronica.helpers.StatusCallback;

public class DBHelper {
    private static DBHelper mDBHelper = null;
    private DBLayer mDBLayer = null;
    private boolean mEmbedded;
    private boolean mStarted = false;

    private DBHelper() {
    }

    public void shutdownDB() {
        this.shutdownDB(this.mEmbedded);
    }

    public void shutdownDB(boolean pEmbedded) {
        try {
            this.mStarted = false;
            DBConnectionPool vDB = (DBConnectionPool)new ApplicationContextLocator().getApplicationContext().getDBLayerBeanFactory("Aquatronica").getBean("Aquatronica", DBConnectionPool.class);
            vDB.stop();
            if (pEmbedded) {
                DriverManager.getConnection("jdbc:derby:aquatronica;shutdown=true");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static synchronized DBHelper getInstance() {
        if (mDBHelper == null) {
            mDBHelper = new DBHelper();
        }
        return mDBHelper;
    }

    public DBLayer getDBLayer() {
        return this.mDBLayer;
    }

    public void startDB(boolean pEmbedded, int pPatchLevel) {
        this.startDB(pEmbedded, pPatchLevel, null);
    }

    public void startDB(boolean pEmbedded, int pPatchLevel, StatusCallback pStatusCallBack) {
        this.mEmbedded = pEmbedded;
        if (pStatusCallBack != null) {
            pStatusCallBack.updateStatusText("Bootstrapping application...", false);
        }
        new ApplicationContextLocator().getApplicationContext().addBasicConfiguration("/properties/aquatronica/j2ee-app" + (this.mEmbedded ? "-embedded" : "") + ".xml", "Aquatronica");
        if (pStatusCallBack != null) {
            pStatusCallBack.updateStatusText("Bootstrapped configuration, starting " + (this.mEmbedded ? "local embedded" : "remote PostgreSQL") + " database engine...", false);
        }
        try {
            this.mDBLayer = new ApplicationContextLocator().getApplicationContext().getDBLayer("Aquatronica");
            if (!pEmbedded && pPatchLevel > 0) {
                this.mDBLayer.queryDatabaseScalar("select count(*) from sensor", null, "Aquatronica");
            }
            this.mStarted = true;
            if (pStatusCallBack != null) {
                pStatusCallBack.updateStatusText((this.mEmbedded ? "Local embedded" : "Remote PostgreSQL") + " database engine started successfully", false);
            }
        }
        catch (RuntimeException e) {
            try {
                this.shutdownDB(this.mEmbedded);
                this.mDBLayer = null;
                this.mStarted = false;
            }
            catch (Exception exc) {
                // empty catch block
            }
            if (pStatusCallBack != null) {
                pStatusCallBack.updateStatusText("Failed starting database engine: " + e.getMessage(), true);
            }
            throw e;
        }
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    public SQLStatement generateSQLStatementInsertPowerUnit(String pSQL, Object[] pParameters, int i) {
        return this.generateSQLStatementInsert(pSQL, pParameters, "PowerUnit" + i, "powerunit_pu_id_seq");
    }

    public SQLStatement generateSQLStatementInsertTankMaintenanceLog(String pSQL, Object[] pParameters) {
        return this.generateSQLStatementInsert(pSQL, pParameters, "TankMaintenanceLog", "tank_maintenance_log_tml_id_seq");
    }

    public SQLStatement generateSQLStatementInsertTank(String pSQL, Object[] pParameters) {
        return this.generateSQLStatementInsert(pSQL, pParameters, "Tank", "tank_tank_id_seq");
    }

    public SQLStatement generateSQLStatementInsertOverlayGraphPreset(String pSQL, Object[] pParameters) {
        return this.generateSQLStatementInsert(pSQL, pParameters, "OverlayGraphPreset", "overlay_graph_preset_ogp_id_seq");
    }

    public SQLStatement generateSQLStatementInsertWaterParameter(String pSQL, Object[] pParameters, int i) {
        return this.generateSQLStatementInsert(pSQL, pParameters, "WaterParameter" + i, "water_parameter_wp_id_seq");
    }

    public SQLStatement generateSQLStatementInsertPowerunitDefinition(String pSQL, Object[] pParameters, int i) {
        return this.generateSQLStatementInsert(pSQL, pParameters, "PowerunitDefinition" + i, "powerunit_definition_pud_id_seq");
    }

    private SQLStatement generateSQLStatementInsert(String pSQL, Object[] pParameters, String pSerialName, String pSequenceName) {
        if (!this.mEmbedded) {
            return new SQLStatement(pSQL, pParameters, true, pSerialName, true, pSequenceName);
        }
        return new SQLStatement(pSQL, pParameters, true, pSerialName, true);
    }

    public XLayerProperties getXLayerProperties() {
        if (this.mEmbedded) {
            return new XLayerProperties(true, true);
        }
        return new XLayerProperties();
    }

    public void applyPatches(int pCurrentPatchLevel, int pDesiredPatchLevel) throws IOException, DocumentException {
        String[] vSQL2;
        String[] vSQL2Embedded;
        String[] vSQL2Remote;
        ArrayList<String> vSQL = new ArrayList<String>();
        if (pCurrentPatchLevel == 0) {
            String[] vSQL22;
            System.out.println("Upgrading to patch level 1...");
            if (!this.mEmbedded) {
                vSQL22 = new String[]{"create table sensor (sens_id serial not null primary key, sens_name varchar(20) not null, sens_value varchar(20) not null, sens_status int not null, sens_timestamp timestamp default now())", "create table powerunit (pu_id serial not null primary key, pu_unit_id int not null,  pu_name varchar(20) not null, pu_timestamp timestamp default now())", "create table plug (pl_pu_id int not null references powerunit(pu_id), pl_id serial not null primary key, pl_plug_id int not null, pl_name varchar(20) not null, pl_status int not null, pl_timestamp timestamp default now())"};
                vSQL.addAll(Arrays.asList(vSQL22));
            }
            vSQL22 = new String[]{"create index pl_plug on plug(pl_pu_id)", "create index pl_plug_name on plug(pl_name)", "create index pu_name on powerunit(pu_name)", "create index sens_name on sensor(sens_name)"};
            vSQL.addAll(Arrays.asList(vSQL22));
            ++pCurrentPatchLevel;
        }
        if (pCurrentPatchLevel == 1) {
            System.out.println("Upgrading to patch level 2...");
            vSQL2Remote = new String[]{"create table tank (tank_id serial not null primary key, tank_name varchar(40) not null)", "create table tank_sensor (ts_tank_id int not null references tank(tank_id), ts_sensor_name varchar(20) not null)", "create table tank_plug (tp_tank_id int not null references tank(tank_id), tp_plug_name varchar(20) not null)", "create table tank_maintenance_log (tml_id serial not null primary key, tml_title varchar(40) not null, tml_details varchar(255), tml_date timestamp not null, tml_tank_id int not null references tank(tank_id))"};
            vSQL2Embedded = new String[]{"create table tank (tank_id int not null generated always as identity primary key, tank_name varchar(40) not null)", "create table tank_sensor (ts_tank_id int not null references tank(tank_id), ts_sensor_name varchar(20) not null)", "create table tank_plug (tp_tank_id int not null references tank(tank_id), tp_plug_name varchar(20) not null)", "create table tank_maintenance_log (tml_id int not null generated always as identity primary key, tml_title varchar(40) not null, tml_details varchar(255), tml_date timestamp not null, tml_tank_id int not null references tank(tank_id))"};
            vSQL2 = this.mEmbedded ? vSQL2Embedded : vSQL2Remote;
            vSQL.addAll(Arrays.asList(vSQL2));
            ++pCurrentPatchLevel;
        }
        if (pCurrentPatchLevel == 2) {
            System.out.println("Upgrading to patch level 3...");
            vSQL2Remote = new String[]{"create table overlay_graph_preset(ogp_id serial not null primary key, ogp_name varchar(40) not null)", "create table overlay_graph_preset_sensor(ogps_ogp_id int not null references overlay_graph_preset(ogp_id), ogps_sensor_name varchar(20) not null)", "create table overlay_graph_preset_plug(ogpp_ogp_id int not null references overlay_graph_preset(ogp_id), ogpp_powerunit_id int not null, ogpp_plug_id int not null)"};
            vSQL2Embedded = new String[]{"create table overlay_graph_preset(ogp_id int not null generated always as identity primary key, ogp_name varchar(40) not null)", "create table overlay_graph_preset_sensor(ogps_ogp_id int not null references overlay_graph_preset(ogp_id), ogps_sensor_name varchar(20) not null)", "create table overlay_graph_preset_plug(ogpp_ogp_id int not null references overlay_graph_preset(ogp_id), ogpp_powerunit_id int not null, ogpp_plug_id int not null)"};
            vSQL2 = this.mEmbedded ? vSQL2Embedded : vSQL2Remote;
            vSQL.addAll(Arrays.asList(vSQL2));
            ++pCurrentPatchLevel;
        }
        if (pCurrentPatchLevel == 3) {
            System.out.println("Upgrading to patch level 4...");
            vSQL2Remote = new String[]{"create table sensor_definition(sd_id serial not null primary key, sd_sensor_name varchar(20) not null, sd_discrete char(1) not null, sd_ntfy_on_alert char(1) not null)", "create table powerunit_definition(pud_id serial not null primary key, pud_powerunit_name varchar(20) not null, pud_unit_id int not null)", "create table plug_definition(pld_id serial not null primary key, pld_plug_name varchar(20) not null, pld_plug_id int not null, pld_pud_id int not null references powerunit_definition(pud_id))", "create table notification(not_alarm_enabled char(1) not null, not_receiver_address varchar(1024), not_new_alert_tmpl_subj varchar(300), not_new_alert_tmpl_body varchar(2048),  not_cleared_alert_tmpl_subj varchar(300), not_cleared_alert_tmpl_body varchar(2048), not_summary_upd_subj varchar(300), not_summary_upd_enabled char(1) not null, not_summary_upd_freq varchar(15), not_summary_upd_time time)", "create table water_parameter(wp_id serial not null primary key, wp_type varchar(20) not null, wp_value float not null, wp_timestamp timestamp default now(), wp_tank_id int not null references tank(tank_id))", "create table overlay_graph_preset_water_parameter(ogpwp_ogp_id int not null references overlay_graph_preset(ogp_id), ogpwp_water_parameter_type varchar(20) not null, ogpwp_tank_id int not null references tank(tank_id))"};
            vSQL2Embedded = new String[]{"create table sensor_definition(sd_id int not null generated always as identity primary key, sd_sensor_name varchar(20) not null, sd_discrete char(1) not null, sd_ntfy_on_alert char(1) not null)", "create table powerunit_definition(pud_id int not null generated always as identity primary key, pud_powerunit_name varchar(20) not null, pud_unit_id int not null)", "create table plug_definition(pld_id int not null generated always as identity primary key, pld_plug_name varchar(20) not null, pld_plug_id int not null, pld_pud_id int not null references powerunit_definition(pud_id))", "create table notification(not_alarm_enabled char(1) not null, not_receiver_address varchar(1024), not_new_alert_tmpl_subj varchar(300), not_new_alert_tmpl_body varchar(2048),  not_cleared_alert_tmpl_subj varchar(300), not_cleared_alert_tmpl_body varchar(2048), not_summary_upd_subj varchar(300), not_summary_upd_enabled char(1) not null, not_summary_upd_freq varchar(15), not_summary_upd_time time)", "create table water_parameter(wp_id int not null generated always as identity primary key, wp_type varchar(20) not null, wp_value float not null, wp_timestamp timestamp default CURRENT_TIMESTAMP, wp_tank_id int not null references tank(tank_id))", "create table overlay_graph_preset_water_parameter(ogpwp_ogp_id int not null references overlay_graph_preset(ogp_id), ogpwp_water_parameter_type varchar(20) not null, ogpwp_tank_id int not null references tank(tank_id))"};
            vSQL2 = this.mEmbedded ? vSQL2Embedded : vSQL2Remote;
            vSQL.addAll(Arrays.asList(vSQL2));
            ++pCurrentPatchLevel;
        }
        if (pCurrentPatchLevel == 4) {
            System.out.println("Upgrading to patch level 5...");
            vSQL2Remote = new String[]{"alter table tank_maintenance_log add tml_plot char(1) not null default 'T'"};
            vSQL2Embedded = new String[]{"alter table tank_maintenance_log add tml_plot char(1) not null default 'T'"};
            vSQL2 = this.mEmbedded ? vSQL2Embedded : vSQL2Remote;
            vSQL.addAll(Arrays.asList(vSQL2));
            ++pCurrentPatchLevel;
        }
        if (vSQL.size() > 0) {
            this.applySQLPatch(vSQL.toArray(new String[0]));
            MutableConfiguration vConfiguration = new MutableConfiguration();
            vConfiguration.setDBPatchLevel(pCurrentPatchLevel);
            vConfiguration.save();
            vSQL.clear();
        }
        if (pCurrentPatchLevel == 5) {
            JOptionPane.showMessageDialog(null, "<html>In order to upgrade the DB to the latest patch level, it is required<br> that all devices be configured before the DB upgrade can commence.<br>  In the following dialog, select each of the three tabs and save the values<br> accordingly.", "Upgrade Notice", 1);
            AquatronicaDevicesForm vDialog = new AquatronicaDevicesForm(new Configuration());
            vDialog.setVisible(true);
            if (this.getCountResult(this.mDBLayer.queryDatabaseScalar("select count(*) from powerunit_definition", null, "Aquatronica")) <= 0L) {
                throw new RuntimeFailureException("The powerunit definition was not properly saved in the previous dialog.  Aborting.");
            }
            if (this.getCountResult(this.mDBLayer.queryDatabaseScalar("select count(*) from plug_definition", null, "Aquatronica")) <= 0L) {
                throw new RuntimeFailureException("The plug definition was not properly saved in the previous dialog.  Aborting.");
            }
            if (this.getCountResult(this.mDBLayer.queryDatabaseScalar("select count(*) from sensor_definition", null, "Aquatronica")) <= 0L) {
                throw new RuntimeFailureException("The sensor definition was not properly saved in the previous dialog.  Aborting.");
            }
            System.out.println("Upgrading to patch level 6...");
            String[] vSQL2Remote2 = new String[]{"alter table powerunit add pu_pud_id int references powerunit_definition(pud_id)", "update powerunit set pu_pud_id = (select pud_id from powerunit_definition where pud_unit_id = pu_unit_id)", "alter table powerunit drop pu_unit_id", "alter table powerunit drop pu_name", "alter table plug add pl_pld_id int references plug_definition(pld_id)", "update plug set pl_pld_id = (select pld_id from plug_definition where pld_plug_id = pl_plug_id and pld_pud_id = (select pu_pud_id from powerunit where pu_id = pl_pu_id))", "alter table plug drop pl_plug_id", "alter table plug drop pl_name", "alter table sensor add sens_sd_id int references sensor_definition(sd_id)", "update sensor set sens_sd_id = (select sd_id from sensor_definition where sd_sensor_name = sens_name)", "alter table sensor drop sens_name", "alter table overlay_graph_preset_sensor add ogps_sd_id int references sensor_definition(sd_id)", "update overlay_graph_preset_sensor set ogps_sd_id = (select sd_id from sensor_definition where sd_sensor_name = ogps_sensor_name)", "alter table overlay_graph_preset_sensor drop ogps_sensor_name", "alter table tank_plug add tp_pld_id int references plug_definition(pld_id)", "alter table tank_plug drop tp_plug_name", "alter table tank_sensor add ts_sd_id int references sensor_definition(sd_id)", "update tank_sensor set ts_sd_id = (select sd_id from sensor_definition where sd_sensor_name = ts_sensor_name)", "alter table tank_sensor drop ts_sensor_name", "create index idx_pu_pud_id on powerunit(pu_pud_id)", "create index idx_pl_pld_id on plug(pl_pld_id)", "create index idx_sens_sd_id on sensor(sens_sd_id)", "create index idx_ogps_sd_id on overlay_graph_preset_sensor(ogps_sd_id)", "create index idx_tp_pld_id on tank_plug(tp_pld_id)", "create index idx_ts_sd_id on tank_sensor(ts_sd_id)"};
            String[] vSQL2Embedded2 = new String[]{"alter table powerunit add pu_pud_id int references powerunit_definition(pud_id)", "update powerunit set pu_pud_id = (select pud_id from powerunit_definition where pud_unit_id = pu_unit_id)", "alter table powerunit drop pu_unit_id", "alter table powerunit drop pu_name", "alter table plug add pl_pld_id int references plug_definition(pld_id)", "update plug set pl_pld_id = (select pld_id from plug_definition where pld_plug_id = pl_plug_id and pld_pud_id = (select pu_pud_id from powerunit where pu_id = pl_pu_id))", "alter table plug drop pl_plug_id", "alter table plug drop pl_name", "alter table sensor add sens_sd_id int references sensor_definition(sd_id)", "update sensor set sens_sd_id = (select sd_id from sensor_definition where sd_sensor_name = sens_name)", "alter table sensor drop sens_name", "alter table overlay_graph_preset_sensor add ogps_sd_id int references sensor_definition(sd_id)", "update overlay_graph_preset_sensor set ogps_sd_id = (select sd_id from sensor_definition where sd_sensor_name = ogps_sensor_name)", "alter table overlay_graph_preset_sensor drop ogps_sensor_name", "alter table tank_plug add tp_pld_id int references plug_definition(pld_id)", "alter table tank_plug drop tp_plug_name", "alter table tank_sensor add ts_sd_id int references sensor_definition(sd_id)", "update tank_sensor set ts_sd_id = (select sd_id from sensor_definition where sd_sensor_name = ts_sensor_name)", "alter table tank_sensor drop ts_sensor_name", "create index idx_pu_pud_id on powerunit(pu_pud_id)", "create index idx_pl_pld_id on plug(pl_pld_id)", "create index idx_sens_sd_id on sensor(sens_sd_id)", "create index idx_ogps_sd_id on overlay_graph_preset_sensor(ogps_sd_id)", "create index idx_tp_pld_id on tank_plug(tp_pld_id)", "create index idx_ts_sd_id on tank_sensor(ts_sd_id)"};
            String[] vSQL23 = this.mEmbedded ? vSQL2Embedded2 : vSQL2Remote2;
            vSQL.addAll(Arrays.asList(vSQL23));
            ++pCurrentPatchLevel;
        }
        if (pCurrentPatchLevel == 6) {
            System.out.println("Upgrading to patch level 7...");
            vSQL2Remote = new String[]{"alter table notification add not_dead_time_alarm int"};
            vSQL2Embedded = new String[]{"alter table notification add not_dead_time_alarm int"};
            vSQL2 = this.mEmbedded ? vSQL2Embedded : vSQL2Remote;
            vSQL.addAll(Arrays.asList(vSQL2));
            ++pCurrentPatchLevel;
        }
        if (pCurrentPatchLevel == 7) {
            System.out.println("Upgrading to patch level 8...");
            vSQL2Remote = new String[]{"alter table notification add not_alarm_disconnect_enabled char(1)", "alter table notification add not_aquastats_disconnect_enabled char(1)", "alter table notification add not_aquastats_disconnect_delay_alarm int", "alter table sensor_definition add sd_archived char(1) default 'F'", "alter table powerunit_definition add pud_archived char(1) default 'F'", "alter table plug_definition drop constraint plug_definition_pld_pud_id_fkey", "alter table plug_definition add constraint plug_definition_pld_pud_id_fkey FOREIGN KEY (pld_pud_id) REFERENCES powerunit_definition(pud_id) on delete cascade", "alter table powerunit drop constraint powerunit_pu_pud_id_fkey", "alter table powerunit add constraint powerunit_pu_pud_id_fkey FOREIGN KEY (pu_pud_id) REFERENCES powerunit_definition(pud_id) on delete cascade", "alter table plug drop constraint plug_pl_pld_id_fkey", "alter table plug add constraint plug_pl_pld_id_fkey FOREIGN KEY (pl_pld_id) REFERENCES plug_definition(pld_id) on delete cascade", "alter table plug drop constraint plug_pl_pu_id_fkey", "alter table plug add constraint plug_pl_pu_id_fkey FOREIGN KEY (pl_pu_id) REFERENCES powerunit(pu_id) on delete cascade", "alter table overlay_graph_preset_plug add ogpp_pld_id int references plug_definition(pld_id) on delete cascade", "update overlay_graph_preset_plug set ogpp_pld_id = (select pld_id from plug_definition, powerunit_definition where pld_pud_id = pud_id and pld_plug_id = ogpp_plug_id and ogpp_powerunit_id = pud_unit_id)", "alter table overlay_graph_preset_plug drop ogpp_powerunit_id", "alter table overlay_graph_preset_plug drop ogpp_plug_id", "alter table tank_plug drop constraint tank_plug_tp_pld_id_fkey", "alter table tank_plug add constraint tank_plug_tp_pld_id_fkey foreign KEY (tp_pld_id) REFERENCES plug_definition(pld_id) on delete cascade", "alter table overlay_graph_preset_sensor drop constraint overlay_graph_preset_sensor_ogps_sd_id_fkey", "alter table overlay_graph_preset_sensor add constraint overlay_graph_preset_sensor_ogps_sd_id_fkey FOREIGN KEY (ogps_sd_id) REFERENCES sensor_definition(sd_id) on delete cascade", "alter table sensor drop constraint sensor_sens_sd_id_fkey", "alter table sensor add constraint sensor_sens_sd_id_fkey FOREIGN KEY (sens_sd_id) REFERENCES sensor_definition(sd_id) on delete cascade", "alter table tank_sensor drop constraint tank_sensor_ts_sd_id_fkey", "alter table tank_sensor add constraint tank_sensor_ts_sd_id_fkey FOREIGN KEY (ts_sd_id) REFERENCES sensor_definition(sd_id) on delete cascade"};
            if (this.mEmbedded) {
                String vSQLFK = "select CONSTRAINTNAME,TABLENAME from SYS.SYSCONSTRAINTS, SYS.SYSTABLES where SYS.SYSCONSTRAINTS.TABLEID = SYS.SYSTABLES.TABLEID and SYS.SYSTABLES.TABLENAME in ('PLUG_DEFINITION','POWERUNIT','PLUG','TANK_PLUG','OVERLAY_GRAPH_PRESET_SENSOR','SENSOR','TANK_SENSOR') and SYS.SYSCONSTRAINTS.TYPE = 'F'";
                List vResFK = this.mDBLayer.queryDatabase(vSQLFK, null, "Aquatronica");
                for (int i = 0; i < vResFK.size(); ++i) {
                    Map vRow = (Map)vResFK.get(i);
                    vSQL.add("alter table " + MapUtils.getMapValueAsString((Map)vRow, (String)"TABLENAME", (boolean)true) + " drop constraint " + MapUtils.getMapValueAsString((Map)vRow, (String)"CONSTRAINTNAME", (boolean)true));
                }
            }
            vSQL2Embedded = new String[]{"alter table notification add not_alarm_disconnect_enabled char(1)", "alter table notification add not_aquastats_disconnect_enabled char(1)", "alter table notification add not_aquastats_disconnect_delay_alarm int", "alter table sensor_definition add sd_archived char(1) default 'F'", "alter table powerunit_definition add pud_archived char(1) default 'F'", "alter table plug_definition add constraint plug_definition_pld_pud_id_fkey FOREIGN KEY (pld_pud_id) REFERENCES powerunit_definition(pud_id) on delete cascade", "alter table powerunit add constraint powerunit_pu_pud_id_fkey FOREIGN KEY (pu_pud_id) REFERENCES powerunit_definition(pud_id) on delete cascade", "alter table plug add constraint plug_pl_pld_id_fkey FOREIGN KEY (pl_pld_id) REFERENCES plug_definition(pld_id) on delete cascade", "alter table plug add constraint plug_pl_pu_id_fkey FOREIGN KEY (pl_pu_id) REFERENCES powerunit(pu_id) on delete cascade", "alter table overlay_graph_preset_plug add ogpp_pld_id int references plug_definition(pld_id) on delete cascade", "update overlay_graph_preset_plug set ogpp_pld_id = (select pld_id from plug_definition, powerunit_definition where pld_pud_id = pud_id and pld_plug_id = ogpp_plug_id and ogpp_powerunit_id = pud_unit_id)", "alter table overlay_graph_preset_plug drop ogpp_powerunit_id", "alter table overlay_graph_preset_plug drop ogpp_plug_id", "alter table tank_plug add constraint tank_plug_tp_pld_id_fkey foreign KEY (tp_pld_id) REFERENCES plug_definition(pld_id) on delete cascade", "alter table overlay_graph_preset_sensor add constraint overlay_graph_preset_sensor_ogps_sd_id_fkey FOREIGN KEY (ogps_sd_id) REFERENCES sensor_definition(sd_id) on delete cascade", "alter table sensor add constraint sensor_sens_sd_id_fkey FOREIGN KEY (sens_sd_id) REFERENCES sensor_definition(sd_id) on delete cascade", "alter table tank_sensor add constraint tank_sensor_ts_sd_id_fkey FOREIGN KEY (ts_sd_id) REFERENCES sensor_definition(sd_id) on delete cascade", "ALTER TABLE TANK_PLUG ADD CONSTRAINT tank_plug_pt_tank_id FOREIGN KEY (TP_TANK_ID) REFERENCES TANK (TANK_ID) ON DELETE NO ACTION ON UPDATE NO ACTION", "ALTER TABLE OVERLAY_GRAPH_PRESET_SENSOR ADD CONSTRAINT overlay_graph_preset_sensor_ogps_ogp_id_fkey FOREIGN KEY (OGPS_OGP_ID) REFERENCES OVERLAY_GRAPH_PRESET (OGP_ID) ON DELETE NO ACTION ON UPDATE NO ACTION", "ALTER TABLE TANK_SENSOR ADD CONSTRAINT tank_sensor_ts_tank_id_fkey FOREIGN KEY (TS_TANK_ID) REFERENCES TANK (TANK_ID) ON DELETE NO ACTION ON UPDATE NO ACTION"};
            vSQL2 = this.mEmbedded ? vSQL2Embedded : vSQL2Remote;
            vSQL.addAll(Arrays.asList(vSQL2));
            ++pCurrentPatchLevel;
        }
        if (vSQL.size() > 0) {
            this.applySQLPatch(vSQL.toArray(new String[0]));
            vSQL.clear();
        }
    }

    private void applySQLPatch(String[] pSQLs) {
        SQLBatch vBatch = new SQLBatch(true, "Aquatronica");
        try {
            for (int i = 0; i < pSQLs.length; ++i) {
                System.out.print("Applying patch statement " + (i + 1) + "... ");
                vBatch.addSQLStatement(new SQLStatement(pSQLs[i], null, false, "__UNKNOWN__", true));
                System.out.println("Done!");
            }
            System.out.println("Committing...");
            this.mDBLayer.submitTransaction(vBatch);
            System.out.println("Done!");
        }
        catch (DBLayerException e) {
            throw new RuntimeNestedException("Could not patch DB: " + e.getMessage(), (Throwable)e);
        }
    }

    private long getCountResult(Object pResult) {
        return pResult instanceof Integer ? ((Integer)pResult).longValue() : ((Long)pResult).longValue();
    }

    public void runDBUpgrade(StatusCallback pStatusCallback) throws IOException, DocumentException {
        if (Configuration.configExists()) {
            MutableConfiguration vConfiguration = new MutableConfiguration();
            int vDBPatchLevel = vConfiguration.getDBPatchLevel();
            if (vDBPatchLevel < vConfiguration.getApplicationPatchLevel()) {
                if (pStatusCallback != null) {
                    pStatusCallback.updateStatusText("DB Upgrade: Patching...", false);
                }
                System.out.println("Applying patches...");
                try {
                    DBHelper.getInstance().applyPatches(vDBPatchLevel, vConfiguration.getApplicationPatchLevel());
                    vConfiguration.setDBPatchLevel(vConfiguration.getApplicationPatchLevel());
                    vConfiguration.save();
                }
                catch (RuntimeException e) {
                    if (pStatusCallback != null) {
                        pStatusCallback.updateStatusText("DB Upgrade: Patching Failed.", true);
                    }
                    throw new DBPatchingFailedException(e.getMessage(), e);
                }
                catch (DocumentException e) {
                    if (pStatusCallback != null) {
                        pStatusCallback.updateStatusText("DB Upgrade: Patching Failed.", true);
                    }
                    throw new DBPatchingFailedException(e.getMessage(), e);
                }
                if (pStatusCallback != null) {
                    pStatusCallback.updateStatusText("DB Upgrade: Updated DB from patch level " + vDBPatchLevel + " to " + vConfiguration.getApplicationPatchLevel(), false);
                }
                System.out.println("Database updated to patch level " + vConfiguration.getApplicationPatchLevel());
            } else {
                System.out.println("Database is already at latest patch level!");
            }
        }
    }

    public long getDBSize() {
        long vDBSize = 0L;
        vDBSize = this.mEmbedded ? this.size(new File(".", "aquatronica")) : (!this.isStarted() ? 0L : (Long)this.mDBLayer.queryDatabaseScalar("select 8*1024*sum(relpages) from pg_class", null, "Aquatronica"));
        return vDBSize;
    }

    public long size(File file) {
        if (file.isFile()) {
            return file.length();
        }
        File[] files = file.listFiles();
        long size = 0L;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                size += this.size(files[i]);
            }
        }
        return size;
    }
}

