/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica.helpers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.za.pwnconsulting.javaconfig.exceptions.ExceptionHelper;
import net.za.pwnconsulting.javaconfig.net.HttpClient2;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import za.co.pwnconsulting.aquatronica.Main;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.helpers.DBHelper;
import za.co.pwnconsulting.aquatronica.helpers.GUIUtils;

public class BugManager {
    private BugManager() {
    }

    public static void handleFatalBug(Throwable pBug) {
        if (pBug instanceof ThreadDeath) {
            throw (ThreadDeath)pBug;
        }
        BugManager.reviewBug(pBug);
    }

    public static void handleError(Window pParent, Throwable pError) {
        if (pError instanceof ThreadDeath) {
            throw (ThreadDeath)pError;
        }
        BugManager.reviewError(pParent, pError);
    }

    public static void reviewError(Window pParent, final Throwable pError) {
        final JDialog vDialog = pParent instanceof JFrame ? new JDialog((JFrame)pParent) : new JDialog((JDialog)pParent);
        vDialog.setModal(true);
        vDialog.setTitle("Critical Error");
        vDialog.setResizable(true);
        vDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                vDialog.dispose();
            }
        });
        GUIUtils.setFrameDimensions(vDialog, 600, 300, false, true);
        JPanel vMainPanel = new JPanel();
        vMainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        vMainPanel.setLayout(new GridBagLayout());
        GridBagConstraints vC = new GridBagConstraints();
        vC.anchor = 18;
        vC.insets = new Insets(2, 2, 2, 2);
        vC.weightx = 1.0;
        vC.weighty = 1.0;
        vC.gridwidth = 1;
        vC.gridheight = 1;
        vC.fill = 2;
        JLabel vLabel = new JLabel("<html>AquaStats has encountered a critical, but non-fatal error. This might be caused by a bad user input or a software problem.  Please verify your input data and try again. If the problem persists, we urge you to please submit a bug report by clicking on the Report Bug button.<br><br>Thank You.</html>");
        URL vBugURL = Main.class.getResource("/images/error.jpg");
        if (vBugURL != null) {
            ImageIcon vImageIcon = new ImageIcon(vBugURL);
            vLabel.setIcon(vImageIcon);
            vLabel.setIconTextGap(10);
        }
        JPanel vLabelPanel = new JPanel();
        vLabelPanel.setLayout(new GridBagLayout());
        vLabelPanel.add((Component)vLabel, vC);
        vC.gridy = 1;
        vC.fill = 1;
        vLabelPanel.add(Box.createVerticalGlue(), vC);
        vC.gridy = 2;
        vC.fill = 2;
        JLabel vErrorMessage = new JLabel("<html>Cause: <font name='Courier New' color='#FF0000' size='2'>" + pError.getMessage() + "</font></html>");
        vLabelPanel.add((Component)vErrorMessage, vC);
        JPanel vButtonPanel = new JPanel();
        JButton vReviewButton = new JButton("Review");
        vReviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextArea vTextArea = new JTextArea(ExceptionHelper.getFullStackTrace((Throwable)pError));
                vTextArea.setFont(new Font("Courier New", 0, 10));
                vTextArea.setColumns(80);
                vTextArea.setEditable(false);
                vTextArea.selectAll();
                vTextArea.copy();
                vTextArea.setCaretPosition(0);
                JScrollPane vScroller = new JScrollPane(vTextArea);
                vScroller.setBorder(BorderFactory.createEtchedBorder());
                vScroller.setPreferredSize(new Dimension(750, 400));
                BugManager.showMessage(vDialog, vScroller);
            }
        });
        JButton vDiscardButton = new JButton("Discard");
        vDiscardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                vDialog.dispose();
            }
        });
        JButton vEmailButton = new JButton("Report Bug");
        vEmailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BugManager.sendError(vDialog, pError);
                    JOptionPane.showMessageDialog(vDialog, "Successfully submitted bug report", "Information", 1);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(vDialog, "Could not send the report: " + e1.getMessage(), "Error", 0);
                }
                vDialog.dispose();
            }
        });
        vButtonPanel.add(vReviewButton);
        vButtonPanel.add(vDiscardButton);
        vButtonPanel.add(vEmailButton);
        vC.gridy = 0;
        vC.fill = 1;
        vMainPanel.add((Component)vLabelPanel, vC);
        vC.gridy = 1;
        vC.weightx = 1.0;
        vC.anchor = 10;
        vC.fill = 0;
        vMainPanel.add((Component)vButtonPanel, vC);
        vDialog.getContentPane().add(vMainPanel);
        vDialog.pack();
        vDialog.setVisible(true);
    }

    private static void sendError(JDialog pParent, Throwable pError) throws IOException {
        String vFromEmail = JOptionPane.showInputDialog(pParent, "If you would like to receive a response to this report, please provide your email address.", "Info required", 1);
        HashMap<String, String> vFields = new HashMap<String, String>();
        vFields.put("Key", "Inf1nityAndBey0nd");
        vFields.put("Client", "AquaStats");
        vFields.put("Subject", "AquaStats Bug Report");
        vFields.put("Body", BugManager.buildErrorMail(pError, vFromEmail));
        String vRes = HttpClient2.submitPOSTRequest((String)"http://bugs.pwnconsulting.co.za/submit_bugreport.html", vFields);
        if (!vRes.equals("OK")) {
            throw new IOException("Failure code received from server: " + vRes);
        }
    }

    private static String buildErrorMail(Throwable pError, String pFromEmail) {
        StringBuffer vBody = new StringBuffer();
        vBody.append(ExceptionHelper.getFullStackTrace((Throwable)pError)).append("\n");
        vBody.append("AquaStats v1.2.5a").append("\n");
        vBody.append("Reply Address: ").append(Utils.makeProperString((String)pFromEmail)).append("\n");
        Properties vProperties = System.getProperties();
        Enumeration<?> vNames = vProperties.propertyNames();
        while (vNames.hasMoreElements()) {
            String vName = (String)vNames.nextElement();
            vBody.append(vName).append(" = ").append(vProperties.getProperty(vName)).append("\n");
        }
        vBody.append("Configuration File:").append("\n");
        try {
            vBody.append(new Configuration().getProperties());
        }
        catch (IOException e) {
            vBody.append("Could not append config.xml: ").append(e.getMessage());
        }
        return vBody.toString();
    }

    public static void reviewBug(final Throwable pBug) {
        final JDialog vDialog = new JDialog();
        vDialog.setModal(true);
        vDialog.setTitle("Fatal Error");
        vDialog.setResizable(true);
        vDialog.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent event) {
                try {
                    DBHelper.getInstance().shutdownDB();
                }
                finally {
                    System.exit(1);
                }
            }
        });
        GUIUtils.setFrameDimensions(vDialog, 650, 300, false, false);
        JPanel vMainPanel = new JPanel();
        vMainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        vMainPanel.setLayout(new GridBagLayout());
        GridBagConstraints vC = new GridBagConstraints();
        vC.anchor = 18;
        vC.insets = new Insets(2, 2, 2, 2);
        vC.weightx = 1.0;
        vC.weighty = 1.0;
        vC.gridwidth = 1;
        vC.gridheight = 1;
        vC.fill = 2;
        JLabel vLabel = new JLabel("<html>AquaStats has encountered a fatal internal error and will now exit. This is generally caused by a corrupted installation or a software problem.  <br><br>Please submit a bug report by clicing on the Report Bug button.<br><br>Thank You.</html>");
        URL vBugURL = Main.class.getResource("/images/bug.jpg");
        if (vBugURL != null) {
            ImageIcon vImageIcon = new ImageIcon(vBugURL);
            vLabel.setIcon(vImageIcon);
            vLabel.setIconTextGap(10);
        }
        JPanel vLabelPanel = new JPanel();
        vLabelPanel.setLayout(new GridBagLayout());
        vLabelPanel.add((Component)vLabel, vC);
        vC.gridy = 1;
        vC.fill = 1;
        vLabelPanel.add(Box.createVerticalGlue(), vC);
        vC.gridy = 2;
        vC.fill = 2;
        JLabel vErrorMessage = new JLabel("<html>Cause: <font name='Courier New' color='#FF0000' size='2'>" + pBug.getMessage() + "</font></html>");
        vLabelPanel.add((Component)vErrorMessage, vC);
        JPanel vButtonPanel = new JPanel();
        JButton vReviewButton = new JButton("Review");
        vReviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextArea vTextArea = new JTextArea(ExceptionHelper.getFullStackTrace((Throwable)pBug));
                vTextArea.setFont(new Font("Courier New", 0, 10));
                vTextArea.setColumns(80);
                vTextArea.setEditable(false);
                vTextArea.selectAll();
                vTextArea.copy();
                vTextArea.setCaretPosition(0);
                JScrollPane vScroller = new JScrollPane(vTextArea);
                vScroller.setBorder(BorderFactory.createEtchedBorder());
                vScroller.setPreferredSize(new Dimension(750, 400));
                BugManager.showMessage(vDialog, vScroller);
            }
        });
        JButton vDiscardButton = new JButton("Discard");
        vDiscardButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                vDialog.dispose();
                try {
                    DBHelper.getInstance().shutdownDB();
                }
                finally {
                    System.exit(1);
                }
            }
        });
        JButton vEmailButton = new JButton("Report Bug");
        vEmailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BugManager.sendError(vDialog, pBug);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(vDialog, "Could not send the report: " + e1.getMessage(), "Error", 0);
                    JOptionPane.showMessageDialog(vDialog, "Successfully submitted bug report", "Information", 1);
                }
                vDialog.dispose();
            }
        });
        vButtonPanel.add(vReviewButton);
        vButtonPanel.add(vDiscardButton);
        vButtonPanel.add(vEmailButton);
        vC.gridy = 0;
        vC.fill = 1;
        vMainPanel.add((Component)vLabelPanel, vC);
        vC.gridy = 1;
        vC.weightx = 1.0;
        vC.anchor = 10;
        vC.fill = 0;
        vMainPanel.add((Component)vButtonPanel, vC);
        vDialog.getContentPane().add(vMainPanel);
        vDialog.pack();
        Dimension vScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension vDialogSize = vDialog.getSize();
        vDialog.setLocation((vScreenSize.width - vDialogSize.width) / 2, (vScreenSize.height - vDialogSize.height) / 2);
        vDialog.setVisible(true);
    }

    private static void showMessage(Component pParent, Component pToDisplay) {
        JOptionPane.showMessageDialog(pParent, pToDisplay, "Stack Trace - Review", 0);
    }
}

