/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica.graphing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import net.za.pwnconsulting.javaconfig.exceptions.NoMatchFoundException;
import net.za.pwnconsulting.javaconfig.utils.DateUtils;
import net.za.pwnconsulting.javaconfig.utils.MutableBoolean;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.data.RangeType;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.UnitType;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.EventCodes;
import za.co.pwnconsulting.aquatronica.PlugData;
import za.co.pwnconsulting.aquatronica.PowerUnitPlug;
import za.co.pwnconsulting.aquatronica.SensorData;
import za.co.pwnconsulting.aquatronica.WaterParameter;
import za.co.pwnconsulting.aquatronica.WaterParameterData;
import za.co.pwnconsulting.aquatronica.config.Configuration;

public abstract class GraphingBase {
    protected Component mOwner;
    protected Configuration mConfiguration;

    public GraphingBase(Component pOwner, Configuration pConfiguration) {
        this.mOwner = pOwner;
        this.mConfiguration = pConfiguration;
    }

    protected XYItemRenderer createSensorRenderer(boolean pShowGaps) {
        StandardXYItemRenderer vRenderer = new StandardXYItemRenderer(2);
        vRenderer.setPlotDiscontinuous(pShowGaps);
        if (pShowGaps) {
            vRenderer.setGapThresholdType(UnitType.ABSOLUTE);
            vRenderer.setGapThreshold((double)((this.mConfiguration.getGraphIntervalThreshold() + 2) * 60 * 1000));
        }
        vRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("Time: {1}, Value: {2}", (DateFormat)new SimpleDateFormat("dd MMM yyyy HH:mm"), (NumberFormat)new DecimalFormat("0.0000")));
        return vRenderer;
    }

    protected XYItemRenderer createPowerUnitRenderer(TimeSeriesCollection pSeries) {
        XYStepAreaRenderer vRendererData = new XYStepAreaRenderer();
        if (pSeries.getSeriesCount() > 1) {
            vRendererData.setSeriesPaint(1, (Paint)Color.LIGHT_GRAY);
        }
        return vRendererData;
    }

    protected ValueAxis createDomainAxis(String pTitle) {
        PeriodAxis vDomainAxis = new PeriodAxis(pTitle);
        vDomainAxis.setAutoRange(true);
        vDomainAxis.setAutoRangeTimePeriodClass(Minute.class);
        vDomainAxis.setAutoRangeMinimumSize(60000.0);
        vDomainAxis.setMajorTickTimePeriodClass(Hour.class);
        vDomainAxis.setMinorTickTimePeriodClass(Minute.class);
        vDomainAxis.setMinorTickMarksVisible(false);
        PeriodAxisLabelInfo[] vInfo = new PeriodAxisLabelInfo[]{new PeriodAxisLabelInfo(Minute.class, (DateFormat)new SimpleDateFormat("HH:mm"), new RectangleInsets(2.0, 0.0, 2.0, 2.0), new Font("SansSerif", 0, 10), (Paint)Color.black, false, (Stroke)new BasicStroke(0.0f), (Paint)Color.lightGray), new PeriodAxisLabelInfo(Day.class, (DateFormat)new SimpleDateFormat("dd MMM yyyy"))};
        vDomainAxis.setLabelInfo(vInfo);
        return vDomainAxis;
    }

    protected ValueAxis createPlugBarRangeAxis(String pTitle) {
        NumberAxis vRangeAxis = new NumberAxis(pTitle);
        vRangeAxis.setAutoRange(false);
        vRangeAxis.setRange(0.0, 1.0);
        vRangeAxis.setRangeType(RangeType.POSITIVE);
        vRangeAxis.setTickUnit(new NumberTickUnit(1.0));
        return vRangeAxis;
    }

    protected ValueAxis createSensorRangeAxis(String pTitle) {
        NumberAxis vRangeAxis = new NumberAxis(pTitle);
        vRangeAxis.setAutoRange(true);
        vRangeAxis.setAutoRangeIncludesZero(false);
        return vRangeAxis;
    }

    protected void showChart(JFreeChart pChart, boolean pRangeAxisZoomable) {
        JFrame vWindow = new JFrame();
        ChartPanel vChartPanel = new ChartPanel(pChart, false);
        vChartPanel.setPreferredSize(new Dimension(this.mConfiguration.getGraphWidth(), this.mConfiguration.getGraphHeight()));
        vChartPanel.setMinimumDrawHeight(100);
        vChartPanel.setMinimumDrawWidth(160);
        vChartPanel.setMaximumDrawHeight(1600);
        vChartPanel.setMaximumDrawWidth(4480);
        vChartPanel.setMouseZoomable(true, false);
        vChartPanel.setRangeZoomable(pRangeAxisZoomable);
        vChartPanel.setDisplayToolTips(true);
        vChartPanel.setAutoscrolls(true);
        vChartPanel.setDoubleBuffered(true);
        vWindow.setContentPane((Container)vChartPanel);
        vWindow.pack();
        vWindow.setDefaultCloseOperation(2);
        vWindow.setLocationRelativeTo(this.mOwner);
        vWindow.setVisible(true);
    }

    protected TimeSeriesCollection createTimeSeries(PowerUnitPlug pSelectedPlug, Date pFrom, Date pTo) {
        Class<Minute> vTimeClass = Minute.class;
        TimeSeries vSeriesPlug = new TimeSeries("Plug: " + pSelectedPlug.getPowerUnitName() + " - " + pSelectedPlug.getPlugName(), vTimeClass);
        TimeSeries vSeriesLimbo = new TimeSeries("Missing Data", vTimeClass);
        List<PlugData> vPlugData = new AquatronicaInterface(this.mConfiguration).getPlugData(pSelectedPlug, pFrom, pTo);
        if (vPlugData.size() <= 0) {
            return null;
        }
        Calendar vLastTime = Calendar.getInstance();
        vLastTime.setTimeInMillis(0L);
        for (PlugData vData : vPlugData) {
            if (vLastTime.getTimeInMillis() > 0L && !vLastTime.getTime().before(vData.getTime()) && !vLastTime.getTime().equals(vData.getTime())) {
                throw new RuntimeException("Data points are out of temporal order");
            }
            if (vLastTime.getTimeInMillis() > 0L && DateUtils.getMinutesDifference((Date)vLastTime.getTime(), (Date)vData.getTime()) > (long)this.mConfiguration.getGraphIntervalThreshold()) {
                while (vLastTime.getTime().before(vData.getTime())) {
                    vSeriesLimbo.addOrUpdate((RegularTimePeriod)new Minute(vLastTime.getTime()), 0.5);
                    vSeriesPlug.addOrUpdate((RegularTimePeriod)new Minute(vLastTime.getTime()), 0.0);
                    vLastTime.add(12, this.mConfiguration.getGraphIntervalThreshold());
                }
            }
            double vStatus = vData.isOn() ? 1.0 : 0.0;
            vSeriesPlug.addOrUpdate((RegularTimePeriod)new Minute(vData.getTime()), vStatus);
            vSeriesLimbo.addOrUpdate((RegularTimePeriod)new Minute(vData.getTime()), 0.0);
            vLastTime.setTime(vData.getTime());
        }
        TimeSeriesCollection vSeries = new TimeSeriesCollection();
        vSeries.addSeries(vSeriesPlug);
        if (vSeriesLimbo.getItemCount() > 0) {
            vSeries.addSeries(vSeriesLimbo);
        }
        return vSeries;
    }

    protected TimeSeriesCollection createTimeSeries(String pSelectedSensor, Date pFrom, Date pTo, MutableBoolean pIsDiscrete) throws NoMatchFoundException {
        Class<Minute> vTimeClass = Minute.class;
        TimeSeries vSeriesSensor = new TimeSeries("Sensor: " + pSelectedSensor, vTimeClass);
        AquatronicaInterface vAquatronicaInterface = new AquatronicaInterface(this.mConfiguration);
        List<SensorData> vSensorData = vAquatronicaInterface.getSensorData(pSelectedSensor, pFrom, pTo);
        if (vSensorData.size() <= 0) {
            return null;
        }
        Calendar vLastTime = Calendar.getInstance();
        vLastTime.setTimeInMillis(0L);
        TimeSeries vSeriesLimbo = new TimeSeries("Missing Data", vTimeClass);
        pIsDiscrete.setBoolean(vAquatronicaInterface.getRawSensor(pSelectedSensor).isDiscrete());
        for (SensorData vData : vSensorData) {
            if (pIsDiscrete.getBoolean().booleanValue()) {
                if (vLastTime.getTimeInMillis() > 0L && !vLastTime.getTime().before(vData.getTime()) && !vLastTime.getTime().equals(vData.getTime())) {
                    throw new RuntimeException("Data points are out of temporal order");
                }
                if (vLastTime.getTimeInMillis() > 0L && DateUtils.getMinutesDifference((Date)vLastTime.getTime(), (Date)vData.getTime()) > (long)this.mConfiguration.getGraphIntervalThreshold()) {
                    while (vLastTime.getTime().before(vData.getTime())) {
                        vSeriesLimbo.addOrUpdate((RegularTimePeriod)new Minute(vLastTime.getTime()), 0.5);
                        vSeriesSensor.addOrUpdate((RegularTimePeriod)new Minute(vLastTime.getTime()), 0.0);
                        vLastTime.add(12, this.mConfiguration.getGraphIntervalThreshold());
                    }
                }
            }
            vSeriesSensor.addOrUpdate((RegularTimePeriod)new Minute(vData.getTime()), pIsDiscrete.getBoolean() != false ? (double)(EventCodes.isSensorInAlarm(vData.getStatusCode()) ? 1 : 0) : Double.parseDouble(vData.getValue()));
            if (!pIsDiscrete.getBoolean().booleanValue()) continue;
            vSeriesLimbo.addOrUpdate((RegularTimePeriod)new Minute(vData.getTime()), 0.0);
            vLastTime.setTime(vData.getTime());
        }
        TimeSeriesCollection vSeries = new TimeSeriesCollection();
        vSeries.addSeries(vSeriesSensor);
        if (pIsDiscrete.getBoolean().booleanValue() && vSeriesLimbo.getItemCount() > 0) {
            vSeries.addSeries(vSeriesLimbo);
        }
        return vSeries;
    }

    protected TimeSeriesCollection createTimeSeries(WaterParameterData pWaterParameterData, Date pFrom, Date pTo) {
        Class<Minute> vTimeClass = Minute.class;
        TimeSeries vSeriesSensor = new TimeSeries("Water Parameter: " + pWaterParameterData.getTank().toString() + " - " + pWaterParameterData.getWaterParameterType().toString(), vTimeClass);
        List<WaterParameter> vSensorData = new AquatronicaInterface(this.mConfiguration).getWaterParameterData(pWaterParameterData, pFrom, pTo);
        if (vSensorData.size() <= 0) {
            return null;
        }
        Calendar vLastTime = Calendar.getInstance();
        vLastTime.setTimeInMillis(0L);
        for (WaterParameter vData : vSensorData) {
            vSeriesSensor.addOrUpdate((RegularTimePeriod)new Minute(vData.getTime()), vData.getValue());
        }
        TimeSeriesCollection vSeries = new TimeSeriesCollection();
        vSeries.addSeries(vSeriesSensor);
        return vSeries;
    }

    protected void addMarkers(XYPlot pPlot, Date pStart, Date pEnd) {
        ValueMarker vValueMarker = new ValueMarker((double)new Minute(new Date()).getFirstMillisecond());
        vValueMarker.setPaint((Paint)Color.BLUE);
        vValueMarker.setLabel("Now");
        pPlot.addDomainMarker((Marker)vValueMarker);
        Calendar vStart = Calendar.getInstance();
        vStart.setTime(pStart);
        Calendar vEnd = Calendar.getInstance();
        vEnd.setTime(pEnd);
        while (vStart.before(vEnd)) {
            vStart.add(6, 1);
            vStart.set(11, 0);
            vStart.set(12, 0);
            vStart.set(13, 0);
            vStart.set(14, 0);
            if (!vStart.before(vEnd)) continue;
            vValueMarker = new ValueMarker((double)new Hour(vStart.getTime()).getFirstMillisecond());
            vValueMarker.setPaint((Paint)Color.GRAY);
            vValueMarker.setStroke((Stroke)new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{9.0f}, 0.0f));
            pPlot.addDomainMarker((Marker)vValueMarker);
        }
    }
}

