/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica.graphing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import net.za.pwnconsulting.javaconfig.exceptions.NoMatchFoundException;
import net.za.pwnconsulting.javaconfig.utils.MutableBoolean;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Minute;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.TextAnchor;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.PowerUnitPlug;
import za.co.pwnconsulting.aquatronica.TankLogEntry;
import za.co.pwnconsulting.aquatronica.WaterParameterData;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.graphing.GraphingBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphing
extends GraphingBase {
    public Graphing(Component pOwner, Configuration pConfiguration) {
        super(pOwner, pConfiguration);
    }

    public void graphSensorData(String pSelectedSensor, Date pFrom, Date pTo) throws NoMatchFoundException {
        MutableBoolean vIsDiscrete = new MutableBoolean();
        TimeSeriesCollection vSeries = this.createTimeSeries(pSelectedSensor, pFrom, pTo, vIsDiscrete);
        if (vSeries == null || vSeries.getSeries().size() <= 0) {
            JOptionPane.showMessageDialog(this.mOwner, "No data was found for " + pSelectedSensor);
            return;
        }
        JFreeChart vChart = ChartFactory.createTimeSeriesChart((String)pSelectedSensor, (String)"Date", (String)(vIsDiscrete.getBoolean() != false ? "Sensor State" : "Sensor Value"), (XYDataset)vSeries, (boolean)true, (boolean)true, (boolean)true);
        XYPlot vPlot = vChart.getXYPlot();
        vPlot.setRangeCrosshairVisible(true);
        vPlot.setDomainCrosshairVisible(true);
        if (vIsDiscrete.getBoolean().booleanValue()) {
            vPlot.setRangeAxis(this.createPlugBarRangeAxis(pSelectedSensor));
            vPlot.setRenderer(this.createPowerUnitRenderer(vSeries));
        } else {
            vPlot.setRenderer(this.createSensorRenderer(true));
            vPlot.setRangeAxis(this.createSensorRangeAxis(pSelectedSensor));
            this.addAnnotations(vPlot.getRenderer(), pFrom, pTo, pSelectedSensor, vSeries);
        }
        vPlot.setDomainAxis(this.createDomainAxis("Date"));
        this.addMarkers(vPlot, new Date((long)vSeries.getDomainLowerBound(true)), new Date((long)vSeries.getDomainUpperBound(true)));
        this.showChart(vChart, true);
    }

    private void addAnnotations(XYItemRenderer pRenderer, Date pFrom, Date pTo, String pSelectedSensor, TimeSeriesCollection pTimeSeries) {
        if (this.mConfiguration.isShowTankMaintenanceLogAnnotations()) {
            List<TankLogEntry> vLogEntries = new AquatronicaInterface(this.mConfiguration).getTankMaintenanceLogEntries(pFrom, pTo, pSelectedSensor);
            this.createAnnotations(vLogEntries, pTimeSeries, pRenderer);
        }
    }

    private void addAnnotations(XYItemRenderer pRenderer, Date pFrom, Date pTo, WaterParameterData pWaterParameterData, TimeSeriesCollection pTimeSeries) {
        if (this.mConfiguration.isShowTankMaintenanceLogAnnotations()) {
            List<TankLogEntry> vLogEntries = new AquatronicaInterface(this.mConfiguration).getTankMaintenanceLogEntries(pFrom, pTo, pWaterParameterData.getTank());
            this.createAnnotations(vLogEntries, pTimeSeries, pRenderer);
        }
    }

    private void createAnnotations(List<TankLogEntry> pLogEntries, TimeSeriesCollection pTimeSeries, XYItemRenderer pRenderer) {
        int i = 0;
        for (TankLogEntry vLogEntry : pLogEntries) {
            if (!vLogEntry.isPlot()) continue;
            double y = this.findClosestRange(pTimeSeries, new Minute(vLogEntry.getTime()));
            XYPointerAnnotation vAnnotation = new XYPointerAnnotation(vLogEntry.getSubject(), (double)new Minute(vLogEntry.getTime()).getFirstMillisecond(), y, i % 2 == 0 ? -2.356194490192345 : -0.7853981633974483);
            vAnnotation.setTextAnchor(i % 2 == 0 ? TextAnchor.BOTTOM_RIGHT : TextAnchor.BOTTOM_LEFT);
            vAnnotation.setPaint((Paint)Color.BLACK);
            vAnnotation.setArrowPaint((Paint)Color.BLACK);
            pRenderer.addAnnotation((XYAnnotation)vAnnotation);
            ++i;
        }
    }

    private double findClosestRange(TimeSeriesCollection pTimeSeries, Minute pTime) {
        double vDelta = Double.MAX_VALUE;
        TimeSeriesDataItem vLastValue = null;
        for (int i = 0; i < pTimeSeries.getSeries().size(); ++i) {
            TimeSeries vTimeSeries = (TimeSeries)pTimeSeries.getSeries().get(i);
            for (int j = 0; j < vTimeSeries.getItemCount(); ++j) {
                TimeSeriesDataItem vItem = (TimeSeriesDataItem)vTimeSeries.getItems().get(j);
                if (!((double)Math.abs(pTime.getFirstMillisecond() - vItem.getPeriod().getFirstMillisecond()) < vDelta)) continue;
                vDelta = Math.abs(pTime.getFirstMillisecond() - vItem.getPeriod().getFirstMillisecond());
                vLastValue = vItem;
            }
        }
        return vLastValue == null ? -1.0 : vLastValue.getValue().doubleValue();
    }

    public void graphData(List pSelectedEntities, Date pFrom, Date pTo) throws NoMatchFoundException {
        DateAxis vAxis = new DateAxis("Date");
        vAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("dd-MMM HH:mm"));
        CombinedDomainXYPlot vCombinedPlot = new CombinedDomainXYPlot((ValueAxis)vAxis);
        vCombinedPlot.setGap(10.0);
        Date vEarliest = new Date(Long.MAX_VALUE);
        Date vLatest = new Date(Long.MIN_VALUE);
        for (int i = 0; i < pSelectedEntities.size(); ++i) {
            XYItemRenderer vItemRenderer;
            ValueAxis vRangeAxis;
            TimeSeriesCollection vTimeDataset = new TimeSeriesCollection();
            Object vItem = pSelectedEntities.get(i);
            MutableBoolean vIsDiscrete = new MutableBoolean(false);
            TimeSeriesCollection vSeriesCollection = vItem instanceof WaterParameterData ? this.createTimeSeries((WaterParameterData)vItem, pFrom, pTo) : (vItem instanceof PowerUnitPlug ? this.createTimeSeries((PowerUnitPlug)vItem, pFrom, pTo) : this.createTimeSeries((String)vItem, pFrom, pTo, vIsDiscrete));
            if (vSeriesCollection == null || vSeriesCollection.getSeries().size() <= 0) {
                JOptionPane.showMessageDialog(this.mOwner, "No data was found for " + vItem);
                return;
            }
            if (new Date((long)vSeriesCollection.getDomainLowerBound(true)).before(vEarliest)) {
                vEarliest = new Date((long)vSeriesCollection.getDomainLowerBound(true));
            }
            if (new Date((long)vSeriesCollection.getDomainUpperBound(true)).after(vLatest)) {
                vLatest = new Date((long)vSeriesCollection.getDomainUpperBound(true));
            }
            for (Object vSeries : vSeriesCollection.getSeries()) {
                vTimeDataset.addSeries((TimeSeries)vSeries);
            }
            if (vItem instanceof PowerUnitPlug || vIsDiscrete.getBoolean().booleanValue()) {
                vRangeAxis = this.createPlugBarRangeAxis(vItem.toString());
                vItemRenderer = this.createPowerUnitRenderer(vTimeDataset);
            } else {
                vRangeAxis = this.createSensorRangeAxis(vItem.toString());
                if (vItem instanceof WaterParameterData) {
                    vItemRenderer = this.createSensorRenderer(false);
                    this.addAnnotations(vItemRenderer, pFrom, pTo, (WaterParameterData)vItem, vTimeDataset);
                } else {
                    vItemRenderer = this.createSensorRenderer(true);
                    this.addAnnotations(vItemRenderer, pFrom, pTo, (String)vItem, vTimeDataset);
                }
            }
            XYPlot vXYPlot = new XYPlot((XYDataset)vTimeDataset, (ValueAxis)vAxis, vRangeAxis, vItemRenderer);
            vXYPlot.setDomainAxis(this.createDomainAxis("Date"));
            vXYPlot.setRangeCrosshairVisible(true);
            vXYPlot.setDomainCrosshairVisible(true);
            this.addMarkers(vXYPlot, new Date((long)vSeriesCollection.getDomainLowerBound(true)), new Date((long)vSeriesCollection.getDomainUpperBound(true)));
            vCombinedPlot.add(vXYPlot);
        }
        JFreeChart vChart = new JFreeChart("Overlay Plot", JFreeChart.DEFAULT_TITLE_FONT, (Plot)vCombinedPlot, true);
        this.showChart(vChart, true);
    }

    public void graphPlugData(PowerUnitPlug pSelectedPlug, Date pFrom, Date pTo) {
        TimeSeriesCollection vSeries = this.createTimeSeries(pSelectedPlug, pFrom, pTo);
        if (vSeries == null || vSeries.getSeries().size() <= 0) {
            JOptionPane.showMessageDialog(this.mOwner, "No data was found for " + pSelectedPlug);
            return;
        }
        JFreeChart vChart = ChartFactory.createTimeSeriesChart((String)(pSelectedPlug.getPowerUnitName() + " - " + pSelectedPlug.getPlugName()), (String)"Date", (String)"Plug State", (XYDataset)vSeries, (boolean)true, (boolean)true, (boolean)true);
        XYPlot vPlot = vChart.getXYPlot();
        vPlot.setRangeCrosshairVisible(true);
        vPlot.setDomainCrosshairVisible(true);
        vPlot.setDomainAxis(this.createDomainAxis("Date"));
        this.addMarkers(vPlot, new Date((long)vSeries.getDomainLowerBound(true)), new Date((long)vSeries.getDomainUpperBound(true)));
        vPlot.setRangeAxis(this.createPlugBarRangeAxis(pSelectedPlug.getPlugName()));
        vPlot.setRenderer(this.createPowerUnitRenderer(vSeries));
        this.showChart(vChart, false);
    }

    public void graphWaterParameterData(WaterParameterData pWaterParameterData, Date pFrom, Date pTo) {
        MutableBoolean vIsDiscrete = new MutableBoolean(false);
        String vFullParamName = pWaterParameterData.toString();
        TimeSeriesCollection vSeries = this.createTimeSeries(pWaterParameterData, pFrom, pTo);
        if (vSeries == null || vSeries.getSeries().size() <= 0) {
            JOptionPane.showMessageDialog(this.mOwner, "No data was found for " + vFullParamName);
            return;
        }
        JFreeChart vChart = ChartFactory.createTimeSeriesChart((String)vFullParamName, (String)"Date", (String)(vIsDiscrete.getBoolean() != false ? "Water Parameter State" : "Water Parameter Value"), (XYDataset)vSeries, (boolean)true, (boolean)true, (boolean)true);
        XYPlot vPlot = vChart.getXYPlot();
        vPlot.setRangeCrosshairVisible(true);
        vPlot.setDomainCrosshairVisible(true);
        if (vIsDiscrete.getBoolean().booleanValue()) {
            vPlot.setRangeAxis(this.createPlugBarRangeAxis(vFullParamName));
            vPlot.setRenderer(this.createPowerUnitRenderer(vSeries));
        } else {
            vPlot.setRenderer(this.createSensorRenderer(false));
            vPlot.setRangeAxis(this.createSensorRangeAxis(vFullParamName));
            this.addAnnotations(vPlot.getRenderer(), pFrom, pTo, pWaterParameterData, vSeries);
        }
        vPlot.setDomainAxis(this.createDomainAxis("Date"));
        this.addMarkers(vPlot, new Date((long)vSeries.getDomainLowerBound(true)), new Date((long)vSeries.getDomainUpperBound(true)));
        this.showChart(vChart, true);
    }
}

