/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica.config;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.za.pwnconsulting.javaconfig.utils.encryption.RC4Encryption;
import za.co.pwnconsulting.aquatronica.config.Configuration;

public class MutableConfiguration
extends Configuration {
    public MutableConfiguration() throws IOException {
        super(new MutableWaterParameters());
    }

    public void setEmbedded(boolean pEmbedded) {
        this.mEmbedded = pEmbedded;
    }

    public void setIP(String pIP) {
        this.mIP = pIP;
    }

    public void setPort(int pPort) {
        this.mPort = pPort;
    }

    public void setInterval(int pInterval) {
        this.mInterval = pInterval;
    }

    public void setGraphIntervalThreshold(int pGraphIntervalThreshold) {
        this.mGraphIntervalThreshold = pGraphIntervalThreshold;
    }

    public void setGraphWidth(int pGraphWidth) {
        this.mGraphWidth = pGraphWidth;
    }

    public void setGraphHeight(int pGraphHeight) {
        this.mGraphHeight = pGraphHeight;
    }

    public void setXAxisResolution(String pXAxisResolution) {
        this.mXAxisResolution = pXAxisResolution;
    }

    public void setProperties(Properties pProperties) {
        this.mProperties = pProperties;
    }

    public void setDBPatchLevelEmbedded(int pDBPatchLevelEmbedded) {
        this.mDBPatchLevelEmbedded = pDBPatchLevelEmbedded;
    }

    public void setDBPatchLevelRemote(int pDBPatchLevelRemote) {
        this.mDBPatchLevelRemote = pDBPatchLevelRemote;
    }

    public void setKeepMainWindowIsOnTop(boolean pKeepMainWindowOnTop) {
        this.mKeepMainWindowOnTop = pKeepMainWindowOnTop;
    }

    public Properties getProperties() {
        return this.mProperties;
    }

    public void setPassword(String pPassword) {
        this.mPassword = pPassword;
    }

    public void setShowTankMaintenanceLogAnnotations(boolean pShowTankMaintenanceLogAnnotations) {
        this.mShowTankMaintenanceLogAnnotations = pShowTankMaintenanceLogAnnotations;
    }

    public void setPostgreSQLIP(String pPostgreSQLIP) {
        this.mPostgreSQLIP = pPostgreSQLIP;
    }

    public void setPostgreSQLPort(int pPostgreSQLPort) {
        this.mPostgreSQLPort = pPostgreSQLPort;
    }

    public void setPostgreSQLUser(String pPostgreSQLUser) {
        this.mPostgreSQLUser = pPostgreSQLUser;
    }

    public void setPostgreSQLPassword(String pPostgreSQLPassword) {
        this.mPostgreSQLPassword = pPostgreSQLPassword;
    }

    public void setPostgreSQLDBName(String pPostgreSQLDBName) {
        this.mPostgreSQLDBName = pPostgreSQLDBName;
    }

    public void setDiscreteInterval(int pDiscreteInterval) {
        this.mDiscreteInterval = pDiscreteInterval;
    }

    public void setSMTPIP(String pSMTPIP) {
        this.mSMTPIP = pSMTPIP;
    }

    public void setSMTPPort(int pSMTPPort) {
        this.mSMTPPort = pSMTPPort;
    }

    public void setMailFromAddress(String pMailFromAddress) {
        this.mMailFromAddress = pMailFromAddress;
    }

    public void setSMTPAuthEnabled(boolean pSMTPAuthEnabled) {
        this.mSMTPAuthEnabled = pSMTPAuthEnabled;
    }

    public void setSMTPAuthUsername(String pSMTPAuthUsername) {
        this.mSMTPAuthUsername = pSMTPAuthUsername;
    }

    public void setSMTPAuthPassword(String pSMTPAuthPassword) {
        this.mSMTPAuthPassword = pSMTPAuthPassword;
    }

    public void setRTMPollingEnabled(boolean pRTMPollingEnabled) {
        this.mRTMPollingEnabled = pRTMPollingEnabled;
    }

    public void setAutoSamplingEnabled(boolean pAutoSamplingEnabled) {
        this.mAutoSamplingEnabled = pAutoSamplingEnabled;
    }

    public void setMainFrameHeight(int pMainFrameHeight) {
        this.mMainFrameHeight = pMainFrameHeight;
    }

    public void setMainFramePosLeft(int pMainFramePosLeft) {
        this.mMainFramePosLeft = pMainFramePosLeft;
    }

    public void setMainFramePosTop(int pMainFramePosTop) {
        this.mMainFramePosTop = pMainFramePosTop;
    }

    public void setMainFrameWidth(int pMainFrameWidth) {
        this.mMainFrameWidth = pMainFrameWidth;
    }

    public void setMainFrameRememberPosAndSize(boolean pMainFrameRememberPosAndSize) {
        this.mMainFrameRememberPosAndSize = pMainFrameRememberPosAndSize;
    }

    public void setRTMPollingInterval(int pRTMPollingInterval) {
        this.mRTMPollingInterval = pRTMPollingInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        this.updateProperties();
        FileOutputStream vFileOutputStream = new FileOutputStream("config.xml");
        try {
            this.mProperties.storeToXML(vFileOutputStream, "");
        }
        finally {
            vFileOutputStream.close();
        }
    }

    private void updateProperties() {
        RC4Encryption vEncryption = new RC4Encryption();
        vEncryption.init("5345tfgdfsg%^$7722346gfg..,;@@43141dddfdfsdgghYT YR)_==");
        this.mProperties.setProperty("db_type", this.mEmbedded ? "E" : "N");
        this.mProperties.setProperty("aquaronica_ethernet_module_ip", this.mIP);
        this.mProperties.setProperty("aquaronica_ethernet_module_port", Integer.toString(this.mPort));
        this.mProperties.setProperty("aquaronica_ethernet_module_poll_interval", Integer.toString(this.mInterval));
        this.mProperties.setProperty("aquaronica_ethernet_module_discrete_poll_interval", Integer.toString(this.mDiscreteInterval));
        this.mProperties.setProperty("graph_interval_threshold", Integer.toString(this.mGraphIntervalThreshold));
        this.mProperties.setProperty("graph_width", Integer.toString(this.mGraphWidth));
        this.mProperties.setProperty("graph_height", Integer.toString(this.mGraphHeight));
        this.mProperties.setProperty("graph_xaxis_resolution", this.mXAxisResolution);
        this.mProperties.setProperty("db_patch_level_embedded", Integer.toString(this.mDBPatchLevelEmbedded));
        this.mProperties.setProperty("db_patch_level_remote", Integer.toString(this.mDBPatchLevelRemote));
        this.mProperties.setProperty("keep_main_window_on_top", Boolean.toString(this.mKeepMainWindowOnTop));
        this.mProperties.setProperty("password", vEncryption.encryptData(this.mPassword));
        this.mProperties.setProperty("show_tank_maintenance_log_annotations", Boolean.toString(this.mShowTankMaintenanceLogAnnotations));
        this.mProperties.setProperty("postgresql_ip", this.mPostgreSQLIP);
        this.mProperties.setProperty("postgresql_port", Integer.toString(this.mPostgreSQLPort));
        this.mProperties.setProperty("postgresql_user", this.mPostgreSQLUser);
        this.mProperties.setProperty("postgresql_password", vEncryption.encryptData(this.mPostgreSQLPassword));
        this.mProperties.setProperty("postgresql_dbname", this.mPostgreSQLDBName);
        this.mProperties.setProperty("aquaronica_smtp_ip", this.mSMTPIP);
        this.mProperties.setProperty("aquaronica_smtp_port", Integer.toString(this.mSMTPPort));
        this.mProperties.setProperty("aquaronica_smtp_mail_from", this.mMailFromAddress);
        this.mProperties.setProperty("aquaronica_smtp_auth_enabled", Boolean.toString(this.mSMTPAuthEnabled));
        this.mProperties.setProperty("aquaronica_smtp_auth_username", this.mSMTPAuthUsername);
        this.mProperties.setProperty("aquaronica_smtp_auth_password", vEncryption.encryptData(this.mSMTPAuthPassword));
        for (Configuration.WaterParameters.WaterParameterType vWaterParameterType : Configuration.WaterParameters.WaterParameterType.values()) {
            this.mProperties.setProperty("water_param_" + vWaterParameterType.toString(), Boolean.toString(this.mWaterParameters.isTypeEnabled(vWaterParameterType)));
        }
        this.mProperties.setProperty("rtm_polling_interval", Integer.toString(this.mRTMPollingInterval));
        this.mProperties.setProperty("rtm_polling_enabled", Boolean.toString(this.mRTMPollingEnabled));
        this.mProperties.setProperty("auto_sampling_enabled", Boolean.toString(this.mAutoSamplingEnabled));
        this.mProperties.setProperty("mainframe_pos_left", Integer.toString(this.mMainFramePosLeft));
        this.mProperties.setProperty("mainframe_pos_top", Integer.toString(this.mMainFramePosTop));
        this.mProperties.setProperty("mainframe_width", Integer.toString(this.mMainFrameWidth));
        this.mProperties.setProperty("mainframe_height", Integer.toString(this.mMainFrameHeight));
        this.mProperties.setProperty("mainframe_remember_pos_and_size", Boolean.toString(this.mMainFrameRememberPosAndSize));
    }

    public int getDBPatchLevel() {
        return this.isEmbedded() ? this.getDBPatchLevelEmbedded() : this.getDBPatchLevelRemote();
    }

    public void setDBPatchLevel(int pPatchLevel) {
        if (this.isEmbedded()) {
            this.setDBPatchLevelEmbedded(pPatchLevel);
        } else {
            this.setDBPatchLevelRemote(pPatchLevel);
        }
    }

    public int getApplicationPatchLevel() {
        return this.isEmbedded() ? 8 : 8;
    }

    public static class MutableWaterParameters
    extends Configuration.WaterParameters {
        public void setTypeEnabled(Configuration.WaterParameters.WaterParameterType pType, boolean pEnabled) {
            this.mParameters.put(pType, pEnabled);
        }
    }
}

