/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import net.za.pwnconsulting.javaconfig.utils.encryption.RC4Encryption;

public class Configuration {
    protected boolean mEmbedded;
    protected String mIP;
    protected int mPort;
    protected int mInterval;
    protected int mDiscreteInterval;
    protected int mGraphWidth;
    protected int mGraphHeight;
    protected int mGraphIntervalThreshold;
    protected boolean mShowTankMaintenanceLogAnnotations;
    protected String mXAxisResolution;
    protected int mDBPatchLevelEmbedded;
    protected int mDBPatchLevelRemote;
    protected boolean mKeepMainWindowOnTop;
    protected String mPassword;
    protected String mSMTPIP;
    protected int mSMTPPort;
    protected String mMailFromAddress;
    protected boolean mSMTPAuthEnabled;
    protected String mSMTPAuthUsername;
    protected String mSMTPAuthPassword;
    protected boolean mRTMPollingEnabled;
    protected int mRTMPollingInterval;
    protected boolean mAutoSamplingEnabled;
    protected WaterParameters mWaterParameters;
    protected String mPostgreSQLIP;
    protected int mPostgreSQLPort;
    protected String mPostgreSQLUser;
    protected String mPostgreSQLPassword;
    protected String mPostgreSQLDBName;
    protected int mMainFramePosLeft;
    protected int mMainFramePosTop;
    protected int mMainFrameWidth;
    protected int mMainFrameHeight;
    protected boolean mMainFrameRememberPosAndSize;
    protected Properties mProperties;

    public static boolean configExists() {
        return new File("config.xml").exists();
    }

    public Configuration() throws IOException {
        this(new WaterParameters());
    }

    protected Configuration(WaterParameters pWaterParameters) throws IOException {
        RC4Encryption vEncryption = new RC4Encryption();
        vEncryption.init("5345tfgdfsg%^$7722346gfg..,;@@43141dddfdfsdgghYT YR)_==");
        this.mWaterParameters = pWaterParameters;
        this.mProperties = new Properties();
        if (Configuration.configExists()) {
            this.mProperties.loadFromXML(new FileInputStream("config.xml"));
        }
        this.mEmbedded = this.mProperties.getProperty("db_type", "E").equals("E");
        this.mIP = this.mProperties.getProperty("aquaronica_ethernet_module_ip", "");
        this.mPort = Utils.getInt((String)this.mProperties.getProperty("aquaronica_ethernet_module_port", "80"));
        this.mInterval = Utils.getInt((String)this.mProperties.getProperty("aquaronica_ethernet_module_poll_interval", "5"));
        this.mDiscreteInterval = Utils.getInt((String)this.mProperties.getProperty("aquaronica_ethernet_module_discrete_poll_interval", "15"));
        this.mGraphIntervalThreshold = Utils.getInt((String)this.mProperties.getProperty("graph_interval_threshold", String.valueOf(this.mInterval)));
        this.mGraphWidth = Utils.getInt((String)this.mProperties.getProperty("graph_width", "800"));
        this.mGraphHeight = Utils.getInt((String)this.mProperties.getProperty("graph_height", "500"));
        this.mXAxisResolution = this.mProperties.getProperty("graph_xaxis_resolution", "Minute");
        this.mDBPatchLevelEmbedded = Utils.getInt((String)this.mProperties.getProperty("db_patch_level_embedded", "0"));
        this.mDBPatchLevelRemote = Utils.getInt((String)this.mProperties.getProperty("db_patch_level_remote", "0"));
        this.mKeepMainWindowOnTop = Utils.getBool((String)this.mProperties.getProperty("keep_main_window_on_top", "false"));
        this.mShowTankMaintenanceLogAnnotations = Utils.getBool((String)this.mProperties.getProperty("show_tank_maintenance_log_annotations", "true"));
        this.mPassword = vEncryption.decryptData(this.mProperties.getProperty("password", ""));
        this.mPostgreSQLIP = this.mProperties.getProperty("postgresql_ip", "");
        this.mPostgreSQLPort = Utils.getInt((String)this.mProperties.getProperty("postgresql_port", "5432"));
        this.mPostgreSQLDBName = this.mProperties.getProperty("postgresql_dbname", "aquatronica");
        this.mPostgreSQLUser = this.mProperties.getProperty("postgresql_user", "postgres");
        this.mPostgreSQLPassword = vEncryption.decryptData(this.mProperties.getProperty("postgresql_password", "C24A91157E60AE74"));
        this.mSMTPIP = this.mProperties.getProperty("aquaronica_smtp_ip", "");
        this.mSMTPPort = Utils.getInt((String)this.mProperties.getProperty("aquaronica_smtp_port", "25"));
        this.mMailFromAddress = this.mProperties.getProperty("aquaronica_smtp_mail_from", "");
        this.mSMTPAuthEnabled = Utils.getBool((String)this.mProperties.getProperty("aquaronica_smtp_auth_enabled", "false"));
        this.mSMTPAuthUsername = this.mProperties.getProperty("aquaronica_smtp_auth_username", "");
        this.mSMTPAuthPassword = vEncryption.decryptData(this.mProperties.getProperty("aquaronica_smtp_auth_password", ""));
        for (WaterParameters.WaterParameterType vWaterParameterType : WaterParameters.WaterParameterType.values()) {
            this.mWaterParameters.mParameters.put(vWaterParameterType, Utils.getBool((String)this.mProperties.getProperty("water_param_" + vWaterParameterType.toString(), "false")));
        }
        this.mRTMPollingInterval = Utils.getInt((String)this.mProperties.getProperty("rtm_polling_interval", "60"));
        this.mRTMPollingEnabled = Utils.getBool((String)this.mProperties.getProperty("rtm_polling_enabled", "false"));
        this.mAutoSamplingEnabled = Utils.getBool((String)this.mProperties.getProperty("auto_sampling_enabled", "false"));
        this.mMainFramePosLeft = Utils.getInt((String)this.mProperties.getProperty("mainframe_pos_left", "-1"));
        this.mMainFramePosTop = Utils.getInt((String)this.mProperties.getProperty("mainframe_pos_top", "-1"));
        this.mMainFrameWidth = Utils.getInt((String)this.mProperties.getProperty("mainframe_width", "-1"));
        this.mMainFrameHeight = Utils.getInt((String)this.mProperties.getProperty("mainframe_height", "-1"));
        this.mMainFrameRememberPosAndSize = Utils.getBool((String)this.mProperties.getProperty("mainframe_remember_pos_and_size", "true"));
    }

    public boolean isEmbedded() {
        return this.mEmbedded;
    }

    public String getIP() {
        return this.mIP;
    }

    public int getPort() {
        return this.mPort;
    }

    public int getInterval() {
        return this.mInterval;
    }

    public int getGraphIntervalThreshold() {
        return this.mGraphIntervalThreshold;
    }

    public int getGraphWidth() {
        return this.mGraphWidth;
    }

    public int getGraphHeight() {
        return this.mGraphHeight;
    }

    public String getXAxisResolution() {
        return this.mXAxisResolution;
    }

    public int getDBPatchLevelEmbedded() {
        return this.mDBPatchLevelEmbedded;
    }

    public int getDBPatchLevelRemote() {
        return this.mDBPatchLevelRemote;
    }

    public boolean isKeepMainWindowOnTop() {
        return this.mKeepMainWindowOnTop;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public boolean isShowTankMaintenanceLogAnnotations() {
        return this.mShowTankMaintenanceLogAnnotations;
    }

    public String getPostgreSQLIP() {
        return this.mPostgreSQLIP;
    }

    public int getPostgreSQLPort() {
        return this.mPostgreSQLPort;
    }

    public String getPostgreSQLUser() {
        return this.mPostgreSQLUser;
    }

    public String getPostgreSQLPassword() {
        return this.mPostgreSQLPassword;
    }

    public int getDiscreteInterval() {
        return this.mDiscreteInterval;
    }

    public WaterParameters getWaterParameters() {
        return this.mWaterParameters;
    }

    public boolean isOneOrMoreWaterParametersDefined() {
        return this.mWaterParameters.isOneOrMoreWaterParametersDefined();
    }

    public String getSMTPIP() {
        return this.mSMTPIP;
    }

    public int getSMTPPort() {
        return this.mSMTPPort;
    }

    public String getMailFromAddress() {
        return this.mMailFromAddress;
    }

    public boolean isSMTPAuthEnabled() {
        return this.mSMTPAuthEnabled;
    }

    public String getSMTPAuthUsername() {
        return this.mSMTPAuthUsername;
    }

    public String getSMTPAuthPassword() {
        return this.mSMTPAuthPassword;
    }

    public boolean isRTMPollingEnabled() {
        return this.mRTMPollingEnabled;
    }

    public boolean isAutoSamplingEnabled() {
        return this.mAutoSamplingEnabled;
    }

    public int getMainFramePosLeft() {
        return this.mMainFramePosLeft;
    }

    public int getMainFramePosTop() {
        return this.mMainFramePosTop;
    }

    public int getMainFrameWidth() {
        return this.mMainFrameWidth;
    }

    public int getMainFrameHeight() {
        return this.mMainFrameHeight;
    }

    public boolean isMainFrameRememberPosAndSize() {
        return this.mMainFrameRememberPosAndSize;
    }

    public int getRTMPollingInterval() {
        return this.mRTMPollingInterval;
    }

    public Properties getProperties() {
        return this.mProperties;
    }

    public void setProperties(Properties pProperties) {
        this.mProperties = pProperties;
    }

    public String getPostgreSQLDBName() {
        return this.mPostgreSQLDBName;
    }

    public String getAppTitle() {
        return "AquaStats v1.2.5a - " + (this.isEmbedded() ? "Embedded Derby: aquatronica" : "Remote PostgreSQL: " + this.getPostgreSQLDBName()) + ", Controller IP: " + (Utils.isEmptyString((String)this.getIP()) ? "<Not Configured>" : this.getIP());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WaterParameters {
        protected Map<WaterParameterType, Boolean> mParameters = new HashMap<WaterParameterType, Boolean>();

        public boolean isTypeEnabled(WaterParameterType pType) {
            if (!this.mParameters.containsKey((Object)pType)) {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)pType));
            }
            return this.mParameters.get((Object)pType);
        }

        public List<WaterParameterType> getWaterParameterTypesEnabled() {
            ArrayList<WaterParameterType> vEnabled = new ArrayList<WaterParameterType>();
            for (WaterParameterType vWaterParameterType : this.mParameters.keySet()) {
                if (!this.isTypeEnabled(vWaterParameterType)) continue;
                vEnabled.add(vWaterParameterType);
            }
            return vEnabled;
        }

        public boolean isOneOrMoreWaterParametersDefined() {
            for (Boolean vValue : this.mParameters.values()) {
                if (!vValue.booleanValue()) continue;
                return true;
            }
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum WaterParameterType {
            Temperature,
            pH,
            Salinity,
            Ammonia,
            Alkalinity,
            Calcium,
            Magnesium,
            Phosphate,
            Nitrite,
            Nitrate,
            Silica,
            Iodine,
            Strontium,
            ORP,
            Boron,
            Iron;

        }
    }
}

