/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.plaf.plastic.Plastic3DLookAndFeel;
import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.Tank;
import za.co.pwnconsulting.aquatronica.WaterParameter;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.helpers.BugManager;
import za.co.pwnconsulting.aquatronica.helpers.GUIUtils;

public class WaterParametersForm
extends JDialog {
    private Configuration mConfiguration;
    private Map<String, JTextField> mFields;
    private List<Configuration.WaterParameters.WaterParameterType> mTypes;
    private SimpleDateFormat mSimpleDateFormat;
    private JPanel mDialogPane;
    private JPanel mContentPanel;
    private JComponent mSeparator1;
    private JPanel mPanel1;
    private JLabel mLabel4;
    private JComboBox mComboBoxTank;
    private JLabel mLabel1;
    private JDateChooser mDateChooserTime;
    private JButton mButtonAdd;
    private JButton mButtonRemove;
    private JComponent mSeparator2;
    private JScrollPane mScrollPane1;
    private JTable mTableWaterParameters;
    private JPanel mButtonBar;
    private JButton mOkButton;

    public WaterParametersForm(Frame owner, Configuration pConfiguration) {
        super(owner);
        this.initComponents(pConfiguration);
        this.init(pConfiguration);
    }

    public WaterParametersForm(Dialog owner, Configuration pConfiguration) {
        super(owner);
        this.initComponents(pConfiguration);
        this.init(pConfiguration);
    }

    private void init(Configuration pConfiguration) {
        this.mSimpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm");
        this.mDateChooserTime.setDate(new Date());
        this.mTypes = pConfiguration.getWaterParameters().getWaterParameterTypesEnabled();
        Vector<String> vColumnNames = new Vector<String>();
        vColumnNames.add("-");
        vColumnNames.add("Time");
        vColumnNames.add("Tank");
        for (Configuration.WaterParameters.WaterParameterType vType : this.mTypes) {
            vColumnNames.add(vType.toString());
        }
        this.mTableWaterParameters.setModel(new DefaultTableModel(vColumnNames, 0));
        this.mTableWaterParameters.getColumn("-").setMaxWidth(0);
        this.mTableWaterParameters.getColumn("-").setMinWidth(0);
        this.mTableWaterParameters.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableWaterParameters.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableWaterParameters.getColumn("Time").setMaxWidth(130);
        this.mTableWaterParameters.getColumn("Time").setMinWidth(130);
        this.mTableWaterParameters.getTableHeader().getColumnModel().getColumn(1).setMaxWidth(130);
        this.mTableWaterParameters.getTableHeader().getColumnModel().getColumn(1).setMinWidth(130);
        this.mTableWaterParameters.getColumn("Tank").setPreferredWidth(100);
        this.mTableWaterParameters.getTableHeader().getColumnModel().getColumn(2).setPreferredWidth(100);
        this.mTableWaterParameters.getSelectionModel().setSelectionMode(0);
        DefaultTableModel vModel = (DefaultTableModel)this.mTableWaterParameters.getModel();
        Map<Date, List<WaterParameter>> vParams = new AquatronicaInterface(pConfiguration).getWaterParameters();
        for (Date vTime : vParams.keySet()) {
            List<WaterParameter> vValues = vParams.get(vTime);
            if (vValues.size() <= 0) continue;
            Object[] vTableValues = new Object[this.mTypes.size() + 3];
            vTableValues[0] = vValues;
            vTableValues[1] = this.mSimpleDateFormat.format(vTime);
            vTableValues[2] = vValues.get(0).getTank();
            for (WaterParameter vValue : vValues) {
                vTableValues[this.mTypes.indexOf((Object)((Object)Configuration.WaterParameters.WaterParameterType.valueOf((String)vValue.getName()))) + 3] = vValue.getValue();
            }
            vModel.addRow(vTableValues);
        }
        this.mFields = new HashMap<String, JTextField>();
        int c = 1;
        int r = 3;
        for (Configuration.WaterParameters.WaterParameterType vType : this.mTypes) {
            this.createField(vType.toString(), c, r);
            if ((c += 4) < 7) continue;
            c = 1;
            r += 2;
        }
        this.validate();
        this.repaint();
    }

    private void createField(String pName, int c, int r) {
        CellConstraints cc = new CellConstraints();
        JLabel vLabel = new JLabel(pName + ": ");
        vLabel.setHorizontalAlignment(4);
        JTextField vTextBox = new JTextField();
        this.mContentPanel.add((Component)vLabel, cc.xy(c, r));
        this.mContentPanel.add((Component)vTextBox, cc.xywh(c += 2, r, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mFields.put(pName, vTextBox);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void buttonAddActionPerformed(ActionEvent e) {
        try {
            DefaultTableModel vModel = (DefaultTableModel)this.mTableWaterParameters.getModel();
            for (int i = 0; i < vModel.getRowCount(); ++i) {
                WaterParameter vWaterParameter = (WaterParameter)((List)vModel.getValueAt(i, 0)).get(0);
                if (!vWaterParameter.getTime().equals(this.mDateChooserTime.getDate()) || vWaterParameter.getTank().getID() != ((Tank)this.mComboBoxTank.getSelectedItem()).getID()) continue;
                JOptionPane.showMessageDialog(this, "An entry with the same time and tank has already been added.  All parameters for the same time and tank must be specified simultaneously.", "Input Warning", 2);
                return;
            }
            ArrayList<WaterParameter> vParams = new ArrayList<WaterParameter>();
            for (String vParameterName : this.mFields.keySet()) {
                JTextField vField = this.mFields.get(vParameterName);
                if (!Utils.isEmptyString((String)vField.getText())) {
                    vParams.add(new WaterParameter(this.mDateChooserTime.getDate(), vParameterName, Double.parseDouble(vField.getText()), (Tank)this.mComboBoxTank.getSelectedItem()));
                }
                vField.setText("");
            }
            new AquatronicaInterface(this.mConfiguration).saveWaterParameters(vParams);
            Object[] vTableValues = new Object[this.mTypes.size() + 3];
            vTableValues[0] = vParams;
            vTableValues[1] = this.mSimpleDateFormat.format(this.mDateChooserTime.getDate());
            vTableValues[2] = ((WaterParameter)vParams.get(0)).getTank();
            for (WaterParameter vValue : vParams) {
                vTableValues[this.mTypes.indexOf((Object)((Object)Configuration.WaterParameters.WaterParameterType.valueOf((String)vValue.getName()))) + 3] = vValue.getValue();
            }
            int vIndex = 0;
            for (int i = 0; i < vModel.getRowCount(); ++i) {
                WaterParameter vWaterParameter = (WaterParameter)((List)vModel.getValueAt(i, 0)).get(0);
                if (!vWaterParameter.getTime().before(this.mDateChooserTime.getDate())) continue;
                vIndex = i;
                break;
            }
            vModel.insertRow(vIndex, vTableValues);
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonRemoveActionPerformed(ActionEvent e) {
        try {
            if (this.mTableWaterParameters.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(this, "First select an entry from the Water Parameter Log table below to delete");
            } else {
                DefaultTableModel vModel = (DefaultTableModel)this.mTableWaterParameters.getModel();
                new AquatronicaInterface(this.mConfiguration).deleteWaterParameters((List)vModel.getValueAt(this.mTableWaterParameters.getSelectedRow(), 0));
                vModel.removeRow(this.mTableWaterParameters.getSelectedRow());
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void initComponents(Configuration pConfiguration) {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mDialogPane = new JPanel();
        this.mContentPanel = new JPanel();
        this.mSeparator1 = compFactory.createSeparator("New Water Parameter Values");
        this.mPanel1 = new JPanel();
        this.mLabel4 = new JLabel();
        this.mComboBoxTank = new JComboBox<Object>(new AquatronicaInterface(pConfiguration).getTanks().toArray());
        this.mLabel1 = new JLabel();
        LookAndFeel vLAF = UIManager.getLookAndFeel();
        if (GUIUtils.isMacOSX()) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.mDateChooserTime = new JDateChooser();
        if (GUIUtils.isMacOSX()) {
            try {
                UIManager.setLookAndFeel(vLAF);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.mButtonAdd = new JButton();
        this.mButtonRemove = new JButton();
        this.mSeparator2 = compFactory.createSeparator("Previous Water Parameter Values");
        this.mScrollPane1 = new JScrollPane();
        this.mTableWaterParameters = new JTable();
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Manual Water Parameters");
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mContentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)20), 1.0), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)20), 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        ((FormLayout)this.mContentPanel.getLayout()).setColumnGroups((int[][])new int[][]{{1, 5}, {3, 7}});
        this.mContentPanel.add((Component)this.mSeparator1, cc.xywh(1, 1, 7, 1));
        this.mPanel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default, default")));
        this.mLabel4.setText("Tank:");
        this.mPanel1.add((Component)this.mLabel4, cc.xywh(1, 1, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mPanel1.add((Component)this.mComboBoxTank, cc.xywh(3, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mLabel1.setText("Date and Time:");
        this.mPanel1.add((Component)this.mLabel1, cc.xywh(1, 2, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mDateChooserTime.setDateFormatString("dd MMM yyyy HH:mm");
        this.mDateChooserTime.setPreferredSize(new Dimension(200, 23));
        this.mPanel1.add((Component)this.mDateChooserTime, cc.xy(3, 2));
        this.mButtonAdd.setText("Add");
        this.mButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WaterParametersForm.this.buttonAddActionPerformed(e);
            }
        });
        this.mPanel1.add((Component)this.mButtonAdd, cc.xywh(5, 2, 1, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.mButtonRemove.setText("Remove");
        this.mButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WaterParametersForm.this.buttonRemoveActionPerformed(e);
            }
        });
        this.mPanel1.add((Component)this.mButtonRemove, cc.xywh(7, 2, 1, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.mContentPanel.add((Component)this.mPanel1, cc.xywh(1, 21, 7, 1));
        this.mContentPanel.add((Component)this.mSeparator2, cc.xywh(1, 23, 7, 1));
        this.mTableWaterParameters.setShowHorizontalLines(false);
        this.mTableWaterParameters.setShowVerticalLines(false);
        this.mScrollPane1.setViewportView(this.mTableWaterParameters);
        this.mContentPanel.add((Component)this.mScrollPane1, cc.xywh(1, 25, 7, 1));
        this.mDialogPane.add((Component)this.mContentPanel, "Center");
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("OK");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WaterParametersForm.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(4, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(840, 530);
        this.setLocationRelativeTo(this.getOwner());
    }
}

