/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.Tank;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.helpers.BugManager;
import za.co.pwnconsulting.aquatronica.helpers.FixedLengthJTextField;

public class TankSetup
extends JDialog {
    private Configuration mConfiguration;
    private Tank mTankInEdit;
    private JPanel mDialogPane;
    private JPanel mContentPanel;
    private JComponent mSeparator1;
    private JLabel mLabel1;
    private FixedLengthJTextField mTextFieldTankName;
    private JButton mButtonDisassociate;
    private JLabel mLabel2;
    private JPanel mPanel2;
    private JComboBox mComboBoxSensors;
    private JButton mButtonAssociate;
    private JScrollPane mScrollPane2;
    private JList mListSensors;
    private JPanel mPanel1;
    private JButton mButtonAdd;
    private JButton mButtonEdit;
    private JButton mButtonDelete;
    private JComponent mSeparator2;
    private JScrollPane mScrollPane1;
    private JTable mTableTanks;
    private JPanel mButtonBar;
    private JButton mOkButton;

    public TankSetup(Frame owner, Configuration pConfiguration) {
        super(owner);
        this.initComponents(pConfiguration);
        this.mConfiguration = pConfiguration;
        this.mTableTanks.getColumn("-").setMaxWidth(0);
        this.mTableTanks.getColumn("-").setMinWidth(0);
        this.mTableTanks.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableTanks.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableTanks.getSelectionModel().setSelectionMode(0);
        this.mTankInEdit = null;
        DefaultTableModel vModel = (DefaultTableModel)this.mTableTanks.getModel();
        vModel.getDataVector().clear();
        List<Tank> vEntries = new AquatronicaInterface(this.mConfiguration).getTanks();
        for (Tank vEntry : vEntries) {
            vModel.addRow(new Object[]{vEntry, vEntry.getName(), vEntry.getAssociatedSensorsAsString()});
        }
        DefaultListModel vModelList = (DefaultListModel)this.mListSensors.getModel();
        vModelList.clear();
        this.mTableTanks.getSelectionModel().addListSelectionListener(new TableTanksSelectionListener(this.mTableTanks));
        this.getRootPane().setDefaultButton(this.mButtonAdd);
    }

    private void buttonAddActionPerformed(ActionEvent e) {
        try {
            if (Utils.isEmptyString((String)this.mTextFieldTankName.getText())) {
                JOptionPane.showMessageDialog(this, "The Tank Name field is mandatory");
            } else {
                DefaultTableModel vModel = (DefaultTableModel)this.mTableTanks.getModel();
                for (int i = 0; i < vModel.getRowCount(); ++i) {
                    if (!((Tank)vModel.getValueAt(i, 0)).getName().toUpperCase().equals(this.mTextFieldTankName.getText().toUpperCase())) continue;
                    JOptionPane.showMessageDialog(this, "<html>Tank names must be unique.  If you want to edit a tank, select it then click on \"Edit Tank\".");
                    return;
                }
                Tank vEntry = new Tank(this.mTextFieldTankName.getText());
                if (this.mTankInEdit != null) {
                    vEntry.setID(this.mTankInEdit.getID());
                }
                DefaultListModel vModelList = (DefaultListModel)this.mListSensors.getModel();
                for (int i = 0; i < vModelList.getSize(); ++i) {
                    vEntry.getAssociatedSensors().add((String)vModelList.getElementAt(i));
                }
                new AquatronicaInterface(this.mConfiguration).saveTank(vEntry);
                vModel.addRow(new Object[]{vEntry, vEntry.getName(), vEntry.getAssociatedSensorsAsString()});
                this.mTextFieldTankName.setText("");
                vModelList.clear();
                this.mTankInEdit = null;
                this.mButtonAdd.setText("Add New Tank");
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonDeleteActionPerformed(ActionEvent e) {
        try {
            if (this.mTableTanks.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(this, "First select an entry from the Tank table below to delete");
            } else {
                DefaultTableModel vModel = (DefaultTableModel)this.mTableTanks.getModel();
                new AquatronicaInterface(this.mConfiguration).deleteTank(((Tank)vModel.getValueAt(this.mTableTanks.getSelectedRow(), 0)).getID());
                vModel.removeRow(this.mTableTanks.getSelectedRow());
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void buttonAssociateActionPerformed(ActionEvent e) {
        DefaultListModel vListModel = (DefaultListModel)this.mListSensors.getModel();
        boolean vFound = false;
        for (int i = 0; i < vListModel.getSize(); ++i) {
            String vSensor = (String)vListModel.get(i);
            if (!this.mComboBoxSensors.getSelectedItem().equals(vSensor)) continue;
            JOptionPane.showMessageDialog(this, "Sensor [" + vSensor + "] is already in the list");
            vFound = true;
            break;
        }
        if (!vFound) {
            vListModel.addElement(this.mComboBoxSensors.getSelectedItem());
        }
    }

    private void buttonDisassociateActionPerformed(ActionEvent e) {
        if (this.mListSensors.getSelectedIndex() >= 0) {
            ((DefaultListModel)this.mListSensors.getModel()).removeElementAt(this.mListSensors.getSelectedIndex());
        }
    }

    private void buttonEditActionPerformed(ActionEvent e) {
        if (this.mTankInEdit != null) {
            JOptionPane.showMessageDialog(this, "You may not start editing another tank before saving the current one.");
        } else if (this.mTableTanks.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "You must first select a tank to modify");
        } else {
            DefaultTableModel vModel = (DefaultTableModel)this.mTableTanks.getModel();
            this.mTankInEdit = (Tank)vModel.getValueAt(this.mTableTanks.getSelectedRow(), 0);
            vModel.removeRow(this.mTableTanks.getSelectedRow());
            this.mTextFieldTankName.setText(this.mTankInEdit.getName());
            DefaultListModel vModelList = (DefaultListModel)this.mListSensors.getModel();
            vModelList.clear();
            for (String vSensorName : this.mTankInEdit.getAssociatedSensors()) {
                vModelList.addElement(vSensorName);
            }
            this.mButtonAdd.setText("Save Tank");
        }
    }

    private void initComponents(Configuration pConfiguration) {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mDialogPane = new JPanel();
        this.mContentPanel = new JPanel();
        this.mSeparator1 = compFactory.createSeparator("Define Your Tank");
        this.mLabel1 = new JLabel();
        this.mTextFieldTankName = new FixedLengthJTextField(40);
        this.mButtonDisassociate = new JButton();
        this.mLabel2 = new JLabel();
        this.mPanel2 = new JPanel();
        this.mComboBoxSensors = new JComboBox<Object>(new AquatronicaInterface(pConfiguration).getSensorNames(true).toArray());
        this.mButtonAssociate = new JButton();
        this.mScrollPane2 = new JScrollPane();
        this.mListSensors = new JList(new DefaultListModel());
        this.mPanel1 = new JPanel();
        this.mButtonAdd = new JButton();
        this.mButtonEdit = new JButton();
        this.mButtonDelete = new JButton();
        this.mSeparator2 = compFactory.createSeparator("Current Tanks");
        this.mScrollPane1 = new JScrollPane();
        this.mTableTanks = new JTable();
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Tanks");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mContentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)80), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;60dlu):grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}));
        this.mContentPanel.add((Component)this.mSeparator1, cc.xywh(1, 1, 5, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mLabel1.setText("Tank Name:");
        this.mLabel1.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel1, cc.xy(1, 3));
        this.mContentPanel.add((Component)this.mTextFieldTankName, cc.xy(3, 3));
        this.mButtonDisassociate.setText("Disassociate");
        this.mButtonDisassociate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TankSetup.this.buttonDisassociateActionPerformed(e);
            }
        });
        this.mContentPanel.add((Component)this.mButtonDisassociate, cc.xywh(5, 3, 1, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.mLabel2.setText("Associate a Sensor:");
        this.mLabel2.setLabelFor(this.mComboBoxSensors);
        this.mLabel2.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel2, cc.xy(1, 5));
        this.mPanel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.mPanel2.add((Component)this.mComboBoxSensors, cc.xy(1, 1));
        this.mButtonAssociate.setText("Associate");
        this.mButtonAssociate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TankSetup.this.buttonAssociateActionPerformed(e);
            }
        });
        this.mPanel2.add((Component)this.mButtonAssociate, cc.xywh(3, 1, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mContentPanel.add((Component)this.mPanel2, cc.xy(3, 5));
        this.mListSensors.setSelectionMode(0);
        this.mScrollPane2.setViewportView(this.mListSensors);
        this.mContentPanel.add((Component)this.mScrollPane2, cc.xy(5, 5));
        this.mPanel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.mButtonAdd.setText("Add New Tank");
        this.mButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TankSetup.this.buttonAddActionPerformed(e);
            }
        });
        this.mPanel1.add((Component)this.mButtonAdd, cc.xy(1, 1));
        this.mButtonEdit.setText("Edit Tank");
        this.mButtonEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TankSetup.this.buttonEditActionPerformed(e);
            }
        });
        this.mPanel1.add((Component)this.mButtonEdit, cc.xy(3, 1));
        this.mButtonDelete.setText("Delete Tank");
        this.mButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TankSetup.this.buttonDeleteActionPerformed(e);
            }
        });
        this.mPanel1.add((Component)this.mButtonDelete, cc.xy(5, 1));
        this.mContentPanel.add((Component)this.mPanel1, cc.xy(3, 7));
        this.mContentPanel.add((Component)this.mSeparator2, cc.xywh(1, 9, 5, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mTableTanks.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}}, new String[]{"-", "Tank Name", "Associated Sensors"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, String.class, String.class};
                this.columnEditable = new boolean[]{false, false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        TableColumnModel cm = this.mTableTanks.getColumnModel();
        cm.getColumn(1).setPreferredWidth(100);
        cm.getColumn(2).setPreferredWidth(200);
        this.mTableTanks.setPreferredScrollableViewportSize(new Dimension(450, 100));
        this.mTableTanks.setShowHorizontalLines(false);
        this.mTableTanks.setShowVerticalLines(false);
        this.mScrollPane1.setViewportView(this.mTableTanks);
        this.mContentPanel.add((Component)this.mScrollPane1, cc.xywh(1, 11, 5, 1));
        this.mDialogPane.add((Component)this.mContentPanel, "Center");
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("OK");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TankSetup.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(2, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(715, 450);
        this.setLocationRelativeTo(this.getOwner());
    }

    class TableTanksSelectionListener
    implements ListSelectionListener {
        private JTable mTable;

        public TableTanksSelectionListener(JTable pTable) {
            this.mTable = pTable;
        }

        public void valueChanged(ListSelectionEvent event) {
            try {
                if (TankSetup.this.mTankInEdit == null && this.mTable.getSelectedRow() >= 0) {
                    DefaultTableModel vModel = (DefaultTableModel)this.mTable.getModel();
                    Tank vTank = (Tank)vModel.getValueAt(this.mTable.getSelectedRow(), 0);
                    TankSetup.this.mTextFieldTankName.setText(vTank.getName());
                    DefaultListModel vModelList = (DefaultListModel)TankSetup.this.mListSensors.getModel();
                    vModelList.clear();
                    for (String vSensorName : vTank.getAssociatedSensors()) {
                        vModelList.addElement(vSensorName);
                    }
                }
            }
            catch (Throwable error) {
                BugManager.handleError((JDialog)SwingUtilities.getRoot((Component)event.getSource()), error);
            }
        }
    }
}

