/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.plaf.plastic.Plastic3DLookAndFeel;
import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.Tank;
import za.co.pwnconsulting.aquatronica.TankLogEntry;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.helpers.BugManager;
import za.co.pwnconsulting.aquatronica.helpers.FixedLengthJTextArea;
import za.co.pwnconsulting.aquatronica.helpers.FixedLengthJTextField;
import za.co.pwnconsulting.aquatronica.helpers.GUIUtils;

public class TankMaintenanceLog
extends JDialog {
    private Configuration mConfiguration;
    private SimpleDateFormat mSimpleDateFormat;
    private TankLogEntry mHistoryInEdit;
    private JPanel mDialogPane;
    private JPanel mContentPanel;
    private JComponent mSeparator1;
    private JLabel mLabel1;
    private FixedLengthJTextField mTextFieldSummary;
    private JLabel mLabel2;
    private JScrollPane mScrollPane1;
    private FixedLengthJTextArea mTextAreaDetails;
    private JLabel mLabel3;
    private JDateChooser mDateChooserDate;
    private JLabel mLabel4;
    private JComboBox mComboBoxTank;
    private JCheckBox mCheckBoxShowOnGraphs;
    private JPanel mPanel1;
    private JButton mButtonAdd;
    private JButton mButtonEdit;
    private JButton mButtonDelete;
    private JComponent mSeparator2;
    private JScrollPane mScrollPane2;
    private JTable mTableHistory;
    private JPanel mButtonBar;
    private JButton mOkButton;

    public TankMaintenanceLog(Frame owner, Configuration pConfiguration) {
        super(owner);
        this.initComponents(pConfiguration);
        this.mSimpleDateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm");
        this.mConfiguration = pConfiguration;
        this.mTableHistory.getColumn("-").setMaxWidth(0);
        this.mTableHistory.getColumn("-").setMinWidth(0);
        this.mTableHistory.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableHistory.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTableHistory.getSelectionModel().setSelectionMode(0);
        this.mHistoryInEdit = null;
        DefaultTableModel vModel = (DefaultTableModel)this.mTableHistory.getModel();
        vModel.getDataVector().clear();
        List<TankLogEntry> vEntries = new AquatronicaInterface(this.mConfiguration).getTankMaintenanceLogEntries();
        for (TankLogEntry vEntry : vEntries) {
            vModel.addRow(new Object[]{vEntry, vEntry.getSubject(), vEntry.getDescription(), this.mSimpleDateFormat.format(vEntry.getTime()), vEntry.getTank(), vEntry.isPlot()});
        }
        this.mTableHistory.getSelectionModel().addListSelectionListener(new HistoryTableSelectionListener(this.mTableHistory));
        this.getRootPane().setDefaultButton(this.mButtonAdd);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void buttonAddActionPerformed(ActionEvent e) {
        try {
            if (Utils.isEmptyString((String)this.mTextFieldSummary.getText())) {
                JOptionPane.showMessageDialog(this, "The Summary field is mandatory");
            } else if (this.mDateChooserDate.getDate() == null) {
                JOptionPane.showMessageDialog(this, "The Time field is mandatory");
            } else {
                TankLogEntry vLogEntry = new TankLogEntry(this.mTextFieldSummary.getText(), this.mTextAreaDetails.getText(), this.mDateChooserDate.getDate(), (Tank)this.mComboBoxTank.getSelectedItem(), this.mCheckBoxShowOnGraphs.isSelected());
                if (this.mHistoryInEdit != null) {
                    vLogEntry.setID(this.mHistoryInEdit.getID());
                }
                new AquatronicaInterface(this.mConfiguration).saveTankMaintenanceLog(vLogEntry);
                this.mHistoryInEdit = null;
                DefaultTableModel vModel = (DefaultTableModel)this.mTableHistory.getModel();
                vModel.insertRow(0, new Object[]{vLogEntry, vLogEntry.getSubject(), vLogEntry.getDescription(), this.mSimpleDateFormat.format(vLogEntry.getTime()), vLogEntry.getTank(), vLogEntry.isPlot()});
                this.mTextFieldSummary.setText("");
                this.mTextAreaDetails.setText("");
                this.mButtonAdd.setText("Add New Log");
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonDeleteActionPerformed(ActionEvent e) {
        try {
            if (this.mTableHistory.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(this, "First select an entry from the Tank Maintenance Log table below to delete");
            } else {
                DefaultTableModel vModel = (DefaultTableModel)this.mTableHistory.getModel();
                new AquatronicaInterface(this.mConfiguration).deleteTankMaintenanceLog(((TankLogEntry)vModel.getValueAt(this.mTableHistory.getSelectedRow(), 0)).getID());
                vModel.removeRow(this.mTableHistory.getSelectedRow());
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonEditActionPerformed(ActionEvent e) {
        if (this.mHistoryInEdit != null) {
            JOptionPane.showMessageDialog(this, "You may not start editing another log entry before saving the current one.");
        } else if (this.mTableHistory.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "You must first select a history log to modify");
        } else {
            DefaultTableModel vModel = (DefaultTableModel)this.mTableHistory.getModel();
            this.mHistoryInEdit = (TankLogEntry)vModel.getValueAt(this.mTableHistory.getSelectedRow(), 0);
            vModel.removeRow(this.mTableHistory.getSelectedRow());
            this.mTextFieldSummary.setText(this.mHistoryInEdit.getSubject());
            this.mTextAreaDetails.setText(this.mHistoryInEdit.getDescription());
            this.mDateChooserDate.setDate(this.mHistoryInEdit.getTime());
            this.mComboBoxTank.setSelectedItem(this.mHistoryInEdit.getTank());
            this.mCheckBoxShowOnGraphs.setSelected(this.mHistoryInEdit.isPlot());
            this.mButtonAdd.setText("Save Log");
        }
    }

    private void initComponents(Configuration pConfiguration) {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mDialogPane = new JPanel();
        this.mContentPanel = new JPanel();
        this.mSeparator1 = compFactory.createSeparator("Specify Tank Log Details");
        this.mLabel1 = new JLabel();
        this.mTextFieldSummary = new FixedLengthJTextField(40);
        this.mLabel2 = new JLabel();
        this.mScrollPane1 = new JScrollPane();
        this.mTextAreaDetails = new FixedLengthJTextArea(255);
        this.mLabel3 = new JLabel();
        LookAndFeel vLAF = UIManager.getLookAndFeel();
        if (GUIUtils.isMacOSX()) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.mDateChooserDate = new JDateChooser();
        if (GUIUtils.isMacOSX()) {
            try {
                UIManager.setLookAndFeel(vLAF);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.mLabel4 = new JLabel();
        this.mComboBoxTank = new JComboBox<Object>(new AquatronicaInterface(pConfiguration).getTanks().toArray());
        this.mCheckBoxShowOnGraphs = new JCheckBox();
        this.mPanel1 = new JPanel();
        this.mButtonAdd = new JButton();
        this.mButtonEdit = new JButton();
        this.mButtonDelete = new JButton();
        this.mSeparator2 = compFactory.createSeparator("Tank Log History");
        this.mScrollPane2 = new JScrollPane();
        this.mTableHistory = new JTable();
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Tank Log");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mContentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)80), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec("fill:max(min;40dlu):grow"), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 0.8)}));
        this.mContentPanel.add((Component)this.mSeparator1, cc.xywh(1, 1, 3, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mLabel1.setText("Summary:");
        this.mLabel1.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel1, cc.xy(1, 3));
        this.mContentPanel.add((Component)this.mTextFieldSummary, cc.xy(3, 3));
        this.mLabel2.setText("Details:");
        this.mLabel2.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel2, cc.xy(1, 5));
        this.mTextAreaDetails.setRows(5);
        this.mTextAreaDetails.setLineWrap(true);
        this.mTextAreaDetails.setWrapStyleWord(true);
        this.mScrollPane1.setViewportView(this.mTextAreaDetails);
        this.mContentPanel.add((Component)this.mScrollPane1, cc.xy(3, 5));
        this.mLabel3.setText("Exact Date and Time:");
        this.mLabel3.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel3, cc.xy(1, 7));
        this.mDateChooserDate.setDateFormatString("dd MMM yyyy HH:mm");
        this.mDateChooserDate.setPreferredSize(new Dimension(200, 23));
        this.mContentPanel.add((Component)this.mDateChooserDate, cc.xywh(3, 7, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mLabel4.setText("Tank:");
        this.mLabel4.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel4, cc.xy(1, 9));
        this.mContentPanel.add((Component)this.mComboBoxTank, cc.xywh(3, 9, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mCheckBoxShowOnGraphs.setText("Show on Graphs?");
        this.mCheckBoxShowOnGraphs.setSelected(true);
        this.mContentPanel.add((Component)this.mCheckBoxShowOnGraphs, cc.xywh(3, 11, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mPanel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.mButtonAdd.setText("Add New Log");
        this.mButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TankMaintenanceLog.this.buttonAddActionPerformed(e);
            }
        });
        this.mPanel1.add((Component)this.mButtonAdd, cc.xywh(1, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mButtonEdit.setText("Edit Log");
        this.mButtonEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TankMaintenanceLog.this.buttonEditActionPerformed(e);
            }
        });
        this.mPanel1.add((Component)this.mButtonEdit, cc.xy(3, 1));
        this.mButtonDelete.setText("Delete Log");
        this.mButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TankMaintenanceLog.this.buttonDeleteActionPerformed(e);
            }
        });
        this.mPanel1.add((Component)this.mButtonDelete, cc.xy(5, 1));
        this.mContentPanel.add((Component)this.mPanel1, cc.xy(3, 13));
        this.mContentPanel.add((Component)this.mSeparator2, cc.xywh(1, 15, 3, 1));
        this.mTableHistory.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, false}, {null, null, null, null, null, null}}, new String[]{"-", "Summary", "Description", "Time", "Tank", "Plot?"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, String.class, String.class, String.class, Object.class, Boolean.class};
                this.columnEditable = new boolean[]{false, false, false, false, false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        TableColumnModel cm = this.mTableHistory.getColumnModel();
        cm.getColumn(1).setPreferredWidth(150);
        cm.getColumn(2).setPreferredWidth(170);
        cm.getColumn(3).setPreferredWidth(120);
        cm.getColumn(4).setPreferredWidth(100);
        cm.getColumn(5).setMinWidth(35);
        cm.getColumn(5).setMaxWidth(35);
        cm.getColumn(5).setPreferredWidth(35);
        this.mTableHistory.setShowHorizontalLines(false);
        this.mTableHistory.setShowVerticalLines(false);
        this.mScrollPane2.setViewportView(this.mTableHistory);
        this.mContentPanel.add((Component)this.mScrollPane2, cc.xywh(1, 17, 3, 1));
        this.mDialogPane.add((Component)this.mContentPanel, "Center");
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("OK");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TankMaintenanceLog.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(4, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(660, 475);
        this.setLocationRelativeTo(this.getOwner());
    }

    class HistoryTableSelectionListener
    implements ListSelectionListener {
        private JTable mTable;

        public HistoryTableSelectionListener(JTable pTable) {
            this.mTable = pTable;
        }

        public void valueChanged(ListSelectionEvent event) {
            try {
                if (TankMaintenanceLog.this.mHistoryInEdit == null && this.mTable.getSelectedRow() >= 0) {
                    TankLogEntry vTLE = (TankLogEntry)((DefaultTableModel)this.mTable.getModel()).getValueAt(this.mTable.getSelectedRow(), 0);
                    TankMaintenanceLog.this.mTextFieldSummary.setText(vTLE.getSubject());
                    TankMaintenanceLog.this.mTextAreaDetails.setText(vTLE.getDescription());
                    TankMaintenanceLog.this.mDateChooserDate.setDate(vTLE.getTime());
                    TankMaintenanceLog.this.mComboBoxTank.setSelectedItem(vTLE.getTank());
                    TankMaintenanceLog.this.mCheckBoxShowOnGraphs.setSelected(vTLE.isPlot());
                }
            }
            catch (Throwable error) {
                BugManager.handleError((JDialog)SwingUtilities.getRoot((Component)event.getSource()), error);
            }
        }
    }
}

