/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.za.pwnconsulting.javaconfig.utils.StringUtils;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.config.Configuration;

public class SensorStatisticsForm
extends JDialog {
    private JPanel mDialogPane;
    private JPanel mContentPanel;
    private JComponent mSeparator1;
    private JLabel mLabel1;
    private JLabel mLabelSensorName;
    private JLabel mLabel2;
    private JLabel mLabelDateRange;
    private JComponent mSeparator2;
    private JLabel mLabel4;
    private JLabel mLabelMaximum;
    private JLabel mLabel5;
    private JLabel mLabelMinimum;
    private JComponent mSeparator3;
    private JLabel mLabel3;
    private JLabel mLabelMean;
    private JLabel mLabel8;
    private JLabel mLabelInterquartileMean;
    private JLabel mLabel7;
    private JLabel mLabelVariance;
    private JLabel mLabel6;
    private JLabel mLabelStandardDeviation;
    private JPanel mButtonBar;
    private JButton mOkButton;

    public SensorStatisticsForm(Frame owner, Configuration pConfiguration, String pSelectedSensor, Date pFrom, Date pTo) {
        super(owner);
        this.initComponents();
        this.init(pConfiguration, pSelectedSensor, pFrom, pTo);
    }

    public SensorStatisticsForm(Dialog owner, Configuration pConfiguration, String pSelectedSensor, Date pFrom, Date pTo) {
        super(owner);
        this.initComponents();
        this.init(pConfiguration, pSelectedSensor, pFrom, pTo);
    }

    private void init(Configuration pConfiguration, String pSelectedSensor, Date pFrom, Date pTo) {
        SimpleDateFormat vSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat vSDFDate = new SimpleDateFormat("yyyy-MM-dd");
        this.mLabelSensorName.setText(pSelectedSensor);
        this.mLabelDateRange.setText(vSDF.format(pFrom) + "  to  " + vSDF.format(pTo));
        AquatronicaInterface vAI = new AquatronicaInterface(pConfiguration);
        this.mLabelMean.setText(StringUtils.formatDecimal((Double)vAI.calculateMeanSensorValue(pSelectedSensor, pFrom, pTo), (String)"0.00###"));
        this.mLabelInterquartileMean.setText(StringUtils.formatDecimal((Double)vAI.calculateInterquartileMeanSensorValue(pSelectedSensor, pFrom, pTo), (String)"0.00###"));
        AquatronicaInterface.ResultOnDate vMaximum = vAI.calculateMaximumSensorValue(pSelectedSensor, pFrom, pTo);
        AquatronicaInterface.ResultOnDate vMinimum = vAI.calculateMinimumSensorValue(pSelectedSensor, pFrom, pTo);
        this.mLabelMaximum.setText(StringUtils.formatDecimal((Double)vMaximum.getValue(), (String)"0.00###") + " on " + vSDF.format(vMaximum.getDate()));
        this.mLabelMinimum.setText(StringUtils.formatDecimal((Double)vMinimum.getValue(), (String)"0.00###") + " on " + vSDF.format(vMinimum.getDate()));
        this.mLabelVariance.setText(StringUtils.formatDecimal((Double)vAI.calculateVarianceSensorValue(pSelectedSensor, pFrom, pTo), (String)"0.00###"));
        this.mLabelStandardDeviation.setText(StringUtils.formatDecimal((Double)vAI.calculateStandardDeviationSensorValue(pSelectedSensor, pFrom, pTo), (String)"0.00###"));
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mDialogPane = new JPanel();
        this.mContentPanel = new JPanel();
        this.mSeparator1 = compFactory.createSeparator("Basic Statistics");
        this.mLabel1 = new JLabel();
        this.mLabelSensorName = new JLabel();
        this.mLabel2 = new JLabel();
        this.mLabelDateRange = new JLabel();
        this.mSeparator2 = compFactory.createSeparator("Extremes");
        this.mLabel4 = new JLabel();
        this.mLabelMaximum = new JLabel();
        this.mLabel5 = new JLabel();
        this.mLabelMinimum = new JLabel();
        this.mSeparator3 = compFactory.createSeparator("Deviations");
        this.mLabel3 = new JLabel();
        this.mLabelMean = new JLabel();
        this.mLabel8 = new JLabel();
        this.mLabelInterquartileMean = new JLabel();
        this.mLabel7 = new JLabel();
        this.mLabelVariance = new JLabel();
        this.mLabel6 = new JLabel();
        this.mLabelStandardDeviation = new JLabel();
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Sensor Statistics");
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mContentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mContentPanel.add((Component)this.mSeparator1, cc.xywh(1, 1, 3, 1));
        this.mLabel1.setText("Sensor:");
        this.mLabel1.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanel.add((Component)this.mLabel1, cc.xy(1, 3));
        this.mLabelSensorName.setText("text");
        this.mContentPanel.add((Component)this.mLabelSensorName, cc.xy(3, 3));
        this.mLabel2.setText("Date Range:");
        this.mLabel2.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanel.add((Component)this.mLabel2, cc.xy(1, 5));
        this.mLabelDateRange.setText("text");
        this.mContentPanel.add((Component)this.mLabelDateRange, cc.xy(3, 5));
        this.mContentPanel.add((Component)this.mSeparator2, cc.xywh(1, 7, 3, 1));
        this.mLabel4.setText("Maximum:");
        this.mLabel4.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanel.add((Component)this.mLabel4, cc.xy(1, 9));
        this.mLabelMaximum.setText("text");
        this.mContentPanel.add((Component)this.mLabelMaximum, cc.xy(3, 9));
        this.mLabel5.setText("Minimum:");
        this.mLabel5.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanel.add((Component)this.mLabel5, cc.xy(1, 11));
        this.mLabelMinimum.setText("text");
        this.mContentPanel.add((Component)this.mLabelMinimum, cc.xy(3, 11));
        this.mContentPanel.add((Component)this.mSeparator3, cc.xywh(1, 13, 3, 1));
        this.mLabel3.setText("Mean:");
        this.mLabel3.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanel.add((Component)this.mLabel3, cc.xy(1, 15));
        this.mLabelMean.setText("text");
        this.mContentPanel.add((Component)this.mLabelMean, cc.xy(3, 15));
        this.mLabel8.setText("Interquartile Mean:");
        this.mLabel8.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanel.add((Component)this.mLabel8, cc.xy(1, 17));
        this.mLabelInterquartileMean.setText("text");
        this.mContentPanel.add((Component)this.mLabelInterquartileMean, cc.xy(3, 17));
        this.mLabel7.setText("Variance:");
        this.mLabel7.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanel.add((Component)this.mLabel7, cc.xy(1, 19));
        this.mLabelVariance.setText("text");
        this.mContentPanel.add((Component)this.mLabelVariance, cc.xy(3, 19));
        this.mLabel6.setText("Standard Deviation:");
        this.mLabel6.setFont(new Font("Helvetica", 1, 13));
        this.mContentPanel.add((Component)this.mLabel6, cc.xy(1, 21));
        this.mLabelStandardDeviation.setText("text");
        this.mContentPanel.add((Component)this.mLabelStandardDeviation, cc.xy(3, 21));
        this.mDialogPane.add((Component)this.mContentPanel, "Center");
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("OK");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SensorStatisticsForm.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(2, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(610, 390);
        this.setLocationRelativeTo(this.getOwner());
    }
}

