/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.panels.DateForGraph;

public class SelectSensorForm
extends JDialog {
    private String mSelectedSensorName = null;
    private Date mFrom;
    private Date mTo;
    private Configuration mConfiguration;
    private JPanel mDialogPane;
    private JPanel mContentPanel;
    private JLabel mLabel1;
    private JComboBox mComboBoxSensors;
    private JCheckBox mCheckBoxAllSensors;
    private DateForGraph mDateForGraph1;
    private JPanel mButtonBar;
    private JButton mOkButton;
    private JButton mCancelButton;

    public SelectSensorForm(Frame owner, Configuration pConfiguration) {
        super(owner);
        this.initComponents(pConfiguration);
        this.mConfiguration = pConfiguration;
        this.getRootPane().setDefaultButton(this.mOkButton);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.mSelectedSensorName = this.mComboBoxSensors.getSelectedItem().toString();
        this.mFrom = this.mDateForGraph1.getFromDate();
        this.mTo = this.mDateForGraph1.getToDate();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    public String getSelectedSensor() {
        return this.mSelectedSensorName;
    }

    public Date getFrom() {
        return this.mFrom;
    }

    public Date getTo() {
        return this.mTo;
    }

    private void checkBoxAllSensorsItemStateChanged(ItemEvent e) {
        this.mComboBoxSensors.removeAllItems();
        List<String> vEntries = new AquatronicaInterface(this.mConfiguration).getSensorNames(!this.mCheckBoxAllSensors.isSelected());
        for (String vEntry : vEntries) {
            this.mComboBoxSensors.addItem(vEntry);
        }
    }

    private void initComponents(Configuration pConfiguration) {
        this.mDialogPane = new JPanel();
        this.mContentPanel = new JPanel();
        this.mLabel1 = new JLabel();
        this.mComboBoxSensors = new JComboBox<Object>(new AquatronicaInterface(pConfiguration).getSensorNames(true).toArray());
        this.mCheckBoxAllSensors = new JCheckBox();
        this.mDateForGraph1 = new DateForGraph();
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        this.mCancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setResizable(false);
        this.setModal(true);
        this.setTitle("Select Sensor");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mContentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mLabel1.setText("Select the sensor:");
        this.mLabel1.setLabelFor(this.mComboBoxSensors);
        this.mLabel1.setFont(this.mLabel1.getFont().deriveFont(this.mLabel1.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel1, cc.xy(1, 1));
        this.mContentPanel.add((Component)this.mComboBoxSensors, cc.xy(3, 1));
        this.mCheckBoxAllSensors.setText("All?");
        this.mCheckBoxAllSensors.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SelectSensorForm.this.checkBoxAllSensorsItemStateChanged(e);
            }
        });
        this.mContentPanel.add((Component)this.mCheckBoxAllSensors, cc.xywh(5, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mContentPanel.add((Component)this.mDateForGraph1, cc.xywh(1, 3, 5, 1));
        this.mDialogPane.add((Component)this.mContentPanel, "Center");
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("OK");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectSensorForm.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(2, 1));
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectSensorForm.this.cancelButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mCancelButton, cc.xy(4, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(495, 385);
        this.setLocationRelativeTo(this.getOwner());
    }
}

