/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.config.MutableConfiguration;
import za.co.pwnconsulting.aquatronica.helpers.BugManager;

public class PreferencesForm
extends JDialog {
    private JPanel mDialogPane;
    private JPanel mButtonBar;
    private JButton mOkButton;
    private JButton mCancelButton;
    private JTabbedPane mTabbedPaneOptions;
    private JPanel mContentPanel;
    private JComponent mSeparator1;
    private JPanel mPanel1;
    private JLabel mLabel1;
    private JRadioButton mRadioButtonDBTypeEmbedded;
    private JRadioButton mRadioButtonDBTypeRemote;
    private JPanel mPanel7;
    private JLabel mLabelPostgreSQLIP;
    private JTextField mTextFieldPostgreSQLIP;
    private JLabel mLabelPostgreSQLUser;
    private JTextField mTextFieldPostgreSQLUser;
    private JLabel mLabelPostgreSQLPort;
    private JTextField mTextFieldPostgreSQLPort;
    private JLabel mLabelPostgreSQLPassword;
    private JPasswordField mPasswordFieldPostgreSQLPassword;
    private JLabel mLabelPostgreSQLDBName;
    private JTextField mTextFieldPostgreSQLDBName;
    private JComponent mSeparator2;
    private JPanel mPanel2;
    private JLabel mLabel2;
    private JTextField mTextFieldIP;
    private JLabel mLabel3;
    private JTextField mTextFieldPort;
    private JLabel mLabel4;
    private JSpinner mTextFieldPollInterval;
    private JLabel mLabel5;
    private JLabel mLabel13;
    private JSpinner mTextFieldDiscretePollInterface;
    private JLabel mLabel14;
    private JLabel mLabel6;
    private JPasswordField mPasswordFieldPassword;
    private JComponent mSeparator3;
    private JPanel mPanel3;
    private JLabel mLabel7;
    private JTextField mTextFieldGraphWidth;
    private JLabel mLabel9;
    private JLabel mLabel8;
    private JTextField mTextFieldGraphHeight;
    private JLabel mLabel10;
    private JLabel mLabel11;
    private JSpinner mTextFieldGraphThreshold;
    private JLabel mLabel12;
    private JCheckBox mCheckBoxTankMaintenanceLogAnnotations;
    private JComponent mSeparator4;
    private JPanel mPanel4;
    private JCheckBox mCheckBoxKeepMainWindowOnTop;
    private JCheckBox mCheckBoxRememberWindowPosition;
    private JCheckBox mCheckBoxAutoSampling;
    private JCheckBox mCheckBoxRTMEnabled;
    private JLabel mLabel17;
    private JSpinner mTextFieldRTMPollInterval;
    private JLabel mLabel16;
    private JPanel mContentPanel3;
    private JComponent mSeparator7;
    private JPanel mPanel8;
    private JLabel mLabelPostgreSQLIP3;
    private JTextField mTextFieldSMTPIP;
    private JLabel mLabelPostgreSQLPort3;
    private JTextField mTextFieldSMTPPort;
    private JLabel mLabelPostgreSQLPort4;
    private JTextField mTextFieldMailFrom;
    private JCheckBox mCheckBoxUseSMTPAuth;
    private JLabel mLabelSMTPAuthUserName;
    private JTextField mTextFieldSMTPAuthUsername;
    private JLabel mLabelSMTPAuthPwd;
    private JPasswordField mPasswordFieldSMTPAuthPassword;
    private JPanel mContentPanel2;
    private JComponent mSeparator5;
    private JPanel mPanel5;
    private JCheckBox mCheckBoxTemp;
    private JCheckBox mCheckBoxpH;
    private JCheckBox mCheckBoxSalinity;
    private JCheckBox mCheckBoxAmmonia;
    private JCheckBox mCheckBoxAlkalinity;
    private JCheckBox mCheckBoxCalcium;
    private JCheckBox mCheckBoxMagnesium;
    private JCheckBox mCheckBoxPhosphate;
    private JComponent mSeparator6;
    private JPanel mPanel6;
    private JCheckBox mCheckBoxNitrite;
    private JCheckBox mCheckBoxNitrate;
    private JCheckBox mCheckBoxSilica;
    private JCheckBox mCheckBoxIodine;
    private JCheckBox mCheckBoxStrontium;
    private JCheckBox mCheckBoxORP;
    private JCheckBox mCheckBoxBoron;
    private JCheckBox mCheckBoxIron;
    private JLabel mLabel15;

    public PreferencesForm(Frame owner) throws IOException {
        super(owner);
        this.initComponents();
        if (Configuration.configExists()) {
            Configuration vConfig = new Configuration();
            if (vConfig.isEmbedded()) {
                this.mRadioButtonDBTypeEmbedded.setSelected(true);
            } else {
                this.mRadioButtonDBTypeRemote.setSelected(true);
            }
            this.mTextFieldIP.setText(vConfig.getIP());
            this.mTextFieldPort.setText(Integer.toString(vConfig.getPort()));
            this.mTextFieldPollInterval.setValue(vConfig.getInterval());
            this.mTextFieldDiscretePollInterface.setValue(vConfig.getDiscreteInterval());
            this.mTextFieldGraphThreshold.setValue(vConfig.getGraphIntervalThreshold());
            this.mTextFieldGraphWidth.setText(Integer.toString(vConfig.getGraphWidth()));
            this.mTextFieldGraphHeight.setText(Integer.toString(vConfig.getGraphHeight()));
            this.mCheckBoxTankMaintenanceLogAnnotations.setSelected(vConfig.isShowTankMaintenanceLogAnnotations());
            this.mCheckBoxKeepMainWindowOnTop.setSelected(vConfig.isKeepMainWindowOnTop());
            this.mPasswordFieldPassword.setText(vConfig.getPassword());
            this.mTextFieldPostgreSQLIP.setText(vConfig.getPostgreSQLIP());
            this.mTextFieldPostgreSQLPort.setText(Integer.toString(vConfig.getPostgreSQLPort()));
            this.mTextFieldPostgreSQLUser.setText(vConfig.getPostgreSQLUser());
            this.mPasswordFieldPostgreSQLPassword.setText(vConfig.getPostgreSQLPassword());
            this.mTextFieldPostgreSQLDBName.setText(vConfig.getPostgreSQLDBName());
            this.togglePostgreSQLParams(vConfig.isEmbedded());
            this.mTextFieldSMTPIP.setText(vConfig.getSMTPIP());
            this.mTextFieldSMTPPort.setText(Integer.toString(vConfig.getSMTPPort()));
            this.mTextFieldMailFrom.setText(vConfig.getMailFromAddress());
            this.mCheckBoxTemp.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Temperature));
            this.mCheckBoxpH.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.pH));
            this.mCheckBoxSalinity.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Salinity));
            this.mCheckBoxAmmonia.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Ammonia));
            this.mCheckBoxAlkalinity.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Alkalinity));
            this.mCheckBoxCalcium.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Calcium));
            this.mCheckBoxMagnesium.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Magnesium));
            this.mCheckBoxPhosphate.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Phosphate));
            this.mCheckBoxNitrite.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Nitrite));
            this.mCheckBoxNitrate.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Nitrate));
            this.mCheckBoxSilica.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Silica));
            this.mCheckBoxIodine.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Iodine));
            this.mCheckBoxStrontium.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Strontium));
            this.mCheckBoxORP.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.ORP));
            this.mCheckBoxBoron.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Boron));
            this.mCheckBoxIron.setSelected(vConfig.getWaterParameters().isTypeEnabled(Configuration.WaterParameters.WaterParameterType.Iron));
            this.mCheckBoxUseSMTPAuth.setSelected(vConfig.isSMTPAuthEnabled());
            this.mTextFieldSMTPAuthUsername.setText(vConfig.getSMTPAuthUsername());
            this.mPasswordFieldSMTPAuthPassword.setText(vConfig.getSMTPAuthPassword());
            this.setSMTPAuthStatus(this.mCheckBoxUseSMTPAuth.isSelected());
            this.mTextFieldRTMPollInterval.setValue(vConfig.getRTMPollingInterval());
            this.mCheckBoxRTMEnabled.setSelected(vConfig.isRTMPollingEnabled());
            this.mCheckBoxAutoSampling.setSelected(vConfig.isAutoSamplingEnabled());
            this.mCheckBoxRememberWindowPosition.setSelected(vConfig.isMainFrameRememberPosAndSize());
            this.getRootPane().setDefaultButton(this.mOkButton);
        } else {
            this.togglePostgreSQLParams(this.mRadioButtonDBTypeEmbedded.isSelected());
        }
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent e) {
        try {
            if ((Integer)this.mTextFieldPollInterval.getValue() * 60 < (Integer)this.mTextFieldDiscretePollInterface.getValue()) {
                JOptionPane.showMessageDialog(this, "The Analogue interval (minutes) cannot be less than the Discrete interval (seconds)", "Input Invalid", 2);
            } else if ((Integer)this.mTextFieldPollInterval.getValue() * 60 % (Integer)this.mTextFieldDiscretePollInterface.getValue() != 0) {
                JOptionPane.showMessageDialog(this, "The Analogue interval (minutes) must be evenly divisable by the Discrete interval (seconds)", "Input Invalid", 2);
            } else if (!Utils.isValidInteger((String)this.mTextFieldPort.getText())) {
                JOptionPane.showMessageDialog(this, "The Ethernet Module Port field is not a valid numeric value", "Input Problem", 2);
                this.mTextFieldPort.grabFocus();
            } else if (!Utils.isValidInteger((String)this.mTextFieldGraphWidth.getText())) {
                JOptionPane.showMessageDialog(this, "The Graph Width field is not a valid numeric value", "Input Problem", 2);
                this.mTextFieldGraphWidth.grabFocus();
            } else if (!Utils.isValidInteger((String)this.mTextFieldGraphHeight.getText())) {
                JOptionPane.showMessageDialog(this, "The Graph Height field is not a valid numeric value", "Input Problem", 2);
                this.mTextFieldGraphHeight.grabFocus();
            } else if (this.mRadioButtonDBTypeRemote.isSelected() && !Utils.isValidInteger((String)this.mTextFieldPostgreSQLPort.getText())) {
                JOptionPane.showMessageDialog(this, "The PostgreSQL Port field is not a valid numeric value", "Input Problem", 2);
                this.mTextFieldPostgreSQLPort.grabFocus();
            } else if (!Utils.isEmptyString((String)this.mTextFieldSMTPPort.getText()) && !Utils.isValidInteger((String)this.mTextFieldSMTPPort.getText())) {
                JOptionPane.showMessageDialog(this, "The SMTP Port field is not a valid numeric value", "Input Problem", 2);
                this.mTextFieldSMTPPort.grabFocus();
            } else {
                int i;
                char[] vChars;
                MutableConfiguration vConfig = new MutableConfiguration();
                vConfig.setEmbedded(this.mRadioButtonDBTypeEmbedded.isSelected());
                vConfig.setIP(this.mTextFieldIP.getText());
                vConfig.setPort(Utils.getInt((String)this.mTextFieldPort.getText()));
                vConfig.setInterval((Integer)this.mTextFieldPollInterval.getValue());
                vConfig.setDiscreteInterval((Integer)this.mTextFieldDiscretePollInterface.getValue());
                vConfig.setGraphIntervalThreshold((Integer)this.mTextFieldGraphThreshold.getValue());
                vConfig.setGraphWidth(Utils.getInt((String)this.mTextFieldGraphWidth.getText()));
                vConfig.setGraphHeight(Utils.getInt((String)this.mTextFieldGraphHeight.getText()));
                vConfig.setKeepMainWindowIsOnTop(this.mCheckBoxKeepMainWindowOnTop.isSelected());
                vConfig.setShowTankMaintenanceLogAnnotations(this.mCheckBoxTankMaintenanceLogAnnotations.isSelected());
                if (this.mRadioButtonDBTypeRemote.isSelected()) {
                    vConfig.setPostgreSQLIP(this.mTextFieldPostgreSQLIP.getText());
                    vConfig.setPostgreSQLPort(Utils.getInt((String)this.mTextFieldPostgreSQLPort.getText()));
                    vConfig.setPostgreSQLUser(this.mTextFieldPostgreSQLUser.getText());
                    vConfig.setPostgreSQLDBName(this.mTextFieldPostgreSQLDBName.getText());
                    vChars = this.mPasswordFieldPostgreSQLPassword.getPassword();
                    vConfig.setPostgreSQLPassword(new String(vChars));
                    for (i = 0; i < vChars.length; ++i) {
                        vChars[i] = '\u0000';
                    }
                }
                vChars = this.mPasswordFieldPassword.getPassword();
                vConfig.setPassword(new String(vChars));
                for (i = 0; i < vChars.length; ++i) {
                    vChars[i] = '\u0000';
                }
                vConfig.setSMTPIP(this.mTextFieldSMTPIP.getText());
                if (!Utils.isEmptyString((String)this.mTextFieldSMTPPort.getText())) {
                    vConfig.setSMTPPort(Utils.getInt((String)this.mTextFieldSMTPPort.getText()));
                }
                vConfig.setMailFromAddress(this.mTextFieldMailFrom.getText());
                MutableConfiguration.MutableWaterParameters vWaterParameters = (MutableConfiguration.MutableWaterParameters)vConfig.getWaterParameters();
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Temperature, this.mCheckBoxTemp.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.pH, this.mCheckBoxpH.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Salinity, this.mCheckBoxSalinity.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Ammonia, this.mCheckBoxAmmonia.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Alkalinity, this.mCheckBoxAlkalinity.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Calcium, this.mCheckBoxCalcium.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Magnesium, this.mCheckBoxMagnesium.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Phosphate, this.mCheckBoxPhosphate.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Nitrite, this.mCheckBoxNitrite.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Nitrate, this.mCheckBoxNitrate.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Silica, this.mCheckBoxSilica.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Iodine, this.mCheckBoxIodine.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Strontium, this.mCheckBoxStrontium.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.ORP, this.mCheckBoxORP.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Boron, this.mCheckBoxBoron.isSelected());
                vWaterParameters.setTypeEnabled(Configuration.WaterParameters.WaterParameterType.Iron, this.mCheckBoxIron.isSelected());
                vConfig.setSMTPAuthEnabled(this.mCheckBoxUseSMTPAuth.isSelected());
                vConfig.setSMTPAuthUsername(this.mTextFieldSMTPAuthUsername.getText());
                vChars = this.mPasswordFieldSMTPAuthPassword.getPassword();
                vConfig.setSMTPAuthPassword(new String(vChars));
                for (int i2 = 0; i2 < vChars.length; ++i2) {
                    vChars[i2] = '\u0000';
                }
                vConfig.setRTMPollingInterval((Integer)this.mTextFieldRTMPollInterval.getValue());
                vConfig.setRTMPollingEnabled(this.mCheckBoxRTMEnabled.isSelected());
                vConfig.setAutoSamplingEnabled(this.mCheckBoxAutoSampling.isSelected());
                vConfig.setMainFrameRememberPosAndSize(this.mCheckBoxRememberWindowPosition.isSelected());
                vConfig.save();
                this.dispose();
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void radioButtonDBTypeEmbeddedItemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.togglePostgreSQLParams(true);
        }
    }

    private void radioButtonDBTypeRemoteItemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.togglePostgreSQLParams(false);
        }
    }

    private void togglePostgreSQLParams(boolean pEmbedded) {
        this.mTextFieldPostgreSQLIP.setEnabled(!pEmbedded);
        this.mTextFieldPostgreSQLPort.setEnabled(!pEmbedded);
        this.mTextFieldPostgreSQLUser.setEnabled(!pEmbedded);
        this.mPasswordFieldPostgreSQLPassword.setEnabled(!pEmbedded);
        this.mTextFieldPostgreSQLDBName.setEnabled(!pEmbedded);
        this.mLabelPostgreSQLIP.setEnabled(!pEmbedded);
        this.mLabelPostgreSQLPort.setEnabled(!pEmbedded);
        this.mLabelPostgreSQLUser.setEnabled(!pEmbedded);
        this.mLabelPostgreSQLPassword.setEnabled(!pEmbedded);
        this.mLabelPostgreSQLDBName.setEnabled(!pEmbedded);
    }

    private void checkBoxUseSMTPAuthItemStateChanged(ItemEvent e) {
        this.setSMTPAuthStatus(e.getStateChange() == 1);
    }

    private void setSMTPAuthStatus(boolean pSelected) {
        this.mLabelSMTPAuthUserName.setEnabled(pSelected);
        this.mLabelSMTPAuthPwd.setEnabled(pSelected);
        this.mTextFieldSMTPAuthUsername.setEnabled(pSelected);
        this.mPasswordFieldSMTPAuthPassword.setEnabled(pSelected);
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mDialogPane = new JPanel();
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        this.mCancelButton = new JButton();
        this.mTabbedPaneOptions = new JTabbedPane();
        this.mContentPanel = new JPanel();
        this.mSeparator1 = compFactory.createSeparator("Database Settings");
        this.mPanel1 = new JPanel();
        this.mLabel1 = new JLabel();
        this.mRadioButtonDBTypeEmbedded = new JRadioButton();
        this.mRadioButtonDBTypeRemote = new JRadioButton();
        this.mPanel7 = new JPanel();
        this.mLabelPostgreSQLIP = new JLabel();
        this.mTextFieldPostgreSQLIP = new JTextField();
        this.mLabelPostgreSQLUser = new JLabel();
        this.mTextFieldPostgreSQLUser = new JTextField();
        this.mLabelPostgreSQLPort = new JLabel();
        this.mTextFieldPostgreSQLPort = new JTextField();
        this.mLabelPostgreSQLPassword = new JLabel();
        this.mPasswordFieldPostgreSQLPassword = new JPasswordField();
        this.mLabelPostgreSQLDBName = new JLabel();
        this.mTextFieldPostgreSQLDBName = new JTextField();
        this.mSeparator2 = compFactory.createSeparator("Ethernet Module Settings");
        this.mPanel2 = new JPanel();
        this.mLabel2 = new JLabel();
        this.mTextFieldIP = new JTextField();
        this.mLabel3 = new JLabel();
        this.mTextFieldPort = new JTextField();
        this.mLabel4 = new JLabel();
        this.mTextFieldPollInterval = new JSpinner();
        this.mLabel5 = new JLabel();
        this.mLabel13 = new JLabel();
        this.mTextFieldDiscretePollInterface = new JSpinner();
        this.mLabel14 = new JLabel();
        this.mLabel6 = new JLabel();
        this.mPasswordFieldPassword = new JPasswordField();
        this.mSeparator3 = compFactory.createSeparator("Graph Preferences");
        this.mPanel3 = new JPanel();
        this.mLabel7 = new JLabel();
        this.mTextFieldGraphWidth = new JTextField();
        this.mLabel9 = new JLabel();
        this.mLabel8 = new JLabel();
        this.mTextFieldGraphHeight = new JTextField();
        this.mLabel10 = new JLabel();
        this.mLabel11 = new JLabel();
        this.mTextFieldGraphThreshold = new JSpinner();
        this.mLabel12 = new JLabel();
        this.mCheckBoxTankMaintenanceLogAnnotations = new JCheckBox();
        this.mSeparator4 = compFactory.createSeparator("Window/State Preferences");
        this.mPanel4 = new JPanel();
        this.mCheckBoxKeepMainWindowOnTop = new JCheckBox();
        this.mCheckBoxRememberWindowPosition = new JCheckBox();
        this.mCheckBoxAutoSampling = new JCheckBox();
        this.mCheckBoxRTMEnabled = new JCheckBox();
        this.mLabel17 = new JLabel();
        this.mTextFieldRTMPollInterval = new JSpinner();
        this.mLabel16 = new JLabel();
        this.mContentPanel3 = new JPanel();
        this.mSeparator7 = compFactory.createSeparator("Email Settings");
        this.mPanel8 = new JPanel();
        this.mLabelPostgreSQLIP3 = new JLabel();
        this.mTextFieldSMTPIP = new JTextField();
        this.mLabelPostgreSQLPort3 = new JLabel();
        this.mTextFieldSMTPPort = new JTextField();
        this.mLabelPostgreSQLPort4 = new JLabel();
        this.mTextFieldMailFrom = new JTextField();
        this.mCheckBoxUseSMTPAuth = new JCheckBox();
        this.mLabelSMTPAuthUserName = new JLabel();
        this.mTextFieldSMTPAuthUsername = new JTextField();
        this.mLabelSMTPAuthPwd = new JLabel();
        this.mPasswordFieldSMTPAuthPassword = new JPasswordField();
        this.mContentPanel2 = new JPanel();
        this.mSeparator5 = compFactory.createSeparator("Critical Water Parameters To Monitor Manually");
        this.mPanel5 = new JPanel();
        this.mCheckBoxTemp = new JCheckBox();
        this.mCheckBoxpH = new JCheckBox();
        this.mCheckBoxSalinity = new JCheckBox();
        this.mCheckBoxAmmonia = new JCheckBox();
        this.mCheckBoxAlkalinity = new JCheckBox();
        this.mCheckBoxCalcium = new JCheckBox();
        this.mCheckBoxMagnesium = new JCheckBox();
        this.mCheckBoxPhosphate = new JCheckBox();
        this.mSeparator6 = compFactory.createSeparator("Other Water Parameters To Monitor Manually");
        this.mPanel6 = new JPanel();
        this.mCheckBoxNitrite = new JCheckBox();
        this.mCheckBoxNitrate = new JCheckBox();
        this.mCheckBoxSilica = new JCheckBox();
        this.mCheckBoxIodine = new JCheckBox();
        this.mCheckBoxStrontium = new JCheckBox();
        this.mCheckBoxORP = new JCheckBox();
        this.mCheckBoxBoron = new JCheckBox();
        this.mCheckBoxIron = new JCheckBox();
        this.mLabel15 = new JLabel();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Preferences");
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("OK");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesForm.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(2, 1));
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesForm.this.cancelButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mCancelButton, cc.xy(4, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        this.mContentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.7), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}));
        this.mContentPanel.add((Component)this.mSeparator1, cc.xy(1, 1));
        this.mPanel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)110), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{new RowSpec("max(min;15dlu)"), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}));
        this.mLabel1.setText("Database Type:");
        this.mLabel1.setFont(new Font("Helvetica", 1, 11));
        this.mPanel1.add((Component)this.mLabel1, cc.xy(1, 1));
        this.mRadioButtonDBTypeEmbedded.setText("Embedded Derby DB");
        this.mRadioButtonDBTypeEmbedded.setSelected(true);
        this.mRadioButtonDBTypeEmbedded.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PreferencesForm.this.radioButtonDBTypeEmbeddedItemStateChanged(e);
            }
        });
        this.mPanel1.add((Component)this.mRadioButtonDBTypeEmbedded, cc.xy(3, 1));
        this.mRadioButtonDBTypeRemote.setText("External PostgreSQL DB");
        this.mRadioButtonDBTypeRemote.setSelectedIcon(null);
        this.mRadioButtonDBTypeRemote.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PreferencesForm.this.radioButtonDBTypeRemoteItemStateChanged(e);
            }
        });
        this.mPanel1.add((Component)this.mRadioButtonDBTypeRemote, cc.xy(5, 1));
        this.mPanel7.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 0.5), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        ((FormLayout)this.mPanel7.getLayout()).setColumnGroups((int[][])new int[][]{{1, 5}, {3, 7}});
        this.mLabelPostgreSQLIP.setText("PostgreSQL IP:");
        this.mLabelPostgreSQLIP.setFont(new Font("Helvetica", 1, 11));
        this.mPanel7.add((Component)this.mLabelPostgreSQLIP, cc.xy(1, 1));
        this.mTextFieldPostgreSQLIP.setPreferredSize(new Dimension(150, 25));
        this.mPanel7.add((Component)this.mTextFieldPostgreSQLIP, cc.xy(3, 1));
        this.mLabelPostgreSQLUser.setText("PostgreSQL User:");
        this.mLabelPostgreSQLUser.setFont(new Font("Helvetica", 1, 11));
        this.mPanel7.add((Component)this.mLabelPostgreSQLUser, cc.xy(5, 1));
        this.mPanel7.add((Component)this.mTextFieldPostgreSQLUser, cc.xy(7, 1));
        this.mLabelPostgreSQLPort.setText("PostgreSQL Port:");
        this.mLabelPostgreSQLPort.setFont(new Font("Helvetica", 1, 11));
        this.mPanel7.add((Component)this.mLabelPostgreSQLPort, cc.xy(1, 3));
        this.mPanel7.add((Component)this.mTextFieldPostgreSQLPort, cc.xy(3, 3));
        this.mLabelPostgreSQLPassword.setText("PostgreSQL Password:");
        this.mLabelPostgreSQLPassword.setFont(new Font("Helvetica", 1, 11));
        this.mPanel7.add((Component)this.mLabelPostgreSQLPassword, cc.xy(5, 3));
        this.mPanel7.add((Component)this.mPasswordFieldPostgreSQLPassword, cc.xy(7, 3));
        this.mLabelPostgreSQLDBName.setText("PostgreSQL DB Name:");
        this.mLabelPostgreSQLDBName.setFont(new Font("Helvetica", 1, 11));
        this.mPanel7.add((Component)this.mLabelPostgreSQLDBName, cc.xy(1, 5));
        this.mPanel7.add((Component)this.mTextFieldPostgreSQLDBName, cc.xy(3, 5));
        this.mPanel1.add((Component)this.mPanel7, cc.xywh(1, 3, 5, 1));
        this.mContentPanel.add((Component)this.mPanel1, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(5, 10, 5, 10)));
        this.mContentPanel.add((Component)this.mSeparator2, cc.xy(1, 5));
        this.mPanel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)120), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)100)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mLabel2.setText("IP Address:");
        this.mLabel2.setFont(new Font("Helvetica", 1, 11));
        this.mPanel2.add((Component)this.mLabel2, cc.xy(1, 1));
        this.mPanel2.add((Component)this.mTextFieldIP, cc.xy(3, 1));
        this.mLabel3.setText("Port:");
        this.mLabel3.setFont(new Font("Helvetica", 1, 11));
        this.mPanel2.add((Component)this.mLabel3, cc.xy(1, 3));
        this.mPanel2.add((Component)this.mTextFieldPort, cc.xy(3, 3));
        this.mLabel4.setText("Analogue Sensor Poll Interval:");
        this.mLabel4.setFont(new Font("Helvetica", 1, 11));
        this.mPanel2.add((Component)this.mLabel4, cc.xy(1, 5));
        this.mTextFieldPollInterval.setModel(new SpinnerNumberModel((Number)15, Integer.valueOf(1), null, (Number)1));
        this.mTextFieldPollInterval.setToolTipText("<html>The time interval (in minutes) to poll the Ethernet module<br> \nfor a status update, for analogue sensors only.  Analogue<br> \nsensors are sensors that have continuous values, and not<br>\na specific set of states, like Temperature, pH etc.");
        this.mPanel2.add((Component)this.mTextFieldPollInterval, cc.xy(3, 5));
        this.mLabel5.setText("minutes");
        this.mLabel5.setFont(new Font("Helvetica", 2, 11));
        this.mPanel2.add((Component)this.mLabel5, cc.xy(5, 5));
        this.mLabel13.setText("Discrete Sensor Poll Interval:");
        this.mLabel13.setFont(new Font("Helvetica", 1, 11));
        this.mPanel2.add((Component)this.mLabel13, cc.xy(1, 7));
        this.mTextFieldDiscretePollInterface.setToolTipText("<html>The time interval (in seconds) to poll the Ethernet module<br> \nfor a status update, for discrete sensors only.  Discrete<br> \nsensors are sensors that have a specific set of values, and not<br>\na continues, like Water Leak, Level etc.<br>\n<br>\nIt is customary to keep this interval very short so that a state<br>\nchange can quickly be detected, and any duty cycle calculations<br>\nto be more accurate.  ");
        this.mTextFieldDiscretePollInterface.setModel(new SpinnerNumberModel((Number)15, Integer.valueOf(15), null, (Number)1));
        this.mPanel2.add((Component)this.mTextFieldDiscretePollInterface, cc.xy(3, 7));
        this.mLabel14.setText("seconds");
        this.mLabel14.setFont(new Font("Helvetica", 2, 11));
        this.mPanel2.add((Component)this.mLabel14, cc.xy(5, 7));
        this.mLabel6.setText("Module Password");
        this.mLabel6.setFont(new Font("Helvetica", 1, 11));
        this.mPanel2.add((Component)this.mLabel6, cc.xy(1, 9));
        this.mPanel2.add((Component)this.mPasswordFieldPassword, cc.xy(3, 9));
        this.mContentPanel.add((Component)this.mPanel2, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(5, 10, 5, 10)));
        this.mContentPanel.add((Component)this.mSeparator3, cc.xy(1, 9));
        this.mPanel3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)110), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)100)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mLabel7.setText("Default Graph Width:");
        this.mLabel7.setFont(new Font("Helvetica", 1, 11));
        this.mPanel3.add((Component)this.mLabel7, cc.xy(1, 1));
        this.mPanel3.add((Component)this.mTextFieldGraphWidth, cc.xy(3, 1));
        this.mLabel9.setText("pixels");
        this.mLabel9.setFont(new Font("Helvetica", 2, 11));
        this.mPanel3.add((Component)this.mLabel9, cc.xy(5, 1));
        this.mLabel8.setText("Default Graph Height:");
        this.mLabel8.setFont(new Font("Helvetica", 1, 11));
        this.mPanel3.add((Component)this.mLabel8, cc.xy(1, 3));
        this.mPanel3.add((Component)this.mTextFieldGraphHeight, cc.xy(3, 3));
        this.mLabel10.setText("pixels");
        this.mLabel10.setFont(new Font("Helvetica", 2, 11));
        this.mPanel3.add((Component)this.mLabel10, cc.xy(5, 3));
        this.mLabel11.setText("Graph Interval Threshold:");
        this.mLabel11.setFont(new Font("Helvetica", 1, 11));
        this.mPanel3.add((Component)this.mLabel11, cc.xy(1, 5));
        this.mTextFieldGraphThreshold.setModel(new SpinnerNumberModel((Number)15, Integer.valueOf(1), null, (Number)1));
        this.mPanel3.add((Component)this.mTextFieldGraphThreshold, cc.xy(3, 5));
        this.mLabel12.setText("minutes");
        this.mLabel12.setFont(new Font("Helvetica", 2, 11));
        this.mPanel3.add((Component)this.mLabel12, cc.xy(5, 5));
        this.mCheckBoxTankMaintenanceLogAnnotations.setText("Show Tank Maintenance Log Annotations");
        this.mCheckBoxTankMaintenanceLogAnnotations.setSelected(true);
        this.mPanel3.add((Component)this.mCheckBoxTankMaintenanceLogAnnotations, cc.xywh(3, 7, 3, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mContentPanel.add((Component)this.mPanel3, new CellConstraints(1, 11, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(5, 10, 5, 10)));
        this.mContentPanel.add((Component)this.mSeparator4, cc.xy(1, 13));
        this.mPanel4.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)80)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)30)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)60), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mCheckBoxKeepMainWindowOnTop.setText("Keep Main Window On Top");
        this.mPanel4.add((Component)this.mCheckBoxKeepMainWindowOnTop, cc.xywh(3, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mCheckBoxRememberWindowPosition.setText("Remember Window Position");
        this.mPanel4.add((Component)this.mCheckBoxRememberWindowPosition, cc.xywh(5, 1, 3, 1));
        this.mCheckBoxAutoSampling.setText("Auto Sampling");
        this.mPanel4.add((Component)this.mCheckBoxAutoSampling, cc.xywh(9, 1, 3, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mCheckBoxRTMEnabled.setText("Auto Real Time Monitoring");
        this.mPanel4.add((Component)this.mCheckBoxRTMEnabled, cc.xywh(3, 3, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mLabel17.setText("RTM Interval:");
        this.mLabel17.setFont(new Font("Helvetica", 1, 11));
        this.mPanel4.add((Component)this.mLabel17, cc.xywh(5, 3, 1, 1, CellConstraints.RIGHT, CellConstraints.CENTER));
        this.mTextFieldRTMPollInterval.setModel(new SpinnerNumberModel((Number)60, Integer.valueOf(10), null, (Number)1));
        this.mTextFieldRTMPollInterval.setToolTipText("<html>The time interval (in minutes) to poll the Ethernet module<br> \nfor a status update, for analogue sensors only.  Analogue<br> \nsensors are sensors that have continuous values, and not<br>\na specific set of states, like Temperature, pH etc.");
        this.mPanel4.add((Component)this.mTextFieldRTMPollInterval, cc.xy(7, 3));
        this.mLabel16.setText("seconds");
        this.mLabel16.setFont(new Font("Helvetica", 2, 11));
        this.mPanel4.add((Component)this.mLabel16, cc.xywh(9, 3, 3, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mContentPanel.add((Component)this.mPanel4, new CellConstraints(1, 15, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(5, 10, 5, 10)));
        this.mTabbedPaneOptions.addTab("General", this.mContentPanel);
        this.mContentPanel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanel3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.TOP, (Size)Sizes.DEFAULT, 0.7), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}));
        this.mContentPanel3.add((Component)this.mSeparator7, cc.xy(1, 1));
        this.mPanel8.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.dluX((int)110), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mLabelPostgreSQLIP3.setText("SMTP Server IP Address:");
        this.mLabelPostgreSQLIP3.setFont(new Font("Helvetica", 1, 11));
        this.mPanel8.add((Component)this.mLabelPostgreSQLIP3, cc.xy(1, 1));
        this.mPanel8.add((Component)this.mTextFieldSMTPIP, cc.xy(3, 1));
        this.mLabelPostgreSQLPort3.setText("SMTP Server Port:");
        this.mLabelPostgreSQLPort3.setFont(new Font("Helvetica", 1, 11));
        this.mPanel8.add((Component)this.mLabelPostgreSQLPort3, cc.xy(1, 3));
        this.mPanel8.add((Component)this.mTextFieldSMTPPort, cc.xy(3, 3));
        this.mLabelPostgreSQLPort4.setText("Sender's Email Address:");
        this.mLabelPostgreSQLPort4.setFont(new Font("Helvetica", 1, 11));
        this.mPanel8.add((Component)this.mLabelPostgreSQLPort4, cc.xy(1, 5));
        this.mPanel8.add((Component)this.mTextFieldMailFrom, cc.xy(3, 5));
        this.mCheckBoxUseSMTPAuth.setText("Use SMTP Authentication");
        this.mCheckBoxUseSMTPAuth.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PreferencesForm.this.checkBoxUseSMTPAuthItemStateChanged(e);
            }
        });
        this.mPanel8.add((Component)this.mCheckBoxUseSMTPAuth, cc.xy(3, 7));
        this.mLabelSMTPAuthUserName.setText("Username:");
        this.mLabelSMTPAuthUserName.setFont(new Font("Helvetica", 1, 11));
        this.mPanel8.add((Component)this.mLabelSMTPAuthUserName, cc.xy(1, 9));
        this.mPanel8.add((Component)this.mTextFieldSMTPAuthUsername, cc.xy(3, 9));
        this.mLabelSMTPAuthPwd.setText("Password:");
        this.mLabelSMTPAuthPwd.setFont(new Font("Helvetica", 1, 11));
        this.mPanel8.add((Component)this.mLabelSMTPAuthPwd, cc.xy(1, 11));
        this.mPanel8.add((Component)this.mPasswordFieldSMTPAuthPassword, cc.xy(3, 11));
        this.mContentPanel3.add((Component)this.mPanel8, cc.xy(1, 3));
        this.mTabbedPaneOptions.addTab("Notifications", this.mContentPanel3);
        this.mContentPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.7), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}));
        this.mContentPanel2.add((Component)this.mSeparator5, cc.xy(1, 1));
        this.mPanel5.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        ((FormLayout)this.mPanel5.getLayout()).setColumnGroups((int[][])new int[][]{{1, 3, 5, 7}});
        this.mCheckBoxTemp.setText("Temperature");
        this.mPanel5.add((Component)this.mCheckBoxTemp, cc.xy(1, 1));
        this.mCheckBoxpH.setText("pH");
        this.mPanel5.add((Component)this.mCheckBoxpH, cc.xy(3, 1));
        this.mCheckBoxSalinity.setText("Salinity");
        this.mPanel5.add((Component)this.mCheckBoxSalinity, cc.xy(5, 1));
        this.mCheckBoxAmmonia.setText("Ammonia");
        this.mPanel5.add((Component)this.mCheckBoxAmmonia, cc.xy(7, 1));
        this.mCheckBoxAlkalinity.setText("Alkalinity");
        this.mPanel5.add((Component)this.mCheckBoxAlkalinity, cc.xy(1, 3));
        this.mCheckBoxCalcium.setText("Calcium");
        this.mPanel5.add((Component)this.mCheckBoxCalcium, cc.xy(3, 3));
        this.mCheckBoxMagnesium.setText("Magnesium");
        this.mPanel5.add((Component)this.mCheckBoxMagnesium, cc.xy(5, 3));
        this.mCheckBoxPhosphate.setText("Phosphate");
        this.mPanel5.add((Component)this.mCheckBoxPhosphate, cc.xy(7, 3));
        this.mContentPanel2.add((Component)this.mPanel5, cc.xy(1, 3));
        this.mContentPanel2.add((Component)this.mSeparator6, cc.xy(1, 5));
        this.mPanel6.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        ((FormLayout)this.mPanel6.getLayout()).setColumnGroups((int[][])new int[][]{{1, 3, 5, 7}});
        this.mCheckBoxNitrite.setText("Nitrite");
        this.mPanel6.add((Component)this.mCheckBoxNitrite, cc.xy(1, 1));
        this.mCheckBoxNitrate.setText("Nitrate");
        this.mPanel6.add((Component)this.mCheckBoxNitrate, cc.xy(3, 1));
        this.mCheckBoxSilica.setText("Silica");
        this.mPanel6.add((Component)this.mCheckBoxSilica, cc.xy(5, 1));
        this.mCheckBoxIodine.setText("Iodine");
        this.mPanel6.add((Component)this.mCheckBoxIodine, cc.xy(7, 1));
        this.mCheckBoxStrontium.setText("Strontium");
        this.mPanel6.add((Component)this.mCheckBoxStrontium, cc.xy(1, 3));
        this.mCheckBoxORP.setText("ORP");
        this.mPanel6.add((Component)this.mCheckBoxORP, cc.xy(3, 3));
        this.mCheckBoxBoron.setText("Boron");
        this.mPanel6.add((Component)this.mCheckBoxBoron, cc.xy(5, 3));
        this.mCheckBoxIron.setText("Iron");
        this.mPanel6.add((Component)this.mCheckBoxIron, cc.xy(7, 3));
        this.mContentPanel2.add((Component)this.mPanel6, cc.xy(1, 7));
        this.mLabel15.setText("<html><font style=\"color: red\">NOTE: Do not choose a parameter here if it is monitored through an Aquatronica probe as this will lead to duplication in values!");
        this.mContentPanel2.add((Component)this.mLabel15, cc.xy(1, 9));
        this.mTabbedPaneOptions.addTab("Manually Monitored Water Parameters", this.mContentPanel2);
        this.mDialogPane.add((Component)this.mTabbedPaneOptions, "Center");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(675, 740);
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroupDBType = new ButtonGroup();
        buttonGroupDBType.add(this.mRadioButtonDBTypeEmbedded);
        buttonGroupDBType.add(this.mRadioButtonDBTypeRemote);
    }
}

