/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import za.co.pwnconsulting.aquatronica.EventCodes;
import za.co.pwnconsulting.aquatronica.PlugData;
import za.co.pwnconsulting.aquatronica.PlugSample;

public class PlugStatusForm
extends JDialog {
    private PlugData.OverridePlugState mPlugState;
    private JPanel mDialogPane;
    private JPanel mContentPanel;
    private JComponent mSeparator1;
    private JLabel mLabel1;
    private JLabel mLabelPowerUnit;
    private JLabel mLabel2;
    private JLabel mLabelPlug;
    private JLabel mLabel3;
    private JLabel mLabelStatus;
    private JLabel mLabel4;
    private JLabel mLabelDescription;
    private JComponent mSeparator2;
    private JPanel mPanel1;
    private JRadioButton mRadioButtonOn;
    private JRadioButton mRadioButtonOff;
    private JRadioButton mRadioButtonRestore;
    private JPanel mButtonBar;
    private JButton mOkButton;
    private JButton mCancelButton;

    public PlugStatusForm(Frame owner, String pPowerUnitName, PlugSample pPlugSample) {
        super(owner);
        this.initComponents();
        this.mPlugState = null;
        this.setLabels(pPowerUnitName, pPlugSample);
    }

    public PlugStatusForm(Dialog owner, String pPowerUnitName, PlugSample pPlugSample) {
        super(owner);
        this.initComponents();
        this.mPlugState = null;
        this.setLabels(pPowerUnitName, pPlugSample);
    }

    private void setLabels(String pPowerUnitName, PlugSample pPlugSample) {
        this.mLabelPowerUnit.setText(pPowerUnitName);
        this.mLabelPlug.setText(pPlugSample.getName());
        this.mLabelStatus.setText(EventCodes.isPlugOn(Utils.getInt((String)pPlugSample.getStatus())) ? "On" : "Off");
        this.mLabelDescription.setText(EventCodes.parsePlugStatus(Utils.getInt((String)pPlugSample.getStatus())));
        PlugData.OverridePlugState vPlugOverride = EventCodes.getPlugOverride(Utils.getInt((String)pPlugSample.getStatus()));
        if (vPlugOverride == PlugData.OverridePlugState.ForcedOn) {
            this.mRadioButtonOn.setSelected(true);
        } else if (vPlugOverride == PlugData.OverridePlugState.ForcedOff) {
            this.mRadioButtonOff.setSelected(true);
        } else if (vPlugOverride == PlugData.OverridePlugState.Auto) {
            this.mRadioButtonRestore.setSelected(true);
        }
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.mPlugState = this.mRadioButtonOn.isSelected() ? PlugData.OverridePlugState.ForcedOn : (this.mRadioButtonOff.isSelected() ? PlugData.OverridePlugState.ForcedOff : PlugData.OverridePlugState.Auto);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    public PlugData.OverridePlugState getPlugState() {
        return this.mPlugState;
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mDialogPane = new JPanel();
        this.mContentPanel = new JPanel();
        this.mSeparator1 = compFactory.createSeparator("Selected Plug Details");
        this.mLabel1 = new JLabel();
        this.mLabelPowerUnit = new JLabel();
        this.mLabel2 = new JLabel();
        this.mLabelPlug = new JLabel();
        this.mLabel3 = new JLabel();
        this.mLabelStatus = new JLabel();
        this.mLabel4 = new JLabel();
        this.mLabelDescription = new JLabel();
        this.mSeparator2 = compFactory.createSeparator("Change Plug Status");
        this.mPanel1 = new JPanel();
        this.mRadioButtonOn = new JRadioButton();
        this.mRadioButtonOff = new JRadioButton();
        this.mRadioButtonRestore = new JRadioButton();
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        this.mCancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Plug Status");
        this.setResizable(false);
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mContentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mContentPanel.add((Component)this.mSeparator1, cc.xywh(1, 1, 3, 1));
        this.mLabel1.setText("Power Unit:");
        this.mLabel1.setFont(this.mLabel1.getFont().deriveFont(this.mLabel1.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel1, cc.xy(1, 3));
        this.mLabelPowerUnit.setText("text");
        this.mContentPanel.add((Component)this.mLabelPowerUnit, cc.xy(3, 3));
        this.mLabel2.setText("Plug:");
        this.mLabel2.setFont(this.mLabel2.getFont().deriveFont(this.mLabel2.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel2, cc.xy(1, 5));
        this.mLabelPlug.setText("text");
        this.mContentPanel.add((Component)this.mLabelPlug, cc.xy(3, 5));
        this.mLabel3.setText("Status:");
        this.mLabel3.setFont(this.mLabel3.getFont().deriveFont(this.mLabel3.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel3, cc.xy(1, 7));
        this.mLabelStatus.setText("text");
        this.mContentPanel.add((Component)this.mLabelStatus, cc.xy(3, 7));
        this.mLabel4.setText("Description:");
        this.mLabel4.setFont(this.mLabel4.getFont().deriveFont(this.mLabel4.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel4, cc.xy(1, 9));
        this.mLabelDescription.setText("text");
        this.mContentPanel.add((Component)this.mLabelDescription, cc.xy(3, 9));
        this.mContentPanel.add((Component)this.mSeparator2, cc.xywh(1, 11, 3, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mPanel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mRadioButtonOn.setText("Force Plug On");
        this.mRadioButtonOn.setSelected(true);
        this.mPanel1.add((Component)this.mRadioButtonOn, cc.xywh(3, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mRadioButtonOff.setText("Force Plug Off");
        this.mPanel1.add((Component)this.mRadioButtonOff, cc.xywh(3, 3, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mRadioButtonRestore.setText("Restore to Automatic");
        this.mPanel1.add((Component)this.mRadioButtonRestore, cc.xywh(3, 5, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mContentPanel.add((Component)this.mPanel1, cc.xywh(1, 13, 3, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.mDialogPane.add((Component)this.mContentPanel, "Center");
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("OK");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlugStatusForm.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(2, 1));
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlugStatusForm.this.cancelButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mCancelButton, cc.xy(4, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(355, 305);
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.mRadioButtonOn);
        buttonGroup1.add(this.mRadioButtonOff);
        buttonGroup1.add(this.mRadioButtonRestore);
    }
}

