/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.PowerUnitPlug;
import za.co.pwnconsulting.aquatronica.config.Configuration;

public class PlugDutyCycleForm
extends JDialog {
    private JPanel mDialogPane;
    private JPanel mContentPanel;
    private JComponent mSeparator1;
    private JLabel mLabel1;
    private JLabel mLabelPlugName;
    private JLabel mLabel2;
    private JLabel mLabelDateRange;
    private JLabel mLabel3;
    private JLabel mLabelTotalTimeOn;
    private JLabel mLabel4;
    private JLabel mLabelTotalTimeOff;
    private JComponent mSeparator2;
    private JLabel mLabel5;
    private JLabel mLabelAverageOnTime;
    private JLabel mLabel6;
    private JLabel mLabelAverageOffTime;
    private JComponent mSeparator3;
    private JLabel mLabel7;
    private JLabel mLabelMaximumOnTime;
    private JLabel mLabel8;
    private JLabel mLabelMaximumOffTime;
    private JLabel mLabel9;
    private JLabel mLabelMinimumOnTime;
    private JLabel mLabel10;
    private JLabel mLabelMinimumOffTime;
    private JPanel mButtonBar;
    private JButton mOkButton;

    public PlugDutyCycleForm(Frame owner, Configuration pConfiguration, PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        super(owner);
        this.initComponents();
        this.init(pConfiguration, pPowerUnitPlug, pFrom, pTo);
    }

    public PlugDutyCycleForm(Dialog owner, Configuration pConfiguration, PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        super(owner);
        this.initComponents();
        this.init(pConfiguration, pPowerUnitPlug, pFrom, pTo);
    }

    private void init(Configuration pConfiguration, PowerUnitPlug pPowerUnitPlug, Date pFrom, Date pTo) {
        SimpleDateFormat vSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat vSDFDate = new SimpleDateFormat("yyyy-MM-dd");
        this.mLabelPlugName.setText(pPowerUnitPlug.toString());
        this.mLabelDateRange.setText(vSDF.format(pFrom) + "  to  " + vSDF.format(pTo));
        AquatronicaInterface vAI = new AquatronicaInterface(pConfiguration);
        double vOnTime = vAI.calculateTotalOnTime(pPowerUnitPlug, pFrom, pTo);
        double vOffTime = vAI.calculateTotalOffTime(pPowerUnitPlug, pFrom, pTo);
        this.mLabelTotalTimeOn.setText((int)vOnTime / 60 + " hours, " + (int)vOnTime % 60 + " minutes");
        this.mLabelTotalTimeOff.setText((int)vOffTime / 60 + " hours, " + (int)vOffTime % 60 + " minutes");
        double vAverageOnTime = vAI.calculateAverageOnTimePerDay(pPowerUnitPlug, pFrom, pTo);
        double vAverageOffTime = vAI.calculateAverageOffTimePerDay(pPowerUnitPlug, pFrom, pTo);
        this.mLabelAverageOnTime.setText((int)vAverageOnTime / 60 + " hours, " + (int)vAverageOnTime % 60 + " minutes");
        this.mLabelAverageOffTime.setText((int)vAverageOffTime / 60 + " hours, " + (int)vAverageOffTime % 60 + " minutes");
        AquatronicaInterface.ResultOnDate vMaximumOnTime = vAI.calculateMaximumOnTimePerDay(pPowerUnitPlug, pFrom, pTo);
        AquatronicaInterface.ResultOnDate vMaximumOffTime = vAI.calculateMaximumOffTimePerDay(pPowerUnitPlug, pFrom, pTo);
        if (vMaximumOnTime.getDate() != null) {
            this.mLabelMaximumOnTime.setText((int)vMaximumOnTime.getValue() / 60 + " hours, " + (int)vMaximumOnTime.getValue() % 60 + " minutes on " + vSDFDate.format(vMaximumOnTime.getDate()));
        } else {
            this.mLabelMaximumOnTime.setText("<Insufficient Data>");
        }
        if (vMaximumOffTime.getDate() != null) {
            this.mLabelMaximumOffTime.setText((int)vMaximumOffTime.getValue() / 60 + " hours, " + (int)vMaximumOffTime.getValue() % 60 + " minutes on " + vSDFDate.format(vMaximumOffTime.getDate()));
        } else {
            this.mLabelMaximumOffTime.setText("<Insufficient Data>");
        }
        AquatronicaInterface.ResultOnDate vMinimumOnTime = vAI.calculateMinimumOnTimePerDay(pPowerUnitPlug, pFrom, pTo);
        AquatronicaInterface.ResultOnDate vMinimumOffTime = vAI.calculateMinimumOffTimePerDay(pPowerUnitPlug, pFrom, pTo);
        if (vMinimumOnTime.getDate() != null) {
            this.mLabelMinimumOnTime.setText((int)vMinimumOnTime.getValue() / 60 + " hours, " + (int)vMinimumOnTime.getValue() % 60 + " minutes on " + vSDFDate.format(vMinimumOnTime.getDate()));
        } else {
            this.mLabelMinimumOnTime.setText("<Insufficient Data>");
        }
        if (vMinimumOffTime.getDate() != null) {
            this.mLabelMinimumOffTime.setText((int)vMinimumOffTime.getValue() / 60 + " hours, " + (int)vMinimumOffTime.getValue() % 60 + " minutes on " + vSDFDate.format(vMinimumOffTime.getDate()));
        } else {
            this.mLabelMinimumOffTime.setText("<Insufficient Data>");
        }
    }

    private void okButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mDialogPane = new JPanel();
        this.mContentPanel = new JPanel();
        this.mSeparator1 = compFactory.createSeparator("Basic Statistics");
        this.mLabel1 = new JLabel();
        this.mLabelPlugName = new JLabel();
        this.mLabel2 = new JLabel();
        this.mLabelDateRange = new JLabel();
        this.mLabel3 = new JLabel();
        this.mLabelTotalTimeOn = new JLabel();
        this.mLabel4 = new JLabel();
        this.mLabelTotalTimeOff = new JLabel();
        this.mSeparator2 = compFactory.createSeparator("Averages");
        this.mLabel5 = new JLabel();
        this.mLabelAverageOnTime = new JLabel();
        this.mLabel6 = new JLabel();
        this.mLabelAverageOffTime = new JLabel();
        this.mSeparator3 = compFactory.createSeparator("Extremes");
        this.mLabel7 = new JLabel();
        this.mLabelMaximumOnTime = new JLabel();
        this.mLabel8 = new JLabel();
        this.mLabelMaximumOffTime = new JLabel();
        this.mLabel9 = new JLabel();
        this.mLabelMinimumOnTime = new JLabel();
        this.mLabel10 = new JLabel();
        this.mLabelMinimumOffTime = new JLabel();
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setTitle("Plug Duty Cycle");
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mContentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mContentPanel.add((Component)this.mSeparator1, cc.xywh(1, 1, 3, 1));
        this.mLabel1.setText("Plug:");
        this.mLabel1.setFont(this.mLabel1.getFont().deriveFont(this.mLabel1.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel1, cc.xy(1, 3));
        this.mLabelPlugName.setText("text");
        this.mContentPanel.add((Component)this.mLabelPlugName, cc.xy(3, 3));
        this.mLabel2.setText("Date Range:");
        this.mLabel2.setFont(this.mLabel2.getFont().deriveFont(this.mLabel2.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel2, cc.xy(1, 5));
        this.mLabelDateRange.setText("text");
        this.mContentPanel.add((Component)this.mLabelDateRange, cc.xy(3, 5));
        this.mLabel3.setText("Total Time On:");
        this.mLabel3.setFont(this.mLabel3.getFont().deriveFont(this.mLabel3.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel3, cc.xy(1, 7));
        this.mLabelTotalTimeOn.setText("text");
        this.mContentPanel.add((Component)this.mLabelTotalTimeOn, cc.xy(3, 7));
        this.mLabel4.setText("Total Time Off:");
        this.mLabel4.setFont(this.mLabel4.getFont().deriveFont(this.mLabel4.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel4, cc.xy(1, 9));
        this.mLabelTotalTimeOff.setText("text");
        this.mContentPanel.add((Component)this.mLabelTotalTimeOff, cc.xy(3, 9));
        this.mContentPanel.add((Component)this.mSeparator2, cc.xywh(1, 11, 3, 1));
        this.mLabel5.setText("Average Time On Per Day:");
        this.mLabel5.setFont(this.mLabel5.getFont().deriveFont(this.mLabel5.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel5, cc.xy(1, 13));
        this.mLabelAverageOnTime.setText("text");
        this.mContentPanel.add((Component)this.mLabelAverageOnTime, cc.xy(3, 13));
        this.mLabel6.setText("Average Time Off Per Day:");
        this.mLabel6.setFont(this.mLabel6.getFont().deriveFont(this.mLabel6.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel6, cc.xy(1, 15));
        this.mLabelAverageOffTime.setText("text");
        this.mContentPanel.add((Component)this.mLabelAverageOffTime, cc.xy(3, 15));
        this.mContentPanel.add((Component)this.mSeparator3, cc.xywh(1, 17, 3, 1));
        this.mLabel7.setText("Maximum Time On Per Day:");
        this.mLabel7.setFont(this.mLabel7.getFont().deriveFont(this.mLabel7.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel7, cc.xy(1, 19));
        this.mLabelMaximumOnTime.setText("text");
        this.mContentPanel.add((Component)this.mLabelMaximumOnTime, cc.xy(3, 19));
        this.mLabel8.setText("Maximum Time Off Per Day:");
        this.mLabel8.setFont(this.mLabel8.getFont().deriveFont(this.mLabel8.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel8, cc.xy(1, 21));
        this.mLabelMaximumOffTime.setText("text");
        this.mContentPanel.add((Component)this.mLabelMaximumOffTime, cc.xy(3, 21));
        this.mLabel9.setText("Minimum Time On Per Day:");
        this.mLabel9.setFont(this.mLabel9.getFont().deriveFont(this.mLabel9.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel9, cc.xy(1, 23));
        this.mLabelMinimumOnTime.setText("text");
        this.mContentPanel.add((Component)this.mLabelMinimumOnTime, cc.xy(3, 23));
        this.mLabel10.setText("Minimum Time Off Per Day:");
        this.mLabel10.setFont(this.mLabel10.getFont().deriveFont(this.mLabel10.getFont().getStyle() | 1));
        this.mContentPanel.add((Component)this.mLabel10, cc.xy(1, 25));
        this.mLabelMinimumOffTime.setText("text");
        this.mContentPanel.add((Component)this.mLabelMinimumOffTime, cc.xy(3, 25));
        this.mDialogPane.add((Component)this.mContentPanel, "Center");
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("OK");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlugDutyCycleForm.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(2, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(610, 390);
        this.setLocationRelativeTo(this.getOwner());
    }
}

