/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.OverlayGraphPreset;
import za.co.pwnconsulting.aquatronica.Plug;
import za.co.pwnconsulting.aquatronica.PowerUnitPlug;
import za.co.pwnconsulting.aquatronica.Tank;
import za.co.pwnconsulting.aquatronica.WaterParameterData;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.helpers.BugManager;
import za.co.pwnconsulting.aquatronica.panels.DateForGraph;

public class OverlayGraphForm
extends JDialog {
    private List mSelections;
    private Configuration mConfiguration;
    private Date mFrom;
    private Date mTo;
    private JPanel mDialogPane;
    private JPanel mContentPanel;
    private JComponent mSeparator1;
    private JLabel mLabel1;
    private JComboBox mComboBoxSensors;
    private JCheckBox mCheckBoxAllSensors;
    private JButton mButtonAddSensor;
    private JButton mButtonRemove;
    private JScrollPane mScrollPane1;
    private JList mListSelections;
    private JComponent mSeparator2;
    private JLabel mLabel2;
    private JComboBox mComboBoxPowerUnit;
    private JCheckBox mCheckBoxAllPowerunits;
    private JLabel mLabel3;
    private JComboBox mComboBoxPlug;
    private JButton mButtonAddPlug;
    private JComponent mSeparator4;
    private JLabel mLabel5;
    private JComboBox mComboBoxWaterParameters;
    private JLabel mLabel6;
    private JComboBox mComboBoxTank;
    private JButton mButtonAddWaterParameter;
    private DateForGraph mDateForGraph1;
    private JPanel mPanel1;
    private JComponent mSeparator3;
    private JLabel mLabel4;
    private JTextField mTextFieldPresetName;
    private JButton mButtonSavePreset;
    private JButton mButtonRemovePreset;
    private JScrollPane mScrollPane2;
    private JList mListPresets;
    private JPanel mButtonBar;
    private JButton mOkButton;
    private JButton mCancelButton;

    public OverlayGraphForm(Frame owner, Configuration pConfiguration) {
        super(owner);
        this.initComponents(pConfiguration);
        this.mConfiguration = pConfiguration;
        this.mSelections = new ArrayList();
        this.comboBoxPowerUnitItemStateChanged(null);
        DefaultListModel vModelList = (DefaultListModel)this.mListPresets.getModel();
        vModelList.clear();
        List<OverlayGraphPreset> vPresets = new AquatronicaInterface(this.mConfiguration).getOverlayGraphPresets();
        for (OverlayGraphPreset vPreset : vPresets) {
            vModelList.addElement(vPreset);
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        DefaultListModel vListModel = (DefaultListModel)this.mListSelections.getModel();
        for (int i = 0; i < vListModel.getSize(); ++i) {
            this.mSelections.add(vListModel.getElementAt(i));
        }
        this.mFrom = this.mDateForGraph1.getFromDate();
        this.mTo = this.mDateForGraph1.getToDate();
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void comboBoxPowerUnitItemStateChanged(ItemEvent e) {
        DefaultComboBoxModel vModel = (DefaultComboBoxModel)this.mComboBoxPlug.getModel();
        vModel.removeAllElements();
        if (this.mComboBoxPowerUnit.getSelectedItem() != null) {
            List<String> vPlugNames = new AquatronicaInterface(this.mConfiguration).getPlugNames(this.mComboBoxPowerUnit.getSelectedItem().toString());
            for (String vPlugName : vPlugNames) {
                vModel.addElement(vPlugName);
            }
        }
    }

    public Date getFrom() {
        return this.mFrom;
    }

    public Date getTo() {
        return this.mTo;
    }

    private void buttonRemoveActionPerformed(ActionEvent e) {
        if (this.mListSelections.getSelectedIndex() >= 0) {
            ((DefaultListModel)this.mListSelections.getModel()).removeElementAt(this.mListSelections.getSelectedIndex());
        }
    }

    public List getSelections() {
        return this.mSelections;
    }

    private void buttonAddSensorActionPerformed(ActionEvent e) {
        DefaultListModel vListModel = (DefaultListModel)this.mListSelections.getModel();
        vListModel.addElement(this.mComboBoxSensors.getSelectedItem());
    }

    private void buttonAddPlugActionPerformed(ActionEvent e) {
        DefaultListModel vListModel = (DefaultListModel)this.mListSelections.getModel();
        vListModel.addElement(new PowerUnitPlug(this.mComboBoxPowerUnit.getSelectedItem().toString(), this.mComboBoxPlug.getSelectedItem().toString()));
    }

    private void buttonSavePresetActionPerformed(ActionEvent e) {
        try {
            if (Utils.isEmptyString((String)this.mTextFieldPresetName.getText())) {
                JOptionPane.showMessageDialog(this, "The preset name must be specified");
            } else {
                DefaultListModel vModelList = (DefaultListModel)this.mListPresets.getModel();
                boolean vDupFound = false;
                for (int i = 0; i < vModelList.getSize(); ++i) {
                    if (!((OverlayGraphPreset)vModelList.get(i)).getName().toUpperCase().equals(this.mTextFieldPresetName.getText().toUpperCase())) continue;
                    vDupFound = true;
                    break;
                }
                if (vDupFound) {
                    JOptionPane.showMessageDialog(this, "This preset name is already used.");
                } else if (this.mListSelections.getModel().getSize() <= 0) {
                    JOptionPane.showMessageDialog(this, "A preset can only be saved when one or more sensors or plugs or manual water parameters have been selected.");
                } else {
                    AquatronicaInterface vAquatronicaInterface = new AquatronicaInterface(this.mConfiguration);
                    OverlayGraphPreset vPreset = new OverlayGraphPreset(this.mTextFieldPresetName.getText());
                    DefaultListModel vSelectedList = (DefaultListModel)this.mListSelections.getModel();
                    for (int i = 0; i < vSelectedList.getSize(); ++i) {
                        Object vEntry = vSelectedList.get(i);
                        if (vEntry instanceof String) {
                            vPreset.getSensorNames().add((String)vEntry);
                            continue;
                        }
                        if (vEntry instanceof PowerUnitPlug) {
                            int vPowerUnitID = vAquatronicaInterface.getPowerUnitID(((PowerUnitPlug)vEntry).getPowerUnitName());
                            int vPlugID = vAquatronicaInterface.getPlugID(vPowerUnitID, ((PowerUnitPlug)vEntry).getPlugName());
                            vPreset.getPlugs().add(new Plug(vPowerUnitID, vPlugID));
                            continue;
                        }
                        if (!(vEntry instanceof WaterParameterData)) continue;
                        vPreset.getWaterParameters().add((WaterParameterData)vEntry);
                    }
                    vAquatronicaInterface.saveOverlayGraphPreset(vPreset);
                    vModelList.addElement(vPreset);
                    this.mTextFieldPresetName.setText("");
                }
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonRemovePresetActionPerformed(ActionEvent e) {
        try {
            if (this.mListPresets.getSelectedIndex() < 0) {
                JOptionPane.showMessageDialog(this, "First select an entry from the Preset list below to delete");
            } else {
                DefaultListModel vModelList = (DefaultListModel)this.mListPresets.getModel();
                new AquatronicaInterface(this.mConfiguration).deleteOverlayGraphPreset(((OverlayGraphPreset)vModelList.get(this.mListPresets.getSelectedIndex())).getID());
                vModelList.remove(this.mListPresets.getSelectedIndex());
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void listPresetsValueChanged(ListSelectionEvent e) {
        try {
            if (this.mListPresets.getSelectedIndex() >= 0) {
                DefaultListModel vModelList = (DefaultListModel)this.mListPresets.getModel();
                OverlayGraphPreset vPreset = (OverlayGraphPreset)vModelList.get(this.mListPresets.getSelectedIndex());
                DefaultListModel vSelectModel = (DefaultListModel)this.mListSelections.getModel();
                vSelectModel.clear();
                for (String vSensorName : vPreset.getSensorNames()) {
                    vSelectModel.addElement(vSensorName);
                }
                AquatronicaInterface vAquatronicaInterface = new AquatronicaInterface(this.mConfiguration);
                for (Plug vPlug : vPreset.getPlugs()) {
                    String vPowerUnitName = vAquatronicaInterface.getPowerUnitName(vPlug.getPowerUnitID());
                    String vPlugName = vAquatronicaInterface.getPlugName(vPlug.getPowerUnitID(), vPlug.getPlugID());
                    vSelectModel.addElement(new PowerUnitPlug(vPowerUnitName, vPlugName));
                }
                for (WaterParameterData vParam : vPreset.getWaterParameters()) {
                    vSelectModel.addElement(vParam);
                }
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonAddWaterParameterActionPerformed(ActionEvent e) {
        DefaultListModel vListModel = (DefaultListModel)this.mListSelections.getModel();
        vListModel.addElement(new WaterParameterData((Configuration.WaterParameters.WaterParameterType)((Object)this.mComboBoxWaterParameters.getSelectedItem()), (Tank)this.mComboBoxTank.getSelectedItem()));
    }

    private void checkBoxAllSensorsItemStateChanged(ItemEvent e) {
        this.mComboBoxSensors.removeAllItems();
        List<String> vEntries = new AquatronicaInterface(this.mConfiguration).getSensorNames(!this.mCheckBoxAllSensors.isSelected());
        for (String vEntry : vEntries) {
            this.mComboBoxSensors.addItem(vEntry);
        }
    }

    private void checkBoxAllPowerunitsItemStateChanged(ItemEvent e) {
        this.mComboBoxPowerUnit.removeAllItems();
        List<String> vEntries = new AquatronicaInterface(this.mConfiguration).getPowerUnitNames(!this.mCheckBoxAllPowerunits.isSelected());
        for (String vEntry : vEntries) {
            this.mComboBoxPowerUnit.addItem(vEntry);
        }
    }

    private void initComponents(Configuration pConfiguration) {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mDialogPane = new JPanel();
        this.mContentPanel = new JPanel();
        this.mSeparator1 = compFactory.createSeparator("Select a sensor");
        this.mLabel1 = new JLabel();
        this.mComboBoxSensors = new JComboBox<Object>(new AquatronicaInterface(pConfiguration).getSensorNames(true).toArray());
        this.mCheckBoxAllSensors = new JCheckBox();
        this.mButtonAddSensor = new JButton();
        this.mButtonRemove = new JButton();
        this.mScrollPane1 = new JScrollPane();
        this.mListSelections = new JList(new DefaultListModel());
        this.mSeparator2 = compFactory.createSeparator("Select a plug");
        this.mLabel2 = new JLabel();
        this.mComboBoxPowerUnit = new JComboBox<Object>(new AquatronicaInterface(pConfiguration).getPowerUnitNames(true).toArray());
        this.mCheckBoxAllPowerunits = new JCheckBox();
        this.mLabel3 = new JLabel();
        this.mComboBoxPlug = new JComboBox();
        this.mButtonAddPlug = new JButton();
        this.mSeparator4 = compFactory.createSeparator("Select a manual water parameter");
        this.mLabel5 = new JLabel();
        this.mComboBoxWaterParameters = new JComboBox<Object>(pConfiguration.getWaterParameters().getWaterParameterTypesEnabled().toArray());
        this.mLabel6 = new JLabel();
        this.mComboBoxTank = new JComboBox<Object>(new AquatronicaInterface(pConfiguration).getTanks().toArray());
        this.mButtonAddWaterParameter = new JButton();
        this.mDateForGraph1 = new DateForGraph();
        this.mPanel1 = new JPanel();
        this.mSeparator3 = compFactory.createSeparator("Presets");
        this.mLabel4 = new JLabel();
        this.mTextFieldPresetName = new JTextField();
        this.mButtonSavePreset = new JButton();
        this.mButtonRemovePreset = new JButton();
        this.mScrollPane2 = new JScrollPane();
        this.mListPresets = new JList(new DefaultListModel());
        this.mButtonBar = new JPanel();
        this.mOkButton = new JButton();
        this.mCancelButton = new JButton();
        CellConstraints cc = new CellConstraints();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("Overlay Graph Selectors");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mDialogPane.setBorder(Borders.DIALOG_BORDER);
        this.mDialogPane.setLayout(new BorderLayout());
        this.mContentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mContentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 0.5), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 0.1), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 0.25), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;80dlu):grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}));
        this.mContentPanel.add((Component)this.mSeparator1, cc.xywh(1, 1, 7, 1));
        this.mLabel1.setText("Sensor:");
        this.mLabel1.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel1, cc.xy(1, 3));
        this.mContentPanel.add((Component)this.mComboBoxSensors, cc.xy(3, 3));
        this.mCheckBoxAllSensors.setText("All?");
        this.mCheckBoxAllSensors.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                OverlayGraphForm.this.checkBoxAllSensorsItemStateChanged(e);
            }
        });
        this.mContentPanel.add((Component)this.mCheckBoxAllSensors, cc.xy(5, 3));
        this.mButtonAddSensor.setText("Add Sensor");
        this.mButtonAddSensor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OverlayGraphForm.this.buttonAddSensorActionPerformed(e);
            }
        });
        this.mContentPanel.add((Component)this.mButtonAddSensor, cc.xy(7, 3));
        this.mButtonRemove.setText("Remove From List");
        this.mButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OverlayGraphForm.this.buttonRemoveActionPerformed(e);
            }
        });
        this.mContentPanel.add((Component)this.mButtonRemove, cc.xywh(9, 3, 5, 1, CellConstraints.CENTER, CellConstraints.DEFAULT));
        this.mListSelections.setSelectionMode(0);
        this.mScrollPane1.setViewportView(this.mListSelections);
        this.mContentPanel.add((Component)this.mScrollPane1, cc.xywh(9, 5, 5, 11));
        this.mContentPanel.add((Component)this.mSeparator2, cc.xywh(1, 5, 7, 1));
        this.mLabel2.setText("Power Unit:");
        this.mLabel2.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel2, cc.xy(1, 7));
        this.mComboBoxPowerUnit.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                OverlayGraphForm.this.comboBoxPowerUnitItemStateChanged(e);
            }
        });
        this.mContentPanel.add((Component)this.mComboBoxPowerUnit, cc.xy(3, 7));
        this.mCheckBoxAllPowerunits.setText("All?");
        this.mCheckBoxAllPowerunits.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                OverlayGraphForm.this.checkBoxAllPowerunitsItemStateChanged(e);
            }
        });
        this.mContentPanel.add((Component)this.mCheckBoxAllPowerunits, cc.xy(5, 7));
        this.mLabel3.setText("Plug:");
        this.mLabel3.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel3, cc.xy(1, 9));
        this.mContentPanel.add((Component)this.mComboBoxPlug, cc.xy(3, 9));
        this.mButtonAddPlug.setText("Add Plug");
        this.mButtonAddPlug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OverlayGraphForm.this.buttonAddPlugActionPerformed(e);
            }
        });
        this.mContentPanel.add((Component)this.mButtonAddPlug, cc.xy(7, 9));
        this.mContentPanel.add((Component)this.mSeparator4, cc.xywh(1, 11, 7, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mLabel5.setText("Select the water parameter:");
        this.mLabel5.setLabelFor(this.mComboBoxWaterParameters);
        this.mLabel5.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel5, cc.xy(1, 13));
        this.mContentPanel.add((Component)this.mComboBoxWaterParameters, cc.xy(3, 13));
        this.mLabel6.setText("Select the tank:");
        this.mLabel6.setFont(new Font("Helvetica", 1, 11));
        this.mContentPanel.add((Component)this.mLabel6, cc.xy(1, 15));
        this.mContentPanel.add((Component)this.mComboBoxTank, cc.xy(3, 15));
        this.mButtonAddWaterParameter.setText("Add Parameter");
        this.mButtonAddWaterParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OverlayGraphForm.this.buttonAddWaterParameterActionPerformed(e);
            }
        });
        this.mContentPanel.add((Component)this.mButtonAddWaterParameter, cc.xy(7, 15));
        this.mContentPanel.add((Component)this.mDateForGraph1, cc.xywh(1, 17, 7, 1));
        this.mPanel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}));
        this.mPanel1.add((Component)this.mSeparator3, cc.xywh(1, 1, 3, 1));
        this.mLabel4.setText("Preset Name:");
        this.mLabel4.setFont(new Font("Helvetica", 1, 11));
        this.mPanel1.add((Component)this.mLabel4, cc.xywh(1, 3, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mPanel1.add((Component)this.mTextFieldPresetName, cc.xywh(3, 3, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.mButtonSavePreset.setText("Save Preset");
        this.mButtonSavePreset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OverlayGraphForm.this.buttonSavePresetActionPerformed(e);
            }
        });
        this.mPanel1.add((Component)this.mButtonSavePreset, cc.xy(1, 5));
        this.mButtonRemovePreset.setText("Remove Preset");
        this.mButtonRemovePreset.setSelectedIcon(null);
        this.mButtonRemovePreset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OverlayGraphForm.this.buttonRemovePresetActionPerformed(e);
            }
        });
        this.mPanel1.add((Component)this.mButtonRemovePreset, cc.xy(3, 5));
        this.mListPresets.setSelectionMode(0);
        this.mListPresets.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                OverlayGraphForm.this.listPresetsValueChanged(e);
            }
        });
        this.mScrollPane2.setViewportView(this.mListPresets);
        this.mPanel1.add((Component)this.mScrollPane2, cc.xywh(1, 7, 3, 1));
        this.mContentPanel.add((Component)this.mPanel1, cc.xywh(9, 17, 5, 1));
        this.mDialogPane.add((Component)this.mContentPanel, "Center");
        this.mButtonBar.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.mButtonBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")));
        this.mOkButton.setText("OK");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OverlayGraphForm.this.okButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mOkButton, cc.xy(2, 1));
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OverlayGraphForm.this.cancelButtonActionPerformed(e);
            }
        });
        this.mButtonBar.add((Component)this.mCancelButton, cc.xy(4, 1));
        this.mDialogPane.add((Component)this.mButtonBar, "South");
        contentPane.add((Component)this.mDialogPane, "Center");
        this.setSize(860, 600);
        this.setLocationRelativeTo(this.getOwner());
    }
}

