/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.za.pwnconsulting.javaconfig.utils.DateUtils;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.AquatronicaSample;
import za.co.pwnconsulting.aquatronica.EventCodes;
import za.co.pwnconsulting.aquatronica.NotificationDetails;
import za.co.pwnconsulting.aquatronica.SensorData;
import za.co.pwnconsulting.aquatronica.SensorDefinition;
import za.co.pwnconsulting.aquatronica.config.Configuration;

public class NotificationModule {
    private Configuration mConfiguration;
    private Timer mSummaryTimer;
    private Map<String, SensorData> mAlarmStatus;
    private Map<String, SensorData> mAlarmStatusMissingDevice;
    private Map<String, Long> mAlarmTime;
    private Map<String, Long> mAlarmTimeMissingDevice;
    private Long mAquaStatsDisconnectedDuration;
    private boolean mAquaStatsDisconnectedAlertSent;
    private NotificationDetails mNotificationDetails;
    private AquatronicaInterface mAquatronicaInterface;

    public NotificationModule(Configuration pConfiguration) {
        this.mConfiguration = pConfiguration;
        this.mAlarmStatus = new HashMap<String, SensorData>();
        this.mAlarmTime = new HashMap<String, Long>();
        this.mAlarmStatusMissingDevice = new HashMap<String, SensorData>();
        this.mAlarmTimeMissingDevice = new HashMap<String, Long>();
        this.mAquaStatsDisconnectedAlertSent = false;
        this.mAquaStatsDisconnectedDuration = null;
        this.mAquatronicaInterface = new AquatronicaInterface(this.mConfiguration);
        this.mNotificationDetails = this.mAquatronicaInterface.getNotificationDetails();
        if (this.mNotificationDetails.isSummaryEnabled()) {
            TimerTask vTask = new TimerTask(){

                public void run() {
                    try {
                        AquatronicaSample vAquatronicaSample = NotificationModule.this.mAquatronicaInterface.sample();
                        String vReport = NotificationModule.this.mAquatronicaInterface.createReport(vAquatronicaSample);
                        NotificationModule.this.mAquatronicaInterface.sendEmail(NotificationModule.this.mNotificationDetails, NotificationModule.this.mNotificationDetails.getSummaryUpdateNotificationSubject(), vReport);
                    }
                    catch (Exception e) {
                        System.out.println("Notification Error: " + e.getMessage() + ", Skipping this check...");
                    }
                }
            };
            int vHour = (int)DateUtils.convertTime((long)1L, (int)4, (int)1);
            this.mSummaryTimer = new Timer(true);
            if (this.mNotificationDetails.getSummaryUpdateFrequency() == NotificationDetails.SummaryUpdateFrequency.Hourly) {
                this.mSummaryTimer.schedule(vTask, vHour, (long)vHour);
            } else {
                Date vTime = this.getNextFixedTime().getTime();
                this.mSummaryTimer.scheduleAtFixedRate(vTask, vTime, (long)DateUtils.convertTime((long)1L, (int)5, (int)1));
            }
        }
    }

    private Calendar getNextFixedTime() {
        Calendar vScheduledTime = Calendar.getInstance();
        vScheduledTime.setTime(this.mNotificationDetails.getSummaryOfUpdateTime());
        Calendar vCalendar = Calendar.getInstance();
        vCalendar.set(11, vScheduledTime.get(11));
        vCalendar.set(12, vScheduledTime.get(12));
        return vCalendar;
    }

    public void checkStatus(AquatronicaSample pLastAquatronicaSample, AquatronicaSample pAquatronicaSample) {
        if (this.mAquaStatsDisconnectedAlertSent) {
            StringBuffer vBody = new StringBuffer(NotificationModule.expandTemplates(this.mNotificationDetails.getClearedAlertTemplateBody()));
            vBody.append(" AquaStats has been RECONNECTED to the Ethernet Controller");
            this.mAquatronicaInterface.sendEmail(this.mNotificationDetails, NotificationModule.expandTemplates(this.mNotificationDetails.getClearedAlertTemplateSubject()), vBody.toString());
        }
        this.mAquaStatsDisconnectedAlertSent = false;
        this.mAquaStatsDisconnectedDuration = null;
        int vDeadTime = (this.mNotificationDetails.getDeadTimeAlertNotification() == null ? 0 : this.mNotificationDetails.getDeadTimeAlertNotification()) * 1000;
        for (String vSensorName : pAquatronicaSample.getSensorData().keySet()) {
            SensorData vSensorData = pAquatronicaSample.getSensorData().get(vSensorName);
            SensorDefinition vSensorDefinition = this.findSensorDefinition(vSensorName);
            if (vSensorDefinition != null && vSensorDefinition.isNotifyOnAlert()) {
                StringBuffer vBody;
                if (this.mNotificationDetails.isAlertOnMissingDevicesEnabled() && (!this.mAlarmTimeMissingDevice.containsKey(vSensorName) || System.currentTimeMillis() - this.mAlarmTimeMissingDevice.get(vSensorName) >= (long)vDeadTime)) {
                    this.mAlarmTimeMissingDevice.remove(vSensorName);
                    if (vSensorData.getValue().equals("?")) {
                        if (!this.mAlarmStatusMissingDevice.containsKey(vSensorName)) {
                            this.mAlarmStatusMissingDevice.put(vSensorName, vSensorData);
                            this.mAlarmTimeMissingDevice.put(vSensorName, System.currentTimeMillis());
                            vBody = new StringBuffer(NotificationModule.expandTemplates(this.mNotificationDetails.getNewAlertTemplateBody()));
                            vBody.append(" Sensor ").append(vSensorName).append(" has been disconnected");
                            this.mAquatronicaInterface.sendEmail(this.mNotificationDetails, NotificationModule.expandTemplates(this.mNotificationDetails.getNewAlertTemplateSubject()), vBody.toString());
                        }
                    } else if (this.mAlarmStatusMissingDevice.containsKey(vSensorName) && this.mAlarmStatusMissingDevice.get(vSensorName).getValue().equals("?")) {
                        this.mAlarmStatusMissingDevice.remove(vSensorName);
                        vBody = new StringBuffer(NotificationModule.expandTemplates(this.mNotificationDetails.getClearedAlertTemplateBody()));
                        vBody.append(" Sensor ").append(vSensorName).append(" has been reconnected");
                        this.mAquatronicaInterface.sendEmail(this.mNotificationDetails, NotificationModule.expandTemplates(this.mNotificationDetails.getClearedAlertTemplateSubject()), vBody.toString());
                    }
                }
                if (!this.mNotificationDetails.isAlertEnabled() || this.mAlarmStatusMissingDevice.containsKey(vSensorName) || this.mAlarmTime.containsKey(vSensorName) && System.currentTimeMillis() - this.mAlarmTime.get(vSensorName) < (long)vDeadTime) continue;
                this.mAlarmTime.remove(vSensorName);
                if (EventCodes.isSensorInAlarm(vSensorData.getStatusCode())) {
                    if (this.mAlarmStatus.containsKey(vSensorName)) continue;
                    this.mAlarmStatus.put(vSensorName, vSensorData);
                    this.mAlarmTime.put(vSensorName, System.currentTimeMillis());
                    vBody = new StringBuffer(NotificationModule.expandTemplates(this.mNotificationDetails.getNewAlertTemplateBody()));
                    vBody.append(" Sensor ").append(vSensorName).append(" is in alarm at ").append(vSensorData.getValue());
                    this.mAquatronicaInterface.sendEmail(this.mNotificationDetails, NotificationModule.expandTemplates(this.mNotificationDetails.getNewAlertTemplateSubject()), vBody.toString());
                    continue;
                }
                if (!this.mAlarmStatus.containsKey(vSensorName) || !EventCodes.isSensorInAlarm(this.mAlarmStatus.get(vSensorName).getStatusCode())) continue;
                this.mAlarmStatus.remove(vSensorName);
                vBody = new StringBuffer(NotificationModule.expandTemplates(this.mNotificationDetails.getClearedAlertTemplateBody()));
                vBody.append(" Sensor ").append(vSensorName).append(" is NOT in alarm any more at ").append(vSensorData.getValue());
                this.mAquatronicaInterface.sendEmail(this.mNotificationDetails, NotificationModule.expandTemplates(this.mNotificationDetails.getClearedAlertTemplateSubject()), vBody.toString());
                continue;
            }
            if (vSensorDefinition != null) continue;
        }
    }

    public void disconnectedFromAquatronica() {
        int vDelayTime = (this.mNotificationDetails.getAlertOnAquaStatsDisconnectedDelay() == null ? 0 : this.mNotificationDetails.getAlertOnAquaStatsDisconnectedDelay()) * 1000;
        if (this.mAquaStatsDisconnectedDuration != null && !this.mAquaStatsDisconnectedAlertSent && System.currentTimeMillis() - this.mAquaStatsDisconnectedDuration >= (long)vDelayTime) {
            StringBuffer vBody = new StringBuffer(NotificationModule.expandTemplates(this.mNotificationDetails.getNewAlertTemplateBody()));
            vBody.append(" AquaStats has been DISCONNECTED from the Ethernet Controller");
            this.mAquatronicaInterface.sendEmail(this.mNotificationDetails, NotificationModule.expandTemplates(this.mNotificationDetails.getNewAlertTemplateSubject()), vBody.toString());
            this.mAquaStatsDisconnectedAlertSent = true;
        } else if (this.mAquaStatsDisconnectedDuration == null) {
            this.mAquaStatsDisconnectedDuration = System.currentTimeMillis();
        }
    }

    private SensorDefinition findSensorDefinition(String pSensorName) {
        for (SensorDefinition vSensorDefinition : this.mNotificationDetails.getSensorDefinitions()) {
            if (!vSensorDefinition.getName().equals(pSensorName)) continue;
            return vSensorDefinition;
        }
        return null;
    }

    public void terminate() {
        if (this.mSummaryTimer != null) {
            this.mSummaryTimer.cancel();
        }
    }

    private static String expandTemplates(String pText) {
        StringBuffer vRes;
        block4: {
            int i = 0;
            vRes = new StringBuffer();
            do {
                if (i < pText.length() - 1 && pText.charAt(i) == '$' && pText.charAt(i + 1) == '{') {
                    StringBuffer vPattern = new StringBuffer();
                    while (i < pText.length() && pText.charAt(i) != '}') {
                        if (pText.charAt(i) == '$' || pText.charAt(i) == '{') {
                            ++i;
                            continue;
                        }
                        vPattern.append(pText.charAt(i));
                        ++i;
                    }
                    SimpleDateFormat vSDF = new SimpleDateFormat(vPattern.toString());
                    vRes.append(vSDF.format(new Date().getTime()));
                    continue;
                }
                vRes.append(pText.charAt(i));
            } while (++i + 1 < pText.length());
            if (i + 1 != pText.length()) break block4;
            vRes.append(pText.charAt(i));
        }
        return vRes.toString();
    }

    public static void main(String[] args) {
        System.out.println(NotificationModule.expandTemplates("Time: ${yyyy-MM-dd HH:mm}"));
    }
}

