/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.za.pwnconsulting.javaconfig.utils.Utils;
import za.co.pwnconsulting.aquatronica.AboutForm;
import za.co.pwnconsulting.aquatronica.AlertForm;
import za.co.pwnconsulting.aquatronica.AquatronicaDevicesForm;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.AquatronicaSample;
import za.co.pwnconsulting.aquatronica.EventCodes;
import za.co.pwnconsulting.aquatronica.OverlayGraphForm;
import za.co.pwnconsulting.aquatronica.PleaseWaitDialog;
import za.co.pwnconsulting.aquatronica.PlugDutyCycleForm;
import za.co.pwnconsulting.aquatronica.PlugSample;
import za.co.pwnconsulting.aquatronica.PlugStatusForm;
import za.co.pwnconsulting.aquatronica.PowerUnitPlug;
import za.co.pwnconsulting.aquatronica.PowerUnitSample;
import za.co.pwnconsulting.aquatronica.PreferencesForm;
import za.co.pwnconsulting.aquatronica.SelectPlugForm;
import za.co.pwnconsulting.aquatronica.SelectSensorForm;
import za.co.pwnconsulting.aquatronica.SelectWaterParameter;
import za.co.pwnconsulting.aquatronica.SensorData;
import za.co.pwnconsulting.aquatronica.SensorStatisticsForm;
import za.co.pwnconsulting.aquatronica.TankMaintenanceLog;
import za.co.pwnconsulting.aquatronica.TankSetup;
import za.co.pwnconsulting.aquatronica.WaterParameterData;
import za.co.pwnconsulting.aquatronica.WaterParametersForm;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.config.MutableConfiguration;
import za.co.pwnconsulting.aquatronica.graphing.Graphing;
import za.co.pwnconsulting.aquatronica.helpers.BrowserLauncher;
import za.co.pwnconsulting.aquatronica.helpers.BugManager;
import za.co.pwnconsulting.aquatronica.helpers.DBHelper;
import za.co.pwnconsulting.aquatronica.helpers.DBPatchingFailedException;
import za.co.pwnconsulting.aquatronica.helpers.DaemonThread;
import za.co.pwnconsulting.aquatronica.helpers.GUIUtils;
import za.co.pwnconsulting.aquatronica.helpers.StatusCallback;

public class MainForm
extends JFrame {
    protected Configuration mConfiguration;
    private boolean mAppConfigured = true;
    private DBHelper mDBHelper = DBHelper.getInstance();
    private AquatronicaInterface.SampleThread mSampleThread;
    private Timer mRTMTimer;
    private AquatronicaSample mPreviousSample;
    private Map<Integer, ImageIcon> mPlugStatuses;
    private JPanel mPanel1;
    private JMenuBar mMenuBar1;
    private JMenu mMenu1;
    private JMenuItem mMenuItemAbout;
    private JMenuItem mMenuItemPreferences;
    private JMenuItem mMenuItemExit;
    private JMenu mMenu2;
    private JCheckBoxMenuItem mCheckBoxMenuItemStartSampling;
    private JMenu mMenu5;
    private JMenuItem mMenuItemAquatronica;
    private JMenuItem mMenuItemTanks;
    private JMenuItem mMenuItemTankMaintenanceLog;
    private JMenuItem mMenuItemCaptureWaterParameters;
    private JMenu mMenu6;
    private JMenuItem mMenuItemAlerts;
    private JMenu mMenu4;
    private JMenuItem mMenuItemGraphSensorData;
    private JMenuItem mMenuItemGraphPlugbarData;
    private JMenuItem mMenuItemGraphManualWaterParams;
    private JMenuItem mMenuItemOverlay;
    private JMenu mMenu3;
    private JMenuItem mMenuItemExportSensorData;
    private JMenuItem mMenuItemPlugBarData;
    private JMenuItem mMenuItemExportManualWaterParams;
    private JMenu mMenu7;
    private JMenuItem mMenuItemPlugDutyCycle;
    private JMenuItem mMenuItemSensorStatistics;
    private JPanel mPanel2;
    private JLabel mLabel1;
    private JButton mButtonFetchStatus;
    private JScrollPane mScrollPane1;
    private JTable mTableSensorData;
    private JPanel mPanel3;
    private JComponent mSeparator2;
    private JCheckBox mCheckBoxEnableRTM;
    private JLabel mLabel3;
    private JSpinner mSpinnerRTMInterval;
    private JLabel mLabel2;
    private JScrollPane mScrollPane2;
    private JTable mTablePlugStatus;
    private JPanel mPanelStatusBar;
    private JLabel mLabelStatus;

    public MainForm() throws IOException {
        this.initComponents();
        this.loadConfig();
        this.mTableSensorData.getColumn("-").setMaxWidth(0);
        this.mTableSensorData.getColumn("-").setMinWidth(0);
        this.mTableSensorData.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTableSensorData.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mTablePlugStatus.getColumn("-").setMaxWidth(0);
        this.mTablePlugStatus.getColumn("-").setMinWidth(0);
        this.mTablePlugStatus.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        this.mTablePlugStatus.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        this.mLabelStatus.setText("AquaStats loading...");
        if (this.mAppConfigured) {
            final MainForm vMainForm = this;
            new DaemonThread(){

                public void run() {
                    try {
                        StatusBarStatusCallback vCallBack = new StatusBarStatusCallback();
                        MainForm.this.mDBHelper.startDB(MainForm.this.mConfiguration.isEmbedded(), MainForm.this.mConfiguration.isEmbedded() ? MainForm.this.mConfiguration.getDBPatchLevelEmbedded() : MainForm.this.mConfiguration.getDBPatchLevelRemote(), vCallBack);
                        DBHelper.getInstance().runDBUpgrade(vCallBack);
                        MainForm.this.loadConfig();
                        if (MainForm.this.mConfiguration.isAutoSamplingEnabled()) {
                            MainForm.this.mCheckBoxMenuItemStartSampling.setSelected(true);
                            MainForm.this.checkBoxMenuItemStartSamplingActionPerformed(null);
                        }
                        MainForm.this.setTitle(MainForm.this.mConfiguration.getAppTitle());
                    }
                    catch (DBPatchingFailedException e) {
                        BugManager.handleError(vMainForm, (Throwable)((Object)e));
                    }
                    catch (Exception e) {
                        BugManager.handleError(vMainForm, e);
                    }
                }
            }.start();
        } else {
            this.mLabelStatus.setText("AquaStats Loaded.");
        }
        this.mPlugStatuses = EventCodes.getStatusIcons();
        this.mPreviousSample = null;
        this.mSpinnerRTMInterval.setValue(this.mConfiguration.getRTMPollingInterval());
        this.mCheckBoxEnableRTM.setSelected(this.mConfiguration.isRTMPollingEnabled());
        if (this.mConfiguration.isMainFrameRememberPosAndSize()) {
            if (this.mConfiguration.getMainFramePosLeft() >= 0 && this.mConfiguration.getMainFramePosTop() >= 0) {
                this.setLocation(this.mConfiguration.getMainFramePosLeft(), this.mConfiguration.getMainFramePosTop());
            }
            if (this.mConfiguration.getMainFrameWidth() > 0 && this.mConfiguration.getMainFrameHeight() > 0) {
                GUIUtils.setFrameDimensions(this, this.mConfiguration.getMainFrameWidth(), this.mConfiguration.getMainFrameHeight(), true, false);
            }
        }
    }

    private void loadConfig() throws IOException {
        this.mAppConfigured = Configuration.configExists();
        this.mConfiguration = new Configuration();
        this.setAlwaysOnTop(this.mConfiguration.isKeepMainWindowOnTop());
    }

    private void menuItemPreferencesActionPerformed(ActionEvent e) {
        try {
            boolean vEmbedded = this.mConfiguration.isEmbedded();
            String vPostgreSQLIP = this.mConfiguration.getPostgreSQLIP();
            Integer vPostgreSQLPort = this.mConfiguration.getPostgreSQLPort();
            PreferencesForm vForm = new PreferencesForm(this);
            vForm.setVisible(true);
            this.loadConfig();
            if (this.mAppConfigured && !this.mDBHelper.isStarted()) {
                final MainForm vMainForm = this;
                new DaemonThread(){

                    public void run() {
                        try {
                            StatusBarStatusCallback vCallBack = new StatusBarStatusCallback();
                            MainForm.this.mDBHelper.startDB(MainForm.this.mConfiguration.isEmbedded(), MainForm.this.mConfiguration.isEmbedded() ? MainForm.this.mConfiguration.getDBPatchLevelEmbedded() : MainForm.this.mConfiguration.getDBPatchLevelRemote(), vCallBack);
                            DBHelper.getInstance().runDBUpgrade(vCallBack);
                            MainForm.this.loadConfig();
                        }
                        catch (DBPatchingFailedException e) {
                            BugManager.handleError(vMainForm, (Throwable)((Object)e));
                        }
                        catch (Exception e) {
                            BugManager.handleError(vMainForm, e);
                        }
                    }
                }.start();
            } else if (this.mAppConfigured && vEmbedded != this.mConfiguration.isEmbedded()) {
                JOptionPane.showMessageDialog(this, "When changing database types it is required that you restart the application.  It will now shut down.");
                DBHelper.getInstance().shutdownDB();
                System.exit(0);
            } else if (!(!this.mAppConfigured || this.mConfiguration.isEmbedded() || vPostgreSQLIP.equals(this.mConfiguration.getPostgreSQLIP()) && vPostgreSQLPort.intValue() == this.mConfiguration.getPostgreSQLPort())) {
                JOptionPane.showMessageDialog(this, "When changing the IP or Port of PostgreSQL, it is required that you restart the application.  It will now shut down.");
                DBHelper.getInstance().shutdownDB();
                System.exit(0);
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void menuItemExitActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void checkBoxMenuItemStartSamplingActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            this.mCheckBoxMenuItemStartSampling.setText(this.mCheckBoxMenuItemStartSampling.getState() ? "Stop Sampling" : "Start Sampling");
            if (this.mCheckBoxMenuItemStartSampling.getState()) {
                StatusBarStatusCallback vCallback = new StatusBarStatusCallback();
                this.mSampleThread = new AquatronicaInterface(this.mConfiguration).startSampling(vCallback);
            } else {
                this.mSampleThread.terminate();
                try {
                    this.mSampleThread.join();
                }
                catch (InterruptedException e1) {}
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void menuItemExportSensorDataActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            SelectSensorForm vDialog = new SelectSensorForm((Frame)this, this.mConfiguration);
            vDialog.setVisible(true);
            if (!Utils.isEmptyString((String)vDialog.getSelectedSensor())) {
                this.exportSensorData(vDialog.getSelectedSensor(), vDialog.getFrom(), vDialog.getTo());
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void exportSensorData(String pSelectedSensor, Date pFrom, Date pTo) throws IOException {
        File vTmpFile = new AquatronicaInterface(this.mConfiguration).exportSensorData(pSelectedSensor, pFrom, pTo);
        if (vTmpFile == null) {
            JOptionPane.showMessageDialog(this, "No data was found for " + pSelectedSensor);
        } else {
            BrowserLauncher.openURL("file://" + vTmpFile.getCanonicalPath());
        }
    }

    private void exportWaterParameterData(WaterParameterData pWaterParameterData, Date pFrom, Date pTo) throws IOException {
        File vTmpFile = new AquatronicaInterface(this.mConfiguration).exportWaterParameterData(pWaterParameterData, pFrom, pTo);
        if (vTmpFile == null) {
            JOptionPane.showMessageDialog(this, "No data was found for " + pWaterParameterData.toString());
        } else {
            BrowserLauncher.openURL("file://" + vTmpFile.getCanonicalPath());
        }
    }

    private void menuItemPlugBarDataActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            SelectPlugForm vDialog = new SelectPlugForm((Frame)this, this.mConfiguration);
            vDialog.setVisible(true);
            if (vDialog.getSelectedPlug() != null) {
                this.exportPlugData(vDialog.getSelectedPlug(), vDialog.getFrom(), vDialog.getTo());
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void exportPlugData(PowerUnitPlug pSelectedPlug, Date pFrom, Date pTo) throws IOException {
        File vTmpFile = new AquatronicaInterface(this.mConfiguration).exportPlugData(pSelectedPlug, pFrom, pTo);
        if (vTmpFile == null) {
            JOptionPane.showMessageDialog(this, "No data was found for " + pSelectedPlug);
        } else {
            BrowserLauncher.openURL("file://" + vTmpFile.getCanonicalPath());
        }
    }

    private void menuItemGraphSensorDataActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            final SelectSensorForm vDialog = new SelectSensorForm((Frame)this, this.mConfiguration);
            vDialog.setVisible(true);
            if (!Utils.isEmptyString((String)vDialog.getSelectedSensor())) {
                final MainForm vOwner = this;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        PleaseWaitDialog vPWD = new PleaseWaitDialog(vOwner, "Please wait while AquaStats is creating the graph...");
                        try {
                            try {
                                new Graphing(vOwner, MainForm.this.mConfiguration).graphSensorData(vDialog.getSelectedSensor(), vDialog.getFrom(), vDialog.getTo());
                            }
                            finally {
                                vOwner.setEnabled(true);
                                vOwner.setFocusable(true);
                                vPWD.dispose();
                            }
                        }
                        catch (Exception exc) {
                            BugManager.handleError(vOwner, exc);
                        }
                    }
                }.start();
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void menuItemGraphPlugbarDataActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            final SelectPlugForm vDialog = new SelectPlugForm((Frame)this, this.mConfiguration);
            vDialog.setVisible(true);
            if (vDialog.getSelectedPlug() != null) {
                final MainForm vOwner = this;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        PleaseWaitDialog vPWD = new PleaseWaitDialog(vOwner, "Please wait while AquaStats is creating the graph...");
                        try {
                            try {
                                new Graphing(vOwner, MainForm.this.mConfiguration).graphPlugData(vDialog.getSelectedPlug(), vDialog.getFrom(), vDialog.getTo());
                            }
                            finally {
                                vOwner.setEnabled(true);
                                vOwner.setFocusable(true);
                                vPWD.dispose();
                            }
                        }
                        catch (Exception exc) {
                            BugManager.handleError(vOwner, exc);
                        }
                    }
                }.start();
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void buttonFetchStatusActionPerformed(ActionEvent e) {
        if (!this.checkSettings(false)) {
            return;
        }
        try {
            this.setStatus("Fetching New Status...", false);
            this.updateStatus(new AquatronicaInterface(this.mConfiguration).sample());
            this.setStatus("New Status Fetched Successfully", false);
        }
        catch (Exception exc) {
            this.setStatus("Failed fetching new status: " + exc.getMessage(), true);
            BugManager.handleError(this, exc);
        }
    }

    private void updateStatus(final AquatronicaSample pSample) {
        DefaultTableModel vModel = (DefaultTableModel)this.mTableSensorData.getModel();
        vModel.getDataVector().clear();
        for (String vSensorName : pSample.getSensorData().keySet()) {
            SensorData vSensorData = pSample.getSensorData().get(vSensorName);
            vModel.addRow(new Object[]{vSensorData, vSensorName, vSensorData.getValue()});
        }
        GUIUtils.setTableColumnToFit(this.mTableSensorData, 1);
        vModel = (DefaultTableModel)this.mTablePlugStatus.getModel();
        vModel.getDataVector().clear();
        for (String vPowerUnitName : pSample.getPowerUnitSample().keySet()) {
            PowerUnitSample vPowerUnitSample = pSample.getPowerUnitSample().get(vPowerUnitName);
            Vector<Object> vVector = new Vector<Object>();
            vVector.setSize(10);
            vVector.set(0, vPowerUnitSample);
            vVector.set(1, vPowerUnitName);
            for (Integer vPlugID : vPowerUnitSample.getPlugSample().keySet()) {
                PlugSample vPlugSample = vPowerUnitSample.getPlugSample().get(vPlugID);
                ImageIcon vImageIcon = this.mPlugStatuses.get(EventCodes.getPlugStatusCode(Utils.getInt((String)vPlugSample.getStatus())));
                JLabel vPlug = new JLabel(vPlugSample.getName(), vImageIcon, 0);
                vPlug.setVerticalTextPosition(1);
                vPlug.setHorizontalTextPosition(0);
                vPlug.setFont(new Font(vPlug.getFont().getFontName(), 0, vPlug.getFont().getSize() - (GUIUtils.isMacOSX() ? 3 : 2)));
                vVector.set(vPlugSample.getPlugID() + 1, vPlug);
            }
            vModel.addRow(vVector);
        }
        GUIUtils.setTableColumnToFit(this.mTablePlugStatus, 1);
        this.mTablePlugStatus.setRowHeight(60);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainForm.this.mPreviousSample = pSample;
            }
        });
    }

    private boolean checkSettings(boolean pNeedDB) {
        if (!this.mAppConfigured) {
            JOptionPane.showMessageDialog(this, "The application has not yet been configured.  Go to File | Preferences.");
            return false;
        }
        if (pNeedDB && !DBHelper.getInstance().isStarted()) {
            JOptionPane.showMessageDialog(null, "The application is configured, however the database has not yet started.");
            return false;
        }
        return true;
    }

    private void menuItemAboutActionPerformed(ActionEvent e) {
        AboutForm vAboutForm = new AboutForm((Frame)this, this.mConfiguration);
        vAboutForm.setVisible(true);
    }

    private void menuItemOverlayActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            final OverlayGraphForm vOverlayGraphForm = new OverlayGraphForm((Frame)this, this.mConfiguration);
            vOverlayGraphForm.setVisible(true);
            if (vOverlayGraphForm.getSelections().size() > 0) {
                final MainForm vOwner = this;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        PleaseWaitDialog vPWD = new PleaseWaitDialog(vOwner, "Please wait while AquaStats is creating the graph...");
                        try {
                            try {
                                new Graphing(vOwner, MainForm.this.mConfiguration).graphData(vOverlayGraphForm.getSelections(), vOverlayGraphForm.getFrom(), vOverlayGraphForm.getTo());
                            }
                            finally {
                                vOwner.setEnabled(true);
                                vOwner.setFocusable(true);
                                vPWD.dispose();
                            }
                        }
                        catch (Exception exc) {
                            BugManager.handleError(vOwner, exc);
                        }
                    }
                }.start();
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void menuItemTankMaintenanceLogActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            if (new AquatronicaInterface(this.mConfiguration).getTanks().size() <= 0) {
                JOptionPane.showMessageDialog(this, "At least one tank needs to be defined before the maintenance log can be accessed");
                this.menuItemTanksActionPerformed(e);
            } else {
                TankMaintenanceLog vTankMaintenanceLog = new TankMaintenanceLog((Frame)this, this.mConfiguration);
                vTankMaintenanceLog.setVisible(true);
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void menuItemTanksActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            TankSetup vTankSetup = new TankSetup((Frame)this, this.mConfiguration);
            vTankSetup.setVisible(true);
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void checkBoxEnableRTMItemStateChanged(ItemEvent e) {
        if (!this.checkSettings(false)) {
            this.mCheckBoxEnableRTM.setSelected(false);
            return;
        }
        if (e.getStateChange() == 1) {
            this.setStatus("Real Time Monitoring Activated...", false);
            this.scheduleTask();
        } else {
            this.cancelTask();
            this.setStatus("Real Time Monitoring Cancelled.", false);
        }
    }

    private void cancelTask() {
        this.mRTMTimer.cancel();
        this.mRTMTimer = null;
    }

    private void scheduleTask() {
        this.mRTMTimer = new Timer(true);
        final MainForm vMainForm = this;
        this.mRTMTimer.schedule(new TimerTask(){

            public void run() {
                try {
                    MainForm.this.setStatus("Fetching New Status...", false);
                    final AquatronicaSample vAquatronicaSample = new AquatronicaInterface(MainForm.this.mConfiguration).sample();
                    MainForm.this.setStatus("New Status Fetched Successfully.", false);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                MainForm.this.updateStatus(vAquatronicaSample);
                            }
                            catch (Exception exc) {
                                BugManager.handleError(vMainForm, exc);
                            }
                        }
                    });
                }
                catch (Exception exc) {
                    MainForm.this.setStatus("Failed fetching new status: " + exc.getMessage(), true);
                }
            }
        }, 1000L, (long)((Integer)this.mSpinnerRTMInterval.getValue() * 1000));
    }

    private void spinnerRTMIntervalStateChanged(ChangeEvent e) {
        System.out.println("StateChanged");
        if (this.mCheckBoxEnableRTM.isSelected()) {
            this.cancelTask();
            this.scheduleTask();
        }
    }

    private void tablePlugStatusMousePressed(MouseEvent e) {
        try {
            if (SwingUtilities.isRightMouseButton(e)) {
                int vRow = ((JTable)e.getSource()).rowAtPoint(e.getPoint());
                final int vColumn = ((JTable)e.getSource()).columnAtPoint(e.getPoint());
                final PowerUnitSample vPowerUnitSample = (PowerUnitSample)((DefaultTableModel)((JTable)e.getSource()).getModel()).getValueAt(vRow, 0);
                if (vColumn > 1 && vPowerUnitSample != null && vPowerUnitSample.getPlugSample().containsKey(vColumn - 1)) {
                    final PlugStatusForm vPlugStatusForm = new PlugStatusForm((Frame)this, vPowerUnitSample.getName(), vPowerUnitSample.getPlugSampleByPlugID(vColumn - 1));
                    vPlugStatusForm.setLocationRelativeTo(this);
                    Point vPoint = e.getPoint();
                    SwingUtilities.convertPointToScreen(vPoint, (JTable)e.getSource());
                    vPlugStatusForm.setLocation(vPoint);
                    vPlugStatusForm.setVisible(true);
                    if (vPlugStatusForm.getPlugState() != null) {
                        final MainForm vMainForm = this;
                        new DaemonThread(){

                            public void run() {
                                try {
                                    StatusBarStatusCallback vCallback = new StatusBarStatusCallback();
                                    new AquatronicaInterface(MainForm.this.mConfiguration).setPlugStatus(vPowerUnitSample.getPowerUnitID(), vColumn - 1, vPlugStatusForm.getPlugState(), vCallback);
                                }
                                catch (Exception exc) {
                                    BugManager.handleError(vMainForm, exc);
                                }
                            }
                        }.start();
                    }
                }
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void setStatus(String pText, boolean pError) {
        this.mLabelStatus.setText(pText);
        if (pError) {
            this.mLabelStatus.setForeground(Color.RED);
        } else {
            this.mLabelStatus.setForeground(new JLabel().getForeground());
        }
    }

    private void menuItemCaptureWaterParametersActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        if (!this.mConfiguration.isOneOrMoreWaterParametersDefined()) {
            JOptionPane.showMessageDialog(this, "At least one Manual Water Parameter must be defined.  Go to File | Preferences | Manually Monitored Water Parameters.", "Configuration Missing", 2);
        } else {
            try {
                WaterParametersForm vWaterParametersForm = new WaterParametersForm((Frame)this, this.mConfiguration);
                vWaterParametersForm.setVisible(true);
            }
            catch (Exception exc) {
                BugManager.handleError(this, exc);
            }
        }
    }

    private void menuItemGraphManualWaterParamsActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            final SelectWaterParameter vDialog = new SelectWaterParameter((Frame)this, this.mConfiguration);
            vDialog.setVisible(true);
            if (vDialog.getWaterParameterData() != null) {
                final MainForm vOwner = this;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        PleaseWaitDialog vPWD = new PleaseWaitDialog(vOwner, "Please wait while AquaStats is creating the graph...");
                        try {
                            try {
                                new Graphing(vOwner, MainForm.this.mConfiguration).graphWaterParameterData(vDialog.getWaterParameterData(), vDialog.getFrom(), vDialog.getTo());
                            }
                            finally {
                                vOwner.setEnabled(true);
                                vOwner.setFocusable(true);
                                vPWD.dispose();
                            }
                        }
                        catch (Exception exc) {
                            BugManager.handleError(vOwner, exc);
                        }
                    }
                }.start();
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void menuItemExportManualWaterParamsActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            SelectWaterParameter vDialog = new SelectWaterParameter((Frame)this, this.mConfiguration);
            vDialog.setVisible(true);
            if (vDialog.getWaterParameterData() != null) {
                this.exportWaterParameterData(vDialog.getWaterParameterData(), vDialog.getFrom(), vDialog.getTo());
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void menuItemAlertsActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            AlertForm vAlertForm = new AlertForm((Frame)this, this.mConfiguration);
            vAlertForm.setVisible(true);
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void thisWindowClosing(WindowEvent e) {
        if (this.mConfiguration.isMainFrameRememberPosAndSize()) {
            try {
                MutableConfiguration vConfig = new MutableConfiguration();
                vConfig.setMainFramePosLeft((int)this.getLocationOnScreen().getX());
                vConfig.setMainFramePosTop((int)this.getLocationOnScreen().getY());
                vConfig.setMainFrameWidth(this.getWidth());
                vConfig.setMainFrameHeight(this.getHeight());
                vConfig.save();
            }
            catch (Exception exc) {
                BugManager.handleError(this, exc);
            }
        }
    }

    private void menuItemPlugDutyCycleActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            final SelectPlugForm vDialog = new SelectPlugForm((Frame)this, this.mConfiguration);
            vDialog.setVisible(true);
            if (vDialog.getSelectedPlug() != null) {
                final MainForm vOwner = this;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        PleaseWaitDialog vPWD = new PleaseWaitDialog(vOwner, "Please wait while AquaStats is calculating things...");
                        try {
                            try {
                                PlugDutyCycleForm vPlugDutyCycleForm = new PlugDutyCycleForm(vOwner, MainForm.this.mConfiguration, vDialog.getSelectedPlug(), vDialog.getFrom(), vDialog.getTo());
                                vPlugDutyCycleForm.setVisible(true);
                            }
                            finally {
                                vOwner.setEnabled(true);
                                vOwner.setFocusable(true);
                                vPWD.dispose();
                            }
                        }
                        catch (Exception exc) {
                            BugManager.handleError(vOwner, exc);
                        }
                    }
                }.start();
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void menuItemSensorStatisticsActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            final SelectSensorForm vDialog = new SelectSensorForm((Frame)this, this.mConfiguration);
            vDialog.setVisible(true);
            if (vDialog.getSelectedSensor() != null) {
                if (new AquatronicaInterface(this.mConfiguration).isDiscreteSensor(vDialog.getSelectedSensor())) {
                    JOptionPane.showMessageDialog(this, "Discrete sensors cannot be used in statistical analysis at this time.", "Error", 0);
                } else {
                    final MainForm vOwner = this;
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            PleaseWaitDialog vPWD = new PleaseWaitDialog(vOwner, "Please wait while AquaStats is calculating things...");
                            try {
                                try {
                                    SensorStatisticsForm vSensorStatisticsForm = new SensorStatisticsForm(vOwner, MainForm.this.mConfiguration, vDialog.getSelectedSensor(), vDialog.getFrom(), vDialog.getTo());
                                    vSensorStatisticsForm.setVisible(true);
                                }
                                finally {
                                    vOwner.setEnabled(true);
                                    vOwner.setFocusable(true);
                                    vPWD.dispose();
                                }
                            }
                            catch (Exception exc) {
                                BugManager.handleError(vOwner, exc);
                            }
                        }
                    }.start();
                }
            }
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void menuItemAquatronicaActionPerformed(ActionEvent e) {
        if (!this.checkSettings(true)) {
            return;
        }
        try {
            AquatronicaDevicesForm vDialog = new AquatronicaDevicesForm((Frame)this, this.mConfiguration);
            vDialog.setVisible(true);
        }
        catch (Exception exc) {
            BugManager.handleError(this, exc);
        }
    }

    private void initComponents() {
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.mPanel1 = new JPanel();
        this.mMenuBar1 = new JMenuBar();
        this.mMenu1 = new JMenu();
        this.mMenuItemAbout = new JMenuItem();
        this.mMenuItemPreferences = new JMenuItem();
        this.mMenuItemExit = new JMenuItem();
        this.mMenu2 = new JMenu();
        this.mCheckBoxMenuItemStartSampling = new JCheckBoxMenuItem();
        this.mMenu5 = new JMenu();
        this.mMenuItemAquatronica = new JMenuItem();
        this.mMenuItemTanks = new JMenuItem();
        this.mMenuItemTankMaintenanceLog = new JMenuItem();
        this.mMenuItemCaptureWaterParameters = new JMenuItem();
        this.mMenu6 = new JMenu();
        this.mMenuItemAlerts = new JMenuItem();
        this.mMenu4 = new JMenu();
        this.mMenuItemGraphSensorData = new JMenuItem();
        this.mMenuItemGraphPlugbarData = new JMenuItem();
        this.mMenuItemGraphManualWaterParams = new JMenuItem();
        this.mMenuItemOverlay = new JMenuItem();
        this.mMenu3 = new JMenu();
        this.mMenuItemExportSensorData = new JMenuItem();
        this.mMenuItemPlugBarData = new JMenuItem();
        this.mMenuItemExportManualWaterParams = new JMenuItem();
        this.mMenu7 = new JMenu();
        this.mMenuItemPlugDutyCycle = new JMenuItem();
        this.mMenuItemSensorStatistics = new JMenuItem();
        this.mPanel2 = new JPanel();
        this.mLabel1 = new JLabel();
        this.mButtonFetchStatus = new JButton();
        this.mScrollPane1 = new JScrollPane();
        this.mTableSensorData = new JTable(){

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (column == MainForm.this.mTableSensorData.getColumnCount() - 1) {
                    SensorData vData = (SensorData)this.getModel().getValueAt(row, 0);
                    if (!c.getBackground().equals(this.getSelectionBackground())) {
                        c.setBackground(EventCodes.isSensorInAlarm(vData.getStatusCode()) ? Color.RED : this.getBackground());
                    }
                    c.setFont(c.getFont().deriveFont(c.getFont().getStyle() & 0xFFFFFFFE));
                    ((JLabel)c).setHorizontalAlignment(2);
                    DefaultTableModel vModel = (DefaultTableModel)MainForm.this.mTableSensorData.getModel();
                    if (MainForm.this.mPreviousSample != null && MainForm.this.mPreviousSample.getSensorData().get((String)vModel.getValueAt(row, 1)) != null && !MainForm.this.mPreviousSample.getSensorData().get((String)vModel.getValueAt(row, 1)).getValue().equals(vData.getValue())) {
                        c.setForeground(Color.BLUE);
                    } else {
                        c.setForeground(this.getForeground());
                    }
                } else if (column == 1) {
                    c.setForeground(Color.WHITE);
                    c.setBackground(new Color(0, 64, 130));
                    c.setFont(c.getFont().deriveFont(c.getFont().getStyle() | 1));
                    ((JLabel)c).setHorizontalAlignment(4);
                }
                return c;
            }
        };
        this.mPanel3 = new JPanel();
        this.mSeparator2 = compFactory.createSeparator("Real Time Monitoring");
        this.mCheckBoxEnableRTM = new JCheckBox();
        this.mLabel3 = new JLabel();
        this.mSpinnerRTMInterval = new JSpinner();
        this.mLabel2 = new JLabel();
        this.mScrollPane2 = new JScrollPane();
        this.mTablePlugStatus = new JTable(){

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                PowerUnitSample vData = (PowerUnitSample)this.getModel().getValueAt(row, 0);
                if (column == 1) {
                    c.setForeground(Color.WHITE);
                    c.setBackground(new Color(0, 127, 129));
                    ((JComponent)c).setBorder(((JComponent)c).getBorder());
                    ((JLabel)c).setHorizontalAlignment(0);
                } else if (column > 1 && vData.getPlugSampleByPlugID(column - 1) != null && EventCodes.isPlugOn(Utils.getInt((String)vData.getPlugSampleByPlugID(column - 1).getStatus()))) {
                    c.setForeground(this.getForeground());
                    c.setBackground(this.getBackground());
                    ((JComponent)c).setBorder(new LineBorder(Color.blue, 3, true));
                } else if (c != null) {
                    ((JComponent)c).setForeground(this.getForeground());
                    ((JComponent)c).setBackground(this.getBackground());
                    ((JComponent)c).setBorder(((JComponent)c).getBorder());
                }
                if (column > 1) {
                    String vStatus = "Undefined";
                    PlugSample vPlugSample = vData.getPlugSampleByPlugID(column - 1);
                    if (vPlugSample != null) {
                        String string = vStatus = EventCodes.isPlugOn(Utils.getInt((String)vPlugSample.getStatus())) ? "On" : "Off";
                        if (c != null) {
                            ((JComponent)c).setToolTipText("Plug: " + vPlugSample.getName() + ", Status: " + vStatus + " - " + EventCodes.parsePlugStatus(Utils.getInt((String)vPlugSample.getStatus())));
                        }
                    }
                }
                return c;
            }

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column) == null ? String.class : this.getValueAt(0, column).getClass();
            }
        };
        this.mTablePlugStatus.setDefaultRenderer(JLabel.class, new JLabelCellRenderer());
        this.mPanelStatusBar = new JPanel();
        this.mLabelStatus = new JLabel();
        CellConstraints cc = new CellConstraints();
        this.setTitle("AquaStats ");
        this.setDefaultCloseOperation(2);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/images/icon.png")).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainForm.this.thisWindowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new FormLayout("default:grow", "fill:default:grow"));
        this.mPanel1.setLayout((LayoutManager)new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{new RowSpec((Size)Sizes.dluY((int)17)), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}));
        this.mMenu1.setText("File");
        this.mMenuItemAbout.setText("About...");
        this.mMenuItemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemAboutActionPerformed(e);
            }
        });
        this.mMenu1.add(this.mMenuItemAbout);
        this.mMenuItemPreferences.setText("Preferences...");
        this.mMenuItemPreferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemPreferencesActionPerformed(e);
            }
        });
        this.mMenu1.add(this.mMenuItemPreferences);
        this.mMenuItemExit.setText("Exit");
        this.mMenuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemExitActionPerformed(e);
            }
        });
        this.mMenu1.add(this.mMenuItemExit);
        this.mMenuBar1.add(this.mMenu1);
        this.mMenu2.setText("Monitoring");
        this.mCheckBoxMenuItemStartSampling.setText("Start Sampling");
        this.mCheckBoxMenuItemStartSampling.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.checkBoxMenuItemStartSamplingActionPerformed(e);
            }
        });
        this.mMenu2.add(this.mCheckBoxMenuItemStartSampling);
        this.mMenuBar1.add(this.mMenu2);
        this.mMenu5.setText("Tools");
        this.mMenuItemAquatronica.setText("Aquatronica Devices...");
        this.mMenuItemAquatronica.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemAquatronicaActionPerformed(e);
            }
        });
        this.mMenu5.add(this.mMenuItemAquatronica);
        this.mMenuItemTanks.setText("Tanks...");
        this.mMenuItemTanks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemTanksActionPerformed(e);
            }
        });
        this.mMenu5.add(this.mMenuItemTanks);
        this.mMenuItemTankMaintenanceLog.setText("Tank Log...");
        this.mMenuItemTankMaintenanceLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemTankMaintenanceLogActionPerformed(e);
            }
        });
        this.mMenu5.add(this.mMenuItemTankMaintenanceLog);
        this.mMenu5.addSeparator();
        this.mMenuItemCaptureWaterParameters.setText("Capture Water Parameters...");
        this.mMenuItemCaptureWaterParameters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemCaptureWaterParametersActionPerformed(e);
            }
        });
        this.mMenu5.add(this.mMenuItemCaptureWaterParameters);
        this.mMenuBar1.add(this.mMenu5);
        this.mMenu6.setText("Alerts");
        this.mMenuItemAlerts.setText("Alerts and Notifications...");
        this.mMenuItemAlerts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemAlertsActionPerformed(e);
            }
        });
        this.mMenu6.add(this.mMenuItemAlerts);
        this.mMenuBar1.add(this.mMenu6);
        this.mMenu4.setText("Graphing");
        this.mMenuItemGraphSensorData.setText("Sensor Data...");
        this.mMenuItemGraphSensorData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemGraphSensorDataActionPerformed(e);
            }
        });
        this.mMenu4.add(this.mMenuItemGraphSensorData);
        this.mMenuItemGraphPlugbarData.setText("Plugbar Data...");
        this.mMenuItemGraphPlugbarData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemGraphPlugbarDataActionPerformed(e);
            }
        });
        this.mMenu4.add(this.mMenuItemGraphPlugbarData);
        this.mMenuItemGraphManualWaterParams.setText("Manual Water Parameters...");
        this.mMenuItemGraphManualWaterParams.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemGraphManualWaterParamsActionPerformed(e);
            }
        });
        this.mMenu4.add(this.mMenuItemGraphManualWaterParams);
        this.mMenu4.addSeparator();
        this.mMenuItemOverlay.setText("Overlay...");
        this.mMenuItemOverlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemOverlayActionPerformed(e);
            }
        });
        this.mMenu4.add(this.mMenuItemOverlay);
        this.mMenuBar1.add(this.mMenu4);
        this.mMenu3.setText("Export");
        this.mMenuItemExportSensorData.setText("Sensor Data...");
        this.mMenuItemExportSensorData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemExportSensorDataActionPerformed(e);
            }
        });
        this.mMenu3.add(this.mMenuItemExportSensorData);
        this.mMenuItemPlugBarData.setText("Plugbar Data...");
        this.mMenuItemPlugBarData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemPlugBarDataActionPerformed(e);
            }
        });
        this.mMenu3.add(this.mMenuItemPlugBarData);
        this.mMenuItemExportManualWaterParams.setText("Manual Water Parameters...");
        this.mMenuItemExportManualWaterParams.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemExportManualWaterParamsActionPerformed(e);
            }
        });
        this.mMenu3.add(this.mMenuItemExportManualWaterParams);
        this.mMenuBar1.add(this.mMenu3);
        this.mMenu7.setText("Statistics");
        this.mMenuItemPlugDutyCycle.setText("Plug Duty Cycle...");
        this.mMenuItemPlugDutyCycle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemPlugDutyCycleActionPerformed(e);
            }
        });
        this.mMenu7.add(this.mMenuItemPlugDutyCycle);
        this.mMenuItemSensorStatistics.setText("Sensor Statistics...");
        this.mMenuItemSensorStatistics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.menuItemSensorStatisticsActionPerformed(e);
            }
        });
        this.mMenu7.add(this.mMenuItemSensorStatistics);
        this.mMenuBar1.add(this.mMenu7);
        this.mPanel1.add((Component)this.mMenuBar1, cc.xy(1, 1));
        this.mPanel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec((Size)Sizes.dluY((int)12))}));
        this.mLabel1.setText("Current Sensor Data");
        this.mLabel1.setFont(this.mLabel1.getFont().deriveFont(this.mLabel1.getFont().getStyle() | 1, (float)this.mLabel1.getFont().getSize() + 2.0f));
        this.mPanel2.add((Component)this.mLabel1, cc.xy(1, 1));
        this.mButtonFetchStatus.setText("Fetch Latest Controller Status");
        this.mButtonFetchStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainForm.this.buttonFetchStatusActionPerformed(e);
            }
        });
        this.mPanel2.add((Component)this.mButtonFetchStatus, cc.xy(3, 1));
        this.mScrollPane1.setPreferredSize(new Dimension(454, 380));
        this.mTableSensorData.setModel(new DefaultTableModel(new Object[0][], new String[]{"-", "Sensor Name", "Value"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, String.class, String.class};
                this.columnEditable = new boolean[]{false, false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        TableColumnModel cm = this.mTableSensorData.getColumnModel();
        cm.getColumn(0).setResizable(false);
        this.mTableSensorData.setRowSelectionAllowed(false);
        this.mTableSensorData.setShowHorizontalLines(false);
        this.mTableSensorData.setShowVerticalLines(false);
        this.mScrollPane1.setViewportView(this.mTableSensorData);
        this.mPanel2.add((Component)this.mScrollPane1, cc.xy(1, 3));
        this.mPanel3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.mPanel3.add((Component)this.mSeparator2, cc.xywh(1, 1, 3, 1));
        this.mCheckBoxEnableRTM.setText("Enable Real Time Monitoring");
        this.mCheckBoxEnableRTM.setHorizontalTextPosition(10);
        this.mCheckBoxEnableRTM.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MainForm.this.checkBoxEnableRTMItemStateChanged(e);
            }
        });
        this.mPanel3.add((Component)this.mCheckBoxEnableRTM, cc.xywh(1, 3, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mLabel3.setText("Monitor Interval (seconds):");
        this.mPanel3.add((Component)this.mLabel3, cc.xywh(1, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        this.mSpinnerRTMInterval.setPreferredSize(new Dimension(50, 24));
        this.mSpinnerRTMInterval.setModel(new SpinnerNumberModel((Number)60, Integer.valueOf(10), null, (Number)1));
        this.mSpinnerRTMInterval.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MainForm.this.spinnerRTMIntervalStateChanged(e);
            }
        });
        JFormattedTextField vTf = ((JSpinner.DefaultEditor)this.mSpinnerRTMInterval.getEditor()).getTextField();
        vTf.setEditable(false);
        vTf.setBackground(Color.white);
        this.mPanel3.add((Component)this.mSpinnerRTMInterval, cc.xywh(3, 5, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.mPanel2.add((Component)this.mPanel3, cc.xywh(3, 3, 1, 1, CellConstraints.FILL, CellConstraints.TOP));
        this.mLabel2.setText("Plug Status");
        this.mLabel2.setFont(this.mLabel2.getFont().deriveFont(this.mLabel2.getFont().getStyle() | 1, (float)this.mLabel2.getFont().getSize() + 2.0f));
        this.mPanel2.add((Component)this.mLabel2, cc.xy(1, 5));
        this.mScrollPane2.setEnabled(false);
        this.mScrollPane2.setPreferredSize(new Dimension(454, 430));
        this.mTablePlugStatus.setModel(new DefaultTableModel(new Object[0][], new String[]{"-", " ", "A", "B", "C", "D", "E", "F", "G", "H"}){
            Class[] columnTypes;
            boolean[] columnEditable;
            {
                this.columnTypes = new Class[]{Object.class, String.class, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class};
                this.columnEditable = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        cm = this.mTablePlugStatus.getColumnModel();
        cm.getColumn(0).setResizable(false);
        this.mTablePlugStatus.setShowHorizontalLines(false);
        this.mTablePlugStatus.setShowVerticalLines(false);
        this.mTablePlugStatus.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                MainForm.this.tablePlugStatusMousePressed(e);
            }
        });
        this.mScrollPane2.setViewportView(this.mTablePlugStatus);
        this.mPanel2.add((Component)this.mScrollPane2, cc.xywh(1, 7, 3, 1));
        this.mPanelStatusBar.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.mLabelStatus.setText("text");
        this.mLabelStatus.setFont(this.mLabelStatus.getFont().deriveFont((float)this.mLabelStatus.getFont().getSize() - 1.0f));
        this.mPanelStatusBar.add((Component)this.mLabelStatus, cc.xy(1, 1));
        this.mPanel2.add((Component)this.mPanelStatusBar, cc.xywh(1, 9, 3, 1));
        this.mPanel1.add((Component)this.mPanel2, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(10, 10, 10, 10)));
        contentPane.add((Component)this.mPanel1, cc.xy(1, 1));
        this.setSize(845, 575);
        this.setLocationRelativeTo(null);
    }

    class JLabelCellRenderer
    implements TableCellRenderer {
        JLabelCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JLabel)value;
        }
    }

    class StatusBarStatusCallback
    implements StatusCallback {
        StatusBarStatusCallback() {
        }

        public void updateStatusText(final String pText, final boolean pError) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainForm.this.setStatus(pText, pError);
                }
            });
        }
    }
}

