/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import java.io.IOException;
import java.util.Calendar;
import javax.swing.UIManager;
import org.dom4j.DocumentException;
import za.co.pwnconsulting.aquatronica.AquatronicaInterface;
import za.co.pwnconsulting.aquatronica.AquatronicaSample;
import za.co.pwnconsulting.aquatronica.MainForm;
import za.co.pwnconsulting.aquatronica.config.Configuration;
import za.co.pwnconsulting.aquatronica.helpers.BugManager;
import za.co.pwnconsulting.aquatronica.helpers.DBHelper;

public class Main {
    public static void main(String[] args) throws IOException, DocumentException {
        if (args.length == 1) {
            if (args[0].equals("SAMPLE") || args[0].equals("STATUS")) {
                if (Configuration.configExists()) {
                    Configuration vConfiguration = new Configuration();
                    DBHelper.getInstance().startDB(vConfiguration.isEmbedded(), vConfiguration.isEmbedded() ? vConfiguration.getDBPatchLevelEmbedded() : vConfiguration.getDBPatchLevelRemote());
                    DBHelper.getInstance().runDBUpgrade(null);
                    System.out.println(vConfiguration.getAppTitle());
                    AquatronicaInterface vAquatronicaInterface = new AquatronicaInterface(vConfiguration);
                    if (args[0].equals("SAMPLE")) {
                        vAquatronicaInterface.startSampling();
                    } else if (args[0].equals("STATUS")) {
                        System.out.println("Fetching latest status from controller...");
                        AquatronicaSample vSample = vAquatronicaInterface.sample();
                        System.out.println(vAquatronicaInterface.createReport(vSample));
                    }
                } else {
                    System.out.println("Application is not configured yet!");
                }
            } else {
                System.out.println("AquaStats v1.2.5a - Copyright (c) " + Calendar.getInstance().get(1) + " by PWN Consulting. All rights reserved.  ");
                System.out.println("Feel free to re-distribute, but do not modify application.");
                System.out.println("Usage: java -jar AquaStats.jar [SAMPLE | STATUS] ");
                System.out.println("SAMPLE           This will run the sampling process headless");
                System.out.println("STATUS           This will poll the ethernet module for the latest status");
            }
        } else {
            try {
                System.setProperty("swing.aatext", "true");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                MainForm vForm = new MainForm();
                vForm.setVisible(true);
            }
            catch (Exception e) {
                BugManager.handleFatalBug(e);
            }
        }
    }
}

