/*
 * Decompiled with CFR 0.152.
 */
package za.co.pwnconsulting.aquatronica;

import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import za.co.pwnconsulting.aquatronica.PlugData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventCodes {
    public static String parseSensorStatus(int pStatus) {
        return EventCodes.isSensorInAlarm(pStatus) ? "Alarm" : "Normal";
    }

    public static boolean isSensorInAlarm(int pStatus) {
        return (pStatus & 1) == 1;
    }

    public static int getPlugStatusCode(int pStatus) {
        return pStatus & 0xFFFFFF7F;
    }

    public static String parsePlugStatus(int pStatus) {
        String vStatus;
        switch (pStatus & 0xFFFFFF7F) {
            case -1: {
                vStatus = "Not Present";
                break;
            }
            case 0: {
                vStatus = "";
                break;
            }
            case 1: {
                vStatus = "Not Defined";
                break;
            }
            case 2: {
                vStatus = "Not Defined";
                break;
            }
            case 10: {
                vStatus = "Timer Program";
                break;
            }
            case 20: {
                vStatus = "Timer Program";
                break;
            }
            case 30: {
                vStatus = "Tide Effect";
                break;
            }
            case 40: {
                vStatus = "Wave Effect";
                break;
            }
            case 50: {
                vStatus = "Power Cut";
                break;
            }
            case 60: {
                vStatus = "Summer Function";
                break;
            }
            case 70: {
                vStatus = "Redox Sensor Program";
                break;
            }
            case 80: {
                vStatus = "pH Sensor Program";
                break;
            }
            case 90: {
                vStatus = "Temperature Sensor Program";
                break;
            }
            case 100: {
                vStatus = "Conductivity Sensor Program";
                break;
            }
            case 110: {
                vStatus = "Level Sensor Program";
                break;
            }
            case 120: {
                vStatus = "Manual Setting";
                break;
            }
            case 126: {
                vStatus = "Not Powered";
                break;
            }
            case 127: {
                vStatus = "Blocked in Emergency";
                break;
            }
            case 71: 
            case 81: 
            case 91: 
            case 101: 
            case 111: {
                vStatus = "XY Program";
                break;
            }
            default: {
                vStatus = "Undefined state";
            }
        }
        return vStatus;
    }

    public static boolean isPlugOn(int pStatus) {
        return (pStatus & 0x80) == 128;
    }

    public static PlugData.OverridePlugState getPlugOverride(int pStatus) {
        if (EventCodes.getPlugStatusCode(pStatus) == 120 && EventCodes.isPlugOn(pStatus)) {
            return PlugData.OverridePlugState.ForcedOn;
        }
        if (EventCodes.getPlugStatusCode(pStatus) == 120 && !EventCodes.isPlugOn(pStatus)) {
            return PlugData.OverridePlugState.ForcedOff;
        }
        return PlugData.OverridePlugState.Auto;
    }

    public static Map<Integer, ImageIcon> getStatusIcons() {
        HashMap<Integer, ImageIcon> vIcons = new HashMap<Integer, ImageIcon>();
        ImageIcon vBianco = new ImageIcon(EventCodes.class.getResource("/images/bianco.gif"));
        ImageIcon vOrologio = new ImageIcon(EventCodes.class.getResource("/images/orologio.gif"));
        ImageIcon vXY = new ImageIcon(EventCodes.class.getResource("/images/xy.gif"));
        vIcons.put(-1, vBianco);
        vIcons.put(0, vBianco);
        vIcons.put(1, new ImageIcon(EventCodes.class.getResource("/images/interrogativo.gif")));
        vIcons.put(2, vBianco);
        vIcons.put(10, vOrologio);
        vIcons.put(20, vOrologio);
        vIcons.put(30, new ImageIcon(EventCodes.class.getResource("/images/dueOnde.gif")));
        vIcons.put(40, new ImageIcon(EventCodes.class.getResource("/images/ondinaLinea.gif")));
        vIcons.put(50, new ImageIcon(EventCodes.class.getResource("/images/ics.gif")));
        vIcons.put(60, new ImageIcon(EventCodes.class.getResource("/images/sole.gif")));
        vIcons.put(70, new ImageIcon(EventCodes.class.getResource("/images/rx.gif")));
        vIcons.put(80, new ImageIcon(EventCodes.class.getResource("/images/ph_ico.gif")));
        vIcons.put(90, new ImageIcon(EventCodes.class.getResource("/images/temperatura.gif")));
        vIcons.put(100, new ImageIcon(EventCodes.class.getResource("/images/microsiemens.gif")));
        vIcons.put(110, new ImageIcon(EventCodes.class.getResource("/images/livello.gif")));
        vIcons.put(120, new ImageIcon(EventCodes.class.getResource("/images/mano.gif")));
        vIcons.put(126, new ImageIcon(EventCodes.class.getResource("/images/spina.gif")));
        vIcons.put(127, new ImageIcon(EventCodes.class.getResource("/images/lucchetto.gif")));
        vIcons.put(71, vXY);
        vIcons.put(81, vXY);
        vIcons.put(91, vXY);
        vIcons.put(101, vXY);
        vIcons.put(111, vXY);
        return vIcons;
    }
}

